-- Copyright (C) 1991-2009 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.
-- Quartus II 9.1 Build 222 10/21/2009
---START_PACKAGE_HEADER-----------------------------------------------------
--
-- Package Name    :  ALTERA_COMMON_CONVERSION
--
-- Description     :  Common conversion functions
--
---END_PACKAGE_HEADER--------------------------------------------------------

-- BEGINING OF PRIMITIVE

Library ieee;
use ieee.std_logic_1164.all;
entity LCELL is
    port(
        a_in                           :  in    std_logic;
        a_out                          :  out   std_logic);
end LCELL;
architecture BEHAVIOR of LCELL is
begin
    a_out <= a_in;
end BEHAVIOR;

-- BEGINING OF PACKAGE
Library ieee;
use ieee.std_logic_1164.all;
use std.textio.all;

-- PACKAGE DECLARATION
package ALTERA_COMMON_CONVERSION is
-- FUNCTION DECLARATION
    function INT_TO_STR_RAM (value : in integer) return string;
    function INT_TO_STR_ARITH (value : in integer) return string;
    function HEX_STR_TO_INT (str : in string) return integer;
    function BIN_STR_TO_INT (str : in string) return integer;
    function OCT_STR_TO_INT (str : in string) return integer;
    function INT_STR_TO_INT (str : in string) return integer;
    function ALPHA_TOLOWER (given_string : in string) return string;
    procedure SHRINK_LINE (str_line : inout line; pos : in integer);
end ALTERA_COMMON_CONVERSION;

package body ALTERA_COMMON_CONVERSION is
-- This function converts an integer to a string
function INT_TO_STR_RAM (value : in integer) return string is
variable ivalue : integer := 0;
variable index  : integer := 0;
variable digit : integer := 0;
variable line_no: string(8 downto 1) := "        ";
begin
    ivalue := value;
    index := 1;

    while (ivalue > 0) loop
        digit := ivalue MOD 10;
        ivalue := ivalue/10;
        case digit is
            when 0 => line_no(index) := '0';
            when 1 => line_no(index) := '1';
            when 2 => line_no(index) := '2';
            when 3 => line_no(index) := '3';
            when 4 => line_no(index) := '4';
            when 5 => line_no(index) := '5';
            when 6 => line_no(index) := '6';
            when 7 => line_no(index) := '7';
            when 8 => line_no(index) := '8';
            when 9 => line_no(index) := '9';
            when others =>
                ASSERT FALSE
                REPORT "Illegal number!"
                SEVERITY ERROR;
        end case;
        index := index + 1;
    end loop;

    return line_no;
end INT_TO_STR_RAM;

function INT_TO_STR_ARITH (value : in integer) return string is
    variable ivalue : integer := 0;
    variable index : integer := 0;
    variable digit : integer := 0;
    variable temp: string(10 downto 1) := "0000000000";
begin
    ivalue := value;
    index := 1;

    while (ivalue > 0) loop
        digit := ivalue mod 10;
        ivalue := ivalue/10;

        case digit is
            when 0 => temp(index) := '0';
            when 1 => temp(index) := '1';
            when 2 => temp(index) := '2';
            when 3 => temp(index) := '3';
            when 4 => temp(index) := '4';
            when 5 => temp(index) := '5';
            when 6 => temp(index) := '6';
            when 7 => temp(index) := '7';
            when 8 => temp(index) := '8';
            when 9 => temp(index) := '9';
            when others =>
                ASSERT FALSE
                REPORT "Illegal number!"
                SEVERITY ERROR;
        end case;
        index := index + 1;
    end loop;

    if value < 0 then
        return '-'& temp(index downto 1);
    else
        return temp(index downto 1);
    end if;
end INT_TO_STR_ARITH;

-- This function converts a hexadecimal number to an integer
function HEX_STR_TO_INT (str : in string) return integer is
variable len : integer := str'length;
variable ivalue : integer := 0;
variable digit : integer := 0;
begin
    for i in len downto 1 loop
        case str(i) is
            when '0' => digit := 0;
            when '1' => digit := 1;
            when '2' => digit := 2;
            when '3' => digit := 3;
            when '4' => digit := 4;
            when '5' => digit := 5;
            when '6' => digit := 6;
            when '7' => digit := 7;
            when '8' => digit := 8;
            when '9' => digit := 9;
            when 'A' => digit := 10;
            when 'a' => digit := 10;
            when 'B' => digit := 11;
            when 'b' => digit := 11;
            when 'C' => digit := 12;
            when 'c' => digit := 12;
            when 'D' => digit := 13;
            when 'd' => digit := 13;
            when 'E' => digit := 14;
            when 'e' => digit := 14;
            when 'F' => digit := 15;
            when 'f' => digit := 15;
            when others =>
                ASSERT FALSE
                REPORT "Illegal hex character "&  str(i) & "! "
                SEVERITY ERROR;
        end case;
        ivalue := ivalue * 16 + digit;
    end loop;
    return ivalue;
end HEX_STR_TO_INT;

-- This function converts a binary number to an integer
function BIN_STR_TO_INT (str : in string) return integer is
variable len : integer := str'length;
variable ivalue : integer := 0;
variable digit : integer := 0;
begin
    for i in len downto 1 loop
        case str(i) is
            when '0' => digit := 0;
            when '1' => digit := 1;
            when others =>
                ASSERT FALSE
                REPORT "Illegal bin character "&  str(i) & "! "
                SEVERITY ERROR;
        end case;
        ivalue := ivalue * 2 + digit;
    end loop;
    return ivalue;
end BIN_STR_TO_INT;

-- This function converts a octadecimal number to an integer
function OCT_STR_TO_INT (str : in string) return integer is
variable len : integer := str'length;
variable ivalue : integer := 0;
variable digit : integer := 0;
begin
    for i in len downto 1 loop
        case str(i) is
            when '0' => digit := 0;
            when '1' => digit := 1;
            when '2' => digit := 2;
            when '3' => digit := 3;
            when '4' => digit := 4;
            when '5' => digit := 5;
            when '6' => digit := 6;
            when '7' => digit := 7;
            when others =>
                ASSERT FALSE
                REPORT "Illegal octadecimal character "&  str(i) & "! "
                SEVERITY ERROR;
        end case;
        ivalue := ivalue * 8 + digit;
    end loop;
    return ivalue;
end OCT_STR_TO_INT;

-- This function converts a integer string to an integer
function INT_STR_TO_INT (str : in string) return integer is
variable len : integer := str'length;
variable newdigit : integer := 0;
variable sign : integer := 1;
variable digit : integer := 0;
begin
    for i in 1 to len loop
        case str(i) is
            when '-' =>
                if i = 1 then
                    sign := -1;
                else
                    ASSERT FALSE
                    REPORT "Illegal Character "&  str(i) & "i n string parameter! "
                    SEVERITY ERROR;
                end if;
            when '0' =>
                digit := 0;
            when '1' =>
                digit := 1;
            when '2' =>
                digit := 2;
            when '3' =>
                digit := 3;
            when '4' =>
                digit := 4;
            when '5' =>
                digit := 5;
            when '6' =>
                digit := 6;
            when '7' =>
                digit := 7;
            when '8' =>
                digit := 8;
            when '9' =>
                digit := 9;
            when others =>
                ASSERT FALSE
                REPORT "Illegal Character "&  str(i) & "in string parameter! "
                SEVERITY ERROR;
        end case;
        newdigit := newdigit * 10 + digit;
    end loop;

    return (sign*newdigit);
end;

-- converts uppercase parameter values (e.g. "AUTO") to lowercase ("auto")
function ALPHA_TOLOWER (given_string : in string) return string is
    -- VARIABLE DECLARATION
    variable result_string : string(given_string'low to given_string'high);

begin
    for i in given_string'low to given_string'high loop
        case given_string(i) is
            when 'A' => result_string(i) := 'a';
            when 'B' => result_string(i) := 'b';
            when 'C' => result_string(i) := 'c';
            when 'D' => result_string(i) := 'd';
            when 'E' => result_string(i) := 'e';
            when 'F' => result_string(i) := 'f';
            when 'G' => result_string(i) := 'g';
            when 'H' => result_string(i) := 'h';
            when 'I' => result_string(i) := 'i';
            when 'J' => result_string(i) := 'j';
            when 'K' => result_string(i) := 'k';
            when 'L' => result_string(i) := 'l';
            when 'M' => result_string(i) := 'm';
            when 'N' => result_string(i) := 'n';
            when 'O' => result_string(i) := 'o';
            when 'P' => result_string(i) := 'p';
            when 'Q' => result_string(i) := 'q';
            when 'R' => result_string(i) := 'r';
            when 'S' => result_string(i) := 's';
            when 'T' => result_string(i) := 't';
            when 'U' => result_string(i) := 'u';
            when 'V' => result_string(i) := 'v';
            when 'W' => result_string(i) := 'w';
            when 'X' => result_string(i) := 'x';
            when 'Y' => result_string(i) := 'y';
            when 'Z' => result_string(i) := 'z';
            when others => result_string(i) := given_string(i);
        end case;
    end loop;

    return (result_string(given_string'low to given_string'high));
end;

-- This procedure "cuts" the str_line into desired length
procedure SHRINK_LINE (str_line : inout line; pos : in integer) is
subtype nstring is string(1 to pos);
variable str : nstring;
begin
    if (pos >= 1) then
        read(str_line, str);
    end if;
end;
end ALTERA_COMMON_CONVERSION;
-- END OF PACKAGE

---START_PACKAGE_HEADER-----------------------------------------------------
--
-- Package Name    :  ALTERA_MF_HINT_EVALUATION
--
-- Description     :  Common function to grep the value of altera specific parameters
--                    within the lpm_hint parameter.
--
---END_PACKAGE_HEADER--------------------------------------------------------

-- BEGINING OF PACKAGE
Library ieee;
use ieee.std_logic_1164.all;

-- PACKAGE DECLARATION
package ALTERA_MF_HINT_EVALUATION is
-- FUNCTION DECLARATION
    function get_parameter_value( constant  given_string : string;
                                            compare_param_name : string) return string;
end ALTERA_MF_HINT_EVALUATION;

package body ALTERA_MF_HINT_EVALUATION is

-- This function will search through the string (given string) to look for a match for the
-- a given parameter(compare_param_name). It will return the value for the given parameter.
function get_parameter_value( constant  given_string : string; 
                                        compare_param_name : string) return string is
    variable param_name_left_index   : integer := given_string'length;
    variable param_name_right_index  : integer := given_string'length;
    variable param_value_left_index  : integer := given_string'length;
    variable param_value_right_index : integer := given_string'length;
    variable set_right_index         : boolean := true;
    variable extract_param_value     : boolean := true; 
    variable extract_param_name      : boolean := false;  
    variable param_found             : boolean := false;
    
begin

    -- checking every character of the given_string from right to left.
    for i in given_string'length downto 1 loop
        if (given_string(i) /= ' ') then
            if (given_string(i) = '=') then
                extract_param_value := false;
                extract_param_name  := true;
                set_right_index := true;
            elsif (given_string(i) = ',') then
                extract_param_value := true;
                extract_param_name  := false;
                set_right_index := true;
                
                if (compare_param_name = given_string(param_name_left_index to param_name_right_index)) then
                        param_found := true;  -- the compare_param_name have been found in the given_string
                        exit;
                end if;            
            else            
                if (extract_param_value = true) then                
                    if (set_right_index = true) then                    
                        param_value_right_index := i;
                        set_right_index := false;    
                    end if;
                    param_value_left_index := i;
                elsif (extract_param_name = true) then                
                    if (set_right_index = true) then                    
                        param_name_right_index := i;
                        set_right_index := false;    
                    end if;
                    param_name_left_index := i;    
                end if;
            end if;
        end if;
    end loop;

    -- for the case whether parameter's name is the left most part of the given_string
    if (extract_param_name = true) then
        if(compare_param_name = given_string(param_name_left_index to param_name_right_index)) then        
            param_found := true;                
        end if;
    end if;

    if(param_found = true) then             
        return given_string(param_value_left_index to param_value_right_index);    
    else    
        return "";   -- return empty string if parameter not found
    end if;
    
end get_parameter_value;
end ALTERA_MF_HINT_EVALUATION;
-- END OF PACKAGE 

---START_PACKAGE_HEADER-----------------------------------------------------
--
-- Package Name    :  ALTERA_DEVICE_FAMILIES
--
-- Description     :  Common Altera device families comparison
--
---END_PACKAGE_HEADER--------------------------------------------------------

-- BEGINING OF PACKAGES
Library ieee;
use ieee.std_logic_1164.all;

-- PACKAGE DECLARATION
package ALTERA_DEVICE_FAMILIES is
-- FUNCTION DECLARATION
    function IS_FAMILY_STRATIX (device : in string) return boolean;
    function IS_FAMILY_STRATIXGX (device : in string) return boolean;
    function IS_FAMILY_CYCLONE (device : in string) return boolean;
    function IS_FAMILY_MAXII (device : in string) return boolean;
    function IS_FAMILY_HARDCOPYSTRATIX (device : in string) return boolean;
    function IS_FAMILY_STRATIXII (device : in string) return boolean;
    function IS_FAMILY_STRATIXIIGX (device : in string) return boolean;
    function IS_FAMILY_ARRIAGX (device : in string) return boolean;
    function IS_FAMILY_CYCLONEII (device : in string) return boolean;
    function IS_FAMILY_HARDCOPYII (device : in string) return boolean;
    function IS_FAMILY_STRATIXIII (device : in string) return boolean;
    function IS_FAMILY_CYCLONEIII (device : in string) return boolean;
    function IS_FAMILY_STRATIXIV (device : in string) return boolean;
    function IS_FAMILY_ARRIAIIGX (device : in string) return boolean;
    function IS_FAMILY_HARDCOPYIII (device : in string) return boolean;
    function IS_FAMILY_HARDCOPYIV (device : in string) return boolean;
    function IS_FAMILY_CYCLONEIIILS (device : in string) return boolean;
    function IS_FAMILY_CYCLONEIVGX (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIXGX (device : in string) return boolean;
    function FEATURE_FAMILY_CYCLONE (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIXIIGX (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIXIII (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIXII (device : in string) return boolean;
    function FEATURE_FAMILY_CYCLONEIVGX (device : in string) return boolean;
    function FEATURE_FAMILY_CYCLONEIII (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIX_HC (device : in string) return boolean;
    function FEATURE_FAMILY_HARDCOPYII (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIX (device : in string) return boolean;
    function FEATURE_FAMILY_MAXII (device : in string) return boolean;
    function FEATURE_FAMILY_CYCLONEII (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIXIV (device : in string) return boolean;
    function FEATURE_FAMILY_ARRIAIIGX (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_STRATIXII (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_STRATIX (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_CYCLONEII (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_CYCLONE (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_CYCLONEIII (device : in string) return boolean;
    function FEATURE_FAMILY_BASE_STRATIXIII (device : in string) return boolean;
    function FEATURE_FAMILY_STRATIX_NONGX (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_MEGARAM (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_M512 (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_LUTRAM (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_STRATIXI_STYLE_RAM (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_STRATIXII_STYLE_RAM (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_STRATIXIII_STYLE_RAM (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_STRATIX_STYLE_PLL (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_STRATIXII_STYLE_PLL (device : in string) return boolean;
    function FEATURE_FAMILY_USES_STRATIXIII_PLL (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_FLEXIBLE_LVDS (device : in string) return boolean;
    function FEATURE_FAMILY_HAS_INVERTED_OUTPUT_DDIO (device : in string) return boolean;
    function IS_VALID_FAMILY (device: in string) return boolean;
end ALTERA_DEVICE_FAMILIES;

package body ALTERA_DEVICE_FAMILIES is


function IS_FAMILY_STRATIX (device : in string) return boolean is
variable is_stratix : boolean := false;
begin
    if ((device = "Stratix") or (device = "STRATIX") or (device = "stratix") or (device = "Yeager") or (device = "YEAGER") or (device = "yeager"))
    then
        is_stratix := true;
    end if;
    return is_stratix;
end IS_FAMILY_STRATIX;

function IS_FAMILY_STRATIXGX (device : in string) return boolean is
variable is_stratixgx : boolean := false;
begin
    if ((device = "Stratix GX") or (device = "STRATIX GX") or (device = "stratix gx") or (device = "Stratix-GX") or (device = "STRATIX-GX") or (device = "stratix-gx") or (device = "StratixGX") or (device = "STRATIXGX") or (device = "stratixgx") or (device = "Aurora") or (device = "AURORA") or (device = "aurora"))
    then
        is_stratixgx := true;
    end if;
    return is_stratixgx;
end IS_FAMILY_STRATIXGX;

function IS_FAMILY_CYCLONE (device : in string) return boolean is
variable is_cyclone : boolean := false;
begin
    if ((device = "Cyclone") or (device = "CYCLONE") or (device = "cyclone") or (device = "ACEX2K") or (device = "acex2k") or (device = "ACEX 2K") or (device = "acex 2k") or (device = "Tornado") or (device = "TORNADO") or (device = "tornado"))
    then
        is_cyclone := true;
    end if;
    return is_cyclone;
end IS_FAMILY_CYCLONE;

function IS_FAMILY_MAXII (device : in string) return boolean is
variable is_maxii : boolean := false;
begin
    if ((device = "MAX II") or (device = "max ii") or (device = "MAXII") or (device = "maxii") or (device = "Tsunami") or (device = "TSUNAMI") or (device = "tsunami"))
    then
        is_maxii := true;
    end if;
    return is_maxii;
end IS_FAMILY_MAXII;

function IS_FAMILY_HARDCOPYSTRATIX (device : in string) return boolean is
variable is_hardcopystratix : boolean := false;
begin
    if ((device = "HardCopy Stratix") or (device = "HARDCOPY STRATIX") or (device = "hardcopy stratix") or (device = "Stratix HC") or (device = "STRATIX HC") or (device = "stratix hc") or (device = "StratixHC") or (device = "STRATIXHC") or (device = "stratixhc") or (device = "HardcopyStratix") or (device = "HARDCOPYSTRATIX") or (device = "hardcopystratix"))
    then
        is_hardcopystratix := true;
    end if;
    return is_hardcopystratix;
end IS_FAMILY_HARDCOPYSTRATIX;

function IS_FAMILY_STRATIXII (device : in string) return boolean is
variable is_stratixii : boolean := false;
begin
    if ((device = "Stratix II") or (device = "STRATIX II") or (device = "stratix ii") or (device = "StratixII") or (device = "STRATIXII") or (device = "stratixii") or (device = "Armstrong") or (device = "ARMSTRONG") or (device = "armstrong"))
    then
        is_stratixii := true;
    end if;
    return is_stratixii;
end IS_FAMILY_STRATIXII;

function IS_FAMILY_STRATIXIIGX (device : in string) return boolean is
variable is_stratixiigx : boolean := false;
begin
    if ((device = "Stratix II GX") or (device = "STRATIX II GX") or (device = "stratix ii gx") or (device = "StratixIIGX") or (device = "STRATIXIIGX") or (device = "stratixiigx"))
    then
        is_stratixiigx := true;
    end if;
    return is_stratixiigx;
end IS_FAMILY_STRATIXIIGX;

function IS_FAMILY_ARRIAGX (device : in string) return boolean is
variable is_arriagx : boolean := false;
begin
    if ((device = "Arria GX") or (device = "ARRIA GX") or (device = "arria gx") or (device = "ArriaGX") or (device = "ARRIAGX") or (device = "arriagx") or (device = "Stratix II GX Lite") or (device = "STRATIX II GX LITE") or (device = "stratix ii gx lite") or (device = "StratixIIGXLite") or (device = "STRATIXIIGXLITE") or (device = "stratixiigxlite"))
    then
        is_arriagx := true;
    end if;
    return is_arriagx;
end IS_FAMILY_ARRIAGX;

function IS_FAMILY_CYCLONEII (device : in string) return boolean is
variable is_cycloneii : boolean := false;
begin
    if ((device = "Cyclone II") or (device = "CYCLONE II") or (device = "cyclone ii") or (device = "Cycloneii") or (device = "CYCLONEII") or (device = "cycloneii") or (device = "Magellan") or (device = "MAGELLAN") or (device = "magellan"))
    then
        is_cycloneii := true;
    end if;
    return is_cycloneii;
end IS_FAMILY_CYCLONEII;

function IS_FAMILY_HARDCOPYII (device : in string) return boolean is
variable is_hardcopyii : boolean := false;
begin
    if ((device = "HardCopy II") or (device = "HARDCOPY II") or (device = "hardcopy ii") or (device = "HardCopyII") or (device = "HARDCOPYII") or (device = "hardcopyii") or (device = "Fusion") or (device = "FUSION") or (device = "fusion"))
    then
        is_hardcopyii := true;
    end if;
    return is_hardcopyii;
end IS_FAMILY_HARDCOPYII;

function IS_FAMILY_STRATIXIII (device : in string) return boolean is
variable is_stratixiii : boolean := false;
begin
    if ((device = "Stratix III") or (device = "STRATIX III") or (device = "stratix iii") or (device = "StratixIII") or (device = "STRATIXIII") or (device = "stratixiii") or (device = "Titan") or (device = "TITAN") or (device = "titan") or (device = "SIII") or (device = "siii"))
    then
        is_stratixiii := true;
    end if;
    return is_stratixiii;
end IS_FAMILY_STRATIXIII;

function IS_FAMILY_CYCLONEIII (device : in string) return boolean is
variable is_cycloneiii : boolean := false;
begin
    if ((device = "Cyclone III") or (device = "CYCLONE III") or (device = "cyclone iii") or (device = "CycloneIII") or (device = "CYCLONEIII") or (device = "cycloneiii") or (device = "Barracuda") or (device = "BARRACUDA") or (device = "barracuda") or (device = "Cuda") or (device = "CUDA") or (device = "cuda") or (device = "CIII") or (device = "ciii"))
    then
        is_cycloneiii := true;
    end if;
    return is_cycloneiii;
end IS_FAMILY_CYCLONEIII;

function IS_FAMILY_STRATIXIV (device : in string) return boolean is
variable is_stratixiv : boolean := false;
begin
    if ((device = "Stratix IV") or (device = "STRATIX IV") or (device = "stratix iv") or (device = "TGX") or (device = "tgx") or (device = "StratixIV") or (device = "STRATIXIV") or (device = "stratixiv") or (device = "Stratix IV (GT)") or (device = "STRATIX IV (GT)") or (device = "stratix iv (gt)") or (device = "Stratix IV (GX)") or (device = "STRATIX IV (GX)") or (device = "stratix iv (gx)") or (device = "Stratix IV (E)") or (device = "STRATIX IV (E)") or (device = "stratix iv (e)") or (device = "StratixIV(GT)") or (device = "STRATIXIV(GT)") or (device = "stratixiv(gt)") or (device = "StratixIV(GX)") or (device = "STRATIXIV(GX)") or (device = "stratixiv(gx)") or (device = "StratixIV(E)") or (device = "STRATIXIV(E)") or (device = "stratixiv(e)") or (device = "StratixIIIGX") or (device = "STRATIXIIIGX") or (device = "stratixiiigx") or (device = "Stratix IV (GT/GX/E)") or (device = "STRATIX IV (GT/GX/E)") or (device = "stratix iv (gt/gx/e)") or (device = "Stratix IV (GT/E/GX)") or (device = "STRATIX IV (GT/E/GX)") or (device = "stratix iv (gt/e/gx)") or (device = "Stratix IV (E/GT/GX)") or (device = "STRATIX IV (E/GT/GX)") or (device = "stratix iv (e/gt/gx)") or (device = "Stratix IV (E/GX/GT)") or (device = "STRATIX IV (E/GX/GT)") or (device = "stratix iv (e/gx/gt)") or (device = "StratixIV(GT/GX/E)") or (device = "STRATIXIV(GT/GX/E)") or (device = "stratixiv(gt/gx/e)") or (device = "StratixIV(GT/E/GX)") or (device = "STRATIXIV(GT/E/GX)") or (device = "stratixiv(gt/e/gx)") or (device = "StratixIV(E/GX/GT)") or (device = "STRATIXIV(E/GX/GT)") or (device = "stratixiv(e/gx/gt)") or (device = "StratixIV(E/GT/GX)") or (device = "STRATIXIV(E/GT/GX)") or (device = "stratixiv(e/gt/gx)") or (device = "Stratix IV (GX/E)") or (device = "STRATIX IV (GX/E)") or (device = "stratix iv (gx/e)") or (device = "StratixIV(GX/E)") or (device = "STRATIXIV(GX/E)") or (device = "stratixiv(gx/e)"))
    then
        is_stratixiv := true;
    end if;
    return is_stratixiv;
end IS_FAMILY_STRATIXIV;

function IS_FAMILY_ARRIAIIGX (device : in string) return boolean is
variable is_arriaiigx : boolean := false;
begin
    if ((device = "Arria II GX") or (device = "ARRIA II GX") or (device = "arria ii gx") or (device = "ArriaIIGX") or (device = "ARRIAIIGX") or (device = "arriaiigx") or (device = "Arria IIGX") or (device = "ARRIA IIGX") or (device = "arria iigx") or (device = "ArriaII GX") or (device = "ARRIAII GX") or (device = "arriaii gx") or (device = "Arria II") or (device = "ARRIA II") or (device = "arria ii") or (device = "ArriaII") or (device = "ARRIAII") or (device = "arriaii") or (device = "Arria II (GX/E)") or (device = "ARRIA II (GX/E)") or (device = "arria ii (gx/e)") or (device = "ArriaII(GX/E)") or (device = "ARRIAII(GX/E)") or (device = "arriaii(gx/e)") or (device = "PIRANHA") or (device = "piranha"))
    then
        is_arriaiigx := true;
    end if;
    return is_arriaiigx;
end IS_FAMILY_ARRIAIIGX;

function IS_FAMILY_HARDCOPYIII (device : in string) return boolean is
variable is_hardcopyiii : boolean := false;
begin
    if ((device = "HardCopy III") or (device = "HARDCOPY III") or (device = "hardcopy iii") or (device = "HardCopyIII") or (device = "HARDCOPYIII") or (device = "hardcopyiii") or (device = "HCX") or (device = "hcx"))
    then
        is_hardcopyiii := true;
    end if;
    return is_hardcopyiii;
end IS_FAMILY_HARDCOPYIII;

function IS_FAMILY_HARDCOPYIV (device : in string) return boolean is
variable is_hardcopyiv : boolean := false;
begin
    if ((device = "HardCopy IV") or (device = "HARDCOPY IV") or (device = "hardcopy iv") or (device = "HardCopyIV") or (device = "HARDCOPYIV") or (device = "hardcopyiv") or (device = "HardCopy IV (GX)") or (device = "HARDCOPY IV (GX)") or (device = "hardcopy iv (gx)") or (device = "HardCopy IV (E)") or (device = "HARDCOPY IV (E)") or (device = "hardcopy iv (e)") or (device = "HardCopyIV(GX)") or (device = "HARDCOPYIV(GX)") or (device = "hardcopyiv(gx)") or (device = "HardCopyIV(E)") or (device = "HARDCOPYIV(E)") or (device = "hardcopyiv(e)") or (device = "HCXIV") or (device = "hcxiv") or (device = "HardCopy IV (GX/E)") or (device = "HARDCOPY IV (GX/E)") or (device = "hardcopy iv (gx/e)") or (device = "HardCopy IV (E/GX)") or (device = "HARDCOPY IV (E/GX)") or (device = "hardcopy iv (e/gx)") or (device = "HardCopyIV(GX/E)") or (device = "HARDCOPYIV(GX/E)") or (device = "hardcopyiv(gx/e)") or (device = "HardCopyIV(E/GX)") or (device = "HARDCOPYIV(E/GX)") or (device = "hardcopyiv(e/gx)"))
    then
        is_hardcopyiv := true;
    end if;
    return is_hardcopyiv;
end IS_FAMILY_HARDCOPYIV;

function IS_FAMILY_CYCLONEIIILS (device : in string) return boolean is
variable is_cycloneiiils : boolean := false;
begin
    if ((device = "Cyclone III LS") or (device = "CYCLONE III LS") or (device = "cyclone iii ls") or (device = "CycloneIIILS") or (device = "CYCLONEIIILS") or (device = "cycloneiiils") or (device = "Cyclone III LPS") or (device = "CYCLONE III LPS") or (device = "cyclone iii lps") or (device = "Cyclone LPS") or (device = "CYCLONE LPS") or (device = "cyclone lps") or (device = "CycloneLPS") or (device = "CYCLONELPS") or (device = "cyclonelps") or (device = "Tarpon") or (device = "TARPON") or (device = "tarpon") or (device = "Cyclone IIIE") or (device = "CYCLONE IIIE") or (device = "cyclone iiie"))
    then
        is_cycloneiiils := true;
    end if;
    return is_cycloneiiils;
end IS_FAMILY_CYCLONEIIILS;

function IS_FAMILY_CYCLONEIVGX (device : in string) return boolean is
variable is_cycloneivgx : boolean := false;
begin
    if ((device = "Cyclone IV GX") or (device = "CYCLONE IV GX") or (device = "cyclone iv gx") or (device = "Cyclone IVGX") or (device = "CYCLONE IVGX") or (device = "cyclone ivgx") or (device = "CycloneIV GX") or (device = "CYCLONEIV GX") or (device = "cycloneiv gx") or (device = "CycloneIVGX") or (device = "CYCLONEIVGX") or (device = "cycloneivgx") or (device = "Cyclone IV") or (device = "CYCLONE IV") or (device = "cyclone iv") or (device = "CycloneIV") or (device = "CYCLONEIV") or (device = "cycloneiv") or (device = "Cyclone IV (GX)") or (device = "CYCLONE IV (GX)") or (device = "cyclone iv (gx)") or (device = "CycloneIV(GX)") or (device = "CYCLONEIV(GX)") or (device = "cycloneiv(gx)") or (device = "Cyclone III GX") or (device = "CYCLONE III GX") or (device = "cyclone iii gx") or (device = "CycloneIII GX") or (device = "CYCLONEIII GX") or (device = "cycloneiii gx") or (device = "Cyclone IIIGX") or (device = "CYCLONE IIIGX") or (device = "cyclone iiigx") or (device = "CycloneIIIGX") or (device = "CYCLONEIIIGX") or (device = "cycloneiiigx") or (device = "Cyclone III GL") or (device = "CYCLONE III GL") or (device = "cyclone iii gl") or (device = "CycloneIII GL") or (device = "CYCLONEIII GL") or (device = "cycloneiii gl") or (device = "Cyclone IIIGL") or (device = "CYCLONE IIIGL") or (device = "cyclone iiigl") or (device = "CycloneIIIGL") or (device = "CYCLONEIIIGL") or (device = "cycloneiiigl") or (device = "Stingray") or (device = "STINGRAY") or (device = "stingray"))
    then
        is_cycloneivgx := true;
    end if;
    return is_cycloneivgx;
end IS_FAMILY_CYCLONEIVGX;

function FEATURE_FAMILY_STRATIXGX (device : in string) return boolean is
variable var_family_stratixgx : boolean := false;
begin
    if (IS_FAMILY_STRATIXGX(device) )
    then
        var_family_stratixgx := true;
    end if;
    return var_family_stratixgx;
end FEATURE_FAMILY_STRATIXGX;


function FEATURE_FAMILY_CYCLONE (device : in string) return boolean is
variable var_family_cyclone : boolean := false;
begin
    if (IS_FAMILY_CYCLONE(device) )
    then
        var_family_cyclone := true;
    end if;
    return var_family_cyclone;
end FEATURE_FAMILY_CYCLONE;


function FEATURE_FAMILY_STRATIXIIGX (device : in string) return boolean is
variable var_family_stratixiigx : boolean := false;
begin
    if (IS_FAMILY_STRATIXIIGX(device) or IS_FAMILY_ARRIAGX(device) )
    then
        var_family_stratixiigx := true;
    end if;
    return var_family_stratixiigx;
end FEATURE_FAMILY_STRATIXIIGX;


function FEATURE_FAMILY_STRATIXIII (device : in string) return boolean is
variable var_family_stratixiii : boolean := false;
begin
    if (IS_FAMILY_STRATIXIII(device) or FEATURE_FAMILY_STRATIXIV(device) or IS_FAMILY_HARDCOPYIII(device) )
    then
        var_family_stratixiii := true;
    end if;
    return var_family_stratixiii;
end FEATURE_FAMILY_STRATIXIII;


function FEATURE_FAMILY_STRATIXII (device : in string) return boolean is
variable var_family_stratixii : boolean := false;
begin
    if (IS_FAMILY_STRATIXII(device) or IS_FAMILY_HARDCOPYII(device) or FEATURE_FAMILY_STRATIXIIGX(device) or FEATURE_FAMILY_STRATIXIII(device) )
    then
        var_family_stratixii := true;
    end if;
    return var_family_stratixii;
end FEATURE_FAMILY_STRATIXII;


function FEATURE_FAMILY_CYCLONEIVGX (device : in string) return boolean is
variable var_family_cycloneivgx : boolean := false;
begin
    if (IS_FAMILY_CYCLONEIVGX(device) or IS_FAMILY_CYCLONEIVGX(device) )
    then
        var_family_cycloneivgx := true;
    end if;
    return var_family_cycloneivgx;
end FEATURE_FAMILY_CYCLONEIVGX;


function FEATURE_FAMILY_CYCLONEIII (device : in string) return boolean is
variable var_family_cycloneiii : boolean := false;
begin
    if (IS_FAMILY_CYCLONEIII(device) or IS_FAMILY_CYCLONEIIILS(device) or FEATURE_FAMILY_CYCLONEIVGX(device) )
    then
        var_family_cycloneiii := true;
    end if;
    return var_family_cycloneiii;
end FEATURE_FAMILY_CYCLONEIII;


function FEATURE_FAMILY_STRATIX_HC (device : in string) return boolean is
variable var_family_stratix_hc : boolean := false;
begin
    if (IS_FAMILY_HARDCOPYSTRATIX(device) )
    then
        var_family_stratix_hc := true;
    end if;
    return var_family_stratix_hc;
end FEATURE_FAMILY_STRATIX_HC;


function FEATURE_FAMILY_HARDCOPYII (device : in string) return boolean is
variable var_family_hardcopyii : boolean := false;
begin
    if (IS_FAMILY_HARDCOPYII(device) )
    then
        var_family_hardcopyii := true;
    end if;
    return var_family_hardcopyii;
end FEATURE_FAMILY_HARDCOPYII;


function FEATURE_FAMILY_STRATIX (device : in string) return boolean is
variable var_family_stratix : boolean := false;
begin
    if (IS_FAMILY_STRATIX(device) or FEATURE_FAMILY_STRATIX_HC(device) or FEATURE_FAMILY_STRATIXGX(device) or FEATURE_FAMILY_CYCLONE(device) or FEATURE_FAMILY_STRATIXII(device) or FEATURE_FAMILY_MAXII(device) or FEATURE_FAMILY_CYCLONEII(device) )
    then
        var_family_stratix := true;
    end if;
    return var_family_stratix;
end FEATURE_FAMILY_STRATIX;


function FEATURE_FAMILY_MAXII (device : in string) return boolean is
variable var_family_maxii : boolean := false;
begin
    if (IS_FAMILY_MAXII(device) )
    then
        var_family_maxii := true;
    end if;
    return var_family_maxii;
end FEATURE_FAMILY_MAXII;


function FEATURE_FAMILY_CYCLONEII (device : in string) return boolean is
variable var_family_cycloneii : boolean := false;
begin
    if (IS_FAMILY_CYCLONEII(device) or FEATURE_FAMILY_CYCLONEIII(device) )
    then
        var_family_cycloneii := true;
    end if;
    return var_family_cycloneii;
end FEATURE_FAMILY_CYCLONEII;


function FEATURE_FAMILY_STRATIXIV (device : in string) return boolean is
variable var_family_stratixiv : boolean := false;
begin
    if (IS_FAMILY_STRATIXIV(device) or IS_FAMILY_ARRIAIIGX(device) or IS_FAMILY_HARDCOPYIV(device) )
    then
        var_family_stratixiv := true;
    end if;
    return var_family_stratixiv;
end FEATURE_FAMILY_STRATIXIV;


function FEATURE_FAMILY_ARRIAIIGX (device : in string) return boolean is
variable var_family_arriaiigx : boolean := false;
begin
    if (IS_FAMILY_ARRIAIIGX(device) )
    then
        var_family_arriaiigx := true;
    end if;
    return var_family_arriaiigx;
end FEATURE_FAMILY_ARRIAIIGX;


function FEATURE_FAMILY_BASE_STRATIXII (device : in string) return boolean is
variable var_family_base_stratixii : boolean := false;
begin
    if (IS_FAMILY_STRATIXII(device) or IS_FAMILY_HARDCOPYII(device) or FEATURE_FAMILY_STRATIXIIGX(device) )
    then
        var_family_base_stratixii := true;
    end if;
    return var_family_base_stratixii;
end FEATURE_FAMILY_BASE_STRATIXII;


function FEATURE_FAMILY_BASE_STRATIX (device : in string) return boolean is
variable var_family_base_stratix : boolean := false;
begin
    if (IS_FAMILY_STRATIX(device) or IS_FAMILY_STRATIXGX(device) or IS_FAMILY_HARDCOPYSTRATIX(device) )
    then
        var_family_base_stratix := true;
    end if;
    return var_family_base_stratix;
end FEATURE_FAMILY_BASE_STRATIX;


function FEATURE_FAMILY_BASE_CYCLONEII (device : in string) return boolean is
variable var_family_base_cycloneii : boolean := false;
begin
    if (IS_FAMILY_CYCLONEII(device) )
    then
        var_family_base_cycloneii := true;
    end if;
    return var_family_base_cycloneii;
end FEATURE_FAMILY_BASE_CYCLONEII;


function FEATURE_FAMILY_BASE_CYCLONE (device : in string) return boolean is
variable var_family_base_cyclone : boolean := false;
begin
    if (IS_FAMILY_CYCLONE(device) )
    then
        var_family_base_cyclone := true;
    end if;
    return var_family_base_cyclone;
end FEATURE_FAMILY_BASE_CYCLONE;


function FEATURE_FAMILY_BASE_CYCLONEIII (device : in string) return boolean is
variable var_family_base_cycloneiii : boolean := false;
begin
    if (IS_FAMILY_CYCLONEIII(device) or IS_FAMILY_CYCLONEIIILS(device) or IS_FAMILY_CYCLONEIVGX(device) )
    then
        var_family_base_cycloneiii := true;
    end if;
    return var_family_base_cycloneiii;
end FEATURE_FAMILY_BASE_CYCLONEIII;


function FEATURE_FAMILY_BASE_STRATIXIII (device : in string) return boolean is
variable var_family_base_stratixiii : boolean := false;
begin
    if (IS_FAMILY_STRATIXIII(device) or FEATURE_FAMILY_STRATIXIV(device) or IS_FAMILY_HARDCOPYIII(device) )
    then
        var_family_base_stratixiii := true;
    end if;
    return var_family_base_stratixiii;
end FEATURE_FAMILY_BASE_STRATIXIII;


function FEATURE_FAMILY_STRATIX_NONGX (device : in string) return boolean is
variable var_family_stratix_nongx : boolean := false;
begin
    if (IS_FAMILY_STRATIX(device) or IS_FAMILY_HARDCOPYSTRATIX(device) )
    then
        var_family_stratix_nongx := true;
    end if;
    return var_family_stratix_nongx;
end FEATURE_FAMILY_STRATIX_NONGX;


function FEATURE_FAMILY_HAS_MEGARAM (device : in string) return boolean is
variable var_family_has_megaram : boolean := false;
begin
    if (( IS_FAMILY_STRATIX(device) or FEATURE_FAMILY_STRATIX_HC(device) or IS_FAMILY_STRATIXGX(device) or FEATURE_FAMILY_STRATIXII(device)  ) and NOT FEATURE_FAMILY_ARRIAIIGX(device) )
    then
        var_family_has_megaram := true;
    end if;
    return var_family_has_megaram;
end FEATURE_FAMILY_HAS_MEGARAM;


function FEATURE_FAMILY_HAS_M512 (device : in string) return boolean is
variable var_family_has_m512 : boolean := false;
begin
    if (IS_FAMILY_STRATIX(device) or FEATURE_FAMILY_STRATIX_HC(device) or IS_FAMILY_STRATIXGX(device) or IS_FAMILY_STRATIXII(device) or FEATURE_FAMILY_STRATIXIIGX(device) )
    then
        var_family_has_m512 := true;
    end if;
    return var_family_has_m512;
end FEATURE_FAMILY_HAS_M512;


function FEATURE_FAMILY_HAS_LUTRAM (device : in string) return boolean is
variable var_family_has_lutram : boolean := false;
begin
    if (FEATURE_FAMILY_STRATIXIII(device) )
    then
        var_family_has_lutram := true;
    end if;
    return var_family_has_lutram;
end FEATURE_FAMILY_HAS_LUTRAM;


function FEATURE_FAMILY_HAS_STRATIXI_STYLE_RAM (device : in string) return boolean is
variable var_family_has_stratixi_style_ram : boolean := false;
begin
    if (IS_FAMILY_STRATIX(device) or FEATURE_FAMILY_STRATIX_HC(device) or FEATURE_FAMILY_STRATIXGX(device) or FEATURE_FAMILY_CYCLONE(device) )
    then
        var_family_has_stratixi_style_ram := true;
    end if;
    return var_family_has_stratixi_style_ram;
end FEATURE_FAMILY_HAS_STRATIXI_STYLE_RAM;


function FEATURE_FAMILY_HAS_STRATIXII_STYLE_RAM (device : in string) return boolean is
variable var_family_has_stratixii_style_ram : boolean := false;
begin
    if (FEATURE_FAMILY_STRATIXII(device) or FEATURE_FAMILY_CYCLONEII(device) )
    then
        var_family_has_stratixii_style_ram := true;
    end if;
    return var_family_has_stratixii_style_ram;
end FEATURE_FAMILY_HAS_STRATIXII_STYLE_RAM;


function FEATURE_FAMILY_HAS_STRATIXIII_STYLE_RAM (device : in string) return boolean is
variable var_family_has_stratixiii_style_ram : boolean := false;
begin
    if (FEATURE_FAMILY_STRATIXIII(device) or FEATURE_FAMILY_CYCLONEIII(device) )
    then
        var_family_has_stratixiii_style_ram := true;
    end if;
    return var_family_has_stratixiii_style_ram;
end FEATURE_FAMILY_HAS_STRATIXIII_STYLE_RAM;


function FEATURE_FAMILY_HAS_STRATIX_STYLE_PLL (device : in string) return boolean is
variable var_family_has_stratix_style_pll : boolean := false;
begin
    if (FEATURE_FAMILY_CYCLONE(device) or FEATURE_FAMILY_STRATIX_HC(device) or IS_FAMILY_STRATIX(device) or FEATURE_FAMILY_STRATIXGX(device) )
    then
        var_family_has_stratix_style_pll := true;
    end if;
    return var_family_has_stratix_style_pll;
end FEATURE_FAMILY_HAS_STRATIX_STYLE_PLL;


function FEATURE_FAMILY_HAS_STRATIXII_STYLE_PLL (device : in string) return boolean is
variable var_family_has_stratixii_style_pll : boolean := false;
begin
    if (( ( FEATURE_FAMILY_STRATIXII(device) and NOT FEATURE_FAMILY_STRATIXIII(device)  ) or FEATURE_FAMILY_CYCLONEII(device)  ) and NOT FEATURE_FAMILY_CYCLONEIII(device) )
    then
        var_family_has_stratixii_style_pll := true;
    end if;
    return var_family_has_stratixii_style_pll;
end FEATURE_FAMILY_HAS_STRATIXII_STYLE_PLL;


function FEATURE_FAMILY_USES_STRATIXIII_PLL (device : in string) return boolean is
variable var_family_uses_stratixiii_pll : boolean := false;
begin
    if (FEATURE_FAMILY_STRATIXIII(device) or FEATURE_FAMILY_CYCLONEIII(device) )
    then
        var_family_uses_stratixiii_pll := true;
    end if;
    return var_family_uses_stratixiii_pll;
end FEATURE_FAMILY_USES_STRATIXIII_PLL;


function FEATURE_FAMILY_HAS_FLEXIBLE_LVDS (device : in string) return boolean is
variable var_family_has_flexible_lvds : boolean := false;
begin
    if (FEATURE_FAMILY_CYCLONE(device) or FEATURE_FAMILY_CYCLONEII(device) )
    then
        var_family_has_flexible_lvds := true;
    end if;
    return var_family_has_flexible_lvds;
end FEATURE_FAMILY_HAS_FLEXIBLE_LVDS;


function FEATURE_FAMILY_HAS_INVERTED_OUTPUT_DDIO (device : in string) return boolean is
variable var_family_has_inverted_output_ddio : boolean := false;
begin
    if (FEATURE_FAMILY_CYCLONEII(device) )
    then
        var_family_has_inverted_output_ddio := true;
    end if;
    return var_family_has_inverted_output_ddio;
end FEATURE_FAMILY_HAS_INVERTED_OUTPUT_DDIO;


function IS_VALID_FAMILY (device : in string) return boolean is
variable is_valid : boolean := false;
begin
    if (((device = "ACEX1K") or (device = "acex1k") or (device = "ACEX 1K") or (device = "acex 1k"))
    or ((device = "APEX20KC") or (device = "apex20kc") or (device = "APEX 20KC") or (device = "apex 20kc"))
    or ((device = "APEX20KE") or (device = "apex20ke") or (device = "APEX 20KE") or (device = "apex 20ke"))
    or ((device = "APEX II") or (device = "apex ii") or (device = "APEXII") or (device = "apexii") or (device = "APEX 20KF") or (device = "apex 20kf") or (device = "APEX20KF") or (device = "apex20kf"))
    or ((device = "FLEX10KE") or (device = "flex10ke") or (device = "FLEX 10KE") or (device = "flex 10ke"))
    or ((device = "FLEX10K") or (device = "flex10k") or (device = "FLEX 10K") or (device = "flex 10k"))
    or ((device = "FLEX10KA") or (device = "flex10ka") or (device = "FLEX 10KA") or (device = "flex 10ka"))
    or ((device = "FLEX6000") or (device = "flex6000") or (device = "FLEX 6000") or (device = "flex 6000") or (device = "FLEX6K") or (device = "flex6k"))
    or ((device = "MAX7000B") or (device = "max7000b") or (device = "MAX 7000B") or (device = "max 7000b"))
    or ((device = "MAX7000AE") or (device = "max7000ae") or (device = "MAX 7000AE") or (device = "max 7000ae"))
    or ((device = "MAX3000A") or (device = "max3000a") or (device = "MAX 3000A") or (device = "max 3000a"))
    or ((device = "MAX7000S") or (device = "max7000s") or (device = "MAX 7000S") or (device = "max 7000s"))
    or ((device = "Stratix") or (device = "STRATIX") or (device = "stratix") or (device = "Yeager") or (device = "YEAGER") or (device = "yeager"))
    or ((device = "Stratix GX") or (device = "STRATIX GX") or (device = "stratix gx") or (device = "Stratix-GX") or (device = "STRATIX-GX") or (device = "stratix-gx") or (device = "StratixGX") or (device = "STRATIXGX") or (device = "stratixgx") or (device = "Aurora") or (device = "AURORA") or (device = "aurora"))
    or ((device = "Cyclone") or (device = "CYCLONE") or (device = "cyclone") or (device = "ACEX2K") or (device = "acex2k") or (device = "ACEX 2K") or (device = "acex 2k") or (device = "Tornado") or (device = "TORNADO") or (device = "tornado"))
    or ((device = "MAX II") or (device = "max ii") or (device = "MAXII") or (device = "maxii") or (device = "Tsunami") or (device = "TSUNAMI") or (device = "tsunami"))
    or ((device = "HardCopy Stratix") or (device = "HARDCOPY STRATIX") or (device = "hardcopy stratix") or (device = "Stratix HC") or (device = "STRATIX HC") or (device = "stratix hc") or (device = "StratixHC") or (device = "STRATIXHC") or (device = "stratixhc") or (device = "HardcopyStratix") or (device = "HARDCOPYSTRATIX") or (device = "hardcopystratix"))
    or ((device = "Stratix II") or (device = "STRATIX II") or (device = "stratix ii") or (device = "StratixII") or (device = "STRATIXII") or (device = "stratixii") or (device = "Armstrong") or (device = "ARMSTRONG") or (device = "armstrong"))
    or ((device = "Stratix II GX") or (device = "STRATIX II GX") or (device = "stratix ii gx") or (device = "StratixIIGX") or (device = "STRATIXIIGX") or (device = "stratixiigx"))
    or ((device = "Arria GX") or (device = "ARRIA GX") or (device = "arria gx") or (device = "ArriaGX") or (device = "ARRIAGX") or (device = "arriagx") or (device = "Stratix II GX Lite") or (device = "STRATIX II GX LITE") or (device = "stratix ii gx lite") or (device = "StratixIIGXLite") or (device = "STRATIXIIGXLITE") or (device = "stratixiigxlite"))
    or ((device = "Cyclone II") or (device = "CYCLONE II") or (device = "cyclone ii") or (device = "Cycloneii") or (device = "CYCLONEII") or (device = "cycloneii") or (device = "Magellan") or (device = "MAGELLAN") or (device = "magellan"))
    or ((device = "HardCopy II") or (device = "HARDCOPY II") or (device = "hardcopy ii") or (device = "HardCopyII") or (device = "HARDCOPYII") or (device = "hardcopyii") or (device = "Fusion") or (device = "FUSION") or (device = "fusion"))
    or ((device = "Stratix III") or (device = "STRATIX III") or (device = "stratix iii") or (device = "StratixIII") or (device = "STRATIXIII") or (device = "stratixiii") or (device = "Titan") or (device = "TITAN") or (device = "titan") or (device = "SIII") or (device = "siii"))
    or ((device = "Cyclone III") or (device = "CYCLONE III") or (device = "cyclone iii") or (device = "CycloneIII") or (device = "CYCLONEIII") or (device = "cycloneiii") or (device = "Barracuda") or (device = "BARRACUDA") or (device = "barracuda") or (device = "Cuda") or (device = "CUDA") or (device = "cuda") or (device = "CIII") or (device = "ciii"))
    or ((device = "Stratix IV") or (device = "STRATIX IV") or (device = "stratix iv") or (device = "TGX") or (device = "tgx") or (device = "StratixIV") or (device = "STRATIXIV") or (device = "stratixiv") or (device = "Stratix IV (GT)") or (device = "STRATIX IV (GT)") or (device = "stratix iv (gt)") or (device = "Stratix IV (GX)") or (device = "STRATIX IV (GX)") or (device = "stratix iv (gx)") or (device = "Stratix IV (E)") or (device = "STRATIX IV (E)") or (device = "stratix iv (e)") or (device = "StratixIV(GT)") or (device = "STRATIXIV(GT)") or (device = "stratixiv(gt)") or (device = "StratixIV(GX)") or (device = "STRATIXIV(GX)") or (device = "stratixiv(gx)") or (device = "StratixIV(E)") or (device = "STRATIXIV(E)") or (device = "stratixiv(e)") or (device = "StratixIIIGX") or (device = "STRATIXIIIGX") or (device = "stratixiiigx") or (device = "Stratix IV (GT/GX/E)") or (device = "STRATIX IV (GT/GX/E)") or (device = "stratix iv (gt/gx/e)") or (device = "Stratix IV (GT/E/GX)") or (device = "STRATIX IV (GT/E/GX)") or (device = "stratix iv (gt/e/gx)") or (device = "Stratix IV (E/GT/GX)") or (device = "STRATIX IV (E/GT/GX)") or (device = "stratix iv (e/gt/gx)") or (device = "Stratix IV (E/GX/GT)") or (device = "STRATIX IV (E/GX/GT)") or (device = "stratix iv (e/gx/gt)") or (device = "StratixIV(GT/GX/E)") or (device = "STRATIXIV(GT/GX/E)") or (device = "stratixiv(gt/gx/e)") or (device = "StratixIV(GT/E/GX)") or (device = "STRATIXIV(GT/E/GX)") or (device = "stratixiv(gt/e/gx)") or (device = "StratixIV(E/GX/GT)") or (device = "STRATIXIV(E/GX/GT)") or (device = "stratixiv(e/gx/gt)") or (device = "StratixIV(E/GT/GX)") or (device = "STRATIXIV(E/GT/GX)") or (device = "stratixiv(e/gt/gx)") or (device = "Stratix IV (GX/E)") or (device = "STRATIX IV (GX/E)") or (device = "stratix iv (gx/e)") or (device = "StratixIV(GX/E)") or (device = "STRATIXIV(GX/E)") or (device = "stratixiv(gx/e)"))
    or ((device = "Arria II GX") or (device = "ARRIA II GX") or (device = "arria ii gx") or (device = "ArriaIIGX") or (device = "ARRIAIIGX") or (device = "arriaiigx") or (device = "Arria IIGX") or (device = "ARRIA IIGX") or (device = "arria iigx") or (device = "ArriaII GX") or (device = "ARRIAII GX") or (device = "arriaii gx") or (device = "Arria II") or (device = "ARRIA II") or (device = "arria ii") or (device = "ArriaII") or (device = "ARRIAII") or (device = "arriaii") or (device = "Arria II (GX/E)") or (device = "ARRIA II (GX/E)") or (device = "arria ii (gx/e)") or (device = "ArriaII(GX/E)") or (device = "ARRIAII(GX/E)") or (device = "arriaii(gx/e)") or (device = "PIRANHA") or (device = "piranha"))
    or ((device = "HardCopy III") or (device = "HARDCOPY III") or (device = "hardcopy iii") or (device = "HardCopyIII") or (device = "HARDCOPYIII") or (device = "hardcopyiii") or (device = "HCX") or (device = "hcx"))
    or ((device = "HardCopy IV") or (device = "HARDCOPY IV") or (device = "hardcopy iv") or (device = "HardCopyIV") or (device = "HARDCOPYIV") or (device = "hardcopyiv") or (device = "HardCopy IV (GX)") or (device = "HARDCOPY IV (GX)") or (device = "hardcopy iv (gx)") or (device = "HardCopy IV (E)") or (device = "HARDCOPY IV (E)") or (device = "hardcopy iv (e)") or (device = "HardCopyIV(GX)") or (device = "HARDCOPYIV(GX)") or (device = "hardcopyiv(gx)") or (device = "HardCopyIV(E)") or (device = "HARDCOPYIV(E)") or (device = "hardcopyiv(e)") or (device = "HCXIV") or (device = "hcxiv") or (device = "HardCopy IV (GX/E)") or (device = "HARDCOPY IV (GX/E)") or (device = "hardcopy iv (gx/e)") or (device = "HardCopy IV (E/GX)") or (device = "HARDCOPY IV (E/GX)") or (device = "hardcopy iv (e/gx)") or (device = "HardCopyIV(GX/E)") or (device = "HARDCOPYIV(GX/E)") or (device = "hardcopyiv(gx/e)") or (device = "HardCopyIV(E/GX)") or (device = "HARDCOPYIV(E/GX)") or (device = "hardcopyiv(e/gx)"))
    or ((device = "Cyclone III LS") or (device = "CYCLONE III LS") or (device = "cyclone iii ls") or (device = "CycloneIIILS") or (device = "CYCLONEIIILS") or (device = "cycloneiiils") or (device = "Cyclone III LPS") or (device = "CYCLONE III LPS") or (device = "cyclone iii lps") or (device = "Cyclone LPS") or (device = "CYCLONE LPS") or (device = "cyclone lps") or (device = "CycloneLPS") or (device = "CYCLONELPS") or (device = "cyclonelps") or (device = "Tarpon") or (device = "TARPON") or (device = "tarpon") or (device = "Cyclone IIIE") or (device = "CYCLONE IIIE") or (device = "cyclone iiie"))
    or ((device = "Cyclone IV GX") or (device = "CYCLONE IV GX") or (device = "cyclone iv gx") or (device = "Cyclone IVGX") or (device = "CYCLONE IVGX") or (device = "cyclone ivgx") or (device = "CycloneIV GX") or (device = "CYCLONEIV GX") or (device = "cycloneiv gx") or (device = "CycloneIVGX") or (device = "CYCLONEIVGX") or (device = "cycloneivgx") or (device = "Cyclone IV") or (device = "CYCLONE IV") or (device = "cyclone iv") or (device = "CycloneIV") or (device = "CYCLONEIV") or (device = "cycloneiv") or (device = "Cyclone IV (GX)") or (device = "CYCLONE IV (GX)") or (device = "cyclone iv (gx)") or (device = "CycloneIV(GX)") or (device = "CYCLONEIV(GX)") or (device = "cycloneiv(gx)") or (device = "Cyclone III GX") or (device = "CYCLONE III GX") or (device = "cyclone iii gx") or (device = "CycloneIII GX") or (device = "CYCLONEIII GX") or (device = "cycloneiii gx") or (device = "Cyclone IIIGX") or (device = "CYCLONE IIIGX") or (device = "cyclone iiigx") or (device = "CycloneIIIGX") or (device = "CYCLONEIIIGX") or (device = "cycloneiiigx") or (device = "Cyclone III GL") or (device = "CYCLONE III GL") or (device = "cyclone iii gl") or (device = "CycloneIII GL") or (device = "CYCLONEIII GL") or (device = "cycloneiii gl") or (device = "Cyclone IIIGL") or (device = "CYCLONE IIIGL") or (device = "cyclone iiigl") or (device = "CycloneIIIGL") or (device = "CYCLONEIIIGL") or (device = "cycloneiiigl") or (device = "Stingray") or (device = "STINGRAY") or (device = "stingray")))
    then
        is_valid := true;
    end if;
    return is_valid;
end IS_VALID_FAMILY;


end ALTERA_DEVICE_FAMILIES;
-- END OF PACKAGE

Library ieee;
use ieee.std_logic_1164.all;

-- START PACKAGE HEADER --------------------------------------------------------
--
-- Package Name : MF_pllpack
--
-- Description  : Used by altpll model to calculate required advanced parameters
--                for PLL simulation. Also has functions to do string->integer,
--                integer->string conversions.
--
-- END PACKAGE HEADER ----------------------------------------------------------

-- PACKAGE DECLARATION
package MF_pllpack is

-- FUNCTION DECLARATION
    function int2str (value : integer)
        return string;
function alt_conv_integer(arg : in std_logic_vector) return integer;


    procedure find_simple_integer_fraction( numerator   : in integer;
                                            denominator : in integer;
                                            max_denom   : in integer;
                                            fraction_num : out integer; 
                                            fraction_div : out integer);

    procedure find_m_and_n_4_manual_phase ( inclock_period : in integer;
                                            vco_phase_shift_step : in integer;
                                            clk0_mult: in integer; clk1_mult: in integer;
                                            clk2_mult: in integer; clk3_mult: in integer;
                                            clk4_mult: in integer; clk5_mult: in integer;
                                            clk6_mult: in integer; clk7_mult: in integer;
                                            clk8_mult: in integer; clk9_mult: in integer;
                                            clk0_div : in integer; clk1_div : in integer;
                                            clk2_div : in integer; clk3_div : in integer;
                                            clk4_div : in integer; clk5_div : in integer;
                                            clk6_div : in integer; clk7_div : in integer;
                                            clk8_div : in integer; clk9_div : in integer;
                                            clk0_used : in string; clk1_used : in string;
                                            clk2_used : in string; clk3_used : in string;
                                            clk4_used : in string; clk5_used : in string;
                                            clk6_used : in string; clk7_used : in string;
                                            clk8_used : in string; clk9_used : in string;
                                            m : out integer;
                                            n : out integer );

    function gcd (X: integer; Y: integer) return integer;

    function count_digit (X: integer) return integer;

    function scale_num (X: integer; Y: integer) return integer;

    function lcm (A1: integer; A2: integer; A3: integer; A4: integer;
                A5: integer; A6: integer; A7: integer;
                A8: integer; A9: integer; A10: integer; P: integer) return integer;

    function output_counter_value (clk_divide: integer; clk_mult : integer ;
            M: integer; N: integer ) return integer;

    function counter_mode (duty_cycle: integer; output_counter_value: integer) return string;

    function counter_high (output_counter_value: integer := 1; duty_cycle: integer)
                        return integer;

    function counter_low (output_counter_value: integer; duty_cycle: integer)
                        return integer;

    function mintimedelay (t1: integer; t2: integer; t3: integer; t4: integer;
                        t5: integer; t6: integer; t7: integer; t8: integer;
                        t9: integer; t10: integer) return integer;

    function maxnegabs (t1: integer; t2: integer; t3: integer; t4: integer;
                        t5: integer; t6: integer; t7: integer; t8: integer;
                        t9: integer; t10: integer) return integer;

    function counter_time_delay ( clk_time_delay: integer;
                        m_time_delay: integer; n_time_delay: integer)
                        return integer;

    function get_phase_degree (phase_shift: integer; clk_period: integer) return integer;

    function counter_initial (tap_phase: integer; m: integer; n: integer)
                        return integer;

    function counter_ph (tap_phase: integer; m : integer; n: integer) return integer;

    function ph_adjust (tap_phase: integer; ph_base : integer) return integer;

    function translate_string (mode : string) return string;
    
    function str2int (s : string) return integer;
end MF_pllpack;

-- BEGINNING OF PACKAGE
package body MF_pllpack is

-- convert integer to string
function int2str( value : integer ) return string is
variable ivalue : integer := 0;
variable index : integer := 1;
variable digit : integer := 0;
variable temp: string(10 downto 1) := "0000000000";

begin
    ivalue := value;
    index := 1;

    while (ivalue > 0) loop
        digit := ivalue mod 10;
        ivalue := ivalue/10;

        case digit is
            when 0 =>    temp(index) := '0';
            when 1 =>    temp(index) := '1';
            when 2 =>    temp(index) := '2';
            when 3 =>    temp(index) := '3';
            when 4 =>    temp(index) := '4';
            when 5 =>    temp(index) := '5';
            when 6 =>    temp(index) := '6';
            when 7 =>    temp(index) := '7';
            when 8 =>    temp(index) := '8';
            when 9 =>    temp(index) := '9';
            when others =>  ASSERT FALSE
                            REPORT "Illegal number!"
                            SEVERITY ERROR;
        end case;

        index := index + 1;
    end loop;

    if (value < 0) then
        return ('-'& temp(index downto 1));
    else
        return temp(index downto 1);
    end if;

end int2str;

function alt_conv_integer(arg : in std_logic_vector) return integer is
variable result : integer;
begin
    result := 0;
    for i in arg'range loop
        if arg(i) = '1' then
            result := result + 2**i;
        end if;
    end loop;
    return result;
end alt_conv_integer;


-- finds the closest integer fraction of a given pair of numerator and denominator. 
procedure find_simple_integer_fraction( numerator   : in integer;
                                        denominator : in integer;
                                        max_denom   : in integer;
                                        fraction_num : out integer; 
                                        fraction_div : out integer) is
    constant MAX_ITER : integer := 20; 
    type INT_ARRAY is array ((MAX_ITER-1) downto 0) of integer;

    variable quotient_array : INT_ARRAY;
    variable int_loop_iter : integer;
    variable int_quot  : integer;
    variable m_value   : integer;
    variable d_value   : integer;
    variable old_m_value : integer;
    variable swap  : integer;
    variable loop_iter : integer;
    variable num   : integer;
    variable den   : integer;
    variable i_max_iter : integer;

begin      
    loop_iter := 0;

    if (numerator = 0) then
        num := 1;
    else
        num := numerator;
    end if;

    if (denominator = 0) then
        den := 1;
    else
        den := denominator;
    end if;

    i_max_iter := max_iter;
   
    while (loop_iter < i_max_iter) loop
        int_quot := num / den;
        quotient_array(loop_iter) := int_quot;
        num := num - (den*int_quot);
        loop_iter := loop_iter+1;
        
        if ((num = 0) or (max_denom /= -1) or (loop_iter = i_max_iter)) then
            -- calculate the numerator and denominator if there is a restriction on the
            -- max denom value or if the loop is ending
            m_value := 0;
            d_value := 1;
            -- get the rounded value at this stage for the remaining fraction
            if (den /= 0) then
                m_value := (2*num/den);
            end if;
            -- calculate the fraction numerator and denominator at this stage
            for int_loop_iter in (loop_iter-1) downto 0 loop
                if (m_value = 0) then
                    m_value := quotient_array(int_loop_iter);
                    d_value := 1;
                else
                    old_m_value := m_value;
                    m_value := (quotient_array(int_loop_iter)*m_value) + d_value;
                    d_value := old_m_value;
                end if;
            end loop;
            -- if the denominator is less than the maximum denom_value or if there is no restriction save it
            if ((d_value <= max_denom) or (max_denom = -1)) then
                if ((m_value = 0) or (d_value = 0)) then
                    fraction_num := numerator;
                    fraction_div := denominator;
                else
                    fraction_num := m_value;
                    fraction_div := d_value;
                end if;
            end if;
            -- end the loop if the denomitor has overflown or the numerator is zero (no remainder during this round)
            if (((d_value > max_denom) and (max_denom /= -1)) or (num = 0)) then
                i_max_iter := loop_iter;
            end if;
        end if;
        -- swap the numerator and denominator for the next round
        swap := den;
        den := num;
        num := swap;
    end loop;
end find_simple_integer_fraction;

-- find the M and N values for Manual phase based on the following 5 criterias:
-- 1. The PFD frequency (i.e. Fin / N) must be in the range 5 MHz to 720 MHz
-- 2. The VCO frequency (i.e. Fin * M / N) must be in the range 300 MHz to 1300 MHz
-- 3. M is less than 512
-- 4. N is less than 512
-- 5. It's the smallest M/N which satisfies all the above constraints, and is within 2ps
--    of the desired vco-phase-shift-step
procedure find_m_and_n_4_manual_phase ( inclock_period : in integer;
                                        vco_phase_shift_step : in integer;
                                        clk0_mult: in integer; clk1_mult: in integer;
                                        clk2_mult: in integer; clk3_mult: in integer;
                                        clk4_mult: in integer; clk5_mult: in integer;
                                        clk6_mult: in integer; clk7_mult: in integer;
                                        clk8_mult: in integer; clk9_mult: in integer;
                                        clk0_div : in integer; clk1_div : in integer;
                                        clk2_div : in integer; clk3_div : in integer;
                                        clk4_div : in integer; clk5_div : in integer;
                                        clk6_div : in integer; clk7_div : in integer;
                                        clk8_div : in integer; clk9_div : in integer;
                                        clk0_used : in string; clk1_used : in string;
                                        clk2_used : in string; clk3_used : in string;
                                        clk4_used : in string; clk5_used : in string;
                                        clk6_used : in string; clk7_used : in string;
                                        clk8_used : in string; clk9_used : in string;
                                        m : out integer;
                                        n : out integer ) is
        constant MAX_M : integer := 511;
        constant MAX_N : integer := 511;
        constant MAX_PFD : integer := 720;
        constant MIN_PFD : integer := 5;
        constant MAX_VCO : integer := 1600; -- max vco frequency. (in mHz)
        constant MIN_VCO : integer := 300;  -- min vco frequency. (in mHz)
        constant MAX_OFFSET : real := 0.004;

        variable vco_period : integer;
        variable pfd_freq : integer;
        variable vco_freq : integer;
        variable vco_ps_step_value : integer;

        variable i_m : integer;
        variable i_n : integer;

        variable i_pre_m : integer;
        variable i_pre_n : integer;

        variable closest_vco_step_value : integer;

        variable i_max_iter : integer;
        variable loop_iter : integer;
        
        variable clk0_div_factor_real : real;
        variable clk1_div_factor_real : real;
        variable clk2_div_factor_real : real;
        variable clk3_div_factor_real : real;
        variable clk4_div_factor_real : real;
        variable clk5_div_factor_real : real;
        variable clk6_div_factor_real : real;
        variable clk7_div_factor_real : real;
        variable clk8_div_factor_real : real;
        variable clk9_div_factor_real : real;
        variable clk0_div_factor_int : integer;
        variable clk1_div_factor_int : integer;
        variable clk2_div_factor_int : integer;
        variable clk3_div_factor_int : integer;
        variable clk4_div_factor_int : integer;
        variable clk5_div_factor_int : integer;
        variable clk6_div_factor_int : integer;
        variable clk7_div_factor_int : integer;
        variable clk8_div_factor_int : integer;
        variable clk9_div_factor_int : integer;
begin
    vco_period := vco_phase_shift_step * 8;
    i_pre_m := 0;
    i_pre_n := 0;
    closest_vco_step_value := 0;

    LOOP_1 :   for i_n_out in 1 to MAX_N loop
        for i_m_out in 1 to MAX_M loop
        
            clk0_div_factor_real := real(clk0_div * i_m_out) / real(clk0_mult * i_n_out);
            clk1_div_factor_real := real(clk1_div * i_m_out) / real(clk1_mult * i_n_out);
            clk2_div_factor_real := real(clk2_div * i_m_out) / real(clk2_mult * i_n_out);
            clk3_div_factor_real := real(clk3_div * i_m_out) / real(clk3_mult * i_n_out);
            clk4_div_factor_real := real(clk4_div * i_m_out) / real(clk4_mult * i_n_out);
            clk5_div_factor_real := real(clk5_div * i_m_out) / real(clk5_mult * i_n_out);
            clk6_div_factor_real := real(clk6_div * i_m_out) / real(clk6_mult * i_n_out);
            clk7_div_factor_real := real(clk7_div * i_m_out) / real(clk7_mult * i_n_out);
            clk8_div_factor_real := real(clk8_div * i_m_out) / real(clk8_mult * i_n_out);
            clk9_div_factor_real := real(clk9_div * i_m_out) / real(clk9_mult * i_n_out);

            clk0_div_factor_int := integer(clk0_div_factor_real);
            clk1_div_factor_int := integer(clk1_div_factor_real);
            clk2_div_factor_int := integer(clk2_div_factor_real);
            clk3_div_factor_int := integer(clk3_div_factor_real);
            clk4_div_factor_int := integer(clk4_div_factor_real);
            clk5_div_factor_int := integer(clk5_div_factor_real);
            clk6_div_factor_int := integer(clk6_div_factor_real);
            clk7_div_factor_int := integer(clk7_div_factor_real);
            clk8_div_factor_int := integer(clk8_div_factor_real);
            clk9_div_factor_int := integer(clk9_div_factor_real);
                        
            if (((abs(clk0_div_factor_real - real(clk0_div_factor_int)) < MAX_OFFSET) or (clk0_used = "unused")) and
                ((abs(clk1_div_factor_real - real(clk1_div_factor_int)) < MAX_OFFSET) or (clk1_used = "unused")) and
                ((abs(clk2_div_factor_real - real(clk2_div_factor_int)) < MAX_OFFSET) or (clk2_used = "unused")) and
                ((abs(clk3_div_factor_real - real(clk3_div_factor_int)) < MAX_OFFSET) or (clk3_used = "unused")) and
                ((abs(clk4_div_factor_real - real(clk4_div_factor_int)) < MAX_OFFSET) or (clk4_used = "unused")) and
                ((abs(clk5_div_factor_real - real(clk5_div_factor_int)) < MAX_OFFSET) or (clk5_used = "unused")) and
                ((abs(clk6_div_factor_real - real(clk6_div_factor_int)) < MAX_OFFSET) or (clk6_used = "unused")) and
                ((abs(clk7_div_factor_real - real(clk7_div_factor_int)) < MAX_OFFSET) or (clk7_used = "unused")) and
                ((abs(clk8_div_factor_real - real(clk8_div_factor_int)) < MAX_OFFSET) or (clk8_used = "unused")) and
                ((abs(clk9_div_factor_real - real(clk9_div_factor_int)) < MAX_OFFSET) or (clk9_used = "unused")) )
            then
                if ((i_m_out /= 0) and (i_n_out /= 0))
                then
                    pfd_freq := 1000000 / (inclock_period * i_n_out);
                    vco_freq := (1000000 * i_m_out) / (inclock_period * i_n_out);
                    vco_ps_step_value := (inclock_period * i_n_out) / (8 * i_m_out);
    
                    if ( (i_m_out < max_m) and (i_n_out < max_n) and (pfd_freq >= min_pfd) and (pfd_freq <= max_pfd) and
                        (vco_freq >= min_vco) and (vco_freq <= max_vco) )
                    then
                        if (abs(vco_ps_step_value - vco_phase_shift_step) <= 2)
                        then
                            i_pre_m := i_m_out;
                            i_pre_n := i_n_out;
                            exit LOOP_1;
                        else
                            if ((closest_vco_step_value = 0) or (abs(vco_ps_step_value - vco_phase_shift_step) < abs(closest_vco_step_value - vco_phase_shift_step)))
                            then
                                i_pre_m := i_m_out;
                                i_pre_n := i_n_out;
                                closest_vco_step_value := vco_ps_step_value;
                            end if;
                        end if;
                    end if;
                end if;
            end if;
        end loop;
    end loop;
    
    if ((i_pre_m /= 0) and (i_pre_n /= 0))
    then
        find_simple_integer_fraction(i_pre_m, i_pre_n,
                    MAX_N, m, n);
    else
        n := 1;
        m := lcm  (clk0_mult, clk1_mult, clk2_mult, clk3_mult,
                clk4_mult, clk5_mult, clk6_mult,
                clk7_mult, clk8_mult, clk9_mult, inclock_period);
    end if;
end find_m_and_n_4_manual_phase;

-- find the greatest common denominator of X and Y
function gcd (X: integer; Y: integer) return integer is
variable L, S, R, G : integer := 1;
begin
    if (X < Y) then -- find which is smaller.
        S := X;
        L := Y;
    else
        S := Y;
        L := X;
    end if;

    R := S;
    while ( R > 1) loop
        S := L;
        L := R;
        R := S rem L;   -- divide bigger number by smaller.
                        -- remainder becomes smaller number.
    end loop;
    if (R = 0) then  -- if evenly divisible then L is gcd else it is 1.
        G := L;
    else
        G := R;
    end if;

    return G;
end gcd;

-- count the number of digits in the given integer
function count_digit (X: integer)
        return integer is
variable count, result: integer := 0;
begin
    result := X;
    while (result /= 0) loop
        result := (result / 10);
        count := count + 1;
    end loop;
    
    return count;
end count_digit;
    
-- reduce the given huge number to Y significant digits
function scale_num (X: integer; Y: integer)
        return integer is
variable count : integer := 0; 
variable lc, fac_ten, result: integer := 1;
begin
    count := count_digit(X);

    for lc in 1 to (count-Y) loop
        fac_ten := fac_ten * 10;
    end loop;
    
    result := (X / fac_ten);
    
    return result;
end scale_num;

-- find the least common multiple of A1 to A10
function lcm (A1: integer; A2: integer; A3: integer; A4: integer;
            A5: integer; A6: integer; A7: integer;
            A8: integer; A9: integer; A10: integer; P: integer)
        return integer is
variable M1, M2, M3, M4, M5 , M6, M7, M8, M9, R: integer := 1;
begin
    M1 := (A1 * A2)/gcd(A1, A2);
    M2 := (M1 * A3)/gcd(M1, A3);
    M3 := (M2 * A4)/gcd(M2, A4);
    M4 := (M3 * A5)/gcd(M3, A5);
    M5 := (M4 * A6)/gcd(M4, A6);
    M6 := (M5 * A7)/gcd(M5, A7);
    M7 := (M6 * A8)/gcd(M6, A8);
    M8 := (M7 * A9)/gcd(M7, A9);
    M9 := (M8 * A10)/gcd(M8, A10);
    if (M9 < 3) then
        R := 10;
    elsif (M9 = 3) then
        R := 9;
    elsif ((M9 <= 10) and (M9 > 3)) then
        R := 4 * M9;
    elsif (M9 > 1000) then
        R := scale_num(M9,3);
    else
        R := M9 ;
    end if;

    return R;
end lcm;

-- find the factor of division of the output clock frequency compared to the VCO
function output_counter_value (clk_divide: integer; clk_mult: integer ;
                                M: integer; N: integer ) return integer is
variable r_real : real := 1.0;
variable r: integer := 1;
begin
    r_real := real(clk_divide * M)/ real(clk_mult * N);
    r := integer(r_real);

    return R;
end output_counter_value;

-- find the mode of each PLL counter - bypass, even or odd
function counter_mode (duty_cycle: integer; output_counter_value: integer)
        return string is
variable R: string (1 to 6) := "      ";
variable counter_value: integer := 1;
begin
    counter_value := (2*duty_cycle*output_counter_value)/100;
    if output_counter_value = 1 then
        R := "bypass";
    elsif (counter_value REM 2) = 0 then
        R := "  even";
    else
        R := "   odd";
    end if;

    return R;
end counter_mode;

-- find the number of VCO clock cycles to hold the output clock high
function counter_high (output_counter_value: integer := 1; duty_cycle: integer)
        return integer is
variable R: integer := 1;
variable half_cycle_high : integer := 1;
begin
    half_cycle_high := (duty_cycle * output_counter_value *2)/100 ;
    if (half_cycle_high REM 2 = 0) then
        R := half_cycle_high/2 ;
    else
        R := (half_cycle_high/2) + 1;
    end if;

    return R;
end;

-- find the number of VCO clock cycles to hold the output clock low
function counter_low (output_counter_value: integer; duty_cycle: integer)
        return integer is
variable R, R1: integer := 1;
variable half_cycle_high : integer := 1;
begin
    half_cycle_high := (duty_cycle * output_counter_value*2)/100 ;
    if (half_cycle_high REM 2 = 0) then
        R1 := half_cycle_high/2 ;
    else
        R1 := (half_cycle_high/2) + 1;
    end if;

    R := output_counter_value - R1;

    if (R = 0) then
        R := 1;
    end if;

    return R;
end;

-- find the smallest time delay amongst t1 to t10
function mintimedelay (t1: integer; t2: integer; t3: integer; t4: integer;
                        t5: integer; t6: integer; t7: integer; t8: integer;
                        t9: integer; t10: integer) return integer is
variable m1,m2,m3,m4,m5,m6,m7,m8,m9 : integer := 0;
begin
    if (t1 < t2) then m1 := t1; else m1 := t2; end if;
    if (m1 < t3) then m2 := m1; else m2 := t3; end if;
    if (m2 < t4) then m3 := m2; else m3 := t4; end if;
    if (m3 < t5) then m4 := m3; else m4 := t5; end if;
    if (m4 < t6) then m5 := m4; else m5 := t6; end if;
    if (m5 < t7) then m6 := m5; else m6 := t7; end if;
    if (m6 < t8) then m7 := m6; else m7 := t8; end if;
    if (m7 < t9) then m8 := m7; else m8 := t9; end if;
    if (m8 < t10) then m9 := m8; else m9 := t10; end if;
    if (m9 > 0) then return m9; else return 0; end if;
end;

-- find the numerically largest negative number, and return its absolute value
function maxnegabs (t1: integer; t2: integer; t3: integer; t4: integer;
                    t5: integer; t6: integer; t7: integer; t8: integer;
                    t9: integer; t10: integer) return integer is
variable m1,m2,m3,m4,m5,m6,m7,m8,m9 : integer := 0;
begin
    if (t1 < t2) then m1 := t1; else m1 := t2; end if;
    if (m1 < t3) then m2 := m1; else m2 := t3; end if;
    if (m2 < t4) then m3 := m2; else m3 := t4; end if;
    if (m3 < t5) then m4 := m3; else m4 := t5; end if;
    if (m4 < t6) then m5 := m4; else m5 := t6; end if;
    if (m5 < t7) then m6 := m5; else m6 := t7; end if;
    if (m6 < t8) then m7 := m6; else m7 := t8; end if;
    if (m7 < t9) then m8 := m7; else m8 := t9; end if;
    if (m8 < t10) then m9 := m8; else m9 := t10; end if;
    if (m9 < 0) then return (0 - m9); else return 0; end if;
end;

-- adjust the phase (tap_phase) with the largest negative number (ph_base)
function ph_adjust (tap_phase: integer; ph_base : integer) return integer is
begin
    return (tap_phase + ph_base);
end;

-- find the time delay for each PLL counter
function counter_time_delay (clk_time_delay: integer;
                            m_time_delay: integer; n_time_delay: integer)
        return integer is
variable R: integer := 0;
begin
    R := clk_time_delay + m_time_delay - n_time_delay;

    return R;
end;

-- calculate the given phase shift (in ps) in terms of degrees
function get_phase_degree (phase_shift: integer; clk_period: integer)
        return integer is
variable result: integer := 0;
begin
    result := ( phase_shift * 360 ) / clk_period;
    -- to round up the calculation result
    if (result > 0) then
        result := result + 1;
    elsif (result < 0) then
        result := result - 1;
    else
        result := 0;
    end if;

    return result;
end;

-- find the number of VCO clock cycles to wait initially before the first rising
-- edge of the output clock
function counter_initial (tap_phase: integer; m: integer; n: integer)
        return integer is
variable R: integer;
variable R1: real;
begin
    R1 := (real(abs(tap_phase)) * real(m))/(360.0 * real(n)) + 0.6;
    -- Note NCSim VHDL had problem in rounding up for 0.5 - 0.99. 
    -- This checking will ensure that the rounding up is done.
    if (R1 >= 0.5) and (R1 <= 1.0) then
        R1 := 1.0;
    end if;

    R := integer(R1);

    return R;
end;

-- find which VCO phase tap (0 to 7) to align the rising edge of the output clock to
function counter_ph (tap_phase: integer; m: integer; n: integer) return integer is
variable R: integer := 0;
begin
    -- 0.5 is added for proper rounding of the tap_phase.
    R := integer(real(integer(real(tap_phase * m / n)+ 0.5) REM 360)/45.0) rem 8;

    return R;
end;

-- convert given string to length 6 by padding with spaces
function translate_string (mode : string) return string is
variable new_mode : string (1 to 6) := "      ";
begin
    if (mode = "bypass") then
        new_mode := "bypass";
    elsif (mode = "even") then
        new_mode := "  even";
    elsif (mode = "odd") then
        new_mode := "   odd";
    end if;

    return new_mode;
end;

function str2int (s : string) return integer is
variable len : integer := s'length;
variable newdigit : integer := 0;
variable sign : integer := 1;
variable digit : integer := 0;
begin
    for i in 1 to len loop
        case s(i) is
            when '-' =>
                if i = 1 then
                    sign := -1;
                else
                    ASSERT FALSE
                    REPORT "Illegal Character "&  s(i) & "i n string parameter! "
                    SEVERITY ERROR;
                end if;
            when '0' =>
                digit := 0;
            when '1' =>
                digit := 1;
            when '2' =>
                digit := 2;
            when '3' =>
                digit := 3;
            when '4' =>
                digit := 4;
            when '5' =>
                digit := 5;
            when '6' =>
                digit := 6;
            when '7' =>
                digit := 7;
            when '8' =>
                digit := 8;
            when '9' =>
                digit := 9;
            when others =>
                ASSERT FALSE
                REPORT "Illegal Character "&  s(i) & "in string parameter! "
                SEVERITY ERROR;
        end case;
        newdigit := newdigit * 10 + digit;
    end loop;

    return (sign*newdigit);
end;
end MF_pllpack;
-- END OF PACKAGE MF_pllpack

library ieee;
use ieee.std_logic_1164.all;

-- DFFP
entity DFFP is
port(
    clk : in std_logic;
    ena : in std_logic := '1';
    d : in std_logic;
    clrn : in std_logic := '1';
    prn : in std_logic := '1';
    q : out std_logic := '0'
);
end DFFP;
architecture behave of DFFP is
begin
process (clk, prn, clrn)
    begin
        if (prn = '0') then 
            q <= '1';
        elsif (clrn = '0') then 
            q <= '0';
        else
            if (ena = '1') then 
                q <= d;
            end if;
        end if;
    end process;
end behave;

Library ieee;
use ieee.std_logic_1164.all;
entity pll_iobuf is
    port(
        i  : in    std_logic;
        oe : in    std_logic;
        io : inout std_logic;
        o  : out   std_logic);
end pll_iobuf;
architecture BEHAVIOR of pll_iobuf is
begin
    process(i, io, oe)
    begin
        if oe = '1' then
            io <= i;
        else
            io <= 'Z';
        end if;
        o <= io;
    end process;
end BEHAVIOR;


--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_m_cntr
--
-- Description : Simulation model for the M counter. This is a
--               model for the loop feedback counter of the Stratix PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_m_cntr is
    PORT  ( clk           : IN std_logic;
            reset         : IN std_logic;
            cout          : OUT std_logic;
            initial_value : IN integer;
            modulus       : IN integer;
            time_delay    : IN integer;
            ph            : IN integer := 0);
END MF_m_cntr;

ARCHITECTURE behave of MF_m_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
                first_rising_edge := false;
                tmp_cout := clk;
            elsif (not first_rising_edge) then
                if (count < modulus) then
                    count := count + 1;
                else
                    count := 1;
                    tmp_cout := not tmp_cout;
                end if;
            end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_n_cntr
--
-- Description : Simulation model for the N counter. This is a
--               model for the input counter of the Stratix PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_n_cntr is
    PORT  ( clk           : IN std_logic;
            reset         : IN std_logic;
            cout          : OUT std_logic;
            modulus       : IN integer;
            time_delay    : IN integer);
END MF_n_cntr;

ARCHITECTURE behave of MF_n_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    variable clk_last_valid_value : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = 'X') then
                ASSERT FALSE REPORT "Invalid transition to 'X' detected on Stratix PLL input clk. This edge will be ignored" severity warning;
            elsif (clk = '1' and first_rising_edge) then
                first_rising_edge := false;
                tmp_cout := clk;
            elsif (not first_rising_edge and (clk_last_valid_value /= clk)) then
                if (count < modulus) then
                    count := count + 1;
                else
                    count := 1;
                    tmp_cout := not tmp_cout;
                end if;
            end if;
        end if;
        if (clk /= 'X') then
            clk_last_valid_value := clk;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : stx_scale_cntr
--
-- Description : Simulation model for the output scale-down counters.
--               This is a common model for the L0, L1, G0, G1, G2, G3, E0,
--               E1, E2 and E3 output counters of the Stratix PLL.
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY stx_scale_cntr is
    PORT  ( clk            : IN std_logic;
            reset          : IN std_logic;
            initial        : IN integer;
            high           : IN integer;
            low            : IN integer;
            mode           : IN string := "bypass";
            time_delay     : IN integer;
            ph_tap         : IN natural;
            cout           : OUT std_logic);
END stx_scale_cntr;

ARCHITECTURE behave of stx_scale_cntr is
begin
    process (clk, reset)
    variable tmp_cout : std_logic := '0';
    variable count : integer := 1;
    variable output_shift_count : integer := 0;
    variable first_rising_edge : boolean := false;
    variable high_reg : integer := 0;
    variable low_reg : integer := 0;
    variable init : boolean := true;
    variable high_cnt_xfer_done : boolean := false;
    begin
        if (reset = '1') then
            count := 1;
            output_shift_count := 0;
            tmp_cout := '0';
            first_rising_edge := false;
        elsif (clk'event) then
            if (init) then
                init := false;
                high_reg := high;
                low_reg := low;
            end if;
            if (mode = "   off") then
                tmp_cout := '0';
            elsif (mode = "bypass") then
                tmp_cout := clk;
            elsif (not first_rising_edge) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                    if (output_shift_count = initial) then
                        tmp_cout := clk;
                        first_rising_edge := true;
                    end if;
                end if;
            elsif (output_shift_count < initial) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                end if;
            else
                count := count + 1;
                if (mode = "  even" and (count = (high_reg*2) + 1)) then
                    tmp_cout := '0';
                    if (high_cnt_xfer_done) then
                        low_reg := low;
                        high_cnt_xfer_done := false;
                    end if;
                elsif (mode = "   odd" and (count = high_reg*2)) then
                    tmp_cout := '0';
                    if (high_cnt_xfer_done) then
                        low_reg := low;
                        high_cnt_xfer_done := false;
                    end if;
                elsif (count = (high_reg + low_reg)*2 + 1) then
                    tmp_cout := '1';
                    count := 1;  -- reset count
                    if (high_reg /= high) then
                        high_cnt_xfer_done := true;
                        high_reg := high;
                    end if;
                end if;
            end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;

end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_pll_reg
--
-- Description : Simulation model for a simple DFF.
--               This is required for the generation of the bit slip-signals.
--               No timing, powers upto 0.
--
--/////////////////////////////////////////////////////////////////////////////
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_pll_reg is
    PORT  ( clk : in std_logic;
            ena : in std_logic := '1';
            d : in std_logic;
            clrn : in std_logic := '1';
            prn : in std_logic := '1';
            q : out std_logic);
end MF_pll_reg;

ARCHITECTURE behave of MF_pll_reg is
begin
    process (clk, prn, clrn)
    variable q_reg : std_logic := '0';
    begin
        if (prn = '0') then
            q_reg := '1';
        elsif (clrn = '0') then
            q_reg := '0';
        elsif (clk'event and clk = '1' and (ena = '1')) then
            q_reg := D;
        end if;

        Q <= q_reg;
    end process;
end behave;
--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stratix_pll
--
-- Description : The behavioral model for Stratix PLL
--
-- Limitations : Applies to the Stratix and Stratix GX device families
--               No support for spread spectrum feature in the model
--
-- Outputs     : Up to 10 output clocks, each defined by its own set of
--               parameters. Locked output (active high) indicates when the
--               PLL locks. clkbad, clkloss and activeclock are used for
--               clock switchover to indicate which input clock has gone
--               bad, when the clock switchover initiates and which input
--               clock is being used as the reference, respectively.
--               scandataout is the data output of the serial scan chain.
--
--///////////////////////////////////////////////////////////////////////////
LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE STD.TEXTIO.all;
USE work.MF_pllpack.all;
USE work.MF_m_cntr;
USE work.MF_n_cntr;
USE work.stx_scale_cntr;
USE work.dffp;
USE work.MF_pll_reg;

ENTITY MF_stratix_pll is
    GENERIC   ( operation_mode              : string := "normal";
                qualify_conf_done           : string := "off";
                compensate_clock            : string := "clk0";
                pll_type                    : string := "auto";  -- EGPP/FAST/AUTO
                scan_chain                  : string := "long";

                clk0_multiply_by            : integer := 1;
                clk0_divide_by              : integer := 1;
                clk0_phase_shift            : string := "0";
                clk0_time_delay             : string := "0";
                clk0_duty_cycle             : integer := 50;

                clk1_multiply_by            : integer := 1;
                clk1_divide_by              : integer := 1;
                clk1_phase_shift            : string := "0";
                clk1_time_delay             : string := "0";
                clk1_duty_cycle             : integer := 50;

                clk2_multiply_by            : integer := 1;
                clk2_divide_by              : integer := 1;
                clk2_phase_shift            : string := "0";
                clk2_time_delay             : string := "0";
                clk2_duty_cycle             : integer := 50;

                clk3_multiply_by            : integer := 1;
                clk3_divide_by              : integer := 1;
                clk3_phase_shift            : string := "0";
                clk3_time_delay             : string := "0";
                clk3_duty_cycle             : integer := 50;

                clk4_multiply_by            : integer := 1;
                clk4_divide_by              : integer := 1;
                clk4_phase_shift            : string := "0";
                clk4_time_delay             : string := "0";
                clk4_duty_cycle             : integer := 50;

                clk5_multiply_by            : integer := 1;
                clk5_divide_by              : integer := 1;
                clk5_phase_shift            : string := "0";
                clk5_time_delay             : string := "0";
                clk5_duty_cycle             : integer := 50;

                extclk0_multiply_by         : integer := 1;
                extclk0_divide_by           : integer := 1;
                extclk0_phase_shift         : string := "0";
                extclk0_time_delay          : string := "0";
                extclk0_duty_cycle          : integer := 50;

                extclk1_multiply_by         : integer := 1;
                extclk1_divide_by           : integer := 1;
                extclk1_phase_shift         : string := "0";
                extclk1_time_delay          : string := "0";
                extclk1_duty_cycle          : integer := 50;

                extclk2_multiply_by         : integer := 1;
                extclk2_divide_by           : integer := 1;
                extclk2_phase_shift         : string := "0";
                extclk2_time_delay          : string := "0";
                extclk2_duty_cycle          : integer := 50;

                extclk3_multiply_by         : integer := 1;
                extclk3_divide_by           : integer := 1;
                extclk3_phase_shift         : string := "0";
                extclk3_time_delay          : string := "0";
                extclk3_duty_cycle          : integer := 50;

                primary_clock               : string := "inclk0";
                inclk0_input_frequency      : integer := 10000;
                inclk1_input_frequency      : integer := 10000;
                gate_lock_signal            : string := "no";
                gate_lock_counter           : integer := 1;
                valid_lock_multiplier       : integer := 5;
                invalid_lock_multiplier     : integer := 5;

                switch_over_on_lossclk      : string := "off";
                switch_over_on_gated_lock   : string := "off";
                switch_over_counter         : integer := 1;
                enable_switch_over_counter  : string := "off";
                feedback_source             : string := "extclk0";
                bandwidth_type              : string := "auto";
                bandwidth                   : integer := 0;
                spread_frequency            : integer := 0;
                down_spread                 : string := "0.0";

                pfd_min                     : integer := 0;
                pfd_max                     : integer := 0;
                vco_min                     : integer := 0;
                vco_max                     : integer := 0;
                vco_center                  : integer := 0;

                -- ADVANCED USER PARAMETERS
                m_initial                   : integer := 1;
                m                           : integer := 0;
                n                           : integer := 1;
                m2                          : integer := 1;
                n2                          : integer := 1;
                ss                          : integer := 0;

                l0_high                     : integer := 1;
                l0_low                      : integer := 1;
                l0_initial                  : integer := 1; 
                l0_mode                     : string := "bypass";
                l0_ph                       : integer := 0;
                l0_time_delay               : integer := 0;

                l1_high                     : integer := 1;
                l1_low                      : integer := 1;
                l1_initial                  : integer := 1;
                l1_mode                     : string := "bypass";
                l1_ph                       : integer := 0;
                l1_time_delay               : integer := 0;

                g0_high                     : integer := 1;
                g0_low                      : integer := 1;
                g0_initial                  : integer := 1;
                g0_mode                     : string := "bypass";
                g0_ph                       : integer := 0;
                g0_time_delay               : integer := 0;

                g1_high                     : integer := 1;
                g1_low                      : integer := 1;
                g1_initial                  : integer := 1;
                g1_mode                     : string := "bypass";
                g1_ph                       : integer := 0;
                g1_time_delay               : integer := 0;

                g2_high                     : integer := 1;
                g2_low                      : integer := 1;
                g2_initial                  : integer := 1;
                g2_mode                     : string := "bypass";
                g2_ph                       : integer := 0;
                g2_time_delay               : integer := 0;

                g3_high                     : integer := 1;
                g3_low                      : integer := 1;
                g3_initial                  : integer := 1;
                g3_mode                     : string := "bypass";
                g3_ph                       : integer := 0;
                g3_time_delay               : integer := 0;

                e0_high                     : integer := 1;
                e0_low                      : integer := 1;
                e0_initial                  : integer := 1;
                e0_mode                     : string := "bypass";
                e0_ph                       : integer := 0;
                e0_time_delay               : integer := 0;

                e1_high                     : integer := 1;
                e1_low                      : integer := 1;
                e1_initial                  : integer := 1;
                e1_mode                     : string := "bypass";
                e1_ph                       : integer := 0;
                e1_time_delay               : integer := 0;

                e2_high                     : integer := 1;
                e2_low                      : integer := 1;
                e2_initial                  : integer := 1;
                e2_mode                     : string := "bypass";
                e2_ph                       : integer := 0;
                e2_time_delay               : integer := 0;

                e3_high                     : integer := 1;
                e3_low                      : integer := 1;
                e3_initial                  : integer := 1;
                e3_mode                     : string := "bypass";
                e3_ph                       : integer := 0;
                e3_time_delay               : integer := 0;

                m_ph                        : integer := 0;
                m_time_delay                : integer := 0;
                n_time_delay                : integer := 0;
  
                extclk0_counter             : string := "e0";
                extclk1_counter             : string := "e1";
                extclk2_counter             : string := "e2";
                extclk3_counter             : string := "e3";

                clk0_counter                : string := "g0";
                clk1_counter                : string := "g1";
                clk2_counter                : string := "g2";
                clk3_counter                : string := "g3";
                clk4_counter                : string := "l0";
                clk5_counter                : string := "l1";

                -- LVDS mode parameters
                enable0_counter             : string := "l0";
                enable1_counter             : string := "l0";
  
                charge_pump_current         : integer := 0;
                loop_filter_r               : string := "1.0";
                loop_filter_c               : integer := 1;
                common_rx_tx                : string := "off";
                rx_outclock_resource        : string := "auto";
                use_vco_bypass              : string := "false";
                use_dc_coupling             : string := "false";

                pll_compensation_delay      : integer := 0;
                simulation_type             : string := "timing";

                clk0_use_even_counter_mode  : string := "off";
                clk1_use_even_counter_mode  : string := "off";
                clk2_use_even_counter_mode  : string := "off";
                clk3_use_even_counter_mode  : string := "off";
                clk4_use_even_counter_mode  : string := "off";
                clk5_use_even_counter_mode  : string := "off";
                extclk0_use_even_counter_mode  : string := "off";
                extclk1_use_even_counter_mode  : string := "off";
                extclk2_use_even_counter_mode  : string := "off";
                extclk3_use_even_counter_mode  : string := "off";

                clk0_use_even_counter_value : string := "off";
                clk1_use_even_counter_value : string := "off";
                clk2_use_even_counter_value : string := "off";
                clk3_use_even_counter_value : string := "off";
                clk4_use_even_counter_value : string := "off";
                clk5_use_even_counter_value : string := "off";
                extclk0_use_even_counter_value : string := "off";
                extclk1_use_even_counter_value : string := "off";
                extclk2_use_even_counter_value : string := "off";
                extclk3_use_even_counter_value : string := "off";
                scan_chain_mif_file         : string := "";

                -- Simulation only generics
                family_name                 : string  := "Stratix";

                skip_vco                    : string := "off"
  
            );

    PORT      ( inclk                       : in std_logic_vector(1 downto 0);
                fbin                        : in std_logic := '0';
                ena                         : in std_logic := '1';
                clkswitch                   : in std_logic := '0';
                areset                      : in std_logic := '0';
                pfdena                      : in std_logic := '1';
                clkena                      : in std_logic_vector(5 downto 0) := "111111";
                extclkena                   : in std_logic_vector(3 downto 0) := "1111";
                scanaclr                    : in std_logic := '0';
                scandata                    : in std_logic := '0';
                scanclk                     : in std_logic := '0';
                clk                         : out std_logic_vector(5 downto 0);
                extclk                      : out std_logic_vector(3 downto 0);
                clkbad                      : out std_logic_vector(1 downto 0);
                activeclock                 : out std_logic;
                locked                      : out std_logic;
                clkloss                     : out std_logic;
                scandataout                 : out std_logic;
                -- lvds specific ports
                comparator                  : in std_logic := '0';
                enable0                     : out std_logic;
                enable1                     : out std_logic 
                );
END MF_stratix_pll;

ARCHITECTURE vital_pll of MF_stratix_pll is

-- internal advanced parameter signals
signal   i_vco_min      : natural;
signal   i_vco_max      : natural;
signal   i_vco_center   : natural;
signal   i_pfd_min      : natural;
signal   i_pfd_max      : natural;
signal   l0_ph_val      : natural;
signal   l1_ph_val      : natural;
signal   g0_ph_val      : natural;
signal   g1_ph_val      : natural;
signal   g2_ph_val      : natural;
signal   g3_ph_val      : natural;
signal   e0_ph_val      : natural;
signal   e1_ph_val      : natural;
signal   e2_ph_val      : natural;
signal   e3_ph_val      : natural;
signal   i_extclk3_counter      : string(1 to 2) := "e3";
signal   i_extclk2_counter      : string(1 to 2) := "e2";
signal   i_extclk1_counter      : string(1 to 2) := "e1";
signal   i_extclk0_counter      : string(1 to 2) := "e0";
signal   i_clk5_counter         : string(1 to 2) := "l1";
signal   i_clk4_counter         : string(1 to 2) := "l0";
signal   i_clk3_counter         : string(1 to 2) := "g3";
signal   i_clk2_counter         : string(1 to 2) := "g2";
signal   i_clk1_counter         : string(1 to 2) := "g1";
signal   i_clk0_counter         : string(1 to 2) := "g0";
signal   i_charge_pump_current  : natural;
signal   i_loop_filter_r        : natural;

-- end internal advanced parameter signals

-- CONSTANTS
CONSTANT EGPP_SCAN_CHAIN : integer := 289;
CONSTANT GPP_SCAN_CHAIN : integer := 193;
CONSTANT TRST : time := 5000 ps;
CONSTANT TRSTCLK : time := 5000 ps;

-- signals

signal vcc : std_logic := '1';

signal fbclk       : std_logic;
signal refclk      : std_logic;

signal l0_clk : std_logic;
signal l1_clk : std_logic;
signal g0_clk : std_logic;
signal g1_clk : std_logic;
signal g2_clk : std_logic;
signal g3_clk : std_logic;
signal e0_clk : std_logic;
signal e1_clk : std_logic;
signal e2_clk : std_logic;
signal e3_clk : std_logic;

signal vco_out : std_logic_vector(7 downto 0) := (OTHERS => '0');

-- signals to assign values to counter params
signal m_val : integer := 1;
signal m_val_tmp : integer := 1;
signal m2_val : integer := 1;
signal n_val : integer := 1;
signal n_val_tmp : integer := 1;
signal n2_val : integer := 1;
signal m_time_delay_val, n_time_delay_val : integer := 0;
signal m_ph_val : integer := 0;
signal m_initial_val : integer := m_initial;

signal l0_initial_val : integer := l0_initial;
signal l1_initial_val : integer := l1_initial;
signal l0_high_val : integer := l0_high;
signal l1_high_val : integer := l1_high;
signal l0_low_val : integer := l0_low;
signal l1_low_val : integer := l1_low;
signal l0_mode_val : string(1 to 6) := "bypass";
signal l1_mode_val : string(1 to 6) := "bypass";
signal l0_time_delay_val : integer := l0_time_delay;
signal l1_time_delay_val : integer := l1_time_delay;

signal g0_initial_val : integer := g0_initial;
signal g1_initial_val : integer := g1_initial;
signal g2_initial_val : integer := g2_initial;
signal g3_initial_val : integer := g3_initial;
signal g0_high_val : integer := g0_high;
signal g1_high_val : integer := g1_high;
signal g2_high_val : integer := g2_high;
signal g3_high_val : integer := g3_high;
signal g0_mode_val : string(1 to 6) := "bypass";
signal g1_mode_val : string(1 to 6) := "bypass";
signal g2_mode_val : string(1 to 6) := "bypass";
signal g3_mode_val : string(1 to 6) := "bypass";
signal g0_low_val : integer := g0_low;
signal g1_low_val : integer := g1_low;
signal g2_low_val : integer := g2_low;
signal g3_low_val : integer := g3_low;
signal g0_time_delay_val : integer := g0_time_delay;
signal g1_time_delay_val : integer := g1_time_delay;
signal g2_time_delay_val : integer := g2_time_delay;
signal g3_time_delay_val : integer := g3_time_delay;

signal e0_initial_val : integer := e0_initial;
signal e1_initial_val : integer := e1_initial;
signal e2_initial_val : integer := e2_initial;
signal e3_initial_val : integer := e3_initial;
signal e0_high_val : integer := e0_high;
signal e1_high_val : integer := e1_high;
signal e2_high_val : integer := e2_high;
signal e3_high_val : integer := e3_high;
signal e0_low_val : integer := e0_low;
signal e1_low_val : integer := e1_low;
signal e2_low_val : integer := e2_low;
signal e3_low_val : integer := e3_low;
signal e0_time_delay_val : integer := e0_time_delay;
signal e1_time_delay_val : integer := e1_time_delay;
signal e2_time_delay_val : integer := e2_time_delay;
signal e3_time_delay_val : integer := e3_time_delay;
signal e0_mode_val : string(1 to 6) := "bypass";
signal e1_mode_val : string(1 to 6) := "bypass";
signal e2_mode_val : string(1 to 6) := "bypass";
signal e3_mode_val : string(1 to 6) := "bypass";

signal m_mode_val : string(1 to 6) := "      ";
signal m2_mode_val : string(1 to 6) := "      ";
signal n_mode_val : string(1 to 6) := "      ";
signal n2_mode_val : string(1 to 6) := "      ";

signal cntr_e0_initial : integer := 1;
signal cntr_e1_initial : integer := 1;
signal cntr_e2_initial : integer := 1;
signal cntr_e3_initial : integer := 1;
signal ext_fbk_delay : integer := 0;
signal cntr_e0_delay : integer := 0;
signal cntr_e1_delay : integer := 0;
signal cntr_e2_delay : integer := 0;
signal cntr_e3_delay : integer := 0;

signal transfer : std_logic := '0';

signal scan_data : std_logic_vector(288 downto 0) := (OTHERS => '0');
signal ena0 : std_logic;
signal ena1 : std_logic;
signal ena2 : std_logic;
signal ena3 : std_logic;
signal ena4 : std_logic;
signal ena5 : std_logic;
signal extena0 : std_logic;
signal extena1 : std_logic;
signal extena2 : std_logic;
signal extena3 : std_logic;

signal clk0_tmp : std_logic;
signal clk1_tmp : std_logic;
signal clk2_tmp : std_logic;
signal clk3_tmp : std_logic;
signal clk4_tmp : std_logic;
signal clk5_tmp : std_logic;
signal extclk0_tmp : std_logic;
signal extclk1_tmp : std_logic;
signal extclk2_tmp : std_logic;
signal extclk3_tmp : std_logic;

signal not_clk0_tmp : std_logic;
signal not_clk1_tmp : std_logic;
signal not_clk2_tmp : std_logic;
signal not_clk3_tmp : std_logic;
signal not_clk4_tmp : std_logic;
signal not_clk5_tmp : std_logic;

signal not_extclk0_tmp : std_logic;
signal not_extclk1_tmp : std_logic;
signal not_extclk2_tmp : std_logic;
signal not_extclk3_tmp : std_logic;

signal clkin : std_logic := '0';
signal gate_locked : std_logic := '0';
signal lock : std_logic := '0';
signal about_to_lock : boolean := false;
signal quiet_period_violation : boolean := false;
signal reconfig_err : boolean := false;
signal scanclr_violation : boolean := false;
signal scanclr_clk_violation : boolean := false;

signal inclk_l0 : std_logic;
signal inclk_l1 : std_logic;
signal inclk_g0 : std_logic;
signal inclk_g1 : std_logic;
signal inclk_g2 : std_logic;
signal inclk_g3 : std_logic;
signal inclk_e0 : std_logic;
signal inclk_e1 : std_logic;
signal inclk_e2 : std_logic;
signal inclk_e3 : std_logic;
signal inclk_m : std_logic;
signal devpor : std_logic;
signal devclrn : std_logic;

signal inclk0_ipd : std_logic;
signal inclk1_ipd : std_logic;
signal ena_ipd : std_logic;
signal pfdena_ipd : std_logic;
signal comparator_ipd : std_logic;
signal areset_ipd : std_logic;
signal fbin_ipd : std_logic;
signal clkena0_ipd : std_logic;
signal clkena1_ipd : std_logic;
signal clkena2_ipd : std_logic;
signal clkena3_ipd : std_logic;
signal clkena4_ipd : std_logic;
signal clkena5_ipd : std_logic;
signal extclkena0_ipd : std_logic;
signal extclkena1_ipd : std_logic;
signal extclkena2_ipd : std_logic;
signal extclkena3_ipd : std_logic;
signal scanclk_ipd : std_logic;
signal scanaclr_ipd : std_logic;
signal scandata_ipd : std_logic;
signal clkswitch_ipd : std_logic;

signal lvds_dffa_clk : std_logic;
signal lvds_dffb_clk : std_logic;
signal lvds_dffc_clk : std_logic;
signal lvds_dffd_clk : std_logic;
signal dffa_out : std_logic := '0';
signal dffb_out : std_logic := '0';
signal dffc_out : std_logic := '0';
signal dffd_out : std_logic := '0';
signal nce_temp : std_logic := '0';
signal nce_l0 : std_logic := '0';
signal nce_l1 : std_logic := '0';

signal inclk_l0_dly1 : std_logic := '0';
signal inclk_l0_dly2 : std_logic := '0';
signal inclk_l0_dly3 : std_logic := '0';
signal inclk_l0_dly4 : std_logic := '0';
signal inclk_l0_dly5 : std_logic := '0';
signal inclk_l0_dly6 : std_logic := '0';
signal inclk_l1_dly1 : std_logic := '0';
signal inclk_l1_dly2 : std_logic := '0';
signal inclk_l1_dly3 : std_logic := '0';
signal inclk_l1_dly4 : std_logic := '0';
signal inclk_l1_dly5 : std_logic := '0';
signal inclk_l1_dly6 : std_logic := '0';


signal sig_offset : time := 0 ps;
signal sig_refclk_time : time := 0 ps;
signal sig_fbclk_time : time := 0 ps;
signal sig_fbclk_period : time := 0 ps;
signal sig_vco_period_was_phase_adjusted : boolean := false;
signal sig_phase_adjust_was_scheduled : boolean := false;
signal sig_stop_vco : std_logic := '0';
signal sig_m_times_vco_period : time := 0 ps;
signal sig_new_m_times_vco_period : time := 0 ps;
signal sig_got_refclk_posedge : boolean := false;
signal sig_got_fbclk_posedge : boolean := false;
signal sig_got_second_refclk : boolean := false;
signal sig_current_clock : string(1 to 6);

signal m_delay : integer := 0;
signal n_delay : integer := 0;

signal sig_curr_clock : string(1 to 6) := primary_clock;
signal scan_chain_length : integer := GPP_SCAN_CHAIN;

signal ext_fbk_cntr_high : integer := 0;
signal ext_fbk_cntr_low : integer := 0;
signal ext_fbk_cntr_delay : integer := 0;
signal ext_fbk_cntr_ph : integer := 0;
signal ext_fbk_cntr_initial : integer := 1;
signal ext_fbk_cntr     : string(1 to 2) := "e0";
signal ext_fbk_cntr_mode : string(1 to 6) := "bypass";

signal enable0_tmp : std_logic := '0';
signal enable1_tmp : std_logic := '0';
signal reset_low : std_logic := '0';

signal scandataout_tmp : std_logic := '0';
signal sdataout_trig : std_logic := '0';
signal sdataout_rst_trig : std_logic := '0';

signal sig_refclk_period : time := (inclk0_input_frequency * 1 ps) * n;

signal schedule_vco : std_logic := '0';

signal areset_ena_sig : std_logic := '0';
signal done_with_param_calc : boolean := false;

COMPONENT MF_m_cntr
    PORT  ( clk           : IN std_logic;
            reset         : IN std_logic;
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer;
            time_delay    : IN integer;
            ph            : IN integer := 0 );
END COMPONENT;

COMPONENT MF_n_cntr
    PORT  ( clk           : IN std_logic;
            reset         : IN std_logic;
            cout          : OUT std_logic;
            modulus       : IN integer;
            time_delay    : IN integer);
END COMPONENT;

COMPONENT stx_scale_cntr
    PORT  ( clk            : IN std_logic;
            reset          : IN std_logic;
            cout           : OUT std_logic;
            initial        : IN integer := 1;
            high           : IN integer := 1;
            low            : IN integer := 1;
            mode           : IN string := "bypass";
            time_delay     : IN integer := 0;
            ph_tap         : IN natural );
END COMPONENT;

COMPONENT dffp

    PORT  ( Q                              :  out   STD_LOGIC := '0';
            D                              :  in    STD_LOGIC := '1';
            CLRN                           :  in    STD_LOGIC := '1';
            PRN                            :  in    STD_LOGIC := '1';
            CLK                            :  in    STD_LOGIC := '0';
            ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

COMPONENT MF_pll_reg
    PORT  ( Q                              :  out   STD_LOGIC := '0';
            D                              :  in    STD_LOGIC := '1';
            CLRN                           :  in    STD_LOGIC := '1';
            PRN                            :  in    STD_LOGIC := '1';
            CLK                            :  in    STD_LOGIC := '0';
            ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        inclk0_ipd <= inclk(0);
        inclk1_ipd <= inclk(1);
        areset_ipd <= areset;
        ena_ipd <= ena;
        fbin_ipd <= fbin;
        pfdena_ipd <= pfdena;
        clkena0_ipd <= clkena(0);
        clkena1_ipd <= clkena(1);
        clkena2_ipd <= clkena(2);
        clkena3_ipd <= clkena(3);
        clkena4_ipd <= clkena(4);
        clkena5_ipd <= clkena(5);
        extclkena0_ipd <= extclkena(0);
        extclkena1_ipd <= extclkena(1);
        extclkena2_ipd <= extclkena(2);
        extclkena3_ipd <= extclkena(3);
        scanclk_ipd <= scanclk;
        scanaclr_ipd <= scanaclr;
        scandata_ipd <= scandata;
        comparator_ipd <= comparator;
        clkswitch_ipd <= clkswitch;
    end block;

    -- User to Advanced parameter conversion

    i_extclk3_counter       <=  "e3" when m=0 else extclk3_counter;
    i_extclk2_counter       <=  "e2" when m=0 else extclk2_counter;
    i_extclk1_counter       <=  "e1" when m=0 else extclk1_counter;
    i_extclk0_counter       <=  "e0" when m=0 else extclk0_counter;
    i_clk5_counter          <=  "l1" when m=0 else clk5_counter;
    i_clk4_counter          <=  "l0" when m=0 else clk4_counter;
    i_clk3_counter          <=  "g3" when m=0 else clk3_counter;
    i_clk2_counter          <=  "g2" when m=0 else clk2_counter;
    i_clk1_counter          <=  "g1" when m=0 else clk1_counter;
    i_clk0_counter          <=  "l0" when m=0 and pll_type = "lvds" else
                                "g0" when m=0 else clk0_counter;

    -- end parameter conversion

    inclk_m <=  extclk0_tmp when operation_mode = "external_feedback" and feedback_source = "extclk0" else
                extclk1_tmp when operation_mode = "external_feedback" and feedback_source = "extclk1" else
                extclk2_tmp when operation_mode = "external_feedback" and feedback_source = "extclk2" else
                extclk3_tmp when operation_mode = "external_feedback" and feedback_source = "extclk3" else
                vco_out(m_ph_val);

    ext_fbk_cntr <= "e0" when (feedback_source = "extclk0" and extclk0_counter = "e0") or (feedback_source = "extclk1" and extclk1_counter = "e0") or (feedback_source = "extclk2" and extclk2_counter = "e0") or (feedback_source = "extclk3" and extclk3_counter = "e0") else
                    "e1" when (feedback_source = "extclk0" and extclk0_counter = "e1") or (feedback_source = "extclk1" and extclk1_counter = "e1") or (feedback_source = "extclk2" and extclk2_counter = "e1") or (feedback_source = "extclk3" and extclk3_counter = "e1") else
                    "e2" when (feedback_source = "extclk0" and extclk0_counter = "e2") or (feedback_source = "extclk1" and extclk1_counter = "e2") or (feedback_source = "extclk2" and extclk2_counter = "e2") or (feedback_source = "extclk3" and extclk3_counter = "e2") else
                    "e3" when (feedback_source = "extclk0" and extclk0_counter = "e3") or (feedback_source = "extclk1" and extclk1_counter = "e3") or (feedback_source = "extclk2" and extclk2_counter = "e3") or (feedback_source = "extclk3" and extclk3_counter = "e3") else
                    "e0";

    ext_fbk_cntr_high   <=  e0_high_val when ext_fbk_cntr = "e0" else
                            e1_high_val when ext_fbk_cntr = "e1" else
                            e2_high_val when ext_fbk_cntr = "e2" else
                            e3_high_val when ext_fbk_cntr = "e3" else
                            1;
    ext_fbk_cntr_low   <=   e0_low_val when ext_fbk_cntr = "e0" else
                            e1_low_val when ext_fbk_cntr = "e1" else
                            e2_low_val when ext_fbk_cntr = "e2" else
                            e3_low_val when ext_fbk_cntr = "e3" else
                            1;
    ext_fbk_cntr_delay  <=  e0_time_delay_val when ext_fbk_cntr = "e0" else
                            e1_time_delay_val when ext_fbk_cntr = "e1" else
                            e2_time_delay_val when ext_fbk_cntr = "e2" else
                            e3_time_delay_val when ext_fbk_cntr = "e3" else
                            0;

    ext_fbk_cntr_ph    <=   e0_ph_val when ext_fbk_cntr = "e0" else
                            e1_ph_val when ext_fbk_cntr = "e1" else
                            e2_ph_val when ext_fbk_cntr = "e2" else
                            e3_ph_val when ext_fbk_cntr = "e3" else
                            0;

    ext_fbk_cntr_initial <= e0_initial_val when ext_fbk_cntr = "e0" else
                            e1_initial_val when ext_fbk_cntr = "e1" else
                            e2_initial_val when ext_fbk_cntr = "e2" else
                            e3_initial_val when ext_fbk_cntr = "e3" else
                            0;
    ext_fbk_cntr_mode  <=   e0_mode_val when ext_fbk_cntr = "e0" else
                            e1_mode_val when ext_fbk_cntr = "e1" else
                            e2_mode_val when ext_fbk_cntr = "e2" else
                            e3_mode_val when ext_fbk_cntr = "e3" else
                            e0_mode_val;

    areset_ena_sig <= areset_ipd or (not ena_ipd) or sig_stop_vco;

    m1 : MF_m_cntr
            port map  ( clk           => inclk_m,
                        reset         => areset_ena_sig,
                        cout          => fbclk,
                        initial_value => m_initial_val,
                        modulus       => m_val,
                        time_delay    => m_delay,
                        ph            => m_ph_val );

    -- add delta delay to inclk1 to ensure inclk0 and inclk1 are processed
    -- in different simulation deltas.

    n1 : MF_n_cntr
            port map  ( clk           => clkin,
                        reset         => areset_ipd,
                        cout          => refclk,
                        modulus       => n_val,
                        time_delay    => n_time_delay_val);

    inclk_l0 <= vco_out(l0_ph_val);
    l0 : stx_scale_cntr
            port map  ( clk            => inclk_l0,
                        reset          => areset_ena_sig,
                        cout           => l0_clk,
                        initial        => l0_initial_val,
                        high           => l0_high_val,
                        low            => l0_low_val,
                        mode           => l0_mode_val,
                        time_delay     => l0_time_delay_val,
                        ph_tap         => l0_ph_val);

    inclk_l1 <= vco_out(l1_ph_val);
    l1 : stx_scale_cntr
            port map  ( clk            => inclk_l1,
                        reset          => areset_ena_sig,
                        cout           => l1_clk,
                        initial        => l1_initial_val,
                        high           => l1_high_val,
                        low            => l1_low_val,
                        mode           => l1_mode_val,
                        time_delay     => l1_time_delay_val,
                        ph_tap         => l1_ph_val);

    inclk_g0 <= vco_out(g0_ph_val);
    g0 : stx_scale_cntr
            port map  ( clk            => inclk_g0,
                        reset          => areset_ena_sig,
                        cout           => g0_clk,
                        initial        => g0_initial_val,
                        high           => g0_high_val,
                        low            => g0_low_val,
                        mode           => g0_mode_val,
                        time_delay     => g0_time_delay_val,
                        ph_tap         => g0_ph_val);


    process(g0_clk, l0_clk, l1_clk)
    begin
        if (g0_clk'event and g0_clk = '1') then
            dffa_out <= comparator_ipd;
        end if;
        if (l0_clk'event and l0_clk = '1' and enable0_counter = "l0") then
            dffb_out <= dffa_out;
            dffc_out <= dffb_out;
            dffd_out <= nce_temp;
        end if;
        if (l1_clk'event and l1_clk = '1' and enable0_counter = "l1") then
            dffb_out <= dffa_out;
            dffc_out <= dffb_out;
            dffd_out <= nce_temp;
        end if;
    end process;

    nce_temp <= (not dffc_out) and dffb_out;

    nce_l0 <= dffd_out when enable0_counter = "l0" else '0';
    nce_l1 <= dffd_out when enable0_counter = "l1" else '0';

    inclk_g1 <= vco_out(g1_ph_val);
    g1 : stx_scale_cntr
            port map  ( clk            => inclk_g1,
                        reset          => areset_ena_sig,
                        cout           => g1_clk,
                        initial        => g1_initial_val,
                        high           => g1_high_val,
                        low            => g1_low_val,
                        mode           => g1_mode_val,
                        time_delay     => g1_time_delay_val,
                        ph_tap         => g1_ph_val);

    inclk_g2 <= vco_out(g2_ph_val);
    g2 : stx_scale_cntr
            port map  ( clk            => inclk_g2,
                        reset          => areset_ena_sig,
                        cout           => g2_clk,
                        initial        => g2_initial_val,
                        high           => g2_high_val,
                        low            => g2_low_val,
                        mode           => g2_mode_val,
                        time_delay     => g2_time_delay_val,
                        ph_tap         => g2_ph_val);

    inclk_g3 <= vco_out(g3_ph_val);
    g3 : stx_scale_cntr
            port map  ( clk            => inclk_g3,
                        reset          => areset_ena_sig,
                        cout           => g3_clk,
                        initial        => g3_initial_val,
                        high           => g3_high_val,
                        low            => g3_low_val,
                        mode           => g3_mode_val,
                        time_delay     => g3_time_delay_val,
                        ph_tap         => g3_ph_val);

    inclk_e0 <= vco_out(e0_ph_val);
    cntr_e0_initial <= 1  when  operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e0" else e0_initial_val;
    cntr_e0_delay  <=   ext_fbk_delay when operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e0" else
                        e0_time_delay_val;
    e0 : stx_scale_cntr
            port map  ( clk            => inclk_e0,
                        reset          => areset_ena_sig,
                        cout           => e0_clk,
                        initial        => cntr_e0_initial,
                        high           => e0_high_val,
                        low            => e0_low_val,
                        mode           => e0_mode_val,
                        time_delay     => cntr_e0_delay,
                        ph_tap         => e0_ph_val);

    inclk_e1 <= vco_out(e1_ph_val);
    cntr_e1_initial <= 1  when  operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e1" else e1_initial_val;
    cntr_e1_delay  <=   ext_fbk_delay when operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e1" else
                        e1_time_delay_val;
    e1 : stx_scale_cntr
            port map  ( clk            => inclk_e1,
                        reset          => areset_ena_sig,
                        cout           => e1_clk,
                        initial        => cntr_e1_initial,
                        high           => e1_high_val,
                        low            => e1_low_val,
                        mode           => e1_mode_val,
                        time_delay     => cntr_e1_delay,
                        ph_tap         => e1_ph_val);

    inclk_e2 <= vco_out(e2_ph_val);
    cntr_e2_initial <= 1  when  operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e2" else e2_initial_val;
    cntr_e2_delay  <=   ext_fbk_delay when operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e2" else
                        e2_time_delay_val;
    e2 : stx_scale_cntr
            port map  ( clk            => inclk_e2,
                        reset          => areset_ena_sig,
                        cout           => e2_clk,
                        initial        => cntr_e2_initial,
                        high           => e2_high_val,
                        low            => e2_low_val,
                        mode           => e2_mode_val,
                        time_delay     => cntr_e2_delay,
                        ph_tap         => e2_ph_val);

    inclk_e3 <= vco_out(e3_ph_val);
    cntr_e3_initial <= 1  when  operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e3" else e3_initial_val;
    cntr_e3_delay  <=   ext_fbk_delay when operation_mode = "external_feedback" and
                                ext_fbk_cntr = "e3" else
                        e3_time_delay_val;
    e3 : stx_scale_cntr
            port map  ( clk            => inclk_e3,
                        reset          => areset_ena_sig,
                        cout           => e3_clk,
                        initial        => cntr_e3_initial,
                        high           => e3_high_val,
                        low            => e3_low_val,
                        mode           => e3_mode_val,
                        time_delay     => cntr_e3_delay,
                        ph_tap         => e3_ph_val);

    inclk_l0_dly1 <= inclk_l0;
    inclk_l0_dly2 <= inclk_l0_dly1;
    inclk_l0_dly3 <= inclk_l0_dly2;
    inclk_l0_dly4 <= inclk_l0_dly3;
    inclk_l0_dly5 <= inclk_l0_dly4;
    inclk_l0_dly6 <= inclk_l0_dly5;

    inclk_l1_dly1 <= inclk_l1;
    inclk_l1_dly2 <= inclk_l1_dly1;
    inclk_l1_dly3 <= inclk_l1_dly2;
    inclk_l1_dly4 <= inclk_l1_dly3;
    inclk_l1_dly5 <= inclk_l1_dly4;
    inclk_l1_dly6 <= inclk_l1_dly5;

    process(inclk_l0_dly6, inclk_l1_dly6, areset_ipd, ena_ipd, sig_stop_vco)
    variable l0_got_first_rising_edge : boolean := false;
    variable l0_count : integer := 1;
    variable l0_tmp, l1_tmp : std_logic := '0';
    variable l1_got_first_rising_edge : boolean := false;
    variable l1_count : integer := 1;
    begin
        if (areset_ipd = '1' or ena_ipd = '0' or sig_stop_vco = '1') then
            l0_count := 1;
            l1_count := 1;
            l0_got_first_rising_edge := false;
            l1_got_first_rising_edge := false;
        else
            if (nce_l0 = '0') then
                if (not l0_got_first_rising_edge) then
                    if (inclk_l0_dly6'event and inclk_l0_dly6 = '1') then
                        l0_got_first_rising_edge := true;
                    end if;
                elsif (inclk_l0_dly6'event) then
                    l0_count := l0_count + 1;
                    if (l0_count = (l0_high_val + l0_low_val) * 2) then
                        l0_count := 1;
                    end if;
                end if;
            end if;
            if (inclk_l0_dly6'event and inclk_l0_dly6 = '0') then
                if (l0_count = 1) then
                    l0_tmp := '1';
                    l0_got_first_rising_edge := false;
                else
                    l0_tmp := '0';
                end if;
            end if;

            if (nce_l1 = '0') then
                if (not l1_got_first_rising_edge) then
                    if (inclk_l1_dly6'event and inclk_l1_dly6 = '1') then
                        l1_got_first_rising_edge := true;
                    end if;
                elsif (inclk_l1_dly6'event) then
                    l1_count := l1_count + 1;
                    if (l1_count = (l1_high_val + l1_low_val) * 2) then
                        l1_count := 1;
                    end if;
                end if;
            end if;
            if (inclk_l1_dly6'event and inclk_l1_dly6 = '0') then
                if (l1_count = 1) then
                    l1_tmp := '1';
                    l1_got_first_rising_edge := false;
                else
                    l1_tmp := '0';
                end if;
            end if;
        end if;

        if (enable0_counter = "l0") then
            enable0_tmp <= l0_tmp;
        elsif (enable0_counter = "l1") then
            enable0_tmp <= l1_tmp;
        else
            enable0_tmp <= '0';
        end if;

        if (enable1_counter = "l0") then
            enable1_tmp <= l0_tmp;
        elsif (enable1_counter = "l1") then
            enable1_tmp <= l1_tmp;
        else
            enable1_tmp <= '0';
        end if;

    end process;

    glocked_cntr : process(clkin, ena_ipd, areset_ipd)
    variable count : integer := 0;
    variable output : std_logic := '0';
    begin
        if (areset_ipd = '1') then
            count := 0;
            output := '0';
        elsif (clkin'event and clkin = '1') then
            if (ena_ipd = '1') then
                count := count + 1;
                if (count = gate_lock_counter) then
                    output := '1';
                end if;
            end if;
        end if;
        gate_locked <= output;
    end process;

    locked  <=  gate_locked and lock when gate_lock_signal = "yes" else
                lock;

    process (transfer)
    variable init : boolean := true;
    variable low, high : std_logic_vector(8 downto 0);
    variable delay_chain : std_logic_vector(3 downto 0);
    variable mn_delay_chain : std_logic_vector(0 to 3);
    variable mode : string(1 to 6) := "bypass";
    variable delay_val : integer := 0;
    variable is_error : boolean := false;
    variable buf : line;

    -- user to advanced variables

    variable   i_m_initial    : natural;
    variable   i_m            : integer := 1;
    variable   i_n            : natural := 1;
    variable   i_m2           : natural;
    variable   i_n2           : natural;
    variable   i_ss           : natural;
    variable   i_l0_high      : natural;
    variable   i_l1_high      : natural;
    variable   i_g0_high      : natural;
    variable   i_g1_high      : natural;
    variable   i_g2_high      : natural;
    variable   i_g3_high      : natural;
    variable   i_e0_high      : natural;
    variable   i_e1_high      : natural;
    variable   i_e2_high      : natural;
    variable   i_e3_high      : natural;
    variable   i_l0_low       : natural;
    variable   i_l1_low       : natural;
    variable   i_g0_low       : natural;
    variable   i_g1_low       : natural;
    variable   i_g2_low       : natural;
    variable   i_g3_low       : natural;
    variable   i_e0_low       : natural;
    variable   i_e1_low       : natural;
    variable   i_e2_low       : natural;
    variable   i_e3_low       : natural;
    variable   i_l0_initial   : natural;
    variable   i_l1_initial   : natural;
    variable   i_g0_initial   : natural;
    variable   i_g1_initial   : natural;
    variable   i_g2_initial   : natural;
    variable   i_g3_initial   : natural;
    variable   i_e0_initial   : natural;
    variable   i_e1_initial   : natural;
    variable   i_e2_initial   : natural;
    variable   i_e3_initial   : natural;
    variable   i_l0_mode      : string(1 to 6);
    variable   i_l1_mode      : string(1 to 6);
    variable   i_g0_mode      : string(1 to 6);
    variable   i_g1_mode      : string(1 to 6);
    variable   i_g2_mode      : string(1 to 6);
    variable   i_g3_mode      : string(1 to 6);
    variable   i_e0_mode      : string(1 to 6);
    variable   i_e1_mode      : string(1 to 6);
    variable   i_e2_mode      : string(1 to 6);
    variable   i_e3_mode      : string(1 to 6);
    variable   max_neg_abs    : integer := 0;
    variable   i_l0_time_delay        : natural;
    variable   i_l1_time_delay        : natural;
    variable   i_g0_time_delay        : natural;
    variable   i_g1_time_delay        : natural;
    variable   i_g2_time_delay        : natural;
    variable   i_g3_time_delay        : natural;
    variable   i_e0_time_delay        : natural;
    variable   i_e1_time_delay        : natural;
    variable   i_e2_time_delay        : natural;
    variable   i_e3_time_delay        : natural;
    variable   i_m_time_delay         : natural;
    variable   i_n_time_delay         : natural;
    variable   i_l0_ph        : natural;
    variable   i_l1_ph        : natural;
    variable   i_g0_ph        : natural;
    variable   i_g1_ph        : natural;
    variable   i_g2_ph        : natural;
    variable   i_g3_ph        : natural;
    variable   i_e0_ph        : natural;
    variable   i_e1_ph        : natural;
    variable   i_e2_ph        : natural;
    variable   i_e3_ph        : natural;
    variable   i_m_ph         : natural;
    variable   output_count   : natural;
    variable   new_divisor    : natural;
    
    -- variables for scaling of multiply_by and divide_by values
    variable i_clk0_mult_by    : integer := 1;
    variable i_clk0_div_by     : integer := 1;
    variable i_clk1_mult_by    : integer := 1;
    variable i_clk1_div_by     : integer := 1;
    variable i_clk2_mult_by    : integer := 1;
    variable i_clk2_div_by     : integer := 1;
    variable i_clk3_mult_by    : integer := 1;
    variable i_clk3_div_by     : integer := 1;
    variable i_clk4_mult_by    : integer := 1;
    variable i_clk4_div_by     : integer := 1;
    variable i_clk5_mult_by    : integer := 1;
    variable i_clk5_div_by     : integer := 1;
    variable i_extclk0_mult_by : integer := 1;
    variable i_extclk0_div_by  : integer := 1;
    variable i_extclk1_mult_by : integer := 1;
    variable i_extclk1_div_by  : integer := 1;
    variable i_extclk2_mult_by : integer := 1;
    variable i_extclk2_div_by  : integer := 1;
    variable i_extclk3_mult_by : integer := 1;
    variable i_extclk3_div_by  : integer := 1;
    variable max_d_value       : integer := 1;
    variable new_multiplier    : integer := 1;
    
    -- internal variables for storing the phase shift number.(used in lvds mode only)
    variable i_clk0_phase_shift : integer := 1;
    variable i_clk1_phase_shift : integer := 1;
    variable i_clk2_phase_shift : integer := 1;

    begin
        if (init) then
            if (m = 0) then  -- convert user parameters to advanced
                -- set the limit of the divide_by value that can be returned by
                -- the following function.
                max_d_value := 500;

                -- scale down the multiply_by and divide_by values provided by the design
                -- before attempting to use them in the calculations below
                find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                                max_d_value, i_clk0_mult_by, i_clk0_div_by);
                find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                                max_d_value, i_clk1_mult_by, i_clk1_div_by);
                find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                                max_d_value, i_clk2_mult_by, i_clk2_div_by);
                find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                                max_d_value, i_clk3_mult_by, i_clk3_div_by);
                find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                                max_d_value, i_clk4_mult_by, i_clk4_div_by);
                find_simple_integer_fraction(clk5_multiply_by, clk5_divide_by,
                                max_d_value, i_clk5_mult_by, i_clk5_div_by);
                find_simple_integer_fraction(extclk0_multiply_by, extclk0_divide_by,
                                max_d_value, i_extclk0_mult_by, i_extclk0_div_by);
                find_simple_integer_fraction(extclk1_multiply_by, extclk1_divide_by,
                                max_d_value, i_extclk1_mult_by, i_extclk1_div_by);
                find_simple_integer_fraction(extclk2_multiply_by, extclk2_divide_by,
                                max_d_value, i_extclk2_mult_by, i_extclk2_div_by);
                find_simple_integer_fraction(extclk3_multiply_by, extclk3_divide_by,
                                max_d_value, i_extclk3_mult_by, i_extclk3_div_by);
                
                i_n := 1;
                if (pll_type = "lvds") then
                    i_m := clk0_multiply_by;
                else
                    i_m := lcm (i_clk0_mult_by, i_clk1_mult_by,
                            i_clk2_mult_by, i_clk3_mult_by,
                            i_clk4_mult_by, i_clk5_mult_by,
                            i_extclk0_mult_by,
                            i_extclk1_mult_by, i_extclk2_mult_by,
                            i_extclk3_mult_by, inclk0_input_frequency);
                end if;
                i_m_time_delay  :=  maxnegabs ( str2int(clk0_time_delay), 
                                                str2int(clk1_time_delay),
                                                str2int(clk2_time_delay), 
                                                str2int(clk3_time_delay), 
                                                str2int(clk4_time_delay),
                                                str2int(clk5_time_delay), 
                                                str2int(extclk0_time_delay),
                                                str2int(extclk1_time_delay), 
                                                str2int(extclk2_time_delay),
                                                str2int(extclk3_time_delay)); 
                i_n_time_delay  := mintimedelay(str2int(clk0_time_delay), 
                                                str2int(clk1_time_delay),
                                                str2int(clk2_time_delay), 
                                                str2int(clk3_time_delay), 
                                                str2int(clk4_time_delay),
                                                str2int(clk5_time_delay), 
                                                str2int(extclk0_time_delay),
                                                str2int(extclk1_time_delay), 
                                                str2int(extclk2_time_delay),
                                                str2int(extclk3_time_delay)); 
                if (pll_type = "lvds") then
                    i_g0_time_delay := counter_time_delay ( str2int(clk2_time_delay), 
                                                            i_m_time_delay, i_n_time_delay);
                else
                    i_g0_time_delay := counter_time_delay ( str2int(clk0_time_delay),
                                                            i_m_time_delay,i_n_time_delay);
                end if;
                i_g1_time_delay := counter_time_delay ( str2int(clk1_time_delay),
                                                        i_m_time_delay, i_n_time_delay);
                i_g2_time_delay := counter_time_delay ( str2int(clk2_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                i_g3_time_delay := counter_time_delay ( str2int(clk3_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                if (pll_type = "lvds") then
                    i_l0_time_delay := i_g0_time_delay;
                    i_l1_time_delay := i_g0_time_delay;
                else
                    i_l0_time_delay := counter_time_delay ( str2int(clk4_time_delay),
                                                            i_m_time_delay, i_n_time_delay);
                    i_l1_time_delay := counter_time_delay ( str2int(clk5_time_delay),
                                                            i_m_time_delay, i_n_time_delay);
                end if;
                i_e0_time_delay := counter_time_delay ( str2int(extclk0_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                i_e1_time_delay := counter_time_delay ( str2int(extclk1_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                i_e2_time_delay := counter_time_delay ( str2int(extclk2_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                i_e3_time_delay := counter_time_delay ( str2int(extclk3_time_delay), 
                                                        i_m_time_delay, i_n_time_delay);
                                                        
                if (pll_type = "flvds") then
                    -- Need to readjust phase shift values when the clock multiply value has been readjusted.
                    new_multiplier := clk0_multiply_by / i_clk0_mult_by;
                    i_clk0_phase_shift := str2int(clk0_phase_shift) * new_multiplier;
                    i_clk1_phase_shift := str2int(clk1_phase_shift) * new_multiplier;
                    i_clk2_phase_shift := str2int(clk2_phase_shift) * new_multiplier;
                else
                    i_clk0_phase_shift := str2int(clk0_phase_shift);
                    i_clk1_phase_shift := str2int(clk1_phase_shift);
                    i_clk2_phase_shift := str2int(clk2_phase_shift);
                end if;
            
                max_neg_abs :=  maxnegabs ( i_clk0_phase_shift, 
                                            i_clk1_phase_shift,
                                            i_clk2_phase_shift,
                                            str2int(clk3_phase_shift),
                                            str2int(clk4_phase_shift),
                                            str2int(clk5_phase_shift),
                                            str2int(extclk0_phase_shift),
                                            str2int(extclk1_phase_shift),
                                            str2int(extclk2_phase_shift),
                                            str2int(extclk3_phase_shift));
                i_m_ph  := counter_ph(get_phase_degree(max_neg_abs,inclk0_input_frequency), i_m, i_n);
                if (pll_type = "lvds") then
                    i_g0_ph := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs),inclk0_input_frequency), i_m, i_n);
                else
                    i_g0_ph := counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs),inclk0_input_frequency), i_m, i_n);
                end if;
                
                i_g1_ph := counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_g2_ph := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_g3_ph := counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);

                if (pll_type = "lvds") then
                    i_l0_ph := i_g0_ph;
                    i_l1_ph := i_g0_ph;
                else
                    i_l0_ph := counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                    i_l1_ph := counter_ph(get_phase_degree(ph_adjust(str2int(clk5_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                end if;
                i_e0_ph := counter_ph(get_phase_degree(ph_adjust(str2int(extclk0_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_e1_ph := counter_ph(get_phase_degree(ph_adjust(str2int(extclk1_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_e2_ph := counter_ph(get_phase_degree(ph_adjust(str2int(extclk2_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_e3_ph := counter_ph(get_phase_degree(ph_adjust(str2int(extclk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                if (pll_type = "lvds") then
                    i_g0_high := counter_high ( output_counter_value(i_clk2_div_by,
                                                i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                else
                    i_g0_high := counter_high ( output_counter_value(i_clk0_div_by,
                                                i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);
                end if;
                i_g1_high := counter_high ( output_counter_value(i_clk1_div_by,
                                            i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
                i_g2_high := counter_high ( output_counter_value(i_clk2_div_by,
                                            i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                i_g3_high := counter_high ( output_counter_value(i_clk3_div_by,
                                            i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
                if (pll_type = "lvds") then
                    i_l0_high := i_g0_high;
                    i_l1_high := i_g0_high;
                else
                    i_l0_high := counter_high ( output_counter_value(i_clk4_div_by,
                                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                    i_l1_high := counter_high ( output_counter_value(i_clk5_div_by,
                                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                end if;
                i_e0_high := counter_high ( output_counter_value(i_extclk0_div_by,
                                            i_extclk0_mult_by,  i_m, i_n), extclk0_duty_cycle);
                i_e1_high := counter_high ( output_counter_value(i_extclk1_div_by,
                                            i_extclk1_mult_by,  i_m, i_n), extclk1_duty_cycle);
                i_e2_high := counter_high ( output_counter_value(i_extclk2_div_by,
                                            i_extclk2_mult_by,  i_m, i_n), extclk2_duty_cycle);
                i_e3_high := counter_high ( output_counter_value(i_extclk3_div_by,
                                            i_extclk3_mult_by,  i_m, i_n), extclk3_duty_cycle);
                if (pll_type = "lvds") then
                    i_g0_low  :=  counter_low ( output_counter_value(i_clk2_div_by,
                                                i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                else
                    i_g0_low  :=  counter_low ( output_counter_value(i_clk0_div_by,
                                                i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
                end if;
                i_g1_low  :=  counter_low ( output_counter_value(i_clk1_div_by,
                                            i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
                i_g2_low  :=  counter_low ( output_counter_value(i_clk2_div_by,
                                            i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                i_g3_low  :=  counter_low ( output_counter_value(i_clk3_div_by,
                                            i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
                if (pll_type = "lvds") then
                    i_l0_low  := i_g0_low;
                    i_l1_low  := i_g0_low;
                else
                    i_l0_low  :=  counter_low ( output_counter_value(i_clk4_div_by,
                                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                    i_l1_low  :=  counter_low ( output_counter_value(i_clk5_div_by,
                                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                end if;
                i_e0_low  :=  counter_low ( output_counter_value(i_extclk0_div_by,
                                            i_extclk0_mult_by,  i_m, i_n), extclk0_duty_cycle);
                i_e1_low  :=  counter_low ( output_counter_value(i_extclk1_div_by,
                                            i_extclk1_mult_by,  i_m, i_n), extclk1_duty_cycle);
                i_e2_low  :=  counter_low ( output_counter_value(i_extclk2_div_by,
                                            i_extclk2_mult_by,  i_m, i_n), extclk2_duty_cycle);
                i_e3_low  :=  counter_low ( output_counter_value(i_extclk3_div_by,
                                            i_extclk3_mult_by,  i_m, i_n), extclk3_duty_cycle);
                i_m_initial  := counter_initial(get_phase_degree(max_neg_abs, inclk0_input_frequency), i_m,i_n);
                if (pll_type = "lvds") then
                    i_g0_initial := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                else
                    i_g0_initial := counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                end if;
                
                i_g1_initial := counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_g2_initial := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_g3_initial := counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                if (pll_type = "lvds") then
                    i_l0_initial := i_g0_initial;
                    i_l1_initial := i_g0_initial;
                else
                    i_l0_initial := counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                    i_l1_initial := counter_initial(get_phase_degree(ph_adjust(str2int(clk5_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                end if;
                i_e0_initial := counter_initial(get_phase_degree(ph_adjust(str2int(extclk0_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_e1_initial := counter_initial(get_phase_degree(ph_adjust(str2int(extclk1_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_e2_initial := counter_initial(get_phase_degree(ph_adjust(str2int(extclk2_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_e3_initial := counter_initial(get_phase_degree(ph_adjust(str2int(extclk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                if (pll_type = "lvds") then
                    i_g0_mode := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                else
                    i_g0_mode := counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
                end if;
                i_g1_mode := counter_mode(clk1_duty_cycle, output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
                i_g2_mode := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                i_g3_mode := counter_mode(clk3_duty_cycle, output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
                if (pll_type = "lvds") then
                    i_l0_mode := "bypass";
                    i_l1_mode := "bypass";
                else
                    i_l0_mode := counter_mode(clk4_duty_cycle, output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));
                    i_l1_mode := counter_mode(clk5_duty_cycle, output_counter_value(i_clk5_div_by, i_clk5_mult_by,  i_m, i_n));
                end if;
                i_e0_mode := counter_mode(extclk0_duty_cycle, output_counter_value(i_extclk0_div_by, i_extclk0_mult_by,  i_m, i_n));
                i_e1_mode := counter_mode(extclk1_duty_cycle, output_counter_value(i_extclk1_div_by, i_extclk1_mult_by,  i_m, i_n));
                i_e2_mode := counter_mode(extclk2_duty_cycle, output_counter_value(i_extclk2_div_by, i_extclk2_mult_by,  i_m, i_n));
                i_e3_mode := counter_mode(extclk3_duty_cycle, output_counter_value(i_extclk3_div_by, i_extclk3_mult_by,  i_m, i_n));

                -- in external feedback mode, need to adjust M value to take
                -- into consideration the external feedback counter value
                if(operation_mode = "external_feedback") then
                    -- if there is a negative phase shift, m_initial can
                    -- only be 1
                    if (max_neg_abs > 0) then
                        i_m_initial := 1;
                    end if;

                    -- calculate the feedback counter multiplier
                    if (feedback_source = "extclk0") then
                        if (i_e0_mode = "bypass") then
                            output_count := 1;
                        else
                            output_count := i_e0_high + i_e0_low;
                        end if;
                    elsif (feedback_source = "extclk1") then
                        if (i_e1_mode = "bypass") then
                            output_count := 1;
                        else
                            output_count := i_e1_high + i_e1_low;
                        end if;
                    elsif (feedback_source = "extclk2") then
                        if (i_e2_mode = "bypass") then
                            output_count := 1;
                        else
                            output_count := i_e2_high + i_e2_low;
                        end if;
                    elsif (feedback_source = "extclk3") then
                        if (i_e3_mode = "bypass") then
                            output_count := 1;
                        else
                            output_count := i_e3_high + i_e3_low;
                        end if;
                    else -- default to e0
                        if (i_e0_mode = "bypass") then
                            output_count := 1;
                        else
                            output_count := i_e0_high + i_e0_low;
                        end if;
                    end if;

                    new_divisor := gcd(i_m, output_count);
                    i_m := i_m / new_divisor;
                    i_n := output_count / new_divisor;
                end if;
 
            else -- m /= 0

                i_n             := n;
                i_m             := m;
                i_m_initial     := m_initial;
                i_m_time_delay  := m_time_delay;
                i_n_time_delay  := n_time_delay;
                i_l0_time_delay := l0_time_delay;
                i_l1_time_delay := l1_time_delay;
                i_g0_time_delay := g0_time_delay;
                i_g1_time_delay := g1_time_delay;
                i_g2_time_delay := g2_time_delay;
                i_g3_time_delay := g3_time_delay;
                i_e0_time_delay := e0_time_delay;
                i_e1_time_delay := e1_time_delay;
                i_e2_time_delay := e2_time_delay;
                i_e3_time_delay := e3_time_delay;
                i_m_ph          := m_ph;
                i_l0_ph         := l0_ph;
                i_l1_ph         := l1_ph;
                i_g0_ph         := g0_ph;
                i_g1_ph         := g1_ph;
                i_g2_ph         := g2_ph;
                i_g3_ph         := g3_ph;
                i_e0_ph         := e0_ph;
                i_e1_ph         := e1_ph;
                i_e2_ph         := e2_ph;
                i_e3_ph         := e3_ph;
                i_l0_high       := l0_high;
                i_l1_high       := l1_high;
                i_g0_high       := g0_high;
                i_g1_high       := g1_high;
                i_g2_high       := g2_high;
                i_g3_high       := g3_high;
                i_e0_high       := e0_high;
                i_e1_high       := e1_high;
                i_e2_high       := e2_high;
                i_e3_high       := e3_high;
                i_l0_low        := l0_low;
                i_l1_low        := l1_low;
                i_g0_low        := g0_low;
                i_g1_low        := g1_low;
                i_g2_low        := g2_low;
                i_g3_low        := g3_low;
                i_e0_low        := e0_low;
                i_e1_low        := e1_low;
                i_e2_low        := e2_low;
                i_e3_low        := e3_low;
                i_l0_initial    := l0_initial;
                i_l1_initial    := l1_initial;
                i_g0_initial    := g0_initial;
                i_g1_initial    := g1_initial;
                i_g2_initial    := g2_initial;
                i_g3_initial    := g3_initial;
                i_e0_initial    := e0_initial;
                i_e1_initial    := e1_initial;
                i_e2_initial    := e2_initial;
                i_e3_initial    := e3_initial;
                i_l0_mode       := translate_string(l0_mode);
                i_l1_mode       := translate_string(l1_mode);
                i_g0_mode       := translate_string(g0_mode);
                i_g1_mode       := translate_string(g1_mode);
                i_g2_mode       := translate_string(g2_mode);
                i_g3_mode       := translate_string(g3_mode);
                i_e0_mode       := translate_string(e0_mode);
                i_e1_mode       := translate_string(e1_mode);
                i_e2_mode       := translate_string(e2_mode);
                i_e3_mode       := translate_string(e3_mode);

            end if; -- user to advanced conversion.

            m_initial_val <= i_m_initial;
            n_val_tmp <= i_n;
            m_val_tmp <= i_m;

            if (i_m = 1) then
                m_mode_val <= "bypass";
            end if;
            if (i_n = 1) then
                n_mode_val <= "bypass";
            end if;

            -- NOTE: m_time_delay (vco time delay) not supported for external
            --       feedback mode
            --       in feedback mode, m_time_delay = delay of feedback loop tap

            m_time_delay_val <= i_m_time_delay; 
            n_time_delay_val <= i_n_time_delay;

            m_ph_val  <= i_m_ph;

            m2_val <= m2;
            n2_val <= n2;
            if (m2 = 1) then
                m2_mode_val <= "bypass";
            end if;
            if (n2 = 1) then
                n2_mode_val <= "bypass";
            end if;

            if (skip_vco = "on") then
                m_val_tmp <= 1;
                m_initial_val <= 1;
                m_time_delay_val <= 0;
                m_ph_val <= 0;
            end if;

            l0_ph_val <= i_l0_ph;
            l1_ph_val <= i_l1_ph;
            g0_ph_val <= i_g0_ph;
            g1_ph_val <= i_g1_ph;
            g2_ph_val <= i_g2_ph;
            g3_ph_val <= i_g3_ph;
            e0_ph_val <= i_e0_ph;
            e1_ph_val <= i_e1_ph;
            e2_ph_val <= i_e2_ph;
            e3_ph_val <= i_e3_ph;

            l0_initial_val    <= i_l0_initial;
            l0_high_val       <= i_l0_high;
            l0_low_val        <= i_l0_low;
            l0_mode_val       <= i_l0_mode;
            l0_time_delay_val <= i_l0_time_delay;

            l1_initial_val    <= i_l1_initial;
            l1_high_val       <= i_l1_high;
            l1_low_val        <= i_l1_low;
            l1_mode_val       <= i_l1_mode;
            l1_time_delay_val <= i_l1_time_delay;

            g0_initial_val    <= i_g0_initial;
            g0_high_val       <= i_g0_high;
            g0_low_val        <= i_g0_low;
            g0_mode_val       <= i_g0_mode;
            g0_time_delay_val <= i_g0_time_delay;

            g1_initial_val    <= i_g1_initial;
            g1_high_val       <= i_g1_high;
            g1_low_val        <= i_g1_low;
            g1_mode_val       <= i_g1_mode;
            g1_time_delay_val <= i_g1_time_delay;

            g2_initial_val    <= i_g2_initial;
            g2_high_val       <= i_g2_high;
            g2_low_val        <= i_g2_low;
            g2_mode_val       <= i_g2_mode;
            g2_time_delay_val <= i_g2_time_delay;

            g3_initial_val    <= i_g3_initial;
            g3_high_val       <= i_g3_high;
            g3_low_val        <= i_g3_low;
            g3_mode_val       <= i_g3_mode;
            g3_time_delay_val <= i_g3_time_delay;

            if (scan_chain = "long") then
                e0_initial_val    <= i_e0_initial;
                e0_high_val       <= i_e0_high;
                e0_low_val        <= i_e0_low;
                e0_mode_val       <= i_e0_mode;
                e0_time_delay_val <= i_e0_time_delay;

                e1_initial_val    <= i_e1_initial;
                e1_high_val       <= i_e1_high;
                e1_low_val        <= i_e1_low;
                e1_mode_val       <= i_e1_mode;
                e1_time_delay_val <= i_e1_time_delay;

                e2_initial_val    <= i_e2_initial;
                e2_high_val       <= i_e2_high;
                e2_low_val        <= i_e2_low;
                e2_mode_val       <= i_e2_mode;
                e2_time_delay_val <= i_e2_time_delay;

                e3_initial_val    <= i_e3_initial;
                e3_high_val       <= i_e3_high;
                e3_low_val        <= i_e3_low;
                e3_mode_val       <= i_e3_mode;
                e3_time_delay_val <= i_e3_time_delay;

                scan_chain_length <= EGPP_SCAN_CHAIN;
            end if;
            init := false;
            done_with_param_calc <= true;
        elsif (transfer'event and transfer = '1') then
            reconfig_err <= false;
            ASSERT false REPORT "Reconfiguring PLL" severity note;
            if (scan_chain = "long") then
                -- cntr e3
                delay_chain := scan_data(287 downto 284);
                if (scan_data(273) = '1') then
                    e3_mode_val <= "bypass";
                    if (scan_data(283) = '1') then
                        e3_mode_val <= "   off";
                        ASSERT false REPORT "The specified bit settings will turn OFF the E3 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                    end if;
                elsif (scan_data(283) = '1') then
                    e3_mode_val <= "   odd";
                else 
                    e3_mode_val <= "  even";
                end if;
                high := scan_data(272 downto 264);
                low := scan_data(282 downto 274);
                e3_low_val <= alt_conv_integer(low);
                e3_high_val <= alt_conv_integer(high);
                -- count value of 0 is actually 512
                if (alt_conv_integer(high) = 0) then
                    e3_high_val <= 512;
                end if;
                if (alt_conv_integer(low) = 0) then
                    e3_low_val <= 512;
                end if;
                delay_val := alt_conv_integer(delay_chain);
                delay_val := delay_val * 250;
                if (delay_val > 3000) then
                    delay_val := 3000;
                end if;
                e3_time_delay_val <= delay_val;
  
                -- cntr e2
                delay_chain := scan_data(263 downto 260);
                if (scan_data(249) = '1') then
                    e2_mode_val <= "bypass";
                    if (scan_data(259) = '1') then
                        e2_mode_val <= "   off";
                        ASSERT false REPORT "The specified bit settings will turn OFF the E2 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                    end if;
                elsif (scan_data(259) = '1') then
                    e2_mode_val <= "   odd";
                else 
                    e2_mode_val <= "  even";
                end if;
                high := scan_data(248 downto 240);
                low := scan_data(258 downto 250);
                e2_low_val <= alt_conv_integer(low);
                e2_high_val <= alt_conv_integer(high);
                if (alt_conv_integer(high) = 0) then
                    e2_high_val <= 512;
                end if;
                if (alt_conv_integer(low) = 0) then
                    e2_low_val <= 512;
                end if;
                delay_val := alt_conv_integer(delay_chain);
                delay_val := delay_val * 250;
                if (delay_val > 3000) then
                    delay_val := 3000;
                end if;
                e2_time_delay_val <= delay_val;

                -- cntr e1
                delay_chain := scan_data(239 downto 236);
                if (scan_data(225) = '1') then
                    e1_mode_val <= "bypass";
                    if (scan_data(235) = '1') then
                        e1_mode_val <= "   off";
                        ASSERT false REPORT "The specified bit settings will turn OFF the E1 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                    end if;
                elsif (scan_data(235) = '1') then
                    e1_mode_val <= "   odd";
                else 
                    e1_mode_val <= "  even";
                end if;
                high := scan_data(224 downto 216);
                low := scan_data(234 downto 226);
                e1_low_val <= alt_conv_integer(low);
                e1_high_val <= alt_conv_integer(high);
                if (alt_conv_integer(high) = 0) then
                    e1_high_val <= 512;
                end if;
                if (alt_conv_integer(low) = 0) then
                    e1_low_val <= 512;
                end if;
                delay_val := alt_conv_integer(delay_chain);
                delay_val := delay_val * 250;
                if (delay_val > 3000) then
                    delay_val := 3000;
                end if;
                e1_time_delay_val <= delay_val;

                -- cntr e0
                delay_chain := scan_data(215 downto 212);
                if (scan_data(201) = '1') then
                    e0_mode_val <= "bypass";
                    if (scan_data(211) = '1') then
                        e0_mode_val <= "   off";
                        ASSERT false REPORT "The specified bit settings will turn OFF the E0 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                    end if;
                elsif (scan_data(211) = '1') then
                    e0_mode_val <= "   odd";
                else 
                    e0_mode_val <= "  even";
                end if;
                high := scan_data(200 downto 192);
                low := scan_data(210 downto 202);
                e0_low_val <= alt_conv_integer(low);
                e0_high_val <= alt_conv_integer(high);
                if (alt_conv_integer(high) = 0) then
                    e0_high_val <= 512;
                end if;
                if (alt_conv_integer(low) = 0) then
                    e0_low_val <= 512;
                end if;
                delay_val := alt_conv_integer(delay_chain);
                delay_val := delay_val * 250;
                if (delay_val > 3000) then
                    delay_val := 3000;
                end if;
                e0_time_delay_val <= delay_val;
 
            end if;
            -- cntr l1
            delay_chain := scan_data(191 downto 188);
            if (scan_data(177) = '1') then
                l1_mode_val <= "bypass";
                if (scan_data(187) = '1') then
                    l1_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the L1 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(187) = '1') then
                l1_mode_val <= "   odd";
            else 
                l1_mode_val <= "  even";
            end if;
            high := scan_data(176 downto 168);
            low := scan_data(186 downto 178);
            l1_low_val <= alt_conv_integer(low);
            l1_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                l1_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                l1_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            l1_time_delay_val <= delay_val;

            -- cntr l0
            delay_chain := scan_data(167 downto 164);
            if (scan_data(153) = '1') then
                l0_mode_val <= "bypass";
                if (scan_data(163) = '1') then
                    l0_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the L0 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(163) = '1') then
                l0_mode_val <= "   odd";
            else 
                l0_mode_val <= "  even";
            end if;
            high := scan_data(152 downto 144);
            low := scan_data(162 downto 154);
            l0_low_val <= alt_conv_integer(low);
            l0_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                l0_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                l0_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            l0_time_delay_val <= delay_val;

            -- cntr g3
            delay_chain := scan_data(143 downto 140);
            if (scan_data(129) = '1') then
                g3_mode_val <= "bypass";
                if (scan_data(139) = '1') then
                    g3_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the G3 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(139) = '1') then
                g3_mode_val <= "   odd";
            else 
                g3_mode_val <= "  even";
            end if;
            high := scan_data(128 downto 120);
            low := scan_data(138 downto 130);
            g3_low_val <= alt_conv_integer(low);
            g3_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                g3_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                g3_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            g3_time_delay_val <= delay_val;

            -- cntr g2
            delay_chain := scan_data(119 downto 116);
            if (scan_data(105) = '1') then
                g2_mode_val <= "bypass";
                if (scan_data(115) = '1') then
                    g2_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the G2 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(115) = '1') then
                g2_mode_val <= "   odd";
            else 
                g2_mode_val <= "  even";
            end if;
            high := scan_data(104 downto 96);
            low := scan_data(114 downto 106);
            g2_low_val <= alt_conv_integer(low);
            g2_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                g2_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                g2_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            g2_time_delay_val <= delay_val;

            -- cntr g1
            delay_chain := scan_data(95 downto 92);
            if (scan_data(81) = '1') then
                g1_mode_val <= "bypass";
                if (scan_data(91) = '1') then
                    g1_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the G1 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(91) = '1') then
                g1_mode_val <= "   odd";
            else 
                g1_mode_val <= "  even";
            end if;
            high := scan_data(80 downto 72);
            low := scan_data(90 downto 82);
            g1_low_val <= alt_conv_integer(low);
            g1_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                g1_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                g1_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            g1_time_delay_val <= delay_val;

            -- cntr g0
            delay_chain := scan_data(71 downto 68);
            if (scan_data(57) = '1') then
                g0_mode_val <= "bypass";
                if (scan_data(67) = '1') then
                    g0_mode_val <= "   off";
                    ASSERT false REPORT "The specified bit settings will turn OFF the G0 counter. It cannot be turned on unless the part is re-initialized." severity warning;
                end if;
            elsif (scan_data(67) = '1') then
                g0_mode_val <= "   odd";
            else 
                g0_mode_val <= "  even";
            end if;
            high := scan_data(56 downto 48);
            low := scan_data(66 downto 58);
            g0_low_val <= alt_conv_integer(low);
            g0_high_val <= alt_conv_integer(high);
            if (alt_conv_integer(high) = 0) then
                g0_high_val <= 512;
            end if;
            if (alt_conv_integer(low) = 0) then
                g0_low_val <= 512;
            end if;
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            g0_time_delay_val <= delay_val;

            -- cntr M
            is_error := false;
            -- 'low' contains modulus for m_cntr(spread_spectrum disabled)
            low := scan_data(32 downto 24);
            m_val_tmp <= alt_conv_integer(low);
            if (scan_data(33) /= '1') then
                if (alt_conv_integer(low) = 1) then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Illegal 1 value for M counter. Instead, M counter should be BYPASSED. Reconfiguration may not work." severity warning;
                elsif (alt_conv_integer(low) = 0) then
                    m_val_tmp <= 512;
                end if;
                if (not is_error) then
                    if (m_mode_val = "bypass") then
                        ASSERT false REPORT "M counter switched from BYPASS mode to enabled (M modulus = " &int2str(alt_conv_integer(low))& "). PLL may lose lock." severity warning;
                    else
                        write (buf, string'("   M modulus = "));
                        write (buf, alt_conv_integer(low));
                        writeline (output, buf);
                    end if;
                    m_mode_val <= "      ";
                end if;
            elsif (scan_data(33) = '1') then
                if (scan_data(24) /= '0') then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Illegal value for M counter in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                else
                    if (m_mode_val /= "bypass") then
                        ASSERT false REPORT "M counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                    end if;
                    write (buf, string'("   M modulus = "));
                    write (buf, 1);
                    writeline (output, buf);
                    m_val_tmp <= 1;
                    m_mode_val <= "bypass";
                end if;
            end if;

            if (skip_vco = "on") then
                m_val_tmp <= 1;
                ASSERT FALSE REPORT "VCO is bypassed, setting M modulus = 1, M time delay = 0" severity note;
            end if;

            -- cntr M2
            if (ss > 0) then
                is_error := false;
                low := scan_data(42 downto 34);
                m2_val <= alt_conv_integer(low);
                if (scan_data(43) /= '1') then
                    if (alt_conv_integer(low) = 1) then
                        is_error := true;
                        reconfig_err <= true;
                        ASSERT false REPORT "Illegal 1 value for M2 counter. Instead, M counter should be BYPASSED. Reconfiguration may not work." severity warning;
                    elsif (alt_conv_integer(low) = 0) then
                        m2_val <= 512;
                    end if;
                    if (not is_error) then
                        if (m2_mode_val = "bypass") then
                            ASSERT false REPORT "M2 counter switched from BYPASS mode to enabled (M2 modulus = " &int2str(alt_conv_integer(low))& "). PLL may lose lock." severity warning;
                        else
                            write (buf, string'("   M2 modulus = "));
                            write (buf, alt_conv_integer(low));
                            writeline (output, buf);
                        end if;
                        m2_mode_val <= "      ";
                    end if;
                elsif (scan_data(43) = '1') then
                    if (scan_data(34) /= '0') then
                        is_error := true;
                        reconfig_err <= true;
                        ASSERT false REPORT "Illegal value for M2 counter in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                    else
                        if (m2_mode_val /= "bypass") then
                            ASSERT false REPORT "M2 counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                        end if;
                        write (buf, string'("   M2 modulus = "));
                        write (buf, 1);
                        writeline (output, buf);
                        m2_val <= 1;
                        m2_mode_val <= "bypass";
                    end if;
                end if;
                if (m_mode_val /= m2_mode_val) then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Incompatible modes for M1/M2 counters. Either both should be BYPASSED or both NON-BYPASSED. Reconfiguration may not work." severity warning;
                end if;
            end if;

            delay_chain := scan_data(47 downto 44);
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            m_time_delay_val <= delay_val;
            if (skip_vco = "on") then
                m_time_delay_val <= 0;
                delay_val := 0;
            end if;
            write (buf, string'("   M time delay = "));
            write (buf, delay_val);
            writeline (output, buf);

            -- cntr N
            is_error := false;
            -- 'low' contains modulus for n_cntr(spread_spectrum disabled)
            low := scan_data(8 downto 0);
            n_val_tmp <= alt_conv_integer(low);
            if (scan_data(9) /= '1') then
                if (alt_conv_integer(low) = 1) then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Illegal 1 value for N counter. Instead, N counter should be BYPASSED. Reconfiguration may not work." severity warning;
                elsif (alt_conv_integer(low) = 0) then
                    n_val_tmp <= 512;
                    write (buf, string'("   N modulus = "));
                    write (buf, 512);
                    writeline (output, buf);
                else
                    write (buf, string'("   N modulus = "));
                    write (buf, alt_conv_integer(low));
                    writeline (output, buf);
                end if;
                if (not is_error) then
                    if (n_mode_val = "bypass") then
                        ASSERT false REPORT "N Counter switched from BYPASS mode to enabled (N modulus = " &int2str(alt_conv_integer(low))& "). PLL may lose lock." severity warning;
                    else
                        write (buf, string'("   N modulus = "));
                        write (buf, alt_conv_integer(low));
                        writeline (output, buf);
                    end if;
                    n_mode_val <= "      ";
                end if;
            elsif (scan_data(9) = '1') then
                if (scan_data(0) /= '0') then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Illegal value for N counter in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                else
                    if (n_mode_val /= "bypass") then
                        ASSERT false REPORT "N counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                    end if;
                    write (buf, string'("   N modulus = "));
                    write (buf, 1);
                    writeline (output, buf);
                    n_val_tmp <= 1;
                    n_mode_val <= "bypass";
                end if;
            end if;

            -- cntr N2
            if (ss > 0) then
                is_error := false;
                low := scan_data(18 downto 10);
                n2_val <= alt_conv_integer(low);
                if (scan_data(19) /= '1') then
                    if (alt_conv_integer(low) = 1) then
                        is_error := true;
                        reconfig_err <= true;
                        ASSERT false REPORT "Illegal 1 value for N2 counter. Instead, N counter should be BYPASSED. Reconfiguration may not work." severity warning;
                    elsif (alt_conv_integer(low) = 0) then
                        n2_val <= 512;
                    end if;
                    if (not is_error) then
                        if (n2_mode_val = "bypass") then
                            ASSERT false REPORT "N2 counter switched from BYPASS mode to enabled (N2 modulus = " &int2str(alt_conv_integer(low))& "). PLL may lose lock." severity warning;
                        else
                            write (buf, string'("   N2 modulus = "));
                            write (buf, alt_conv_integer(low));
                            writeline (output, buf);
                        end if;
                        n2_mode_val <= "      ";
                    end if;
                elsif (scan_data(19) = '1') then
                    if (scan_data(10) /= '0') then
                        is_error := true;
                        reconfig_err <= true;
                        ASSERT false REPORT "Illegal value for N2 counter in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                    else
                        if (n2_mode_val /= "bypass") then
                            ASSERT false REPORT "N2 counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                        end if;
                        write (buf, string'("   N2 modulus = "));
                        write (buf, 1);
                        writeline (output, buf);
                        n2_val <= 1;
                        n2_mode_val <= "bypass";
                    end if;
                end if;
                if (n_mode_val /= n2_mode_val) then
                    is_error := true;
                    reconfig_err <= true;
                    ASSERT false REPORT "Incompatible modes for N1/N2 counters. Either both should be BYPASSED or both NON-BYPASSED. Reconfiguration may not work." severity warning;
                end if;
            end if;

            delay_chain := scan_data(23 downto 20);
            delay_val := alt_conv_integer(delay_chain);
            delay_val := delay_val * 250;
            if (delay_val > 3000) then
                delay_val := 3000;
            end if;
            n_time_delay_val <= delay_val;
            write (buf, string'("   N time delay = "));
            write (buf, delay_val);
            writeline (output, buf);

        else
            if (scan_chain = "long") then
                write (buf, string'("   E3 high = "));
                write (buf, e3_high_val);
                write (buf, string'(" ,  E3 low = "));
                write (buf, e3_low_val);
                write (buf, string'(" ,  E3 mode = "));
                write (buf, e3_mode_val);
                write (buf, string'(" ,  E3 time delay = "));
                write (buf, e3_time_delay_val);
                writeline(output, buf);

                write (buf, string'("   E2 high = "));
                write (buf, e2_high_val);
                write (buf, string'(" ,  E2 low = "));
                write (buf, e2_low_val);
                write (buf, string'(" ,  E2 mode = "));
                write (buf, e2_mode_val);
                write (buf, string'(" ,  E2 time delay = "));
                write (buf, e2_time_delay_val);
                writeline(output, buf);

                write (buf, string'("   E1 high = "));
                write (buf, e1_high_val);
                write (buf, string'(" ,  E1 low = "));
                write (buf, e1_low_val);
                write (buf, string'(" ,  E1 mode = "));
                write (buf, e1_mode_val);
                write (buf, string'(" ,  E1 time delay = "));
                write (buf, e1_time_delay_val);
                writeline(output, buf);

                write (buf, string'("   E0 high = "));
                write (buf, e0_high_val);
                write (buf, string'(" ,  E0 low = "));
                write (buf, e0_low_val);
                write (buf, string'(" ,  E0 mode = "));
                write (buf, e0_mode_val);
                write (buf, string'(" ,  E0 time delay = "));
                write (buf, e0_time_delay_val);
                writeline(output, buf);
            end if;

            write (buf, string'("   L1 high = "));
            write (buf, l1_high_val);
            write (buf, string'(" ,  L1 low = "));
            write (buf, l1_low_val);
            write (buf, string'(" ,  L1 mode = "));
            write (buf, l1_mode_val);
            write (buf, string'(" ,  L1 time delay = "));
            write (buf, l1_time_delay_val);
            writeline(output, buf);

            write (buf, string'("   L0 high = "));
            write (buf, l0_high_val);
            write (buf, string'(" ,  L0 low = "));
            write (buf, l0_low_val);
            write (buf, string'(" ,  L0 mode = "));
            write (buf, l0_mode_val);
            write (buf, string'(" ,  L0 time delay = "));
            write (buf, l0_time_delay_val);
            writeline(output, buf);

            write (buf, string'("   G3 high = "));
            write (buf, g3_high_val);
            write (buf, string'(" ,  G3 low = "));
            write (buf, g3_low_val);
            write (buf, string'(" ,  G3 mode = "));
            write (buf, g3_mode_val);
            write (buf, string'(" ,  G3 time delay = "));
            write (buf, g3_time_delay_val);
            writeline(output, buf);

            write (buf, string'("   G2 high = "));
            write (buf, g2_high_val);
            write (buf, string'(" ,  G2 low = "));
            write (buf, g2_low_val);
            write (buf, string'(" ,  G2 mode = "));
            write (buf, g2_mode_val);
            write (buf, string'(" ,  G2 time delay = "));
            write (buf, g2_time_delay_val);
            writeline(output, buf);

            write (buf, string'("   G1 high = "));
            write (buf, g1_high_val);
            write (buf, string'(" ,  G1 low = "));
            write (buf, g1_low_val);
            write (buf, string'(" ,  G1 mode = "));
            write (buf, g1_mode_val);
            write (buf, string'(" ,  G1 time delay = "));
            write (buf, g1_time_delay_val);
            writeline(output, buf);

            write (buf, string'("   G0 high = "));
            write (buf, g0_high_val);
            write (buf, string'(" ,  G0 low = "));
            write (buf, g0_low_val);
            write (buf, string'(" ,  G0 mode = "));
            write (buf, g0_mode_val);
            write (buf, string'(" ,  G0 time delay = "));
            write (buf, g0_time_delay_val);
            writeline(output, buf);

        end if;
    end process;

    process (schedule_vco, areset_ipd, ena_ipd, pfdena_ipd, refclk, fbclk, inclk0_ipd, inclk1_ipd, clkswitch_ipd, done_with_param_calc)
    variable sched_time : time := 0 ps;

    TYPE time_array is ARRAY (0 to 7) of time;
    variable init : boolean := true;
    variable refclk_period : time;
    variable primary_clock_frequency : time;
    variable m_times_vco_period : time;
    variable new_m_times_vco_period : time;

    variable phase_shift : time_array := (OTHERS => 0 ps);
    variable last_phase_shift : time_array := (OTHERS => 0 ps);

    variable l_index : integer := 1;
    variable cycle_to_adjust : integer := 0;

    variable stop_vco : boolean := false;

    variable locked_tmp : std_logic := '0';
    variable pll_is_locked : boolean := false;
    variable pll_about_to_lock : boolean := false;
    variable cycles_to_lock : integer := 0;
    variable cycles_to_unlock : integer := 0;

    variable got_first_refclk : boolean := false;
    variable got_second_refclk : boolean := false;
    variable got_first_fbclk : boolean := false;

    variable refclk_time : time := 0 ps;
    variable fbclk_time : time := 0 ps;
    variable first_fbclk_time : time := 0 ps;

    variable fbclk_period : time := 0 ps;

    variable first_schedule : boolean := true;
    variable schedule_offset : boolean := true;

    variable vco_val : std_logic := '0';
    variable vco_period_was_phase_adjusted : boolean := false;
    variable phase_adjust_was_scheduled : boolean := false;

    variable loop_xplier : integer;
    variable loop_initial : integer := 0;
    variable loop_ph : integer := 0;
    variable loop_time_delay : integer := 0;

    variable initial_delay : time := 0 ps;
    variable vco_per : time;
    variable tmp_rem : integer;
    variable my_rem : integer;
    variable fbk_phase : integer := 0;

    variable pull_back_ext_fbk_cntr : integer := 0;
    variable pull_back_M : integer := 0;
    variable total_pull_back : integer := 0;
    variable fbk_delay : integer := 0;

    variable offset : time := 0 ps;

    variable tmp_vco_per : integer := 0;
    variable high_time : time;
    variable low_time : time;

    variable got_refclk_posedge : boolean := false;
    variable got_fbclk_posedge : boolean := false;
    variable inclk_out_of_range : boolean := false;
    variable no_warn : boolean := false;
    variable init_clks : boolean := true;
    variable ext_fbk_cntr_modulus : integer := 1;
    variable pll_is_in_reset : boolean := false;

    -- clkswitch variables
    variable other_clock_value : std_logic := '0';
    variable other_clock_last_value : std_logic;
    variable current_clock : string(1 to 6) := primary_clock;
    variable clk0_count, clk1_count : integer := 0;
    variable clk0_is_bad, clk1_is_bad : std_logic := '0';
    variable primary_clk_is_bad : boolean := false;
    variable current_clk_is_bad : boolean := false;
    variable got_curr_clk_falling_edge_after_clkswitch : boolean := false;
    variable switch_over_count : integer := 0;
    variable active_clock : std_logic := '0';
    variable external_switch : boolean := false;

    begin
        if (init and done_with_param_calc) then
            if (pll_type = "fast") then
                locked_tmp := '1';
            end if;
            m_val <= m_val_tmp;
            n_val <= n_val_tmp;
            -- jump-start the VCO
            -- add 1 ps delay to ensure all signals are updated to initial
            -- values
            schedule_vco <= transport not schedule_vco after 1 ps;

            init := false;
        end if;

        -- merged from separate process
        if (now = 0 ps) then
            if (current_clock = "inclk1") then
                active_clock := '1';
            end if;
        end if;
        if (clkswitch_ipd'event and clkswitch_ipd = '1') then
            external_switch := true;
        end if;
        -- save the current inclk event value
        if (inclk0_ipd'event) then
            if (current_clock /= "inclk0") then
                other_clock_value := inclk0_ipd;
            end if;
        end if;
        if (inclk1_ipd'event) then
            if (current_clock /= "inclk1") then
                other_clock_value := inclk1_ipd;
            end if;
        end if;

        -- check if either input clk is bad
        if (inclk0_ipd'event and inclk0_ipd = '1') then
            clk0_count := clk0_count + 1;
            clk0_is_bad := '0';
            if (current_clock = "inclk0") then
                current_clk_is_bad := false;
            end if;
            clk1_count := 0;
            if (clk0_count > 2) then
                -- no event on other clk for 2 cycles
                clk1_is_bad := '1';
                if (current_clock = "inclk1") then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;
        if (inclk1_ipd'event and inclk1_ipd = '1') then
            clk1_count := clk1_count + 1;
            clk1_is_bad := '0';
            if (current_clock = "inclk1") then
                current_clk_is_bad := false;
            end if;
            clk0_count := 0;
            if (clk1_count > 2) then
                -- no event on other clk for 2 cycles
                clk0_is_bad := '1';
                if (current_clock = "inclk0") then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;

        -- check if the bad clk is the primary clock
        if ((primary_clock = "inclk0" and clk0_is_bad = '1') or (primary_clock = "inclk1" and clk1_is_bad = '1')) then
            primary_clk_is_bad := true;
        else
            primary_clk_is_bad := false;
        end if;

        -- actual switching
        if (inclk0_ipd'event and current_clock = "inclk0") then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk0_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk0_ipd;
                end if;
            else
                clkin <= transport inclk0_ipd;
            end if;
        end if;
        if (inclk1_ipd'event and current_clock = "inclk1") then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk1_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk1_ipd;
                end if;
            else
                clkin <= transport inclk1_ipd;
            end if;
        end if;
        if (inclk0_ipd'event or inclk1_ipd'event) then
            if ( (other_clock_value = '1') and
                (other_clock_value /= other_clock_last_value) and
                (switch_over_on_lossclk = "on") and
                (enable_switch_over_counter = "on") and
                (primary_clk_is_bad) ) then
                    switch_over_count := switch_over_count + 1;
            end if;
            if ((other_clock_value = '0') and (other_clock_value /= other_clock_last_value)) then
                if (external_switch and (got_curr_clk_falling_edge_after_clkswitch or current_clk_is_bad)) or (switch_over_on_lossclk = "on" and primary_clk_is_bad and (enable_switch_over_counter = "off" or switch_over_count = switch_over_counter)) then
                    got_curr_clk_falling_edge_after_clkswitch := false;
                    if (current_clock = "inclk0") then
                        current_clock := "inclk1";
                    else
                        current_clock := "inclk0";
                    end if;
                    active_clock := not active_clock;
                    switch_over_count := 0;
                    external_switch := false;
                    current_clk_is_bad := false;
                end if;
            end if;
            other_clock_last_value := other_clock_value;
        end if;

        -- schedule outputs
        clkbad(0) <= clk0_is_bad;
        clkbad(1) <= clk1_is_bad;
        if (switch_over_on_lossclk = "on" and clkswitch_ipd /= '1') then
            if (primary_clk_is_bad) then
                -- assert clkloss
                clkloss <= '1';
            else
                clkloss <= '0';
            end if;
        else
            clkloss <= clkswitch_ipd;
        end if;
        activeclock <= active_clock;

        -- end -- clkswitch

        if (schedule_vco'event) then
            if (init_clks) then
                if (primary_clock = "inclk0") then
                    refclk_period := inclk0_input_frequency * n_val * 1 ps;
                    primary_clock_frequency := inclk0_input_frequency * 1 ps;
                elsif (primary_clock = "inclk1") then
                    refclk_period := inclk1_input_frequency * n_val * 1 ps;
                    primary_clock_frequency := inclk1_input_frequency * 1 ps;
                end if;

                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                init_clks := false;
            end if;
            sched_time := 0 ps;
            for i in 0 to 7 loop
                last_phase_shift(i) := phase_shift(i);
            end loop;
            cycle_to_adjust := 0;
            l_index := 1;
            m_times_vco_period := new_m_times_vco_period;
        end if;

        -- areset was asserted
        if (areset_ipd'event and areset_ipd = '1') then
            assert false report family_name & " PLL was reset" severity note;
        end if;

        -- areset deasserted
        if (areset_ipd'event and areset_ipd = '0') then
            if (scandataout_tmp = '1') then
                sdataout_rst_trig <= transport not sdataout_rst_trig;
            end if;
        end if;

        -- ena was deasserted
        if (ena_ipd'event and ena_ipd = '0') then
            assert false report family_name & " PLL was disabled" severity note;
        end if;

        if (schedule_vco'event and (areset_ipd = '1' or ena_ipd = '0' or stop_vco)) then
            if (areset_ipd = '1') then
                pll_is_in_reset := true;
            end if;

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after last_phase_shift(i);
                phase_shift(i) := 0 ps;
                last_phase_shift(i) := 0 ps;
            end loop;

            -- reset lock parameters
            locked_tmp := '0';
            if (pll_type = "fast") then
                locked_tmp := '1';
            end if;
            pll_is_locked := false;
            pll_about_to_lock := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;

            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := 0 ps;
            got_first_fbclk := false;
            fbclk_time := 0 ps;
            first_fbclk_time := 0 ps;
            fbclk_period := 0 ps;

            first_schedule := true;
            schedule_offset := true;
            vco_val := '0';
            vco_period_was_phase_adjusted := false;
            phase_adjust_was_scheduled := false;

        elsif ((schedule_vco'event or ena_ipd'event or areset_ipd'event) and areset_ipd = '0' and ena_ipd = '1' and (not stop_vco) and (now > 0 ps)) then

            -- note areset deassert time
            -- note it as refclk_time to prevent false triggering
            -- of stop_vco after areset
            if (areset_ipd'event and areset_ipd = '0' and pll_is_in_reset) then
                refclk_time := now;
                pll_is_in_reset := false;
            end if;

            -- calculate loop_xplier : this will be different from m_val
            -- in external_feedback_mode
            loop_xplier := m_val;
            loop_initial := m_initial_val - 1;
            loop_ph := m_ph_val;
            loop_time_delay := m_time_delay_val;

            if (operation_mode = "external_feedback") then
                if (ext_fbk_cntr_mode = "bypass") then
                    ext_fbk_cntr_modulus := 1;
                else
                    ext_fbk_cntr_modulus := ext_fbk_cntr_high + ext_fbk_cntr_low;
                end if;

                loop_xplier := m_val * (ext_fbk_cntr_modulus);
                loop_ph := ext_fbk_cntr_ph;
                loop_initial := ext_fbk_cntr_initial - 1 + ((m_initial_val - 1) * (ext_fbk_cntr_modulus));
                loop_time_delay := m_time_delay_val + ext_fbk_cntr_delay;
            end if;

            -- convert initial value to delay
            initial_delay := (loop_initial * m_times_vco_period)/loop_xplier;

            -- convert loop ph_tap to delay
            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            tmp_vco_per := (m_times_vco_period/1 ps) / loop_xplier;
            if (my_rem /= 0) then
                tmp_vco_per := tmp_vco_per + 1;
            end if;
            fbk_phase := (loop_ph * tmp_vco_per)/8;

            if (operation_mode = "external_feedback") then
                pull_back_ext_fbk_cntr :=  ext_fbk_cntr_delay + (ext_fbk_cntr_initial - 1) * (m_times_vco_period/loop_xplier)/1 ps + fbk_phase;
                while (pull_back_ext_fbk_cntr > refclk_period/1 ps) loop
                    pull_back_ext_fbk_cntr := pull_back_ext_fbk_cntr - refclk_period/ 1 ps;
                end loop;
                pull_back_M :=  m_time_delay_val + (m_initial_val - 1) * (ext_fbk_cntr_modulus) * ((refclk_period/loop_xplier)/1 ps);
                while (pull_back_M > refclk_period/1 ps) loop
                    pull_back_M := pull_back_M - refclk_period/ 1 ps;
                end loop;
            else
                pull_back_ext_fbk_cntr := 0;
                pull_back_M := initial_delay/1 ps + m_time_delay_val + fbk_phase;
            end if;

            total_pull_back := pull_back_M + pull_back_ext_fbk_cntr;

            if (simulation_type = "timing") then
                total_pull_back := total_pull_back + pll_compensation_delay;
            end if;
            while (total_pull_back > refclk_period/1 ps) loop
                total_pull_back := total_pull_back - refclk_period/1 ps;
            end loop;

            if (total_pull_back > 0) then
                offset := refclk_period - (total_pull_back * 1 ps);
            end if;
            if (operation_mode = "external_feedback") then
                fbk_delay := pull_back_M;
                if (simulation_type = "timing") then
                    fbk_delay := fbk_delay + pll_compensation_delay;
                end if;
                ext_fbk_delay <= transport (pull_back_ext_fbk_cntr - fbk_phase) after 1 ps;
            else
                fbk_delay := total_pull_back - fbk_phase;
                if (fbk_delay < 0) then
                    offset := offset - (fbk_phase * 1 ps);
                    fbk_delay := total_pull_back;
                end if;
            end if;

            -- assign m_delay
            m_delay <= transport fbk_delay after 1 ps;

            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            for i in 1 to loop_xplier loop
                -- adjust cycles
                tmp_vco_per := (m_times_vco_period/1 ps)/loop_xplier;
                if (my_rem /= 0 and l_index <= my_rem) then
                    tmp_rem := (loop_xplier * l_index) rem my_rem;
                    cycle_to_adjust := (loop_xplier * l_index) / my_rem;
                    if (tmp_rem /= 0) then
                        cycle_to_adjust := cycle_to_adjust + 1;
                    end if;
                end if;
                if (cycle_to_adjust = i) then
                    tmp_vco_per := tmp_vco_per + 1;
                    l_index := l_index + 1;
                end if;

                -- calculate high and low periods
                vco_per := tmp_vco_per * 1 ps;
                high_time := (tmp_vco_per/2) * 1 ps;
                if (tmp_vco_per rem 2 /= 0) then
                    high_time := high_time + 1 ps;
                end if;
                low_time := vco_per - high_time;

                -- schedule the rising and falling edges
                for j in 1 to 2 loop
                    vco_val := not vco_val;
                    if (vco_val = '0') then
                        sched_time := sched_time + high_time;
                    elsif (vco_val = '1') then
                        sched_time := sched_time + low_time;
                    end if;

                    -- add offset
                    if (schedule_offset) then
                        sched_time := sched_time + offset;
                        schedule_offset := false;
                    end if;

                    -- schedule the phase taps
                    for k in 0 to 7 loop
                        phase_shift(k) := (k * vco_per)/8;
                        if (first_schedule) then
                            vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                        else
                            vco_out(k) <= transport vco_val after (sched_time + last_phase_shift(k));
                        end if;
                    end loop;
                end loop;
            end loop;

            -- schedule once more
            if (first_schedule) then
                vco_val := not vco_val;
                if (vco_val = '0') then
                    sched_time := sched_time + high_time;
                elsif (vco_val = '1') then
                    sched_time := sched_time + low_time;
                end if;
                -- schedule the phase taps
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                    vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                end loop;
                first_schedule := false;
            end if;

            if (sched_time > 0 ps) then
                schedule_vco <= transport not schedule_vco after sched_time;
            end if;

            if (vco_period_was_phase_adjusted) then
                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := true;

                vco_per := m_times_vco_period/loop_xplier;
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                end loop;
            end if;
        end if;

        if (refclk'event and refclk = '1' and areset_ipd = '0') then
            n_val <= n_val_tmp;
            got_refclk_posedge := true;
            if (not got_first_refclk) then
                got_first_refclk := true;
            else
                got_second_refclk := true;
                refclk_period := now - refclk_time;

                -- check if incoming freq. will cause VCO range to be
                -- exceeded
                if ((vco_max /= 0 and vco_min /= 0 and skip_vco = "off" and pfdena_ipd = '1') and
                    (((refclk_period/1 ps)/loop_xplier > vco_max) or
                    ((refclk_period/1 ps)/loop_xplier < vco_min)) ) then
                    if (pll_is_locked) then
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may lose lock" severity warning;
                        if (inclk_out_of_range) then
                            -- unlock
                            pll_is_locked := false;
                            locked_tmp := '0';
                            if (pll_type = "fast") then
                                locked_tmp := '1';
                            end if;
                            pll_about_to_lock := false;
                            cycles_to_lock := 0;
                            assert false report family_name & " PLL lost lock" severity note;
                            first_schedule := true;
                            schedule_offset := true;
                            vco_period_was_phase_adjusted := false;
                            phase_adjust_was_scheduled := false;
                        end if;
                    elsif (not no_warn) then
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may not lock." severity warning;
                        no_warn := true;
                    end if;
                    inclk_out_of_range := true;
                else
                    inclk_out_of_range := false;
                end if;
            end if;

            if (stop_vco) then
                stop_vco := false;
                schedule_vco <= not schedule_vco;
            end if;

            refclk_time := now;
        else
            got_refclk_posedge := false;
        end if;

        if (fbclk'event and fbclk = '1') then
            m_val <= transport m_val_tmp after 1 ps;
            got_fbclk_posedge := true;
            if (not got_first_fbclk) then
                got_first_fbclk := true;
            else
                fbclk_period := now - fbclk_time;
            end if;

            -- need refclk_period here, so initialized to proper value above
            if ( ( (now - refclk_time > 1.5 * refclk_period) and pfdena_ipd = '1' and pll_is_locked)  or ((now - refclk_time > 5 * refclk_period) and pfdena_ipd = '1') ) then
                stop_vco := true;
                -- reset
                got_first_refclk := false;
                got_first_fbclk := false;
                got_second_refclk := false;
                if (pll_is_locked) then
                    pll_is_locked := false;
                    locked_tmp := '0';
                    if (pll_type = "fast") then
                        locked_tmp := '1';
                    end if;
                    assert false report family_name & " PLL lost lock due to loss of input clock" severity note;
                end if;
                pll_about_to_lock := false;
                cycles_to_lock := 0;
                cycles_to_unlock := 0;
                first_schedule := true;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := false;
            end if;
            fbclk_time := now;
        else
            got_fbclk_posedge := false;
        end if;

        if ((got_refclk_posedge or got_fbclk_posedge) and got_second_refclk and pfdena_ipd = '1' and (not inclk_out_of_range)) then

            -- now we know actual incoming period
            if ( abs(fbclk_time - refclk_time) <= 5 ps or
                (got_first_fbclk and abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                -- considered in phase
                if (cycles_to_lock = valid_lock_multiplier - 1) then
                    pll_about_to_lock := true;
                end if;
                if (cycles_to_lock = valid_lock_multiplier) then
                    if (not pll_is_locked) then
                        assert (quiet_period_violation) report family_name & " PLL locked to incoming clock" severity note;
                    end if;
                    pll_is_locked := true;
                    locked_tmp := '1';
                    if (pll_type = "fast") then
                        locked_tmp := '0';
                    end if;
                end if;
                -- increment lock counter only if second part of above
                -- time check is NOT true
                if (not(abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                    cycles_to_lock := cycles_to_lock + 1;
                end if;

                -- adjust m_times_vco_period
                new_m_times_vco_period := refclk_period;
            else
                -- if locked, begin unlock
                if (pll_is_locked) then
                    cycles_to_unlock := cycles_to_unlock + 1;
                    if (cycles_to_unlock = invalid_lock_multiplier) then
                        pll_is_locked := false;
                        locked_tmp := '0';
                        if (pll_type = "fast") then
                            locked_tmp := '1';
                        end if;
                        pll_about_to_lock := false;
                        cycles_to_lock := 0;
                        assert (quiet_period_violation) report family_name & " PLL lost lock" severity note;
                        first_schedule := true;
                        schedule_offset := true;
                        vco_period_was_phase_adjusted := false;
                        phase_adjust_was_scheduled := false;
                    end if;
                end if;
                if ( abs(refclk_period - fbclk_period) <= 2 ps ) then
                    -- frequency is still good
                    if (now = fbclk_time and (not phase_adjust_was_scheduled)) then
                        if ( abs(fbclk_time - refclk_time) > refclk_period/2) then
                            if ( abs(fbclk_time - refclk_time) > 1.5 * refclk_period) then
                                -- input clock may have stopped; do nothing
                            else
                            new_m_times_vco_period := m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                            vco_period_was_phase_adjusted := true;
                            end if;
                        else
                            new_m_times_vco_period := m_times_vco_period - abs(fbclk_time - refclk_time);
                            vco_period_was_phase_adjusted := true;
                        end if;

                    end if;
                else
                    phase_adjust_was_scheduled := false;
                    new_m_times_vco_period := refclk_period;
                end if;
            end if;
        end if;

        if (pfdena_ipd = '0') then
            locked_tmp := 'X';
            pll_is_locked := false;
            cycles_to_lock := 0;
        end if;

        -- give message only at time of deassertion
        if (pfdena_ipd'event and pfdena_ipd = '0') then
            assert false report "PFDENA deasserted." severity note;
        elsif (pfdena_ipd'event and pfdena_ipd = '1') then
            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := now;
        end if;

        if (quiet_period_violation or reconfig_err or scanclr_violation or scanclr_clk_violation) then
            lock <= '0';
            if (pll_type = "fast") then
                lock <= '1';
            end if;
        else
            lock <= locked_tmp;
        end if;
        about_to_lock <= pll_about_to_lock after 1 ps;

        -- signal to calculate quiet_time
        sig_refclk_period <= refclk_period;
        sig_current_clock <= current_clock;

        -- signals for debugging
        sig_offset <= offset;
        sig_refclk_time <= refclk_time;
        sig_fbclk_time <= fbclk_time;
        sig_fbclk_period <= fbclk_period;
        sig_vco_period_was_phase_adjusted <= vco_period_was_phase_adjusted;
        sig_phase_adjust_was_scheduled <= phase_adjust_was_scheduled;
        if (stop_vco = true) then
            sig_stop_vco <= '1';
        else
            sig_stop_vco <= '0';
        end if;
        sig_m_times_vco_period <= m_times_vco_period;
        sig_new_m_times_vco_period <= new_m_times_vco_period;
        sig_got_refclk_posedge <= got_refclk_posedge;
        sig_got_fbclk_posedge <= got_fbclk_posedge;
        sig_got_second_refclk <= got_second_refclk;
    end process;

    process (scanclk_ipd, scanaclr_ipd, scan_data, transfer, sdataout_trig, sdataout_rst_trig)
    variable j : integer := 0;
    variable pll_in_quiet_period : boolean := false;
    variable start_quiet_time : time := 0 ps;
    variable quiet_time : time := 0 ps;
    variable scanclr_rising_time : time := 0 ps;
    variable scanclr_falling_time : time := 0 ps;
    variable got_first_scanclk_after_scanclr_inactive_edge : boolean := false;
    variable scan_chain_being_reset : boolean := false;

    function  slowest_clk ( L0 : integer; L0_mode : string(1 to 6);
                            L1 : integer; L1_mode : string(1 to 6);
                            G0 : integer; G0_mode : string(1 to 6);
                            G1 : integer; G1_mode : string(1 to 6);
                            G2 : integer; G2_mode : string(1 to 6);
                            G3 : integer; G3_mode : string(1 to 6);
                            E0 : integer; E0_mode : string(1 to 6);
                            E1 : integer; E1_mode : string(1 to 6);
                            E2 : integer; E2_mode : string(1 to 6);
                            E3 : integer; E3_mode : string(1 to 6);
                            scan_chain : string; 
                            refclk : time; m_mod : integer) return time is
        variable max_modulus : integer := 1;
        variable q_period : time := 0 ps;
        variable refclk_int : integer := 0;
        begin
            if (L0_mode /= "bypass" and L0_mode /= "   off") then
                max_modulus := L0;
            end if;
            if (L1 > max_modulus and L1_mode /= "bypass" and L1_mode /= "   off") then
                max_modulus := L1;
            end if;
            if (G0 > max_modulus and G0_mode /= "bypass" and G0_mode /= "   off") then
                max_modulus := G0;
            end if;
            if (G1 > max_modulus and G1_mode /= "bypass" and G1_mode /= "   off") then
                max_modulus := G1;
            end if;
            if (G2 > max_modulus and G2_mode /= "bypass" and G2_mode /= "   off") then
                max_modulus := G2;
            end if;
            if (G3 > max_modulus and G3_mode /= "bypass" and G3_mode /= "   off") then
                max_modulus := G3;
            end if;
            if (scan_chain = "long") then
                if (E0 > max_modulus and E0_mode /= "bypass" and E0_mode /= "   off") then
                    max_modulus := E0;
                end if;
                if (E1 > max_modulus and E1_mode /= "bypass" and E1_mode /= "   off") then
                    max_modulus := E1;
                end if;
                if (E2 > max_modulus and E2_mode /= "bypass" and E2_mode /= "   off") then
                    max_modulus := E2;
                end if;
                if (E3 > max_modulus and E3_mode /= "bypass" and E3_mode /= "   off") then
                    max_modulus := E3;
                end if;
            end if;
            refclk_int := refclk / 1 ps;
            if (m_mod /= 0) then
                q_period := ((refclk_int/m_mod) * max_modulus) * 1 ps;
            end if;
        return (2*q_period);
    end slowest_clk;

    begin
        if (transfer'event) then
            if (transfer = '0') then
                -- clear the chain
                for i in scan_data'range loop
                    scan_data(i) <= '0';
                end loop;
            end if;
        elsif (scanaclr_ipd'event and scanaclr_ipd = '1') then
            -- scanaclr rising
            scanclr_rising_time := now;
            scan_chain_being_reset := true;
        elsif (scanaclr_ipd'event and scanaclr_ipd = '0') then
            -- scanaclr falling
            scanclr_falling_time := now;
            if (scan_chain_being_reset and (now - scanclr_rising_time < TRST)) then
                scanclr_violation <= true;
                ASSERT false REPORT "Detected SCANACLR ACTIVE pulse width violation. Required is 5000 ps, actual is "& int2str((now - scanclr_rising_time) / 1 ps) &". The PLL may not function correctly." severity warning;
            else
                scanclr_violation <= false;
                for i in scan_data'range loop
                    scan_data(i) <= '0';
                end loop;
            end if;
            scan_chain_being_reset := false;
            got_first_scanclk_after_scanclr_inactive_edge := false;
        elsif (scanclk_ipd'event and scanclk_ipd = '1' and not got_first_scanclk_after_scanclr_inactive_edge and (now - scanclr_falling_time < TRSTCLK)) then
            scanclr_clk_violation <= true;
            got_first_scanclk_after_scanclr_inactive_edge := true;

            ASSERT false REPORT "Detected SCANACLR INACTIVE time violation before rising edge of SCANCLK. Required is 5000 ps, actual is "& int2str((now - scanclr_falling_time) / 1 ps) &". Reconfiguration may not work." severity warning;
        elsif (scanclk_ipd'event and scanclk_ipd = '1' and scanaclr_ipd = '0') then
            if (pll_in_quiet_period and (now - start_quiet_time < quiet_time)) then
                ASSERT false REPORT "Detected transition on SCANCLK during quiet period. The PLL may not function correctly." severity warning;
                quiet_period_violation <= true;
            else
                pll_in_quiet_period := false;
                for j in scan_chain_length-1 downto 1 loop
                    scan_data(j) <= scan_data(j-1);
                end loop;
                scan_data(0) <= scandata_ipd;
            end if;
            if (not got_first_scanclk_after_scanclr_inactive_edge) then
                got_first_scanclk_after_scanclr_inactive_edge := true;
                scanclr_clk_violation <= false;
            end if;
        elsif (scanclk_ipd'event and scanclk_ipd = '0' and scanaclr_ipd = '0') then
            if (pll_in_quiet_period and (now - start_quiet_time < quiet_time)) then
                ASSERT false REPORT "Detected transition on SCANCLK during quiet period. The PLL may not function correctly." severity warning;
                quiet_period_violation <= true;
            elsif (scan_data(scan_chain_length-1) = '1') then
                -- reset violation flag only after another reconfig seq.
                quiet_period_violation <= false;

                -- initiate transfer
                transfer <= '1';
                transfer <= transport '0' after 1 ps;
                scandataout_tmp <= '1';
                pll_in_quiet_period := true;
                start_quiet_time := now;
                quiet_time := slowest_clk ( l0_high_val+l0_low_val, l0_mode_val,
                                            l1_high_val+l1_low_val, l1_mode_val,
                                            g0_high_val+g0_low_val, g0_mode_val,
                                            g1_high_val+g1_low_val, g1_mode_val,
                                            g2_high_val+g2_low_val, g2_mode_val,
                                            g3_high_val+g3_low_val, g3_mode_val,
                                            e0_high_val+e0_low_val, e0_mode_val,
                                            e1_high_val+e1_low_val, e1_mode_val,
                                            e2_high_val+e2_low_val, e2_mode_val,
                                            e3_high_val+e3_low_val, e3_mode_val,
                                            scan_chain, sig_refclk_period, m_val);
                sdataout_trig <= transport not sdataout_trig after quiet_time;
            end if;
        elsif (sdataout_trig'event) then
            if (areset_ipd = '0') then
                scandataout_tmp <= transport '0';
            end if;
        elsif (sdataout_rst_trig'event) then
            scandataout_tmp <= transport '0' after quiet_time;
        end if;
    end process;

    clk0_tmp <= l0_clk when i_clk0_counter = "l0" else
                l1_clk when i_clk0_counter = "l1" else
                g0_clk when i_clk0_counter = "g0" else
                g1_clk when i_clk0_counter = "g1" else
                g2_clk when i_clk0_counter = "g2" else
                g3_clk when i_clk0_counter = "g3" else
                '0';
    not_clk0_tmp <= not clk0_tmp;
    ena0_reg : dffp
                port map  ( D    => clkena(0),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk0_tmp,
                            Q    => ena0 );
                            
    clk(0)  <=  ena0 and clk0_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena0 and 'X';

    clk1_tmp <= l0_clk when i_clk1_counter = "l0" else
                l1_clk when i_clk1_counter = "l1" else
                g0_clk when i_clk1_counter = "g0" else
                g1_clk when i_clk1_counter = "g1" else
                g2_clk when i_clk1_counter = "g2" else
                g3_clk when i_clk1_counter = "g3" else
                '0';
    not_clk1_tmp <= not clk1_tmp;
    ena1_reg : dffp
                port map  ( D    => clkena(1),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk1_tmp,
                            Q    => ena1 );
                            
    clk(1)  <=  ena1 and clk1_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena1 and 'X';

    clk2_tmp <= l0_clk when i_clk2_counter = "l0" else
                l1_clk when i_clk2_counter = "l1" else
                g0_clk when i_clk2_counter = "g0" else
                g1_clk when i_clk2_counter = "g1" else
                g2_clk when i_clk2_counter = "g2" else
                g3_clk when i_clk2_counter = "g3" else
                '0';
    not_clk2_tmp <= not clk2_tmp;
    ena2_reg : dffp
                port map  ( D    => clkena(2),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk2_tmp,
                            Q    => ena2 );
                            
    clk(2)  <=  ena2 and clk2_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena2 and 'X';

    clk3_tmp <= l0_clk when i_clk3_counter = "l0" else
                l1_clk when i_clk3_counter = "l1" else
                g0_clk when i_clk3_counter = "g0" else
                g1_clk when i_clk3_counter = "g1" else
                g2_clk when i_clk3_counter = "g2" else
                g3_clk when i_clk3_counter = "g3" else
                '0';
    not_clk3_tmp <= not clk3_tmp;
    ena3_reg : dffp
                port map  ( D    => clkena(3),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk3_tmp,
                            Q    => ena3 );
                            
    clk(3)  <=  ena3 and clk3_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena3 and 'X';

    clk4_tmp <= l0_clk when i_clk4_counter = "l0" else
                l1_clk when i_clk4_counter = "l1" else
                g0_clk when i_clk4_counter = "g0" else
                g1_clk when i_clk4_counter = "g1" else
                g2_clk when i_clk4_counter = "g2" else
                g3_clk when i_clk4_counter = "g3" else
                '0';
    not_clk4_tmp <= not clk4_tmp;
    ena4_reg : dffp
                port map  ( D    => clkena(4),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk4_tmp,
                            Q    => ena4 );
                            
    clk(4)  <=  ena4 and clk4_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena4 and 'X';

    clk5_tmp <= l0_clk when i_clk5_counter = "l0" else
                l1_clk when i_clk5_counter = "l1" else
                g0_clk when i_clk5_counter = "g0" else
                g1_clk when i_clk5_counter = "g1" else
                g2_clk when i_clk5_counter = "g2" else
                g3_clk when i_clk5_counter = "g3" else
                '0';
    not_clk5_tmp <= not clk5_tmp;
    ena5_reg : dffp
                port map  ( D    => clkena(5),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_clk5_tmp,
                            Q    => ena5 );
                            
    clk(5)  <=  ena5 and clk5_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                ena5 and 'X';

    extclk0_tmp <=  e0_clk when i_extclk0_counter = "e0" else
                    e1_clk when i_extclk0_counter = "e1" else
                    e2_clk when i_extclk0_counter = "e2" else
                    e3_clk when i_extclk0_counter = "e3" else
                    g0_clk when i_extclk0_counter = "g0" else
                    '0';
    not_extclk0_tmp <= not extclk0_tmp;
    extena0_reg : dffp
                port map  ( D    => extclkena(0),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_extclk0_tmp,
                            Q    => extena0 );
                            
    extclk(0)  <=   extena0 and extclk0_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                    extena0 and 'X';

    extclk1_tmp <=  e0_clk when i_extclk1_counter = "e0" else
                    e1_clk when i_extclk1_counter = "e1" else
                    e2_clk when i_extclk1_counter = "e2" else
                    e3_clk when i_extclk1_counter = "e3" else
                    g0_clk when i_extclk1_counter = "g0" else
                    '0';
    not_extclk1_tmp <= not extclk1_tmp;
    extena1_reg : dffp
                port map  ( D    => extclkena(1),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_extclk1_tmp,
                            Q    => extena1 );
                            
    extclk(1)  <=   extena1 and extclk1_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                    extena1 and 'X';

    extclk2_tmp <=  e0_clk when i_extclk2_counter = "e0" else
                    e1_clk when i_extclk2_counter = "e1" else
                    e2_clk when i_extclk2_counter = "e2" else
                    e3_clk when i_extclk2_counter = "e3" else
                    g0_clk when i_extclk2_counter = "g0" else
                    '0';
    not_extclk2_tmp <= not extclk2_tmp;
    extena2_reg : dffp
                port map  ( D    => extclkena(2),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_extclk2_tmp,
                            Q    => extena2 );
                            
    extclk(2)  <=   extena2 and extclk2_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                    extena2 and 'X';

    extclk3_tmp <=  e0_clk when i_extclk3_counter = "e0" else
                    e1_clk when i_extclk3_counter = "e1" else
                    e2_clk when i_extclk3_counter = "e2" else
                    e3_clk when i_extclk3_counter = "e3" else
                    g0_clk when i_extclk3_counter = "g0" else
                    '0';
    not_extclk3_tmp <= not extclk3_tmp;
    extena3_reg : dffp
                port map  ( D    => extclkena(3),
                            CLRN => vcc,
                            PRN  => vcc,
                            ENA  => vcc,
                            CLK  => not_extclk3_tmp,
                            Q    => extena3 );
                            
    extclk(3)  <=   extena3 and extclk3_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                    extena3 and 'X';

    enable0 <=  enable0_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                'X';
    enable1 <=  enable1_tmp when (areset_ipd = '1' or ena_ipd = '0') or (about_to_lock and (not quiet_period_violation) and (not reconfig_err) and (not scanclr_violation) and (not scanclr_clk_violation)) else
                'X';

    scandataout <= scandataout_tmp;

end vital_pll;
-- END ARCHITECTURE VITAL_PLL

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : arm_m_cntr
--
-- Description : Simulation model for the M counter. M is the loop 
--               feedback counter of the StratixII PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY arm_m_cntr is
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer := 1;
            time_delay    : IN integer := 0
        );
END arm_m_cntr;

ARCHITECTURE behave of arm_m_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
                first_rising_edge := false;
                tmp_cout := clk;
            elsif (not first_rising_edge) then
                if (count < modulus) then
                    count := count + 1;
                else
                    count := 1;
                    tmp_cout := not tmp_cout;
                end if;
            end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : arm_n_cntr
--
-- Description : Simulation model for the N counter. N is the
--               input counter of the StratixII PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY arm_n_cntr is
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer := 1;
            time_delay    : IN integer := 0
        );
END arm_n_cntr;

ARCHITECTURE behave of arm_n_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    variable clk_last_valid_value : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = 'X') then
                ASSERT FALSE REPORT "Invalid transition to 'X' detected on PLL input clk. This edge will be ignored." severity warning;
            elsif (clk = '1' and first_rising_edge) then
                first_rising_edge := false;
                tmp_cout := clk;
            elsif (not first_rising_edge) then
                if (count < modulus) then
                    count := count + 1;
                else
                    count := 1;
                    tmp_cout := not tmp_cout;
                end if;
            end if;
        end if;
        if (clk /= 'X') then
            clk_last_valid_value := clk;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : arm_scale_cntr
--
-- Description : Simulation model for the output scale-down counters.
--               This is a common model for the C0, C1, C2, C3, C4 and C5
--               output counters of the StratixII PLL.
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY arm_scale_cntr is
    PORT(   clk            : IN std_logic;
            reset          : IN std_logic := '0';
            initial        : IN integer := 1;
            high           : IN integer := 1;
            low            : IN integer := 1;
            mode           : IN string := "bypass";
            ph_tap         : IN integer := 0;
            cout           : OUT std_logic
        );
END arm_scale_cntr;

ARCHITECTURE behave of arm_scale_cntr is
begin
    process (clk, reset)
    variable tmp_cout : std_logic := '0';
    variable count : integer := 1;
    variable output_shift_count : integer := 1;
    variable first_rising_edge : boolean := false;
    begin
        if (reset = '1') then
            count := 1;
            output_shift_count := 1;
            tmp_cout := '0';
            first_rising_edge := false;
        elsif (clk'event) then
            if (mode = "   off") then
                tmp_cout := '0';
            elsif (mode = "bypass") then
                tmp_cout := clk;
                first_rising_edge := true;
            elsif (not first_rising_edge) then
                if (clk = '1') then
                    if (output_shift_count = initial) then
                        tmp_cout := clk;
                        first_rising_edge := true;
                    else
                        output_shift_count := output_shift_count + 1;
                    end if;
                end if;
            elsif (output_shift_count < initial) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                end if;
            else
                count := count + 1;
                if (mode = "  even" and (count = (high*2) + 1)) then
                    tmp_cout := '0';
                elsif (mode = "   odd" and (count = high*2)) then
                    tmp_cout := '0';
                elsif (count = (high + low)*2 + 1) then
                    tmp_cout := '1';
                    count := 1;  -- reset count
                end if;
            end if;
        end if;
        cout <= transport tmp_cout;
    end process;

end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stratixii_pll
--
-- Description : Simulation model for the StratixII PLL.
--               In the functional mode, it is also the model for the altpll
--               megafunction.
--
-- Limitations : Does not support Spread Spectrum and Bandwidth.
--
-- Outputs     : Up to 6 output clocks, each defined by its own set of
--               parameters. Locked output (active high) indicates when the
--               PLL locks. clkbad, clkloss and activeclock are used for
--               clock switchover to indicate which input clock has gone
--               bad, when the clock switchover initiates and which input
--               clock is being used as the reference, respectively.
--               scandataout is the data output of the serial scan chain.
--
--///////////////////////////////////////////////////////////////////////////
LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE STD.TEXTIO.all;
USE work.MF_pllpack.all;
USE work.arm_m_cntr;
USE work.arm_n_cntr;
USE work.arm_scale_cntr;
USE work.dffp;
USE work.MF_pll_reg;

ENTITY MF_stratixii_pll is
    GENERIC (
        operation_mode              : string := "normal";
        pll_type                    : string := "auto";  -- EGPP/FAST/AUTO
        compensate_clock            : string := "clk0";
        feedback_source             : string := "clk0";
        qualify_conf_done           : string := "off";

        test_input_comp_delay       : integer := 0;
        test_feedback_comp_delay    : integer := 0;

        inclk0_input_frequency      : integer := 10000;
        inclk1_input_frequency      : integer := 10000;

        gate_lock_signal            : string := "no";
        gate_lock_counter           : integer := 1;
        self_reset_on_gated_loss_lock : string := "off";
        valid_lock_multiplier       : integer := 1;
        invalid_lock_multiplier     : integer := 5;
        sim_gate_lock_device_behavior : string := "off";

        switch_over_type            : string := "auto";
        switch_over_on_lossclk      : string := "off";
        switch_over_on_gated_lock   : string := "off";
        switch_over_counter         : integer := 1;
        enable_switch_over_counter  : string := "on";

        bandwidth                   : integer := 0;
        bandwidth_type              : string := "auto";
        down_spread                 : string := "0.0";
        spread_frequency            : integer := 0;

        clk0_output_frequency       : integer := 0;
        clk0_multiply_by            : integer := 1;
        clk0_divide_by              : integer := 1;
        clk0_phase_shift            : string := "0";
        clk0_duty_cycle             : integer := 50;

        clk1_output_frequency       : integer := 0;
        clk1_multiply_by            : integer := 1;
        clk1_divide_by              : integer := 1;
        clk1_phase_shift            : string := "0";
        clk1_duty_cycle             : integer := 50;

        clk2_output_frequency       : integer := 0;
        clk2_multiply_by            : integer := 1;
        clk2_divide_by              : integer := 1;
        clk2_phase_shift            : string := "0";
        clk2_duty_cycle             : integer := 50;

        clk3_output_frequency       : integer := 0;
        clk3_multiply_by            : integer := 1;
        clk3_divide_by              : integer := 1;
        clk3_phase_shift            : string := "0";
        clk3_duty_cycle             : integer := 50;

        clk4_output_frequency       : integer := 0;
        clk4_multiply_by            : integer := 1;
        clk4_divide_by              : integer := 1;
        clk4_phase_shift            : string := "0";
        clk4_duty_cycle             : integer := 50;

        clk5_output_frequency       : integer := 0;
        clk5_multiply_by            : integer := 1;
        clk5_divide_by              : integer := 1;
        clk5_phase_shift            : string := "0";
        clk5_duty_cycle             : integer := 50;

        pfd_min                     : integer := 0;
        pfd_max                     : integer := 0;
        vco_min                     : integer := 0;
        vco_max                     : integer := 0;
        vco_center                  : integer := 0;

        -- ADVANCED USER PARAMETERS
        m_initial                   : integer := 1;
        m                           : integer := 0;
        n                           : integer := 1;
        m2                          : integer := 1;
        n2                          : integer := 1;
        ss                          : integer := 0;

        c0_high                     : integer := 1;
        c0_low                      : integer := 1;
        c0_initial                  : integer := 1; 
        c0_mode                     : string := "bypass";
        c0_ph                       : integer := 0;

        c1_high                     : integer := 1;
        c1_low                      : integer := 1;
        c1_initial                  : integer := 1;
        c1_mode                     : string := "bypass";
        c1_ph                       : integer := 0;

        c2_high                     : integer := 1;
        c2_low                      : integer := 1;
        c2_initial                  : integer := 1;
        c2_mode                     : string := "bypass";
        c2_ph                       : integer := 0;

        c3_high                     : integer := 1;
        c3_low                      : integer := 1;
        c3_initial                  : integer := 1;
        c3_mode                     : string := "bypass";
        c3_ph                       : integer := 0;

        c4_high                     : integer := 1;
        c4_low                      : integer := 1;
        c4_initial                  : integer := 1;
        c4_mode                     : string := "bypass";
        c4_ph                       : integer := 0;
        
        c5_high                     : integer := 1;
        c5_low                      : integer := 1;
        c5_initial                  : integer := 1;
        c5_mode                     : string := "bypass";
        c5_ph                       : integer := 0;
        
        m_ph                        : integer := 0;
        
        clk0_counter                : string := "c0";
        clk1_counter                : string := "c1";
        clk2_counter                : string := "c2";
        clk3_counter                : string := "c3";
        clk4_counter                : string := "c4";
        clk5_counter                : string := "c5";
        
        c1_use_casc_in              : string := "off";
        c2_use_casc_in              : string := "off";
        c3_use_casc_in              : string := "off";
        c4_use_casc_in              : string := "off";
        c5_use_casc_in              : string := "off";
        
        m_test_source               : integer := 5;
        c0_test_source              : integer := 5;
        c1_test_source              : integer := 5;
        c2_test_source              : integer := 5;
        c3_test_source              : integer := 5;
        c4_test_source              : integer := 5;
        c5_test_source              : integer := 5;
        
        -- LVDS mode parameters
        enable0_counter             : string := "c0";
        enable1_counter             : string := "c1";
        sclkout0_phase_shift        : string := "0";
        sclkout1_phase_shift        : string := "0";
        
        charge_pump_current         : integer := 52;
        loop_filter_r               : string := " 1.000000";
        loop_filter_c               : integer := 16;
        common_rx_tx                : string := "off";
        use_vco_bypass              : string := "false";
        use_dc_coupling             : string := "false";
        
        pll_compensation_delay      : integer := 0;
        simulation_type             : string := "functional";

        -- Simulation only generics
        family_name                 : string  := "StratixII";
        
        clk0_use_even_counter_mode  : string := "off";
        clk1_use_even_counter_mode  : string := "off";
        clk2_use_even_counter_mode  : string := "off";
        clk3_use_even_counter_mode  : string := "off";
        clk4_use_even_counter_mode  : string := "off";
        clk5_use_even_counter_mode  : string := "off";
        
        clk0_use_even_counter_value : string := "off";
        clk1_use_even_counter_value : string := "off";
        clk2_use_even_counter_value : string := "off";
        clk3_use_even_counter_value : string := "off";
        clk4_use_even_counter_value : string := "off";
        clk5_use_even_counter_value : string := "off";
        
        vco_multiply_by             : integer := 0;
        vco_divide_by               : integer := 0;
        scan_chain_mif_file         : string := "";
        vco_post_scale              : integer := 1

    );

    PORT
    (
        inclk                       : in std_logic_vector(1 downto 0);
        fbin                        : in std_logic := '0';
        ena                         : in std_logic := '1';
        clkswitch                   : in std_logic := '0';
        areset                      : in std_logic := '0';
        pfdena                      : in std_logic := '1';
        scanread                    : in std_logic := '0';
        scanwrite                   : in std_logic := '0';
        scandata                    : in std_logic := '0';
        scanclk                     : in std_logic := '0';
        testin                      : in std_logic_vector(3 downto 0) := "0000";
        clk                         : out std_logic_vector(5 downto 0);
        clkbad                      : out std_logic_vector(1 downto 0);
        activeclock                 : out std_logic;
        locked                      : out std_logic;
        clkloss                     : out std_logic;
        scandataout                 : out std_logic;
        scandone                    : out std_logic;
        testupout                   : out std_logic;
        testdownout                 : out std_logic;
        -- lvds specific ports
        enable0                     : out std_logic;
        enable1                     : out std_logic;
        sclkout                     : out std_logic_vector(1 downto 0)
    );
END MF_stratixii_pll;

ARCHITECTURE vital_pll of MF_stratixii_pll is

TYPE int_array is ARRAY(NATURAL RANGE <>) of integer;
TYPE str_array is ARRAY(NATURAL RANGE <>) of string(1 to 6);
TYPE str_array1 is ARRAY(NATURAL RANGE <>) of string(1 to 9);
TYPE std_logic_array is ARRAY(NATURAL RANGE <>) of std_logic;

-- internal advanced parameter signals
signal   i_vco_min      : integer;
signal   i_vco_max      : integer;
signal   i_vco_center   : integer;
signal   i_pfd_min      : integer;
signal   i_pfd_max      : integer;
signal   c_ph_val       : int_array(0 to 5) := (OTHERS => 0);
signal   c_high_val     : int_array(0 to 5) := (OTHERS => 1);
signal   c_low_val      : int_array(0 to 5) := (OTHERS => 1);
signal   c_initial_val  : int_array(0 to 5) := (OTHERS => 1);
signal   c_mode_val     : str_array(0 to 5);

-- old values
signal   c_high_val_old : int_array(0 to 5) := (OTHERS => 1);
signal   c_low_val_old  : int_array(0 to 5) := (OTHERS => 1);
signal   c_ph_val_old   : int_array(0 to 5) := (OTHERS => 0);
signal   c_mode_val_old : str_array(0 to 5);

-- hold registers
signal   c_high_val_hold : int_array(0 to 5) := (OTHERS => 1);
signal   c_low_val_hold  : int_array(0 to 5) := (OTHERS => 1);
signal   c_ph_val_hold   : int_array(0 to 5) := (OTHERS => 0);
signal   c_mode_val_hold : str_array(0 to 5);

-- temp registers
signal   sig_c_ph_val_tmp   : int_array(0 to 5) := (OTHERS => 0);
signal   sig_c_low_val_tmp  : int_array(0 to 5) := (OTHERS => 1);
signal   sig_c_hi_val_tmp  : int_array(0 to 5) := (OTHERS => 1);
signal   c_ph_val_orig  : int_array(0 to 5) := (OTHERS => 0);

--signal   i_clk5_counter         : string(1 to 2) := "c5";
--signal   i_clk4_counter         : string(1 to 2) := "c4";
--signal   i_clk3_counter         : string(1 to 2) := "c3";
--signal   i_clk2_counter         : string(1 to 2) := "c2";
--signal   i_clk1_counter         : string(1 to 2) := "c1";
--signal   i_clk0_counter         : string(1 to 2) := "c0";

signal   i_clk5_counter         : integer := 5;
signal   i_clk4_counter         : integer := 4;
signal   i_clk3_counter         : integer := 3;
signal   i_clk2_counter         : integer := 2;
signal   i_clk1_counter         : integer := 1;
signal   i_clk0_counter         : integer := 0;
signal   i_charge_pump_current  : integer;
signal   i_loop_filter_r        : integer;

-- end internal advanced parameter signals

-- CONSTANTS
CONSTANT GPP_SCAN_CHAIN : integer := 174;
CONSTANT FAST_SCAN_CHAIN : integer := 75;
CONSTANT GATE_LOCK_CYCLES : integer := 7;

CONSTANT cntrs : str_array(5 downto 0) := ("    C5", "    C4", "    C3", "    C2", "    C1", "    C0");
CONSTANT ss_cntrs : str_array(0 to 3) := ("     M", "    M2", "     N", "    N2");

CONSTANT loop_filter_c_arr : int_array(0 to 3) := (57, 16, 36, 5);
CONSTANT fpll_loop_filter_c_arr : int_array(0 to 3) := (18, 13, 8, 2);
CONSTANT charge_pump_curr_arr : int_array(0 to 15) := (6, 12, 30, 36, 52, 57, 72, 77, 92, 96, 110, 114, 127, 131, 144, 148);
CONSTANT loop_filter_r_arr : str_array1(0 to 39) := (" 1.000000", " 1.500000", " 2.000000", " 2.500000", " 3.000000", " 3.500000", " 4.000000", " 4.500000", " 5.000000", " 5.500000", " 6.000000", " 6.500000", " 7.000000", " 7.500000", " 8.000000", " 8.500000", " 9.000000", " 9.500000", "10.000000", "10.500000", "11.000000", "11.500000", "12.000000", "12.500000", "13.000000", "13.500000", "14.000000", "14.500000", "15.000000", "15.500000", "16.000000", "16.500000", "17.000000", "17.500000", "18.000000", "18.500000", "19.000000", "19.500000", "20.000000", "20.500000");

-- signals

signal vcc : std_logic := '1';

signal fbclk       : std_logic;
signal refclk      : std_logic;

signal c_clk : std_logic_array(0 to 5);
signal vco_out : std_logic_vector(7 downto 0) := (OTHERS => '0');
signal vco_tap : std_logic_vector(7 downto 0) := (OTHERS => '0');
signal vco_out_last_value : std_logic_vector(7 downto 0);
signal vco_tap_last_value : std_logic_vector(7 downto 0);

-- signals to assign values to counter params
signal m_val : int_array(0 to 1) := (OTHERS => 1);
signal n_val : int_array(0 to 1) := (OTHERS => 1);
signal m_ph_val : integer := 0;
signal m_initial_val : integer := m_initial;

signal m_mode_val : str_array(0 to 1) := (OTHERS => "      ");
signal n_mode_val : str_array(0 to 1) := (OTHERS => "      ");
signal lfc_val : integer := 0;
signal cp_curr_val : integer := 0;
signal lfr_val : string(1 to 9) := "         ";

-- old values
signal m_val_old : int_array(0 to 1) := (OTHERS => 1);
signal n_val_old : int_array(0 to 1) := (OTHERS => 1);
signal m_mode_val_old : str_array(0 to 1) := (OTHERS => "      ");
signal n_mode_val_old : str_array(0 to 1) := (OTHERS => "      ");
signal m_ph_val_old : integer := 0;
signal lfc_old : integer := 0;
signal cp_curr_old : integer := 0;
signal lfr_old : string(1 to 9) := "         ";
signal num_output_cntrs : integer := 6;

signal scan_data : std_logic_vector(173 downto 0) := (OTHERS => '0');

signal clk0_tmp : std_logic;
signal clk1_tmp : std_logic;
signal clk2_tmp : std_logic;
signal clk3_tmp : std_logic;
signal clk4_tmp : std_logic;
signal clk5_tmp : std_logic;
signal sclkout0_tmp : std_logic;
signal sclkout1_tmp : std_logic;

signal clkin : std_logic := '0';
signal gate_locked : std_logic := '0';
signal lock : std_logic := '0';
signal about_to_lock : boolean := false;
signal reconfig_err : boolean := false;

signal inclk_c0 : std_logic;
signal inclk_c1 : std_logic;
signal inclk_c2 : std_logic;
signal inclk_c3 : std_logic;
signal inclk_c4 : std_logic;
signal inclk_c5 : std_logic;
signal inclk_m : std_logic;
signal devpor : std_logic;
signal devclrn : std_logic;

signal inclk0_ipd : std_logic;
signal inclk1_ipd : std_logic;
signal ena_ipd : std_logic;
signal pfdena_ipd : std_logic;
signal areset_ipd : std_logic;
signal fbin_ipd : std_logic;
signal scanclk_ipd : std_logic;
signal scanread_ipd : std_logic;
signal scanwrite_ipd : std_logic;
signal scandata_ipd : std_logic;
signal clkswitch_ipd : std_logic;
-- registered signals
signal scanread_reg : std_logic := '0';
signal scanwrite_reg : std_logic := '0';
signal scanwrite_enabled : std_logic := '0';
signal gated_scanclk : std_logic := '1';

signal inclk_c0_dly1 : std_logic := '0';
signal inclk_c0_dly2 : std_logic := '0';
signal inclk_c0_dly3 : std_logic := '0';
signal inclk_c0_dly4 : std_logic := '0';
signal inclk_c0_dly5 : std_logic := '0';
signal inclk_c0_dly6 : std_logic := '0';
signal inclk_c1_dly1 : std_logic := '0';
signal inclk_c1_dly2 : std_logic := '0';
signal inclk_c1_dly3 : std_logic := '0';
signal inclk_c1_dly4 : std_logic := '0';
signal inclk_c1_dly5 : std_logic := '0';
signal inclk_c1_dly6 : std_logic := '0';


signal sig_offset : time := 0 ps;
signal sig_refclk_time : time := 0 ps;
signal sig_fbclk_period : time := 0 ps;
signal sig_vco_period_was_phase_adjusted : boolean := false;
signal sig_phase_adjust_was_scheduled : boolean := false;
signal sig_stop_vco : std_logic := '0';
signal sig_m_times_vco_period : time := 0 ps;
signal sig_new_m_times_vco_period : time := 0 ps;
signal sig_got_refclk_posedge : boolean := false;
signal sig_got_fbclk_posedge : boolean := false;
signal sig_got_second_refclk : boolean := false;

signal m_delay : integer := 0;
signal n_delay : integer := 0;

signal inclk1_tmp : std_logic := '0';

signal ext_fbk_cntr_high : integer := 0;
signal ext_fbk_cntr_low : integer := 0;
signal ext_fbk_cntr_ph : integer := 0;
signal ext_fbk_cntr_initial : integer := 1;
signal ext_fbk_cntr     : string(1 to 2) := "c0";
signal ext_fbk_cntr_mode : string(1 to 6) := "bypass";
signal ext_fbk_cntr_index : integer := 0;

signal enable0_tmp : std_logic := '0';
signal enable1_tmp : std_logic := '0';
signal reset_low : std_logic := '0';

signal scandataout_tmp : std_logic := '0';
signal scandone_tmp : std_logic := '0';

signal sig_refclk_period : time := (inclk0_input_frequency * 1 ps) * n;

signal schedule_vco : std_logic := '0';

signal areset_ena_sig : std_logic := '0';
signal pll_in_test_mode : boolean := false;

signal inclk_c_from_vco : std_logic_array(0 to 5);

signal inclk_m_from_vco : std_logic;
signal inclk_sclkout0_from_vco : std_logic;
signal inclk_sclkout1_from_vco : std_logic;

--signal tap0_is_active : boolean := true;
    signal sig_quiet_time : time := 0 ps;
    signal sig_slowest_clk_old : time := 0 ps;
    signal sig_slowest_clk_new : time := 0 ps;
    signal sig_m_val_tmp : int_array(0 to 1) := (OTHERS => 1);

COMPONENT arm_m_cntr
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic;
        initial_value : IN integer := 1;
        modulus       : IN integer := 1;
        time_delay    : IN integer := 0
    );
END COMPONENT;

COMPONENT arm_n_cntr
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic;
        initial_value : IN integer := 1;
        modulus       : IN integer := 1;
        time_delay    : IN integer := 0
    );
END COMPONENT;

COMPONENT arm_scale_cntr
    PORT (
        clk            : IN std_logic;
        reset          : IN std_logic := '0';
        cout           : OUT std_logic;
        initial        : IN integer := 1;
        high           : IN integer := 1;
        low            : IN integer := 1;
        mode           : IN string := "bypass";
        ph_tap         : IN integer := 0
    );
END COMPONENT;

COMPONENT dffp

    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

COMPONENT MF_pll_reg
    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        inclk0_ipd <= inclk(0);
        inclk1_ipd <= inclk(1);
        areset_ipd <= areset;
        ena_ipd <= ena;
        fbin_ipd <= fbin;
        pfdena_ipd <= pfdena;
        scanclk_ipd <= scanclk;
        scanread_ipd <= scanread;
        scandata_ipd <= scandata;
        scanwrite_ipd <= scanwrite;
        clkswitch_ipd <= clkswitch;
    end block;

    inclk_m <=  clkin when m_test_source = 0 else
                clk0_tmp when operation_mode = "external_feedback" and feedback_source = "clk0" else
                clk1_tmp when operation_mode = "external_feedback" and feedback_source = "clk1" else
                clk2_tmp when operation_mode = "external_feedback" and feedback_source = "clk2" else
                clk3_tmp when operation_mode = "external_feedback" and feedback_source = "clk3" else
                clk4_tmp when operation_mode = "external_feedback" and feedback_source = "clk4" else
                clk5_tmp when operation_mode = "external_feedback" and feedback_source = "clk5" else
                inclk_m_from_vco;


    ext_fbk_cntr_high <= c_high_val(ext_fbk_cntr_index);
    ext_fbk_cntr_low  <= c_low_val(ext_fbk_cntr_index);
    ext_fbk_cntr_ph   <= c_ph_val(ext_fbk_cntr_index);
    ext_fbk_cntr_initial <= c_initial_val(ext_fbk_cntr_index);
    ext_fbk_cntr_mode <= c_mode_val(ext_fbk_cntr_index);

    areset_ena_sig <= areset_ipd or (not ena_ipd) or sig_stop_vco;

    pll_in_test_mode <= true when   m_test_source /= 5 or c0_test_source /= 5 or
                                    c1_test_source /= 5 or c2_test_source /= 5 or
                                    c3_test_source /= 5 or c4_test_source /= 5 or
                                    c5_test_source /= 5 else
                        false;
   
   
    m1 : arm_m_cntr
        port map (  clk           => inclk_m,
                    reset         => areset_ena_sig,
                    cout          => fbclk,
                    initial_value => m_initial_val,
                    modulus       => m_val(0),
                    time_delay    => m_delay
                );

    -- add delta delay to inclk1 to ensure inclk0 and inclk1 are processed
    -- in different simulation deltas.
    inclk1_tmp <= inclk1_ipd;

    process (inclk0_ipd, inclk1_tmp, clkswitch_ipd)
    variable input_value : std_logic := '0';
    variable current_clock : integer := 0;
    variable clk0_count, clk1_count : integer := 0;
    variable clk0_is_bad, clk1_is_bad : std_logic := '0';
    variable primary_clk_is_bad : boolean := false;
    variable current_clk_is_bad : boolean := false;
    variable got_curr_clk_falling_edge_after_clkswitch : boolean := false;
    variable switch_over_count : integer := 0;
    variable active_clock : std_logic := '0';
    variable external_switch : boolean := false;
    begin
        if (now = 0 ps) then
            if (switch_over_type = "manual" and clkswitch_ipd = '1') then
                current_clock := 1;
                active_clock := '1';
            end if;
        end if;
        if (clkswitch_ipd'event and clkswitch_ipd = '1' and switch_over_type = "auto") then
            external_switch := true;
        elsif (switch_over_type = "manual") then
            if (clkswitch_ipd'event and clkswitch_ipd = '1') then
                current_clock := 1;
                active_clock := '1';
                clkin <= transport inclk1_tmp;
            elsif (clkswitch_ipd'event and clkswitch_ipd = '0') then
                current_clock := 0;
                active_clock := '0';
                clkin <= transport inclk0_ipd;
            end if;
        end if;
        -- save the current inclk event value
        if (inclk0_ipd'event) then
            input_value := inclk0_ipd;
        elsif (inclk1_tmp'event) then
            input_value := inclk1_tmp;
        end if;

        -- check if either input clk is bad
        if (inclk0_ipd'event and inclk0_ipd = '1') then
            clk0_count := clk0_count + 1;
            clk0_is_bad := '0';
            clk1_count := 0;
            if (clk0_count > 2) then
                -- no event on other clk for 2 cycles
                clk1_is_bad := '1';
                if (current_clock = 1) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;
        if (inclk1_tmp'event and inclk1_tmp = '1') then
            clk1_count := clk1_count + 1;
            clk1_is_bad := '0';
            clk0_count := 0;
            if (clk1_count > 2) then
                -- no event on other clk for 2 cycles
                clk0_is_bad := '1';
                if (current_clock = 0) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;

        -- check if the bad clk is the primary clock
        if (clk0_is_bad = '1') then
            primary_clk_is_bad := true;
        else
            primary_clk_is_bad := false;
        end if;

        -- actual switching
        if (inclk0_ipd'event and current_clock = 0) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk0_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk0_ipd;
                end if;
            else
                clkin <= transport inclk0_ipd;
            end if;
        elsif (inclk1_tmp'event and current_clock = 1) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk1_tmp = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk1_tmp;
                end if;
            else
                clkin <= transport inclk1_tmp;
            end if;
        else
            if (input_value = '1' and switch_over_on_lossclk = "on"  and enable_switch_over_counter = "on" and primary_clk_is_bad) then
                switch_over_count := switch_over_count + 1;
            end if;
            if (input_value = '0') then
                if (external_switch and (got_curr_clk_falling_edge_after_clkswitch or current_clk_is_bad)) or (switch_over_on_lossclk = "on" and primary_clk_is_bad and clkswitch_ipd /= '1' and (enable_switch_over_counter = "off" or switch_over_count = switch_over_counter)) then
                    got_curr_clk_falling_edge_after_clkswitch := false;
                    if (current_clock = 0) then
                        current_clock := 1;
                    else
                        current_clock := 0;
                    end if;
                    active_clock := not active_clock;
                    switch_over_count := 0;
                    external_switch := false;
                    current_clk_is_bad := false;
                end if;
       
            end if;
        end if;

        -- schedule outputs
        clkbad(0) <= clk0_is_bad;
        clkbad(1) <= clk1_is_bad;
        if (switch_over_on_lossclk = "on" and clkswitch_ipd /= '1') then
            if (primary_clk_is_bad) then
                -- assert clkloss
                clkloss <= '1';
            else
                clkloss <= '0';
            end if;
        else
            clkloss <= clkswitch_ipd;
        end if;
        activeclock <= active_clock;

    end process;

    process (inclk_sclkout0_from_vco)
    begin
        sclkout0_tmp <= inclk_sclkout0_from_vco;
    end process;

    process (inclk_sclkout1_from_vco)
    begin
        sclkout1_tmp <= inclk_sclkout1_from_vco;
    end process;

    n1 : arm_n_cntr
        port map (
                clk           => clkin,
                reset         => areset_ipd,
                cout          => refclk,
                initial_value => n_val(0),
                modulus       => n_val(0));


    inclk_c0 <= clkin when c0_test_source = 0 else
                refclk when c0_test_source = 1 else
                inclk_c_from_vco(0);
    c0 : arm_scale_cntr
        port map (
                clk            => inclk_c0,
                reset          => areset_ena_sig,
                cout           => c_clk(0),
                initial        => c_initial_val(0),
                high           => c_high_val(0),
                low            => c_low_val(0),
                mode           => c_mode_val(0),
                ph_tap         => c_ph_val(0));

                
    inclk_c1 <= clkin when c1_test_source = 0 else
                fbclk when c1_test_source = 2 else
                c_clk(0) when c1_use_casc_in = "on" else
                inclk_c_from_vco(1);
    c1 : arm_scale_cntr
        port map (
                clk            => inclk_c1,
                reset          => areset_ena_sig,
                cout           => c_clk(1),
                initial        => c_initial_val(1),
                high           => c_high_val(1),
                low            => c_low_val(1),
                mode           => c_mode_val(1),
                ph_tap         => c_ph_val(1));


    inclk_c2 <= clkin when c2_test_source = 0 else
                c_clk(1) when c2_use_casc_in = "on" else
                inclk_c_from_vco(2);
    c2 : arm_scale_cntr
        port map (
                clk            => inclk_c2,
                reset          => areset_ena_sig,
                cout           => c_clk(2),
                initial        => c_initial_val(2),
                high           => c_high_val(2),
                low            => c_low_val(2),
                mode           => c_mode_val(2),
                ph_tap         => c_ph_val(2));


    inclk_c3 <= clkin when c3_test_source = 0 else
                c_clk(2) when c3_use_casc_in = "on" else
                inclk_c_from_vco(3);
    c3 : arm_scale_cntr
        port map (
                clk            => inclk_c3,
                reset          => areset_ena_sig,
                cout           => c_clk(3),
                initial        => c_initial_val(3),
                high           => c_high_val(3),
                low            => c_low_val(3),
                mode           => c_mode_val(3),
                ph_tap         => c_ph_val(3));

    inclk_c4 <= '0' when (pll_type = "fast") else
                clkin when (c4_test_source = 0) else
                c_clk(3) when (c4_use_casc_in = "on") else
                inclk_c_from_vco(4);
    c4 : arm_scale_cntr
        port map (
                clk            => inclk_c4,
                reset          => areset_ena_sig,
                cout           => c_clk(4),
                initial        => c_initial_val(4),
                high           => c_high_val(4),
                low            => c_low_val(4),
                mode           => c_mode_val(4),
                ph_tap         => c_ph_val(4));

    inclk_c5 <= '0' when (pll_type = "fast") else
                clkin when c5_test_source = 0 else
                c_clk(4) when c5_use_casc_in = "on" else
                inclk_c_from_vco(5);
    c5 : arm_scale_cntr
        port map (
                clk            => inclk_c5,
                reset          => areset_ena_sig,
                cout           => c_clk(5),
                initial        => c_initial_val(5),
                high           => c_high_val(5),
                low            => c_low_val(5),
                mode           => c_mode_val(5),
                ph_tap         => c_ph_val(5));

    inclk_c0_dly1 <= inclk_c0 when (pll_type = "fast" or pll_type = "lvds")
                    else '0';
    inclk_c0_dly2 <= inclk_c0_dly1;
    inclk_c0_dly3 <= inclk_c0_dly2;
    inclk_c0_dly4 <= inclk_c0_dly3;
    inclk_c0_dly5 <= inclk_c0_dly4;
    inclk_c0_dly6 <= inclk_c0_dly5;

    inclk_c1_dly1 <= inclk_c1 when (pll_type = "fast" or pll_type = "lvds")
                    else '0';
    inclk_c1_dly2 <= inclk_c1_dly1;
    inclk_c1_dly3 <= inclk_c1_dly2;
    inclk_c1_dly4 <= inclk_c1_dly3;
    inclk_c1_dly5 <= inclk_c1_dly4;
    inclk_c1_dly6 <= inclk_c1_dly5;

    process(inclk_c0_dly6, inclk_c1_dly6, areset_ipd, ena_ipd, sig_stop_vco)
    variable c0_got_first_rising_edge : boolean := false;
    variable c0_count : integer := 2;
    variable c0_initial_count : integer := 1;
    variable c0_tmp, c1_tmp : std_logic := '0';
    variable c1_got_first_rising_edge : boolean := false;
    variable c1_count : integer := 2;
    variable c1_initial_count : integer := 1;
    begin
        if (areset_ipd = '1' or ena_ipd = '0' or sig_stop_vco = '1') then
            c0_count := 2;
            c1_count := 2;
            c0_initial_count := 1;
            c1_initial_count := 1;
            c0_got_first_rising_edge := false;
            c1_got_first_rising_edge := false;
        else
            if (not c0_got_first_rising_edge) then
                if (inclk_c0_dly6'event and inclk_c0_dly6 = '1') then
                    if (c0_initial_count = c_initial_val(0)) then
                        c0_got_first_rising_edge := true;
                    else
                        c0_initial_count := c0_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c0_dly6'event) then
                c0_count := c0_count + 1;
                if (c0_count = (c_high_val(0) + c_low_val(0)) * 2) then
                    c0_count := 1;
                end if;
            end if;
            if (inclk_c0_dly6'event and inclk_c0_dly6 = '0') then
                if (c0_count = 1) then
                    c0_tmp := '1';
                    c0_got_first_rising_edge := false;
                else
                    c0_tmp := '0';
                end if;
            end if;

            if (not c1_got_first_rising_edge) then
                if (inclk_c1_dly6'event and inclk_c1_dly6 = '1') then
                    if (c1_initial_count = c_initial_val(1)) then
                        c1_got_first_rising_edge := true;
                    else
                        c1_initial_count := c1_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c1_dly6'event) then
                c1_count := c1_count + 1;
                if (c1_count = (c_high_val(1) + c_low_val(1)) * 2) then
                    c1_count := 1;
                end if;
            end if;
            if (inclk_c1_dly6'event and inclk_c1_dly6 = '0') then
                if (c1_count = 1) then
                    c1_tmp := '1';
                    c1_got_first_rising_edge := false;
                else
                    c1_tmp := '0';
                end if;
            end if;
        end if;

        if (enable0_counter = "c0") then
            enable0_tmp <= c0_tmp;
        elsif (enable0_counter = "c1") then
            enable0_tmp <= c1_tmp;
        else
            enable0_tmp <= '0';
        end if;

        if (enable1_counter = "c0") then
            enable1_tmp <= c0_tmp;
        elsif (enable1_counter = "c1") then
            enable1_tmp <= c1_tmp;
        else
            enable1_tmp <= '0';
        end if;

    end process;

    glocked_cntr : process(clkin, ena_ipd, areset_ipd)
    variable count : integer := 0;
    variable output : std_logic := '0';
    begin
        if (areset_ipd = '1') then
            count := 0;
            output := '0';
        elsif (clkin'event and clkin = '1') then
            if (ena_ipd = '1') then
                count := count + 1;
                if (sim_gate_lock_device_behavior = "on") then
                    if (count = gate_lock_counter) then
                        output := '1';
                    end if;
                elsif (count = GATE_LOCK_CYCLES) then
                    output := '1';
                end if;
            end if;
        end if;
        gate_locked <= output;
    end process;

    locked <=   gate_locked and lock when gate_lock_signal = "yes" else
                lock;


    process (scandone_tmp)
    variable buf : line;
    begin
        if (scandone_tmp'event and scandone_tmp = '1') then
            if (reconfig_err = false) then
                ASSERT false REPORT family_name & " PLL Reprogramming completed with the following values (Values in parantheses indicate values before reprogramming) :" severity note;
                write (buf, string'("    N modulus = "));
                write (buf, n_val(0));
                write (buf, string'(" ( "));
                write (buf, n_val_old(0));
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M modulus = "));
                write (buf, m_val(0));
                write (buf, string'(" ( "));
                write (buf, m_val_old(0));
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M ph_tap = "));
                write (buf, m_ph_val);
                write (buf, string'(" ( "));
                write (buf, m_ph_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                if (ss > 0) then
                    write (buf, string'("    M2 modulus = "));
                    write (buf, m_val(1));
                    write (buf, string'(" ( "));
                    write (buf, m_val_old(1));
                    write (buf, string'(" )"));
                    writeline (output, buf);

                    write (buf, string'("    N2 modulus = "));
                    write (buf, n_val(1));
                    write (buf, string'(" ( "));
                    write (buf, n_val_old(1));
                    write (buf, string'(" )"));
                    writeline (output, buf);
                end if;

                for i in 0 to (num_output_cntrs-1) loop
                    write (buf, cntrs(i));
                    write (buf, string'(" :   high = "));
                    write (buf, c_high_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_high_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   low = "));
                    write (buf, sig_c_low_val_tmp(i));
                    write (buf, string'(" ("));
                    write (buf, c_low_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   mode = "));
                    write (buf, c_mode_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_mode_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   phase tap = "));
                    write (buf, c_ph_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_ph_val_old(i));
                    write (buf, string'(") "));
                    writeline(output, buf);
                end loop;

                write (buf, string'("    Charge Pump Current (uA) = "));
                write (buf, cp_curr_val);
                write (buf, string'(" ( "));
                write (buf, cp_curr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (pF) = "));
                write (buf, lfc_val);
                write (buf, string'(" ( "));
                write (buf, lfc_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (Kohm) = "));
                write (buf, lfr_val);
                write (buf, string'(" ( "));
                write (buf, lfr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

            else ASSERT false REPORT "Errors were encountered during PLL reprogramming. Please refer to error/warning messages above." severity warning;
            end if;
        end if;
    end process;

    process (scanwrite_enabled, c_clk(0), c_clk(1), c_clk(2), c_clk(3), c_clk(4), c_clk(5), vco_tap, fbclk, scanclk_ipd, gated_scanclk)
    variable init : boolean := true;
    variable low, high : std_logic_vector(7 downto 0);
    variable low_fast, high_fast : std_logic_vector(3 downto 0);
    variable mode : string(1 to 6) := "bypass";
    variable is_error : boolean := false;
    variable m_tmp, n_tmp : std_logic_vector(8 downto 0);
    variable n_fast : std_logic_vector(1 downto 0);
    variable c_high_val_tmp : int_array(0 to 5) := (OTHERS => 1);
    variable c_low_val_tmp  : int_array(0 to 5) := (OTHERS => 1);
    variable c_ph_val_tmp   : int_array(0 to 5) := (OTHERS => 0);
    variable c_mode_val_tmp : str_array(0 to 5);
    variable m_ph_val_tmp   : integer := 0;
    variable m_val_tmp      : int_array(0 to 1) := (OTHERS => 1);
    variable c0_rising_edge_transfer_done : boolean := false;
    variable c1_rising_edge_transfer_done : boolean := false;
    variable c2_rising_edge_transfer_done : boolean := false;
    variable c3_rising_edge_transfer_done : boolean := false;
    variable c4_rising_edge_transfer_done : boolean := false;
    variable c5_rising_edge_transfer_done : boolean := false;

    -- variables for scaling of multiply_by and divide_by values
    variable i_clk0_mult_by    : integer := 1;
    variable i_clk0_div_by     : integer := 1;
    variable i_clk1_mult_by    : integer := 1;
    variable i_clk1_div_by     : integer := 1;
    variable i_clk2_mult_by    : integer := 1;
    variable i_clk2_div_by     : integer := 1;
    variable i_clk3_mult_by    : integer := 1;
    variable i_clk3_div_by     : integer := 1;
    variable i_clk4_mult_by    : integer := 1;
    variable i_clk4_div_by     : integer := 1;
    variable i_clk5_mult_by    : integer := 1;
    variable i_clk5_div_by     : integer := 1;
    variable max_d_value       : integer := 1;
    variable new_multiplier    : integer := 1;
    
    -- internal variables for storing the phase shift number.(used in lvds mode only)
    variable i_clk0_phase_shift : integer := 1;
    variable i_clk1_phase_shift : integer := 1;
    variable i_clk2_phase_shift : integer := 1;

    -- user to advanced variables

    variable   max_neg_abs    : integer := 0;
    variable   i_m_initial    : integer;
    variable   i_m            : integer := 1;
    variable   i_n            : integer := 1;
    variable   i_m2           : integer;
    variable   i_n2           : integer;
    variable   i_ss           : integer;
    variable   i_c_high       : int_array(0 to 5);
    variable   i_c_low        : int_array(0 to 5);
    variable   i_c_initial    : int_array(0 to 5);
    variable   i_c_ph         : int_array(0 to 5);
    variable   i_c_mode       : str_array(0 to 5);
    variable   i_m_ph         : integer;
    variable   output_count   : integer;
    variable   new_divisor    : integer;

    variable clk0_cntr : string(1 to 2) := "c0";
    variable clk1_cntr : string(1 to 2) := "c1";
    variable clk2_cntr : string(1 to 2) := "c2";
    variable clk3_cntr : string(1 to 2) := "c3";
    variable clk4_cntr : string(1 to 2) := "c4";
    variable clk5_cntr : string(1 to 2) := "c5";

    variable fbk_cntr : string(1 to 2);
    variable fbk_cntr_index : integer;
    variable start_bit : integer;
    variable quiet_time : time := 0 ps;
    variable slowest_clk_old : time := 0 ps;
    variable slowest_clk_new : time := 0 ps;
    variable tmp_scan_data : std_logic_vector(173 downto 0) := (OTHERS => '0');
    variable m_lo, m_hi : std_logic_vector(4 downto 0);

    variable j : integer := 0;
    variable scanread_active_edge : time := 0 ps;
    variable got_first_scanclk : boolean := false;
    variable got_first_gated_scanclk : boolean := false;
    variable scanclk_last_rising_edge : time := 0 ps;
    variable scanclk_period : time := 0 ps;
    variable current_scan_data : std_logic_vector(173 downto 0) := (OTHERS => '0');
    variable index : integer := 0;
    variable scan_chain_length : integer := GPP_SCAN_CHAIN;
    variable tmp_rem : integer := 0;
    variable scanclk_cycles : integer := 0;
    variable lfc_tmp : std_logic_vector(1 downto 0);
    variable lfr_tmp : std_logic_vector(5 downto 0);
    variable lfr_int : integer := 0;

    function slowest_clk (
            C0 : integer; C0_mode : string(1 to 6);
            C1 : integer; C1_mode : string(1 to 6);
            C2 : integer; C2_mode : string(1 to 6);
            C3 : integer; C3_mode : string(1 to 6);
            C4 : integer; C4_mode : string(1 to 6);
            C5 : integer; C5_mode : string(1 to 6);
            refclk : time; m_mod : integer) return time is
    variable max_modulus : integer := 1;
    variable q_period : time := 0 ps;
    variable refclk_int : integer := 0;
    begin
        if (C0_mode /= "bypass" and C0_mode /= "   off") then
            max_modulus := C0;
        end if;
        if (C1 > max_modulus and C1_mode /= "bypass" and C1_mode /= "   off") then
            max_modulus := C1;
        end if;
        if (C2 > max_modulus and C2_mode /= "bypass" and C2_mode /= "   off") then
            max_modulus := C2;
        end if;
        if (C3 > max_modulus and C3_mode /= "bypass" and C3_mode /= "   off") then
            max_modulus := C3;
        end if;
        if (C4 > max_modulus and C4_mode /= "bypass" and C4_mode /= "   off") then
            max_modulus := C4;
        end if;
        if (C5 > max_modulus and C5_mode /= "bypass" and C5_mode /= "   off") then
            max_modulus := C5;
        end if;

        refclk_int := refclk / 1 ps;
        if (m_mod /= 0) then
            if (refclk_int > (refclk_int * max_modulus / m_mod)) then
                q_period := refclk_int * 1 ps;
            else
                q_period := (refclk_int * max_modulus / m_mod) * 1 ps;
            end if;
        end if;
        return (2*q_period);
    end slowest_clk;

    function int2bin (arg : integer; size : integer) return std_logic_vector is
    variable int_val : integer := arg;
    variable result : std_logic_vector(size-1 downto 0);
    begin
        for i in 0 to result'left loop
            if ((int_val mod 2) = 0) then
                result(i) := '0';
            else
                result(i) := '1';
            end if;
            int_val := int_val/2;
        end loop;
        return result;
    end int2bin;

    function extract_cntr_index (arg:string) return integer is
    variable index : integer := 0;
    begin
        if (arg(2) = '0') then
            index := 0;
        elsif (arg(2) = '1') then
            index := 1;
        elsif (arg(2) = '2') then
            index := 2;
        elsif (arg(2) = '3') then
            index := 3;
        elsif (arg(2) = '4') then
            index := 4;
        else index := 5;
        end if;

        return index;
    end extract_cntr_index;

    begin
        if (init) then
            if (m = 0) then
                clk5_cntr  := "c5";
                clk4_cntr  := "c4";
                clk3_cntr  := "c3";
                clk2_cntr  := "c2";
                clk1_cntr  := "c1";
                clk0_cntr  := "c0";
            else
                clk5_cntr  := clk5_counter;
                clk4_cntr  := clk4_counter;
                clk3_cntr  := clk3_counter;
                clk2_cntr  := clk2_counter;
                clk1_cntr  := clk1_counter;
                clk0_cntr  := clk0_counter;
            end if;

            if (operation_mode = "external_feedback") then
                if (feedback_source = "clk0") then
                    fbk_cntr := clk0_cntr;
                elsif (feedback_source = "clk1") then
                    fbk_cntr := clk1_cntr;
                elsif (feedback_source = "clk2") then
                    fbk_cntr := clk2_cntr;
                elsif (feedback_source = "clk3") then
                    fbk_cntr := clk3_cntr;
                elsif (feedback_source = "clk4") then
                    fbk_cntr := clk4_cntr;
                elsif (feedback_source = "clk5") then
                    fbk_cntr := clk5_cntr;
                else
                    fbk_cntr := "c0";
                end if;

                if (fbk_cntr = "c0") then
                    fbk_cntr_index := 0;
                elsif (fbk_cntr = "c1") then
                    fbk_cntr_index := 1;
                elsif (fbk_cntr = "c2") then
                    fbk_cntr_index := 2;
                elsif (fbk_cntr = "c3") then
                    fbk_cntr_index := 3;
                elsif (fbk_cntr = "c4") then
                    fbk_cntr_index := 4;
                elsif (fbk_cntr = "c5") then
                    fbk_cntr_index := 5;
                end if;

                ext_fbk_cntr <= fbk_cntr;
                ext_fbk_cntr_index <= fbk_cntr_index;
            end if;
            i_clk0_counter <= extract_cntr_index(clk0_cntr);
            i_clk1_counter <= extract_cntr_index(clk1_cntr);
            i_clk2_counter <= extract_cntr_index(clk2_cntr);
            i_clk3_counter <= extract_cntr_index(clk3_cntr);
            i_clk4_counter <= extract_cntr_index(clk4_cntr);
            i_clk5_counter <= extract_cntr_index(clk5_cntr);


            if (m = 0) then  -- convert user parameters to advanced
                -- set the limit of the divide_by value that can be returned by
                -- the following function.
                max_d_value := 500;

                -- scale down the multiply_by and divide_by values provided by the design
                -- before attempting to use them in the calculations below
                find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                                max_d_value, i_clk0_mult_by, i_clk0_div_by);
                find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                                max_d_value, i_clk1_mult_by, i_clk1_div_by);
                find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                                max_d_value, i_clk2_mult_by, i_clk2_div_by);
                find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                                max_d_value, i_clk3_mult_by, i_clk3_div_by);
                find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                                max_d_value, i_clk4_mult_by, i_clk4_div_by);
                find_simple_integer_fraction(clk5_multiply_by, clk5_divide_by,
                                max_d_value, i_clk5_mult_by, i_clk5_div_by);

                if (((pll_type = "fast") or (pll_type = "lvds")) and ((vco_multiply_by /= 0) and (vco_divide_by /= 0))) then
                    i_n := vco_divide_by;
                    i_m := vco_multiply_by;
                else
                    i_n := 1;
                    i_m := lcm (i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, i_clk5_mult_by,
                                1, 1, 1, 1, inclk0_input_frequency);
                end if;

                if (pll_type = "flvds") then
                    -- Need to readjust phase shift values when the clock multiply value has been readjusted.
                    new_multiplier := clk0_multiply_by / i_clk0_mult_by;
                    i_clk0_phase_shift := str2int(clk0_phase_shift) * new_multiplier;
                    i_clk1_phase_shift := str2int(clk1_phase_shift) * new_multiplier;
                    i_clk2_phase_shift := str2int(clk2_phase_shift) * new_multiplier;
                else
                    i_clk0_phase_shift := str2int(clk0_phase_shift);
                    i_clk1_phase_shift := str2int(clk1_phase_shift);
                    i_clk2_phase_shift := str2int(clk2_phase_shift);
                end if;

                max_neg_abs := maxnegabs(i_clk0_phase_shift, 
                                        i_clk1_phase_shift,
                                        i_clk2_phase_shift,
                                        str2int(clk3_phase_shift),
                                        str2int(clk4_phase_shift),
                                        str2int(clk5_phase_shift),
                                        0, 0, 0, 0);
                i_m_ph  := counter_ph(get_phase_degree(max_neg_abs,inclk0_input_frequency), i_m, i_n); 

                i_c_ph(0) := counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(1) := counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(2) := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(3) := counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(4) := counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(5) := counter_ph(get_phase_degree(ph_adjust(str2int(clk5_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_high(0) := counter_high(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);
                i_c_high(1) := counter_high(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
                i_c_high(2) := counter_high(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                i_c_high(3) := counter_high(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
                i_c_high(4) := counter_high(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_c_high(5) := counter_high(output_counter_value(i_clk5_div_by,
                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                i_c_low(0)  := counter_low(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
                i_c_low(1)  := counter_low(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
                i_c_low(2)  := counter_low(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                i_c_low(3)  := counter_low(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
                i_c_low(4)  := counter_low(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_c_low(5)  := counter_low(output_counter_value(i_clk5_div_by,
                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                i_m_initial  := counter_initial(get_phase_degree(max_neg_abs, inclk0_input_frequency), i_m,i_n);
                
                i_c_initial(0) := counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(1) := counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(2) := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(3) := counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(4) := counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(5) := counter_initial(get_phase_degree(ph_adjust(str2int(clk5_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_mode(0) := counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
                i_c_mode(1) := counter_mode(clk1_duty_cycle, output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
                i_c_mode(2) := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                i_c_mode(3) := counter_mode(clk3_duty_cycle, output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
                i_c_mode(4) := counter_mode(clk4_duty_cycle, output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));
                i_c_mode(5) := counter_mode(clk5_duty_cycle, output_counter_value(i_clk5_div_by, i_clk5_mult_by,  i_m, i_n));

                -- in external feedback mode, need to adjust M value to take
                -- into consideration the external feedback counter value
                if(operation_mode = "external_feedback") then
                    -- if there is a negative phase shift, m_initial can
                    -- only be 1
                    if (max_neg_abs > 0) then
                        i_m_initial := 1;
                    end if;

                    -- calculate the feedback counter multiplier
                    if (i_c_mode(fbk_cntr_index) = "bypass") then
                        output_count := 1;
                    else
                        output_count := i_c_high(fbk_cntr_index) + i_c_low(fbk_cntr_index);
                    end if;

                    new_divisor := gcd(i_m, output_count);
                    i_m := i_m / new_divisor;
                    i_n := output_count / new_divisor;
                end if;
 
            else -- m /= 0

                i_n             := n;
                i_m             := m;
                i_m_initial     := m_initial;
                i_m_ph          := m_ph;
                i_c_ph(0)         := c0_ph;
                i_c_ph(1)         := c1_ph;
                i_c_ph(2)         := c2_ph;
                i_c_ph(3)         := c3_ph;
                i_c_ph(4)         := c4_ph;
                i_c_ph(5)         := c5_ph;
                i_c_high(0)       := c0_high;
                i_c_high(1)       := c1_high;
                i_c_high(2)       := c2_high;
                i_c_high(3)       := c3_high;
                i_c_high(4)       := c4_high;
                i_c_high(5)       := c5_high;
                i_c_low(0)        := c0_low;
                i_c_low(1)        := c1_low;
                i_c_low(2)        := c2_low;
                i_c_low(3)        := c3_low;
                i_c_low(4)        := c4_low;
                i_c_low(5)        := c5_low;
                i_c_initial(0)    := c0_initial;
                i_c_initial(1)    := c1_initial;
                i_c_initial(2)    := c2_initial;
                i_c_initial(3)    := c3_initial;
                i_c_initial(4)    := c4_initial;
                i_c_initial(5)    := c5_initial;
                i_c_mode(0)       := translate_string(c0_mode);
                i_c_mode(1)       := translate_string(c1_mode);
                i_c_mode(2)       := translate_string(c2_mode);
                i_c_mode(3)       := translate_string(c3_mode);
                i_c_mode(4)       := translate_string(c4_mode);
                i_c_mode(5)       := translate_string(c5_mode);

            end if; -- user to advanced conversion.

            m_initial_val <= i_m_initial;
            n_val(0) <= i_n;
            m_val(0) <= i_m;
            m_val(1) <= m2;
            n_val(1) <= n2;

            if (i_m = 1) then
                m_mode_val(0) <= "bypass";
            else
                m_mode_val(0) <= "      ";
            end if;
            if (m2 = 1) then
                m_mode_val(1) <= "bypass";
            end if;
            if (i_n = 1) then
                n_mode_val(0) <= "bypass";
            end if;
            if (n2 = 1) then
                n_mode_val(1) <= "bypass";
            end if;

            m_ph_val  <= i_m_ph;
            m_ph_val_tmp := i_m_ph;
            m_val_tmp := m_val;

            for i in 0 to 5 loop
                if (i_c_mode(i) = "bypass") then
                    if (pll_type = "fast" or pll_type = "lvds") then
                        i_c_high(i) := 16;
                        i_c_low(i) := 16;
                    else
                        i_c_high(i) := 256;
                        i_c_low(i) := 256;
                    end if;
                end if;
                c_ph_val(i)         <= i_c_ph(i);
                c_initial_val(i)    <= i_c_initial(i);
                c_high_val(i)       <= i_c_high(i);
                c_low_val(i)        <= i_c_low(i);
                c_mode_val(i)       <= i_c_mode(i);
                c_high_val_tmp(i)   := i_c_high(i);
                c_low_val_tmp(i)    := i_c_low(i);
                c_mode_val_tmp(i)   := i_c_mode(i);
                c_ph_val_tmp(i)     := i_c_ph(i);
                c_ph_val_orig(i)    <= i_c_ph(i);
                c_high_val_hold(i)  <= i_c_high(i);
                c_low_val_hold(i)   <= i_c_low(i);
                c_mode_val_hold(i)  <= i_c_mode(i);
            end loop;

            lfc_val <= loop_filter_c;
            lfr_val <= loop_filter_r;
            cp_curr_val <= charge_pump_current;

            if (pll_type = "fast") then
                scan_chain_length := FAST_SCAN_CHAIN;
            end if;
            -- initialize the scan_chain contents
            -- CP/LF bits
            scan_data(11 downto 0) <= "000000000000";
            for i in 0 to 3 loop
                if (pll_type = "fast" or pll_type = "lvds") then
                    if (fpll_loop_filter_c_arr(i) = loop_filter_c) then
                        scan_data(11 downto 10) <= int2bin(i, 2);
                    end if;
                else
                    if (loop_filter_c_arr(i) = loop_filter_c) then
                        scan_data(11 downto 10) <= int2bin(i, 2);
                    end if;
                end if;
            end loop;
            for i in 0 to 15 loop
                if (charge_pump_curr_arr(i) = charge_pump_current) then
                    scan_data(3 downto 0) <= int2bin(i, 4);
                end if;
            end loop;
            for i in 0 to 39 loop
                if (loop_filter_r_arr(i) = loop_filter_r) then
                    if (i >= 16 and i <= 23) then
                        scan_data(9 downto 4) <= int2bin((i+8), 6);
                    elsif (i >= 24 and i <= 31) then
                        scan_data(9 downto 4) <= int2bin((i+16), 6);
                    elsif (i >= 32) then
                        scan_data(9 downto 4) <= int2bin((i+24), 6);
                    else
                        scan_data(9 downto 4) <= int2bin(i, 6);
                    end if;
                end if;
            end loop;
               
            if (pll_type = "fast" or pll_type = "lvds") then
                scan_data(21 downto 12) <= "0000000000"; -- M, C3-C0 ph
                -- C0-C3 high
                scan_data(25 downto 22) <= int2bin(i_c_high(0), 4);
                scan_data(35 downto 32) <= int2bin(i_c_high(1), 4);
                scan_data(45 downto 42) <= int2bin(i_c_high(2), 4);
                scan_data(55 downto 52) <= int2bin(i_c_high(3), 4);
                -- C0-C3 low
                scan_data(30 downto 27) <= int2bin(i_c_low(0), 4);
                scan_data(40 downto 37) <= int2bin(i_c_low(1), 4);
                scan_data(50 downto 47) <= int2bin(i_c_low(2), 4);
                scan_data(60 downto 57) <= int2bin(i_c_low(3), 4);
                -- C0-C3 mode
                for i in 0 to 3 loop
                    if (i_c_mode(i) = "   off" or i_c_mode(i) = "bypass") then
                        scan_data(26 + (10*i)) <= '1';
                        if (i_c_mode(i) = "   off") then
                            scan_data(31 + (10*i)) <= '1';
                        else
                            scan_data(31 + (10*i)) <= '0';
                        end if;
                    else 
                        scan_data(26 + (10*i)) <= '0';
                        if (i_c_mode(i) = "   odd") then
                            scan_data(31 + (10*i)) <= '1';
                        else
                            scan_data(31 + (10*i)) <= '0';
                        end if;
                    end if;
                end loop;
                -- M
                if (i_m = 1) then
                    scan_data(66) <= '1';
                    scan_data(71) <= '0';
                    scan_data(65 downto 62) <= "0000";
                    scan_data(70 downto 67) <= "0000";
                else
                    scan_data(66) <= '0';       -- set BYPASS bit to 0
                    scan_data(70 downto 67) <= int2bin(i_m/2, 4);   -- set M low
                    if (i_m rem 2 = 0) then
                        -- M is an even no. : set M high = low,
                        -- set odd/even bit to 0
                        scan_data(65 downto 62) <= int2bin(i_m/2, 4);
                        scan_data(71) <= '0';
                    else       -- M is odd : M high = low + 1
                        scan_data(65 downto 62) <= int2bin((i_m/2) + 1, 4);
                        scan_data(71) <= '1';
                    end if;
                end if;
                -- N
                scan_data(73 downto 72) <= int2bin(i_n, 2);
                if (i_n = 1) then
                    scan_data(74) <= '1';
                    scan_data(73 downto 72) <= "00";
                end if;
            else          -- PLL type is auto or enhanced
                scan_data(25 downto 12) <= "00000000000000"; -- M, C5-C0 ph
                -- C0-C5 high
                scan_data(123 downto 116) <= int2bin(i_c_high(0), 8);
                scan_data(105 downto 98) <= int2bin(i_c_high(1), 8);
                scan_data(87 downto 80) <= int2bin(i_c_high(2), 8);
                scan_data(69 downto 62) <= int2bin(i_c_high(3), 8);
                scan_data(51 downto 44) <= int2bin(i_c_high(4), 8);
                scan_data(33 downto 26) <= int2bin(i_c_high(5), 8);
                -- C0-C5 low
                scan_data(132 downto 125) <= int2bin(i_c_low(0), 8);
                scan_data(114 downto 107) <= int2bin(i_c_low(1), 8);
                scan_data(96 downto 89) <= int2bin(i_c_low(2), 8);
                scan_data(78 downto 71) <= int2bin(i_c_low(3), 8);
                scan_data(60 downto 53) <= int2bin(i_c_low(4), 8);
                scan_data(42 downto 35) <= int2bin(i_c_low(5), 8);
                -- C0-C5 mode
                for i in 0 to 5 loop
                    if (i_c_mode(i) = "   off" or i_c_mode(i) = "bypass") then
                        scan_data(124 - (18*i)) <= '1';
                        if (i_c_mode(i) = "   off") then
                            scan_data(133 - (18*i)) <= '1';
                        else
                            scan_data(133 - (18*i)) <= '0';
                        end if;
                    else 
                        scan_data(124 - (18*i)) <= '0';
                        if (i_c_mode(i) = "   odd") then
                            scan_data(133 - (18*i)) <= '1';
                        else
                            scan_data(133 - (18*i)) <= '0';
                        end if;
                    end if;
                end loop;

                -- M/M2
                scan_data(142 downto 134) <= int2bin(i_m, 9);
                scan_data(143) <= '0';
                scan_data(152 downto 144) <= int2bin(m2, 9);
                scan_data(153) <= '0';
                if (i_m = 1) then
                    scan_data(143) <= '1';
                    scan_data(142 downto 134) <= "000000000";
                end if;
                if (m2 = 1) then
                    scan_data(153) <= '1';
                    scan_data(152 downto 144) <= "000000000";
                end if;
               
                -- N/N2
                scan_data(162 downto 154) <= int2bin(i_n, 9);
                scan_data(172 downto 164) <= int2bin(n2, 9);
                if (i_n = 1) then
                    scan_data(163) <= '1';
                    scan_data(162 downto 154) <= "000000000";
                end if;
                if (n2 = 1) then
                    scan_data(173) <= '1';
                    scan_data(172 downto 164) <= "000000000";
                end if;
               
            end if;
            if (pll_type = "fast" or pll_type = "lvds") then
                num_output_cntrs <= 4;
            else
                num_output_cntrs <= 6;
            end if;

            init := false;
        elsif (scanwrite_enabled'event and scanwrite_enabled = '0') then
            -- falling edge : deassert scandone
            scandone_tmp <= transport '0' after (1.5 * scanclk_period);
            c0_rising_edge_transfer_done := false;
            c1_rising_edge_transfer_done := false;
            c2_rising_edge_transfer_done := false;
            c3_rising_edge_transfer_done := false;
            c4_rising_edge_transfer_done := false;
            c5_rising_edge_transfer_done := false;
        elsif (scanwrite_enabled'event and scanwrite_enabled = '1') then
            ASSERT false REPORT "PLL Reprogramming Initiated" severity note;

            reconfig_err <= false;

            -- make temporary copy of scan_data for processing
            tmp_scan_data := scan_data;

            -- save old values
            lfc_old <= lfc_val;
            lfr_old <= lfr_val;
            cp_curr_old <= cp_curr_val;

            -- CP
            -- Bits 0-3 : all values are legal
            cp_curr_val <= charge_pump_curr_arr(alt_conv_integer(scan_data(3 downto 0)));

            -- LF Resistance : bits 4-9
            -- values from 010000 - 010111, 100000 - 100111,
            --             110000 - 110111 are illegal
            lfr_tmp := tmp_scan_data(9 downto 4);
            lfr_int := alt_conv_integer(lfr_tmp);
            if (((lfr_int >= 16) and (lfr_int <= 23)) or
                ((lfr_int >= 32) and (lfr_int <= 39)) or
                ((lfr_int >= 48) and (lfr_int <= 55))) then
                reconfig_err <= true;
                ASSERT false REPORT "Illegal bit settings for Loop Filter Resistance. Legal bit values range from 000000-001111, 011000-011111, 101000-101111 and 111000-111111. Reconfiguration may not work." severity warning;
            else
                if (lfr_int >= 56) then
                    lfr_int := lfr_int - 24;
                elsif ((lfr_int >= 40) and (lfr_int <= 47)) then
                    lfr_int := lfr_int - 16;
                elsif ((lfr_int >= 24) and (lfr_int <= 31)) then
                    lfr_int := lfr_int - 8;
                end if;
                lfr_val <= loop_filter_r_arr(lfr_int);
            end if;

            -- LF Capacitance : bits 10,11 : all values are legal
            lfc_tmp := scan_data(11 downto 10);
            if (pll_type = "fast" or pll_type = "lvds") then
                lfc_val <= fpll_loop_filter_c_arr(alt_conv_integer(lfc_tmp));
            else
                lfc_val <= loop_filter_c_arr(alt_conv_integer(lfc_tmp));
            end if;

            -- cntrs c0-c5
            -- save old values for display info.
            m_val_old <= m_val;
            n_val_old <= n_val;
            m_mode_val_old <= m_mode_val;
            n_mode_val_old <= n_mode_val;
            m_ph_val_old <= m_ph_val;
            c_high_val_old <= c_high_val;
            c_low_val_old <= c_low_val;
            c_ph_val_old <= c_ph_val;
            c_mode_val_old <= c_mode_val;

            -- first the M counter phase : bit order same for fast and GPP
            if (scan_data(12) = '0') then
                -- do nothing
            elsif (scan_data(12) = '1' and scan_data(13) = '1') then
                m_ph_val_tmp := m_ph_val_tmp + 1;
                if (m_ph_val_tmp > 7) then
                    m_ph_val_tmp := 0;
                end if;
            elsif (scan_data(12) = '1' and scan_data(13) = '0') then
                m_ph_val_tmp := m_ph_val_tmp - 1;
                if (m_ph_val_tmp < 0) then
                    m_ph_val_tmp := 7;
                end if;
            else
                reconfig_err <= true;
                ASSERT false REPORT "Illegal values for M counter phase tap. Reconfiguration may not work." severity warning;
            end if;

            -- read the fast PLL bits
            if (pll_type = "fast" or pll_type = "lvds") then
                -- C3-C0 phase bits
                for i in 3 downto 0 loop
                    start_bit := 14 + ((3-i)*2);
                    if (tmp_scan_data(start_bit) = '0') then
                        -- do nothing
                    elsif (tmp_scan_data(start_bit) = '1') then
                        if (tmp_scan_data(start_bit + 1) = '1') then
                            c_ph_val_tmp(i) := c_ph_val_tmp(i) + 1;
                            if (c_ph_val_tmp(i) > 7) then
                                c_ph_val_tmp(i) := 0;
                            end if;
                        elsif (tmp_scan_data(start_bit + 1) = '0') then
                            c_ph_val_tmp(i) := c_ph_val_tmp(i) - 1;
                            if (c_ph_val_tmp(i) < 0) then
                                c_ph_val_tmp(i) := 7;
                            end if;
                        end if;
                    end if;
                end loop;
                -- C0-C3 counter moduli
                for i in 0 to 3 loop
                    start_bit := 22 + (i*10);
                    if (tmp_scan_data(start_bit + 4) = '1') then
                        c_mode_val_tmp(i) := "bypass";
                        if (tmp_scan_data(start_bit + 9) = '1') then
                            c_mode_val_tmp(i) := "   off";
                            ASSERT false REPORT "The specified bit settings will turn OFF the " &cntrs(i)& "counter. It cannot be turned on unless the part is re-initialized." severity warning;
                        end if;
                    elsif (tmp_scan_data(start_bit + 9) = '1') then
                        c_mode_val_tmp(i) := "   odd";
                    else
                        c_mode_val_tmp(i) := "  even";
                    end if;
                    high_fast := tmp_scan_data(start_bit+3 downto start_bit);
                    low_fast := tmp_scan_data(start_bit+8 downto start_bit+5);
                    if (tmp_scan_data(start_bit+3 downto start_bit) = "0000") then
                        c_high_val_tmp(i) := 16;
                    else
                        c_high_val_tmp(i) := alt_conv_integer(high_fast);
                    end if;
                    if (tmp_scan_data(start_bit+8 downto start_bit+5) = "0000") then
                        c_low_val_tmp(i) := 16;
                    else
                        c_low_val_tmp(i) := alt_conv_integer(low_fast);
                    end if;
                end loop;
                sig_c_ph_val_tmp <= c_ph_val_tmp;
                sig_c_low_val_tmp <= c_low_val_tmp;
                sig_c_hi_val_tmp <= c_high_val_tmp;
                -- M
                -- some temporary storage
                if (tmp_scan_data(65 downto 62) = "0000") then
                    m_hi := "10000";
                else
                    m_hi := "0" & tmp_scan_data(65 downto 62);
                end if;
                if (tmp_scan_data(70 downto 67) = "0000") then
                    m_lo := "10000";
                else
                    m_lo := "0" & tmp_scan_data(70 downto 67);
                end if;
                m_val_tmp(0) := alt_conv_integer(m_hi) + alt_conv_integer(m_lo);
                if (tmp_scan_data(66) = '1') then
                    if (tmp_scan_data(71) = '1') then
                        -- this will turn off the M counter : error
                        reconfig_err <= true;
                        is_error := true;
                        ASSERT false REPORT "The specified bit settings will turn OFF the M counter. This is illegal. Reconfiguration may not work." severity warning;
                    else -- M counter is being bypassed
                        if (m_mode_val(0) /= "bypass") then
                            -- mode is switched : give warning
                            ASSERT false REPORT "M counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                        end if;
                        m_val_tmp(0) := 1;
                        m_mode_val(0) <= "bypass";
                    end if;
                else
                    if (m_mode_val(0) = "bypass") then
                        -- mode is switched : give warning
                        ASSERT false REPORT "M counter switched BYPASS mode to enabled. PLL may lose lock." severity warning;
                    end if;
                    m_mode_val(0) <= "      ";
                    if (tmp_scan_data(71) = '1') then
                        -- odd : check for duty cycle, if not 50% -- error
                        if (alt_conv_integer(m_hi) - alt_conv_integer(m_lo) /= 1) then
                            reconfig_err <= true;
                            ASSERT FALSE REPORT "The M counter of the " & family_name & " FAST PLL can be configured for 50% duty cycle only. In this case, the HIGH and LOW moduli programmed will result in a duty cycle other than 50%, which is illegal. Reconfiguration may not work." severity warning;
                        end if;
                    else -- even
                        if (alt_conv_integer(m_hi) /= alt_conv_integer(m_lo)) then
                            reconfig_err <= true;
                            ASSERT FALSE REPORT "The M counter of the " & family_name & " FAST PLL can be configured for 50% duty cycle only. In this case, the HIGH and LOW moduli programmed will result in a duty cycle other than 50%, which is illegal. Reconfiguration may not work." severity warning;
                        end if;
                    end if;
                end if;

                -- N
                is_error := false;
                n_fast := tmp_scan_data(73 downto 72);
                n_val(0) <= alt_conv_integer(n_fast);
                if (tmp_scan_data(74) /= '1') then
                    if (alt_conv_integer(n_fast) = 1) then
                        is_error := true;
                        reconfig_err <= true;
                        -- cntr value is illegal : give warning
                        ASSERT false REPORT "Illegal 1 value for N counter. Instead the counter should be BYPASSED. Reconfiguration may not work." severity warning;
                    elsif (alt_conv_integer(n_fast) = 0) then
                        n_val(0) <= 4;
                        ASSERT FALSE REPORT "N Modulus = " &int2str(4)& " " severity note;
                    end if;
                    if (not is_error) then
                        if (n_mode_val(0) = "bypass") then
                            ASSERT false REPORT "N Counter switched from BYPASS mode to enabled (N modulus = " &int2str(alt_conv_integer(n_fast))& "). PLL may lose lock." severity warning;
                        else
                            ASSERT FALSE REPORT "N modulus = " &int2str(alt_conv_integer(n_fast))& " "severity note;
                        end if;
                        n_mode_val(0) <= "      ";
                    end if;
                elsif (tmp_scan_data(74) = '1') then
                    if (tmp_scan_data(72) /= '0') then
                        is_error := true;
                        reconfig_err <= true;
                        ASSERT false report "Illegal value for N counter in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                    else
                        if (n_mode_val(0) /= "bypass") then
                            ASSERT false REPORT "N Counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                        end if;
                        n_val(0) <= 1;
                        n_mode_val(0) <= "bypass";
                    end if;
                end if;
            else   -- GENERAL PURPOSE PLL
                for i in 0 to 5 loop
                    start_bit := 116 - (i*18);
                    if (tmp_scan_data(start_bit + 8) = '1') then
                        c_mode_val_tmp(i) := "bypass";
                        if (tmp_scan_data(start_bit + 17) = '1') then
                            c_mode_val_tmp(i) := "   off";
                            ASSERT false REPORT "The specified bit settings will turn OFF the " &cntrs(i)& "counter. It cannot be turned on unless the part is re-initialized." severity warning;
                        end if;
                    elsif (tmp_scan_data(start_bit + 17) = '1') then
                        c_mode_val_tmp(i) := "   odd";
                    else
                        c_mode_val_tmp(i) := "  even";
                    end if;
                    high := tmp_scan_data(start_bit + 7 downto start_bit);
                    low := tmp_scan_data(start_bit+16 downto start_bit+9);
                    if (tmp_scan_data(start_bit+7 downto start_bit) = "00000000") then
                        c_high_val_tmp(i) := 256;
                    else
                        c_high_val_tmp(i) := alt_conv_integer(high);
                    end if;
                    if (tmp_scan_data(start_bit+16 downto start_bit+9) = "00000000") then
                        c_low_val_tmp(i) := 256;
                    else
                        c_low_val_tmp(i) := alt_conv_integer(low);
                    end if;
                end loop;
                -- the phase taps
                for i in 0 to 5 loop
                    start_bit := 14 + (i*2);
                    if (tmp_scan_data(start_bit) = '0') then
                        -- do nothing
                    elsif (tmp_scan_data(start_bit) = '1') then
                        if (tmp_scan_data(start_bit + 1) = '1') then
                            c_ph_val_tmp(i) := c_ph_val_tmp(i) + 1;
                            if (c_ph_val_tmp(i) > 7) then
                                c_ph_val_tmp(i) := 0;
                            end if;
                        elsif (tmp_scan_data(start_bit + 1) = '0') then
                            c_ph_val_tmp(i) := c_ph_val_tmp(i) - 1;
                            if (c_ph_val_tmp(i) < 0) then
                                c_ph_val_tmp(i) := 7;
                            end if;
                        end if;
                    end if;
                end loop;
                sig_c_ph_val_tmp <= c_ph_val_tmp;
                sig_c_low_val_tmp <= c_low_val_tmp;
                sig_c_hi_val_tmp <= c_high_val_tmp;

                -- cntrs M/M2
                for i in 0 to 1 loop
                    start_bit := 134 + (i*10);
                    if ( i = 0 or (i = 1 and ss > 0) ) then
                        is_error := false;
                        m_tmp := tmp_scan_data(start_bit+8 downto start_bit);
                        m_val_tmp(i) := alt_conv_integer(m_tmp);
                        if (tmp_scan_data(start_bit+9) /= '1') then
                            if (alt_conv_integer(m_tmp) = 1) then
                                is_error := true;
                                reconfig_err <= true;
                                -- cntr value is illegal : give warning
                                ASSERT false REPORT "Illegal 1 value for " &ss_cntrs(i)& "counter. Instead " &ss_cntrs(i)& "should be BYPASSED. Reconfiguration may not work." severity warning;
                            elsif (tmp_scan_data(start_bit+8 downto start_bit) = "000000000") then
                                m_val_tmp(i) := 512;
                            end if;
                            if (not is_error) then
                                if (m_mode_val(i) = "bypass") then
                                    -- Mode is switched : give warning
                                    ASSERT false REPORT "M Counter switched from BYPASS mode to enabled (M modulus = " &int2str(alt_conv_integer(m_tmp))& "). PLL may lose lock." severity warning;
                                else
                                end if;
                                m_mode_val(i) <= "      ";
                            end if;
                        elsif (tmp_scan_data(start_bit+9) = '1') then
                            if (tmp_scan_data(start_bit) /= '0') then
                                is_error := true;
                                reconfig_err <= true;
                                ASSERT false report "Illegal value for counter " &ss_cntrs(i)& "in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                            else
                                if (m_mode_val(i) /= "bypass") then
                                    -- Mode is switched : give warning
                                    ASSERT false REPORT "M Counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                                end if;
                                m_val_tmp(i) := 1;
                                m_mode_val(i) <= "bypass";
                            end if;
                        end if;
                    end if;
                end loop;
                if (ss > 0) then
                    if (m_mode_val(0) /= m_mode_val(1)) then
                        reconfig_err <= true;
                        is_error := true;
                        ASSERT false REPORT "Incompatible modes for M/M2 counters. Either both should be BYPASSED or both NON-BYPASSED. Reconfiguration may not work." severity warning;
                    end if;
                end if;
                sig_m_val_tmp <= m_val_tmp;
                -- cntrs N/N2
                for i in 0 to 1 loop
                    start_bit := 154 + i*10;
                    if ( i = 0 or (i = 1 and ss > 0) ) then
                        is_error := false;
                        n_tmp := tmp_scan_data(start_bit+8 downto start_bit);
                        n_val(i) <= alt_conv_integer(n_tmp);
                        if (tmp_scan_data(start_bit+9) /= '1') then
                            if (alt_conv_integer(n_tmp) = 1) then
                                is_error := true;
                                reconfig_err <= true;
                                -- cntr value is illegal : give warning
                                ASSERT false REPORT "Illegal 1 value for " &ss_cntrs(2+i)& "counter. Instead " &ss_cntrs(2+i)& "should be BYPASSED. Reconfiguration may not work." severity warning;
                            elsif (alt_conv_integer(n_tmp) = 0) then
                                n_val(i) <= 512;
                            end if;
                            if (not is_error) then
                                if (n_mode_val(i) = "bypass") then
                                    ASSERT false REPORT "N Counter switched from BYPASS mode to enabled (N modulus = " &int2str(alt_conv_integer(n_tmp))& "). PLL may lose lock." severity warning;
                                else
                                end if;
                                n_mode_val(i) <= "      ";
                            end if;
                        elsif (tmp_scan_data(start_bit+9) = '1') then
                            if (tmp_scan_data(start_bit) /= '0') then
                                is_error := true;
                                reconfig_err <= true;
                                ASSERT false report "Illegal value for counter " &ss_cntrs(2+i)& "in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work." severity warning;
                            else
                                if (n_mode_val(i) /= "bypass") then
                                    ASSERT false REPORT "N Counter switched from enabled to BYPASS mode. PLL may lose lock." severity warning;
                                end if;
                                n_val(i) <= 1;
                                n_mode_val(i) <= "bypass";
                            end if;
                        end if;
                    end if;
                end loop;
                if (ss > 0) then
                    if (n_mode_val(0) /= n_mode_val(1)) then
                        reconfig_err <= true;
                        is_error := true;
                        ASSERT false REPORT "Incompatible modes for N/N2 counters. Either both should be BYPASSED or both NON-BYPASSED. Reconfiguration may not work." severity warning;
                    end if;
                end if;
            end if;
            
            slowest_clk_old := slowest_clk(c_high_val(0)+c_low_val(0), c_mode_val(0),
                                    c_high_val(1)+c_low_val(1), c_mode_val(1),
                                    c_high_val(2)+c_low_val(2), c_mode_val(2),
                                    c_high_val(3)+c_low_val(3), c_mode_val(3),
                                    c_high_val(4)+c_low_val(4), c_mode_val(4),
                                    c_high_val(5)+c_low_val(5), c_mode_val(5),
                                    sig_refclk_period, m_val(0));

            slowest_clk_new := slowest_clk(c_high_val_tmp(0)+c_low_val_tmp(0), c_mode_val_tmp(0),
                                    c_high_val_tmp(1)+c_low_val_tmp(1), c_mode_val_tmp(1),
                                    c_high_val_tmp(2)+c_low_val_tmp(2), c_mode_val_tmp(2),
                                    c_high_val_tmp(3)+c_low_val_tmp(3), c_mode_val_tmp(3),
                                    c_high_val_tmp(4)+c_low_val_tmp(4), c_mode_val_tmp(4),
                                    c_high_val_tmp(5)+c_low_val_tmp(5), c_mode_val_tmp(5),
                                    sig_refclk_period, m_val_tmp(0));

            if (slowest_clk_new > slowest_clk_old) then
                quiet_time := slowest_clk_new;
            else
                quiet_time := slowest_clk_old;
            end if;
            sig_quiet_time <= quiet_time;
            sig_slowest_clk_old <= slowest_clk_old;
            sig_slowest_clk_new <= slowest_clk_new;
            tmp_rem := (quiet_time/1 ps) rem (scanclk_period/ 1 ps);
            scanclk_cycles := (quiet_time/1 ps) / (scanclk_period/1 ps);
            if (tmp_rem /= 0) then
                scanclk_cycles := scanclk_cycles + 1;
            end if;
            scandone_tmp <= transport '1' after ((scanclk_cycles+1)*scanclk_period - (scanclk_period/2));
        end if;

        if (scanwrite_enabled = '1') then
            if (fbclk'event and fbclk = '1') then
                m_val <= m_val_tmp;
            end if;

            if (c_clk(0)'event and c_clk(0) = '1') then
                c_high_val(0) <= c_high_val_tmp(0);
                c_mode_val(0) <= c_mode_val_tmp(0);
                c0_rising_edge_transfer_done := true;
            end if;
            if (c_clk(1)'event and c_clk(1) = '1') then
                c_high_val(1) <= c_high_val_tmp(1);
                c_mode_val(1) <= c_mode_val_tmp(1);
                c1_rising_edge_transfer_done := true;
            end if;
            if (c_clk(2)'event and c_clk(2) = '1') then
                c_high_val(2) <= c_high_val_tmp(2);
                c_mode_val(2) <= c_mode_val_tmp(2);
                c2_rising_edge_transfer_done := true;
            end if;
            if (c_clk(3)'event and c_clk(3) = '1') then
                c_high_val(3) <= c_high_val_tmp(3);
                c_mode_val(3) <= c_mode_val_tmp(3);
                c3_rising_edge_transfer_done := true;
            end if;
            if (c_clk(4)'event and c_clk(4) = '1') then
                c_high_val(4) <= c_high_val_tmp(4);
                c_mode_val(4) <= c_mode_val_tmp(4);
                c4_rising_edge_transfer_done := true;
            end if;
            if (c_clk(5)'event and c_clk(5) = '1') then
                c_high_val(5) <= c_high_val_tmp(5);
                c_mode_val(5) <= c_mode_val_tmp(5);
                c5_rising_edge_transfer_done := true;
            end if;
        end if;

        if (c_clk(0)'event and c_clk(0) = '0' and c0_rising_edge_transfer_done) then
            c_low_val(0) <= c_low_val_tmp(0);
        end if;
        if (c_clk(1)'event and c_clk(1) = '0' and c1_rising_edge_transfer_done) then
            c_low_val(1) <= c_low_val_tmp(1);
        end if;
        if (c_clk(2)'event and c_clk(2) = '0' and c2_rising_edge_transfer_done) then
            c_low_val(2) <= c_low_val_tmp(2);
        end if;
        if (c_clk(3)'event and c_clk(3) = '0' and c3_rising_edge_transfer_done) then
            c_low_val(3) <= c_low_val_tmp(3);
        end if;
        if (c_clk(4)'event and c_clk(4) = '0' and c4_rising_edge_transfer_done) then
            c_low_val(4) <= c_low_val_tmp(4);
        end if;
        if (c_clk(5)'event and c_clk(5) = '0' and c5_rising_edge_transfer_done) then
            c_low_val(5) <= c_low_val_tmp(5);
        end if;

        if (scanwrite_enabled = '1') then
            for x in 0 to 7 loop
                if (vco_tap(x) /= vco_tap_last_value(x) and vco_tap(x) = '0') then
                    -- TAP X has event
                    for i in 0 to 5 loop
                        if (c_ph_val(i) = x) then
                            c_ph_val(i) <= c_ph_val_tmp(i);
                        end if;
                    end loop;
                    if (m_ph_val = x) then
                        m_ph_val <= m_ph_val_tmp;
                    end if;
                end if;
            end loop;
        end if;

        -- revert counter phase tap values to POF programmed values
        -- if PLL is reset

        if (areset_ipd = '1') then
            c_ph_val <= i_c_ph;
            c_ph_val_tmp := i_c_ph;
            m_ph_val <= i_m_ph;
            m_ph_val_tmp := i_m_ph;
        end if;

        for x in 0 to 7 loop
            if (vco_tap(x) /= vco_tap_last_value(x)) then
                -- TAP X has event
                for i in 0 to 5 loop
                    if (c_ph_val(i) = x) then
                        inclk_c_from_vco(i) <= vco_tap(x);
                        if (i = 0 and enable0_counter = "c0") then
                            inclk_sclkout0_from_vco <= vco_tap(x);
                        end if;
                        if (i = 0 and enable1_counter = "c0") then
                            inclk_sclkout1_from_vco <= vco_tap(x);
                        end if;
                        if (i = 1 and enable0_counter = "c1") then
                            inclk_sclkout0_from_vco <= vco_tap(x);
                        end if;
                        if (i = 1 and enable1_counter = "c1") then
                            inclk_sclkout1_from_vco <= vco_tap(x);
                        end if;
                    end if;
                end loop;

                if (m_ph_val = x) then
                    inclk_m_from_vco <= vco_tap(x);
                end if;

                vco_tap_last_value(x) <= vco_tap(x);
            end if;
        end loop;



        if (scanclk_ipd'event and scanclk_ipd = '0') then
            -- enable scanwrite on falling edge
            scanwrite_enabled <= scanwrite_reg;
        end if;

        if (scanread_reg = '1') then
            gated_scanclk <= transport scanclk_ipd and scanread_reg;
        else
            gated_scanclk <= transport '1';
        end if;

        if (scanclk_ipd'event and scanclk_ipd = '1') then
            -- register scanread and scanwrite
            scanread_reg <= scanread_ipd;
            scanwrite_reg <= scanwrite_ipd;

            if (got_first_scanclk) then
                scanclk_period := now - scanclk_last_rising_edge;
            else
                got_first_scanclk := true;
            end if;
            -- reset got_first_scanclk on falling edge of scanread_reg
            if (scanread_ipd = '0' and scanread_reg = '1') then
                got_first_scanclk := false;
                got_first_gated_scanclk := false;
            end if;

            scanclk_last_rising_edge := now;
        end if;
   
        if (gated_scanclk'event and gated_scanclk = '1' and now > 0 ps) then
            if (not got_first_gated_scanclk) then
                got_first_gated_scanclk := true;
            end if;
            for j in scan_chain_length - 1 downto 1 loop
                scan_data(j) <= scan_data(j-1);
            end loop;
            scan_data(0) <= scandata_ipd;
        end if;
    end process;

    scandataout_tmp <= scan_data(FAST_SCAN_CHAIN-1) when (pll_type = "fast" or pll_type = "lvds") else scan_data(GPP_SCAN_CHAIN-1);


    SCHEDULE : process (schedule_vco, areset_ipd, ena_ipd, pfdena_ipd, refclk, fbclk, vco_out)
    variable sched_time : time := 0 ps;

    TYPE time_array is ARRAY (0 to 7) of time;
    variable init : boolean := true;
    variable refclk_period : time;
    variable m_times_vco_period : time;
    variable new_m_times_vco_period : time;

    variable phase_shift : time_array := (OTHERS => 0 ps);
    variable last_phase_shift : time_array := (OTHERS => 0 ps);

    variable l_index : integer := 1;
    variable cycle_to_adjust : integer := 0;

    variable stop_vco : boolean := false;

    variable locked_tmp : std_logic := '0';
    variable pll_is_locked : boolean := false;
    variable pll_about_to_lock : boolean := false;
    variable cycles_to_lock : integer := 0;
    variable cycles_to_unlock : integer := 0;

    variable got_first_refclk : boolean := false;
    variable got_second_refclk : boolean := false;
    variable got_first_fbclk : boolean := false;

    variable refclk_time : time := 0 ps;
    variable fbclk_time : time := 0 ps;
    variable first_fbclk_time : time := 0 ps;

    variable fbclk_period : time := 0 ps;

    variable first_schedule : boolean := true;

    variable vco_val : std_logic := '0';
    variable vco_period_was_phase_adjusted : boolean := false;
    variable phase_adjust_was_scheduled : boolean := false;

    variable loop_xplier : integer;
    variable loop_initial : integer := 0;
    variable loop_ph : integer := 0;
    variable loop_time_delay : integer := 0;

    variable initial_delay : time := 0 ps;
    variable vco_per : time;
    variable tmp_rem : integer;
    variable my_rem : integer;
    variable fbk_phase : integer := 0;

    variable pull_back_M : integer := 0;
    variable total_pull_back : integer := 0;
    variable fbk_delay : integer := 0;

    variable offset : time := 0 ps;

    variable tmp_vco_per : integer := 0;
    variable high_time : time;
    variable low_time : time;

    variable got_refclk_posedge : boolean := false;
    variable got_fbclk_posedge : boolean := false;
    variable inclk_out_of_range : boolean := false;
    variable no_warn : boolean := false;

    variable ext_fbk_cntr_modulus : integer := 1;
    variable init_clks : boolean := true;
    variable pll_is_in_reset : boolean := false;
    variable pll_is_disabled : boolean := false;
    variable next_vco_sched_time : time  := 0 ps;
    variable tap0_is_active : boolean := true;

    begin
        if (init) then

            -- jump-start the VCO
            -- add 1 ps delay to ensure all signals are updated to initial
            -- values
            schedule_vco <= transport not schedule_vco after 1 ps;

            init := false;
        end if;

        if (schedule_vco'event) then
            if (init_clks) then
                refclk_period := inclk0_input_frequency * n_val(0) * 1 ps;

                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                init_clks := false;
            end if;
            sched_time := 0 ps;
            for i in 0 to 7 loop
                last_phase_shift(i) := phase_shift(i);
            end loop;
            cycle_to_adjust := 0;
            l_index := 1;
            m_times_vco_period := new_m_times_vco_period;
        end if;

        -- areset was asserted
        if (areset_ipd'event and areset_ipd = '1') then
            assert false report family_name & " PLL was reset" severity note;
            -- reset lock parameters
            locked_tmp := '0';
            pll_is_locked := false;
            pll_about_to_lock := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;
            pll_is_in_reset := true;
            tap0_is_active := false;
            for x in 0 to 7 loop
                vco_tap(x) <= '0';
            end loop;
        end if;

        -- note areset deassert time
        -- note it as refclk_time to prevent false triggering
        -- of stop_vco after areset
        if (areset_ipd'event and areset_ipd = '0' and pll_is_in_reset) then
            refclk_time := now;
            pll_is_in_reset := false;
            if (ena_ipd = '1' and not stop_vco and next_vco_sched_time <= now) then
                schedule_vco <= not schedule_vco;
            end if;
        end if;

        -- ena was deasserted
        if (ena_ipd'event and ena_ipd = '0') then
            assert false report family_name & " PLL was disabled" severity note;
            pll_is_disabled := true;
            tap0_is_active := false;
            for x in 0 to 7 loop
                vco_tap(x) <= '0';
            end loop;
        end if;

        if (ena_ipd'event and ena_ipd = '1') then
            assert false report family_name & " PLL is enabled" severity note;
            pll_is_disabled := false;
            if (areset_ipd /= '1' and not stop_vco and next_vco_sched_time < now) then
                schedule_vco <= not schedule_vco;
            end if;
        end if;

        -- illegal value on areset_ipd
        if (areset_ipd'event and areset_ipd = 'X') then
            assert false report "Illegal value 'X' detected on ARESET input" severity warning;
        end if;

        if (areset_ipd = '1' or ena_ipd = '0' or stop_vco) then

            -- reset lock parameters
            locked_tmp := '0';
            pll_is_locked := false;
            pll_about_to_lock := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;

            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := 0 ps;
            got_first_fbclk := false;
            fbclk_time := 0 ps;
            first_fbclk_time := 0 ps;
            fbclk_period := 0 ps;

--            first_schedule := true;
--            vco_val := '0';
            vco_period_was_phase_adjusted := false;
            phase_adjust_was_scheduled := false;

            -- reset all counter phase taps to POF programmed values
        end if;

        if (schedule_vco'event and areset_ipd /= '1' and ena_ipd /= '0' and (not stop_vco) and now > 0 ps) then


            -- calculate loop_xplier : this will be different from m_val
            -- in external_feedback_mode
            loop_xplier := m_val(0);
            loop_initial := m_initial_val - 1;
            loop_ph := m_ph_val;

            if (operation_mode = "external_feedback") then
                if (ext_fbk_cntr_mode = "bypass") then
                    ext_fbk_cntr_modulus := 1;
                else
                    ext_fbk_cntr_modulus := ext_fbk_cntr_high + ext_fbk_cntr_low;
                end if;
                loop_xplier := m_val(0) * (ext_fbk_cntr_modulus);
                loop_ph := ext_fbk_cntr_ph;
                loop_initial := ext_fbk_cntr_initial - 1 + ((m_initial_val - 1) * ext_fbk_cntr_modulus);
            end if;

            -- convert initial value to delay
            initial_delay := (loop_initial * m_times_vco_period)/loop_xplier;

            -- convert loop ph_tap to delay
            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            tmp_vco_per := (m_times_vco_period/1 ps) / loop_xplier;
            if (my_rem /= 0) then
                tmp_vco_per := tmp_vco_per + 1;
            end if;
            fbk_phase := (loop_ph * tmp_vco_per)/8;

            if (operation_mode = "external_feedback") then
                pull_back_M :=  (m_initial_val - 1) * ext_fbk_cntr_modulus * ((refclk_period/loop_xplier)/1 ps);
                while (pull_back_M > refclk_period/1 ps) loop
                    pull_back_M := pull_back_M - refclk_period/ 1 ps;
                end loop;
            else
                pull_back_M := initial_delay/1 ps + fbk_phase;
            end if;

            total_pull_back := pull_back_M;

            if (simulation_type = "timing") then
                total_pull_back := total_pull_back + pll_compensation_delay;
            end if;
            while (total_pull_back > refclk_period/1 ps) loop
                total_pull_back := total_pull_back - refclk_period/1 ps;
            end loop;

            if (total_pull_back > 0) then
                offset := refclk_period - (total_pull_back * 1 ps);
            end if;
            if (operation_mode = "external_feedback") then
                fbk_delay := pull_back_M;
                if (simulation_type = "timing") then
                    fbk_delay := fbk_delay + pll_compensation_delay;
                end if;
            else
                fbk_delay := total_pull_back - fbk_phase;
                if (fbk_delay < 0) then
                    offset := offset - (fbk_phase * 1 ps);
                    fbk_delay := total_pull_back;
                end if;
            end if;

            -- assign m_delay
            m_delay <= transport fbk_delay after 1 ps;

            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            for i in 1 to loop_xplier loop
                -- adjust cycles
                tmp_vco_per := (m_times_vco_period/1 ps)/loop_xplier;
                if (my_rem /= 0 and l_index <= my_rem) then
                    tmp_rem := (loop_xplier * l_index) rem my_rem;
                    cycle_to_adjust := (loop_xplier * l_index) / my_rem;
                    if (tmp_rem /= 0) then
                        cycle_to_adjust := cycle_to_adjust + 1;
                    end if;
                end if;
                if (cycle_to_adjust = i) then
                    tmp_vco_per := tmp_vco_per + 1;
                    l_index := l_index + 1;
                end if;

                -- calculate high and low periods
                vco_per := tmp_vco_per * 1 ps;
                high_time := (tmp_vco_per/2) * 1 ps;
                if (tmp_vco_per rem 2 /= 0) then
                    high_time := high_time + 1 ps;
                end if;
                low_time := vco_per - high_time;

                -- schedule the rising and falling edges
                for j in 1 to 2 loop
                    vco_val := not vco_val;
                    if (vco_val = '0') then
                        sched_time := sched_time + high_time;
                    elsif (vco_val = '1') then
                        sched_time := sched_time + low_time;
                    end if;

                    -- schedule tap0
                    vco_out(0) <= transport vco_val after sched_time;
                end loop;
            end loop;

            -- schedule once more
            if (first_schedule) then
                vco_val := not vco_val;
                if (vco_val = '0') then
                    sched_time := sched_time + high_time;
                elsif (vco_val = '1') then
                    sched_time := sched_time + low_time;
                end if;
                -- schedule tap 0
                vco_out(0) <= transport vco_val after sched_time;

                first_schedule := false;
            end if;

            schedule_vco <= transport not schedule_vco after sched_time;
            next_vco_sched_time := now + sched_time;

            if (vco_period_was_phase_adjusted) then
                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := true;

                vco_per := m_times_vco_period/loop_xplier;
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                end loop;
            end if;
        end if;

        -- now schedule the other taps with the appropriate phase-shift
        if (vco_out(0)'event) then
            for k in 1 to 7 loop
                phase_shift(k) := (k * vco_per)/8;
                vco_out(k) <= transport vco_out(0) after phase_shift(k);
            end loop;
        end if;

        if (refclk'event and refclk = '1' and areset_ipd = '0') then
            got_refclk_posedge := true;
            if (not got_first_refclk) then
                got_first_refclk := true;
            else
                got_second_refclk := true;
                refclk_period := now - refclk_time;

                -- check if incoming freq. will cause VCO range to be
                -- exceeded
                if ( (vco_max /= 0 and vco_min /= 0 and pfdena_ipd = '1') and
                    (((refclk_period/1 ps)/loop_xplier > vco_max) or
                    ((refclk_period/1 ps)/loop_xplier < vco_min)) ) then
                    if (pll_is_locked) then
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may lose lock" severity warning;
                        if (inclk_out_of_range) then
                            pll_is_locked := false;
                            locked_tmp := '0';
                            pll_about_to_lock := false;
                            cycles_to_lock := 0;
                            vco_period_was_phase_adjusted := false;
                            phase_adjust_was_scheduled := false;
                            assert false report family_name & " PLL lost lock." severity note;
                        end if;
                    elsif (not no_warn) then
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may not lock. Please use the correct frequency." severity warning;
                        no_warn := true;
                    end if;
                    inclk_out_of_range := true;
                else
                    inclk_out_of_range := false;
                end if;
            end if;

            if (stop_vco) then
                stop_vco := false;
                schedule_vco <= not schedule_vco;
            end if;

            refclk_time := now;
        else
            got_refclk_posedge := false;
        end if;

        if (fbclk'event and fbclk = '1') then
            got_fbclk_posedge := true;
            if (not got_first_fbclk) then
                got_first_fbclk := true;
            else
                fbclk_period := now - fbclk_time;
            end if;

            -- need refclk_period here, so initialized to proper value above
            if ( ( (now - refclk_time > 1.5 * refclk_period) and pfdena_ipd = '1' and pll_is_locked) or ( (now - refclk_time > 5 * refclk_period) and pfdena_ipd = '1') ) then
                stop_vco := true;
                -- reset
                got_first_refclk := false;
                got_first_fbclk := false;
                got_second_refclk := false;
                if (pll_is_locked) then
                    pll_is_locked := false;
                    locked_tmp := '0';
                    assert false report family_name & " PLL lost lock due to loss of input clock" severity note;
                end if;
                pll_about_to_lock := false;
                cycles_to_lock := 0;
                cycles_to_unlock := 0;
                first_schedule := true;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := false;
                tap0_is_active := false;
                for x in 0 to 7 loop
                    vco_tap(x) <= '0';
                end loop;
            end if;
            fbclk_time := now;
        else
            got_fbclk_posedge := false;
        end if;

        if ((got_refclk_posedge or got_fbclk_posedge) and got_second_refclk and pfdena_ipd = '1' and (not inclk_out_of_range)) then

            -- now we know actual incoming period
            if ( abs(fbclk_time - refclk_time) <= 5 ps or
                (got_first_fbclk and abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                -- considered in phase
                if (cycles_to_lock = valid_lock_multiplier - 1) then
                    pll_about_to_lock := true;
                end if;
                if (cycles_to_lock = valid_lock_multiplier) then
                    if (not pll_is_locked) then
                        assert false report family_name & " PLL locked to incoming clock" severity note;
                    end if;
                    pll_is_locked := true;
                    locked_tmp := '1';
                    cycles_to_unlock := 0;
                end if;
                -- increment lock counter only if second part of above
                -- time check is NOT true
                if (not(abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                    cycles_to_lock := cycles_to_lock + 1;
                end if;

                -- adjust m_times_vco_period
                new_m_times_vco_period := refclk_period;
            else
                -- if locked, begin unlock
                if (pll_is_locked) then
                    cycles_to_unlock := cycles_to_unlock + 1;
                    if (cycles_to_unlock = invalid_lock_multiplier) then
                        pll_is_locked := false;
                        locked_tmp := '0';
                        pll_about_to_lock := false;
                        cycles_to_lock := 0;
                        vco_period_was_phase_adjusted := false;
                        phase_adjust_was_scheduled := false;
                        assert false report family_name & " PLL lost lock." severity note;
                    end if;
                end if;
                if ( abs(refclk_period - fbclk_period) <= 2 ps ) then
                    -- frequency is still good
                    if (now = fbclk_time and (not phase_adjust_was_scheduled)) then
                        if ( abs(fbclk_time - refclk_time) > refclk_period/2) then
                            if ( abs(fbclk_time - refclk_time) > 1.5 * refclk_period) then
                                -- input clock may have stopped : do nothing
                            else
                            new_m_times_vco_period := m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                            vco_period_was_phase_adjusted := true;
                            end if;
                        else
                            new_m_times_vco_period := m_times_vco_period - abs(fbclk_time - refclk_time);
                            vco_period_was_phase_adjusted := true;
                        end if;

                    end if;
                else
                    phase_adjust_was_scheduled := false;
                    new_m_times_vco_period := refclk_period;
                end if;

            end if;
        end if;

        -- check which vco_tap has event
        for x in 0 to 7 loop
            if (vco_out(x) /= vco_out_last_value(x)) then
                -- TAP X has event
                if (x = 0 and areset_ipd = '0' and ena_ipd = '1' and sig_stop_vco = '0') then
                    if (vco_out(0) = '1') then
                        tap0_is_active := true;
                    end if;
                    if (tap0_is_active) then
                        vco_tap(0) <= vco_out(0);
                    end if;
                elsif (tap0_is_active) then
                        vco_tap(x) <= vco_out(x);
                end if;
                if (sig_stop_vco = '1') then
                    vco_tap(x) <= '0';
                end if;
                vco_out_last_value(x) <= vco_out(x);
            end if;
        end loop;
        
        if (pfdena_ipd = '0') then
            if (pll_is_locked) then
                locked_tmp := 'X';
            end if;
            pll_is_locked := false;
            cycles_to_lock := 0;
        end if;

        -- give message only at time of deassertion
        if (pfdena_ipd'event and pfdena_ipd = '0') then
            assert false report "PFDENA deasserted." severity note;
        elsif (pfdena_ipd'event and pfdena_ipd = '1') then
            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := now;
        end if;

        if (reconfig_err) then
            lock <= '0';
        else
            lock <= locked_tmp;
        end if;
        about_to_lock <= pll_about_to_lock after 1 ps;

        -- signal to calculate quiet_time
        sig_refclk_period <= refclk_period;

        if (stop_vco = true) then
            sig_stop_vco <= '1';
        else
            sig_stop_vco <= '0';
        end if;
    end process SCHEDULE;

    clk0_tmp <= c_clk(i_clk0_counter);
    clk(0)   <= clk0_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    clk1_tmp <= c_clk(i_clk1_counter);
    clk(1)   <= clk1_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    clk2_tmp <= c_clk(i_clk2_counter);
    clk(2)   <= clk2_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    clk3_tmp <= c_clk(i_clk3_counter);
    clk(3)   <= clk3_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    clk4_tmp <= c_clk(i_clk4_counter);
    clk(4)   <= clk4_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    clk5_tmp <= c_clk(i_clk5_counter);
    clk(5)   <= clk5_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    sclkout(0) <= sclkout0_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    sclkout(1) <= sclkout1_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    enable0 <= enable0_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';
    enable1 <= enable1_tmp when (areset_ipd = '1' or ena_ipd = '0' or pll_in_test_mode) or (about_to_lock and (not reconfig_err)) else
                'X';

    scandataout <= scandataout_tmp;
    scandone <= scandone_tmp;

end vital_pll;
-- END ARCHITECTURE VITAL_PLL

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_ttn_mn_cntr
--
-- Description : Simulation model for the M and N counter. This is a
--               common model for the input counter and the loop feedback
--               counter of the StratixIII PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_arith.all;
USE IEEE.std_logic_unsigned.all;

ENTITY MF_ttn_mn_cntr is
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer := 1;
            time_delay    : IN integer := 0
        );
END MF_ttn_mn_cntr;

ARCHITECTURE behave of MF_ttn_mn_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
            first_rising_edge := false;
            tmp_cout := clk;
        elsif (not first_rising_edge) then
            if (count < modulus) then
                count := count + 1;
            else
                count := 1;
                tmp_cout := not tmp_cout;
            end if;
        end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_ttn_scale_cntr
--
-- Description : Simulation model for the output scale-down counters.
--               This is a common model for the C0, C1, C2, C3, C4 and C5
--               output counters of the StratixII PLL.
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_ttn_scale_cntr is
    PORT(   clk            : IN std_logic;
            reset          : IN std_logic := '0';
            initial        : IN integer := 1;
            high           : IN integer := 1;
            low            : IN integer := 1;
            mode           : IN string := "bypass";
            ph_tap         : IN integer := 0;
            cout           : OUT std_logic
        );
END MF_ttn_scale_cntr;

ARCHITECTURE behave of MF_ttn_scale_cntr is
begin
    process (clk, reset)
    variable tmp_cout : std_logic := '0';
    variable count : integer := 1;
    variable output_shift_count : integer := 1;
    variable first_rising_edge : boolean := false;
    begin
        if (reset = '1') then
            count := 1;
            output_shift_count := 1;
            tmp_cout := '0';
            first_rising_edge := false;
        elsif (clk'event) then
            if (mode = "   off") then
                tmp_cout := '0';
            elsif (mode = "bypass") then
                tmp_cout := clk;
                first_rising_edge := true;
            elsif (not first_rising_edge) then
                if (clk = '1') then
                    if (output_shift_count = initial) then
                        tmp_cout := clk;
                        first_rising_edge := true;
                    else
                        output_shift_count := output_shift_count + 1;
                    end if;
                end if;
            elsif (output_shift_count < initial) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                end if;
            else
                count := count + 1;
                if (mode = "  even" and (count = (high*2) + 1)) then
                    tmp_cout := '0';
                elsif (mode = "   odd" and (count = high*2)) then
                    tmp_cout := '0';
                elsif (count = (high + low)*2 + 1) then
                    tmp_cout := '1';
                    count := 1;  -- reset count
                end if;
            end if;
        end if;
        cout <= transport tmp_cout;
    end process;

end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stratixiii_pll
--
-- Description : Simulation model for the StratixII PLL.
--               In the functional mode, it is also the model for the altpll
--               megafunction.
--
-- Limitations : Does not support Spread Spectrum and Bandwidth.
--
-- Outputs     : Up to 10 output clocks, each defined by its own set of
--               parameters. Locked output (active high) indicates when the
--               PLL locks. clkbad and activeclock are used for
--               clock switchover to indicate which input clock has gone
--               bad, when the clock switchover initiates and which input
--               clock is being used as the reference, respectively.
--               scandataout is the data output of the serial scan chain.
--
--///////////////////////////////////////////////////////////////////////////
LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE STD.TEXTIO.all;
USE work.MF_pllpack.all;
USE work.MF_ttn_mn_cntr;
USE work.MF_ttn_scale_cntr;
USE work.dffp;
USE work.MF_pll_reg;

-- New Features : The list below outlines key new features in TITAN:
--                1. Dynamic Phase Reconfiguration
--                2. Dynamic PLL Reconfiguration (different protocol)
--                3. More output counters

ENTITY MF_stratixiii_pll is
    GENERIC (
        operation_mode              : string := "normal";
        pll_type                    : string := "auto";  -- AUTO/FAST/ENHANCED/LEFT_RIGHT/TOP_BOTTOM
        compensate_clock            : string := "clock0";
        
        inclk0_input_frequency      : integer := 0;
        inclk1_input_frequency      : integer := 0;
        
        self_reset_on_loss_lock     : string  := "off";
        switch_over_type            : string  := "auto";
        switch_over_counter         : integer := 1;
        enable_switch_over_counter  : string := "off";

        dpa_multiply_by : integer := 0;
        dpa_divide_by   : integer := 0;
        dpa_divider     : integer := 0;
        
        bandwidth                    : integer := 0;
        bandwidth_type               : string  := "auto";
        use_dc_coupling              : string  := "false";

        
        
        lock_c                      : integer := 4;
        sim_gate_lock_device_behavior : string := "off";
        lock_high                   : integer := 0;
        lock_low                    : integer := 0;
        lock_window_ui              : string := "0.05";
        lock_window                 : time := 5 ps;
        test_bypass_lock_detect     : string := "off";
        

        clk0_output_frequency       : integer := 0;
        clk0_multiply_by            : integer := 0;
        clk0_divide_by              : integer := 0;
        clk0_phase_shift            : string := "0";
        clk0_duty_cycle             : integer := 50;

        clk1_output_frequency       : integer := 0;
        clk1_multiply_by            : integer := 0;
        clk1_divide_by              : integer := 0;
        clk1_phase_shift            : string := "0";
        clk1_duty_cycle             : integer := 50;

        clk2_output_frequency       : integer := 0;
        clk2_multiply_by            : integer := 0;
        clk2_divide_by              : integer := 0;
        clk2_phase_shift            : string := "0";
        clk2_duty_cycle             : integer := 50;

        clk3_output_frequency       : integer := 0;
        clk3_multiply_by            : integer := 0;
        clk3_divide_by              : integer := 0;
        clk3_phase_shift            : string := "0";
        clk3_duty_cycle             : integer := 50;

        clk4_output_frequency       : integer := 0;
        clk4_multiply_by            : integer := 0;
        clk4_divide_by              : integer := 0;
        clk4_phase_shift            : string := "0";
        clk4_duty_cycle             : integer := 50;

        clk5_output_frequency       : integer := 0;
        clk5_multiply_by            : integer := 0;
        clk5_divide_by              : integer := 0;
        clk5_phase_shift            : string := "0";
        clk5_duty_cycle             : integer := 50;
        
        clk6_output_frequency       : integer := 0;
        clk6_multiply_by            : integer := 0;
        clk6_divide_by              : integer := 0;
        clk6_phase_shift            : string := "0";
        clk6_duty_cycle             : integer := 50;
        
        clk7_output_frequency       : integer := 0;
        clk7_multiply_by            : integer := 0;
        clk7_divide_by              : integer := 0;
        clk7_phase_shift            : string := "0";
        clk7_duty_cycle             : integer := 50;
        
        clk8_output_frequency       : integer := 0;
        clk8_multiply_by            : integer := 0;
        clk8_divide_by              : integer := 0;
        clk8_phase_shift            : string := "0";
        clk8_duty_cycle             : integer := 50;
        
        clk9_output_frequency       : integer := 0;
        clk9_multiply_by            : integer := 0;
        clk9_divide_by              : integer := 0;
        clk9_phase_shift            : string := "0";
        clk9_duty_cycle             : integer := 50;
        

        pfd_min                     : integer := 0;
        pfd_max                     : integer := 0;
        vco_min                     : integer := 0;
        vco_max                     : integer := 0;
        vco_center                  : integer := 0;

        -- ADVANCED USER PARAMETERS
        m_initial                   : integer := 1;
        m                           : integer := 0;
        n                           : integer := 1;

        c0_high                     : integer := 1;
        c0_low                      : integer := 1;
        c0_initial                  : integer := 1; 
        c0_mode                     : string := "bypass";
        c0_ph                       : integer := 0;

        c1_high                     : integer := 1;
        c1_low                      : integer := 1;
        c1_initial                  : integer := 1;
        c1_mode                     : string := "bypass";
        c1_ph                       : integer := 0;

        c2_high                     : integer := 1;
        c2_low                      : integer := 1;
        c2_initial                  : integer := 1;
        c2_mode                     : string := "bypass";
        c2_ph                       : integer := 0;

        c3_high                     : integer := 1;
        c3_low                      : integer := 1;
        c3_initial                  : integer := 1;
        c3_mode                     : string := "bypass";
        c3_ph                       : integer := 0;

        c4_high                     : integer := 1;
        c4_low                      : integer := 1;
        c4_initial                  : integer := 1;
        c4_mode                     : string := "bypass";
        c4_ph                       : integer := 0;
        
        c5_high                     : integer := 1;
        c5_low                      : integer := 1;
        c5_initial                  : integer := 1;
        c5_mode                     : string := "bypass";
        c5_ph                       : integer := 0;
        
        c6_high                     : integer := 1;
        c6_low                      : integer := 1;
        c6_initial                  : integer := 1;
        c6_mode                     : string := "bypass";
        c6_ph                       : integer := 0;
        
        c7_high                     : integer := 1;
        c7_low                      : integer := 1;
        c7_initial                  : integer := 1;
        c7_mode                     : string := "bypass";
        c7_ph                       : integer := 0;
        
        c8_high                     : integer := 1;
        c8_low                      : integer := 1;
        c8_initial                  : integer := 1;
        c8_mode                     : string := "bypass";
        c8_ph                       : integer := 0;
        
        c9_high                     : integer := 1;
        c9_low                      : integer := 1;
        c9_initial                  : integer := 1;
        c9_mode                     : string := "bypass";
        c9_ph                       : integer := 0;
        
        m_ph                        : integer := 0;
        
        clk0_counter                : string := "unused";
        clk1_counter                : string := "unused";
        clk2_counter                : string := "unused";
        clk3_counter                : string := "unused";
        clk4_counter                : string := "unused";
        clk5_counter                : string := "unused";
        clk6_counter                : string := "unused";
        clk7_counter                : string := "unused";
        clk8_counter                : string := "unused";
        clk9_counter                : string := "unused";
        
        c1_use_casc_in              : string := "off";
        c2_use_casc_in              : string := "off";
        c3_use_casc_in              : string := "off";
        c4_use_casc_in              : string := "off";
        c5_use_casc_in              : string := "off";
        c6_use_casc_in              : string := "off";
        c7_use_casc_in              : string := "off";
        c8_use_casc_in              : string := "off";
        c9_use_casc_in              : string := "off";
        
        m_test_source               : integer := -1;
        c0_test_source              : integer := -1;
        c1_test_source              : integer := -1;
        c2_test_source              : integer := -1;
        c3_test_source              : integer := -1;
        c4_test_source              : integer := -1;
        c5_test_source              : integer := -1;
        c6_test_source              : integer := -1;
        c7_test_source              : integer := -1;
        c8_test_source              : integer := -1;
        c9_test_source              : integer := -1;
        
        vco_multiply_by             : integer := 0;
        vco_divide_by               : integer := 0;
        vco_post_scale              : integer := 1;
        vco_frequency_control       : string  := "auto";
        vco_phase_shift_step        : integer := 0;
        
        charge_pump_current         : integer := 10;
        loop_filter_r               : string := " 1.0";
        loop_filter_c               : integer := 0;

        
        pll_compensation_delay      : integer := 0;
        simulation_type             : string := "functional";
        
        clk0_use_even_counter_mode  : string := "off";
        clk1_use_even_counter_mode  : string := "off";
        clk2_use_even_counter_mode  : string := "off";
        clk3_use_even_counter_mode  : string := "off";
        clk4_use_even_counter_mode  : string := "off";
        clk5_use_even_counter_mode  : string := "off";
        clk6_use_even_counter_mode  : string := "off";
        clk7_use_even_counter_mode  : string := "off";
        clk8_use_even_counter_mode  : string := "off";
        clk9_use_even_counter_mode  : string := "off";
        
        clk0_use_even_counter_value : string := "off";
        clk1_use_even_counter_value : string := "off";
        clk2_use_even_counter_value : string := "off";
        clk3_use_even_counter_value : string := "off";
        clk4_use_even_counter_value : string := "off";
        clk5_use_even_counter_value : string := "off";
        clk6_use_even_counter_value : string := "off";
        clk7_use_even_counter_value : string := "off";
        clk8_use_even_counter_value : string := "off";
        clk9_use_even_counter_value : string := "off";
            
-- Test only
        init_block_reset_a_count    : integer := 1;
        init_block_reset_b_count    : integer := 1;
        charge_pump_current_bits : integer := 0;
        lock_window_ui_bits : integer := 0;
        loop_filter_c_bits : integer := 0;
        loop_filter_r_bits : integer := 0;
        test_counter_c0_delay_chain_bits : integer := 0;
        test_counter_c1_delay_chain_bits : integer := 0;
        test_counter_c2_delay_chain_bits : integer := 0;
        test_counter_c3_delay_chain_bits : integer := 0;
        test_counter_c4_delay_chain_bits : integer := 0;
        test_counter_c5_delay_chain_bits : integer := 0;
        test_counter_c6_delay_chain_bits : integer := 0;
        test_counter_c7_delay_chain_bits : integer := 0;
        test_counter_c8_delay_chain_bits : integer := 0;
        test_counter_c9_delay_chain_bits : integer := 0;
        test_counter_m_delay_chain_bits : integer := 0;
        test_counter_n_delay_chain_bits : integer := 0;
        test_feedback_comp_delay_chain_bits : integer := 0;
        test_input_comp_delay_chain_bits : integer := 0;
        test_volt_reg_output_mode_bits : integer := 0;
        test_volt_reg_output_voltage_bits : integer := 0;
        test_volt_reg_test_mode : string := "false";
        vco_range_detector_high_bits : integer := -1;
        vco_range_detector_low_bits : integer := -1;
        scan_chain_mif_file : string := "";
        dpa_output_clock_phase_shift : integer := 0;
        test_counter_c3_sclk_delay_chain_bits   : integer := -1;
        test_counter_c4_sclk_delay_chain_bits   : integer := -1;
        test_counter_c5_lden_delay_chain_bits   : integer := -1;
        test_counter_c6_lden_delay_chain_bits   : integer := -1;

        auto_settings : string  := "true";     
-- Simulation only generics
        family_name                 : string  := "StratixIII";

        use_vco_bypass              : string := "false"
    );

    PORT
    (
        inclk                       : in std_logic_vector(1 downto 0);
        fbin                         : in std_logic := '0';
        fbout                        : out std_logic;
        clkswitch                   : in std_logic := '0';
        areset                      : in std_logic := '0';
        pfdena                      : in std_logic := '1';
        scandata                    : in std_logic := '0';
        scanclk                     : in std_logic := '0';
        scanclkena                  : in std_logic := '1';
        configupdate                : in std_logic := '0';
        clk                         : out std_logic_vector(9 downto 0);
        phasecounterselect          : in std_logic_vector(3 downto 0) := "0000";
        phaseupdown                 : in std_logic := '0';
        phasestep                   : in std_logic := '0';
        clkbad                      : out std_logic_vector(1 downto 0);
        activeclock                 : out std_logic;
        locked                      : out std_logic;
        scandataout                 : out std_logic;
        scandone                    : out std_logic;
        phasedone                   : out std_logic;
        vcooverrange                : out std_logic;
        vcounderrange               : out std_logic

    );
END MF_stratixiii_pll;

ARCHITECTURE vital_pll of MF_stratixiii_pll is

function get_vco_min_no_division(i_vco_post_scale : INTEGER) return INTEGER is
begin
    if (i_vco_post_scale = 1) then
        return vco_min * 2;
    else
        return vco_min;
    end if;
end;

function get_vco_max_no_division(i_vco_post_scale : INTEGER) return INTEGER is
begin
    if (i_vco_post_scale = 1) then
        return vco_max * 2;
    else
        return vco_max;
    end if;
end;

TYPE int_array is ARRAY(NATURAL RANGE <>) of integer;
TYPE str_array is ARRAY(NATURAL RANGE <>) of string(1 to 6);
TYPE str_array1 is ARRAY(NATURAL RANGE <>) of string(1 to 9);
TYPE std_logic_array is ARRAY(NATURAL RANGE <>) of std_logic;

constant VCO_MIN_NO_DIVISION   : integer := get_vco_min_no_division(vco_post_scale);
constant VCO_MAX_NO_DIVISION   : integer := get_vco_max_no_division(vco_post_scale);

-- internal advanced parameter signals
signal   i_vco_min      : integer := vco_min;
signal   i_vco_max      : integer := vco_max;
signal   i_vco_center   : integer;
signal   i_pfd_min      : integer;
signal   i_pfd_max      : integer;
    signal   c_ph_val       : int_array(0 to 9) := (OTHERS => 0);
    signal   c_ph_val_tmp   : int_array(0 to 9) := (OTHERS => 0);
    signal   c_high_val     : int_array(0 to 9) := (OTHERS => 1);
    signal   c_low_val      : int_array(0 to 9) := (OTHERS => 1);
    signal   c_initial_val  : int_array(0 to 9) := (OTHERS => 1);
    signal   c_mode_val     : str_array(0 to 9);
    signal   clk_num     : str_array(0 to 9);

-- old values
    signal   c_high_val_old : int_array(0 to 9) := (OTHERS => 1);
    signal   c_low_val_old  : int_array(0 to 9) := (OTHERS => 1);
    signal   c_ph_val_old   : int_array(0 to 9) := (OTHERS => 0);
    signal   c_mode_val_old : str_array(0 to 9);
-- hold registers
    signal   c_high_val_hold : int_array(0 to 9) := (OTHERS => 1);
    signal   c_low_val_hold  : int_array(0 to 9) := (OTHERS => 1);
    signal   c_ph_val_hold   : int_array(0 to 9) := (OTHERS => 0);
    signal   c_mode_val_hold : str_array(0 to 9);

-- temp registers
    signal   sig_c_ph_val_tmp   : int_array(0 to 9) := (OTHERS => 0);
    signal   c_ph_val_orig  : int_array(0 to 9) := (OTHERS => 0);

    signal   i_clk9_counter         : integer := 9;
    signal   i_clk8_counter         : integer := 8;
    signal   i_clk7_counter         : integer := 7;
    signal   i_clk6_counter         : integer := 6;
    signal   i_clk5_counter         : integer := 5;
signal   real_lock_high : integer := 0;
signal   i_clk4_counter         : integer := 4;
signal   i_clk3_counter         : integer := 3;
signal   i_clk2_counter         : integer := 2;
signal   i_clk1_counter         : integer := 1;
signal   i_clk0_counter         : integer := 0;
signal   i_charge_pump_current  : integer;
signal   i_loop_filter_r        : integer;

-- end internal advanced parameter signals

-- CONSTANTS
CONSTANT    SCAN_CHAIN : integer := 144;
CONSTANT    GPP_SCAN_CHAIN : integer := 234;
CONSTANT    FAST_SCAN_CHAIN : integer := 180;
    CONSTANT cntrs : str_array(9 downto 0) := ("    C9", "    C8", "    C7", "    C6", "    C5", "    C4", "    C3", "    C2", "    C1", "    C0");
CONSTANT    ss_cntrs : str_array(0 to 3) := ("     M", "    M2", "     N", "    N2");
            
CONSTANT    loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    fpll_loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    charge_pump_curr_arr : int_array(0 to 15) := (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

CONSTANT    num_phase_taps : integer := 8;
-- signals

signal    vcc : std_logic := '1';
          
signal    fbclk       : std_logic;
signal    refclk      : std_logic;
signal    vco_over    : std_logic := '0';
signal    vco_under   : std_logic := '1';

signal pll_locked : boolean := false;


    signal c_clk : std_logic_array(0 to 9);
signal vco_out : std_logic_vector(7 downto 0) := (OTHERS => '0');

-- signals to assign values to counter params
signal    m_val : integer := 1;
signal    n_val : integer := 1;
signal    m_ph_val : integer := 0;
signal    m_ph_initial : integer := 0;
signal    m_ph_val_tmp  : integer := 0;
signal    m_initial_val : integer := m_initial;
         
signal    m_mode_val : string(1 to 6) := "      ";
signal    n_mode_val : string(1 to 6) := "      ";
signal    lfc_val : integer := 0;
signal    vco_cur : integer := vco_post_scale;
signal    cp_curr_val : integer := 0;
signal    lfr_val : string(1 to 2) := "  ";
         
signal    cp_curr_old_bit_setting : integer := charge_pump_current_bits;
signal    cp_curr_val_bit_setting : std_logic_vector(2 downto 0) := (OTHERS => '0');
signal    lfr_old_bit_setting : integer := loop_filter_r_bits;
signal    lfr_val_bit_setting : std_logic_vector(4 downto 0) := (OTHERS => '0');
signal    lfc_old_bit_setting : integer := loop_filter_c_bits; 
signal    lfc_val_bit_setting : std_logic_vector(1 downto 0) := (OTHERS => '0');
         
signal    pll_reconfig_display_full_setting : boolean := FALSE; -- display full setting, change to true
-- old    values
signal    m_val_old : integer := 1;
signal    n_val_old : integer := 1;
signal    m_mode_val_old : string(1 to 6) := "      ";
signal    n_mode_val_old : string(1 to 6) := "      ";
signal    m_ph_val_old : integer := 0;
signal    lfc_old : integer := 0;
signal    vco_old : integer := 0;
signal    cp_curr_old : integer := 0;
signal    lfr_old : string(1 to 2) := "  ";
    signal num_output_cntrs : integer := 10;
signal    scanclk_period : time := 1 ps;
    signal scan_data : std_logic_vector(0 to 233) := (OTHERS => '0');


    signal clk_pfd : std_logic_vector(0 to 9);
signal    clk0_tmp : std_logic;
signal    clk1_tmp : std_logic;
signal    clk2_tmp : std_logic;
signal    clk3_tmp : std_logic;
signal    clk4_tmp : std_logic;
    signal clk5_tmp : std_logic;
    signal clk6_tmp : std_logic;
    signal clk7_tmp : std_logic;
    signal clk8_tmp : std_logic;
    signal clk9_tmp : std_logic;

signal    update_conf_latches : std_logic := '0';
signal    update_conf_latches_reg : std_logic := '0';

signal    clkin : std_logic := '0';
signal    gate_locked : std_logic := '0';
signal    pfd_locked : std_logic := '0';
signal    lock : std_logic := '0';
signal    about_to_lock : boolean := false;
signal    reconfig_err : boolean := false;

signal    inclk_c0 : std_logic;
signal    inclk_c1 : std_logic;
signal    inclk_c2 : std_logic;
signal    inclk_c3 : std_logic;
signal    inclk_c4 : std_logic;
    signal inclk_c5 : std_logic;
    signal inclk_c6 : std_logic;
    signal inclk_c7 : std_logic;
    signal inclk_c8 : std_logic;
    signal inclk_c9 : std_logic;
signal inclk_m : std_logic;
signal devpor : std_logic;
signal devclrn : std_logic;

signal inclk0_ipd : std_logic;
signal inclk1_ipd : std_logic;
signal pfdena_ipd : std_logic;
signal areset_ipd : std_logic;
signal fbin_ipd : std_logic;
signal scanclk_ipd : std_logic;
signal scanclkena_ipd, scanclkena_reg : std_logic;
signal scandata_ipd : std_logic;
signal clkswitch_ipd : std_logic;
    signal phasecounterselect_ipd : std_logic_vector(3 downto 0);
signal phaseupdown_ipd : std_logic;
signal phasestep_ipd : std_logic;
signal configupdate_ipd : std_logic;
-- registered signals

signal sig_offset : time := 0 ps;
signal sig_refclk_time : time := 0 ps;
signal sig_fbclk_period : time := 0 ps;
signal sig_vco_period_was_phase_adjusted : boolean := false;
signal sig_phase_adjust_was_scheduled : boolean := false;
signal sig_stop_vco : std_logic := '0';
signal sig_m_times_vco_period : time := 0 ps;
signal sig_new_m_times_vco_period : time := 0 ps;
signal sig_got_refclk_posedge : boolean := false;
signal sig_got_fbclk_posedge : boolean := false;
signal sig_got_second_refclk : boolean := false;

signal m_delay : integer := 0;
signal n_delay : integer := 0;

signal inclk1_tmp : std_logic := '0';


signal reset_low : std_logic := '0';

-- Phase Reconfig

    SIGNAL phasecounterselect_reg   :  std_logic_vector(3 DOWNTO 0);

SIGNAL phaseupdown_reg          :  std_logic := '0';
SIGNAL phasestep_reg            :  std_logic := '0';
SIGNAL phasestep_high_count     :  integer := 0;
SIGNAL update_phase             :  std_logic := '0';

signal scandataout_tmp : std_logic := '0';
signal scandata_in : std_logic := '0';
signal scandata_out : std_logic := '0';
signal scandone_tmp : std_logic := '1';
signal initiate_reconfig : std_logic := '0';

signal sig_refclk_period : time := (inclk0_input_frequency * 1 ps) * n;

signal schedule_vco : std_logic := '0';

signal areset_ena_sig : std_logic := '0';
signal pll_in_test_mode : boolean := false;
signal pll_has_just_been_reconfigured : boolean := false;

    signal inclk_c_from_vco : std_logic_array(0 to 9);

signal inclk_m_from_vco : std_logic;

SIGNAL inclk0_period              : time := 0 ps;
SIGNAL last_inclk0_period         : time := 0 ps;
SIGNAL last_inclk0_edge         : time := 0 ps;
SIGNAL first_inclk0_edge_detect : STD_LOGIC := '0';
SIGNAL inclk1_period              : time := 0 ps;
SIGNAL last_inclk1_period         : time := 0 ps;
SIGNAL last_inclk1_edge         : time := 0 ps;
SIGNAL first_inclk1_edge_detect : STD_LOGIC := '0';



COMPONENT MF_ttn_mn_cntr
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic;
        initial_value : IN integer := 1;
        modulus       : IN integer := 1;
        time_delay    : IN integer := 0
    );
END COMPONENT;

COMPONENT MF_ttn_scale_cntr
    PORT (
        clk            : IN std_logic;
        reset          : IN std_logic := '0';
        cout           : OUT std_logic;
        initial        : IN integer := 1;
        high           : IN integer := 1;
        low            : IN integer := 1;
        mode           : IN string := "bypass";
        ph_tap         : IN integer := 0
    );
END COMPONENT;

COMPONENT dffp

    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

COMPONENT MF_pll_reg
    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        inclk0_ipd <= inclk(0);
        inclk1_ipd <= inclk(1);
        areset_ipd <= areset;
        fbin_ipd <= fbin;
        pfdena_ipd <= pfdena;
        scanclk_ipd <= scanclk;
        scanclkena_ipd <= scanclkena;
        scandata_ipd <= scandata;
        configupdate_ipd <= configupdate;
        clkswitch_ipd <= clkswitch;
        phaseupdown_ipd <= phaseupdown;
        phasestep_ipd <= phasestep;
        phasecounterselect_ipd(0) <= phasecounterselect(0);
        phasecounterselect_ipd(1) <= phasecounterselect(1);
        phasecounterselect_ipd(2) <= phasecounterselect(2);
        phasecounterselect_ipd(3) <= phasecounterselect(3);

    end block;

inclk_m <=  fbclk when m_test_source = 0 else
            refclk when m_test_source = 1 else
            inclk_m_from_vco;

    areset_ena_sig <= areset_ipd or sig_stop_vco;

    pll_in_test_mode <= true when   (m_test_source /= -1 or c0_test_source /= -1 or
                                    c1_test_source /= -1 or c2_test_source /= -1 or
                                    c3_test_source /= -1 or c4_test_source /= -1 or
                                    c5_test_source /= -1 or c6_test_source /= -1 or 
                                    c7_test_source /= -1 or c8_test_source /= -1 or
                                    c9_test_source /= -1)
                        else
                        false;
   

    real_lock_high <= lock_high WHEN (sim_gate_lock_device_behavior = "on") ELSE 0;   
    m1 : MF_ttn_mn_cntr
        port map (  clk           => inclk_m,
                    reset         => areset_ena_sig,
                    cout          => fbclk,
                    initial_value => m_initial_val,
                    modulus       => m_val,
                    time_delay    => m_delay
                );

    -- add delta delay to inclk1 to ensure inclk0 and inclk1 are processed
    -- in different simulation deltas.
    inclk1_tmp <= inclk1_ipd;

    -- Calculate the inclk0 period
    PROCESS
    VARIABLE inclk0_period_tmp : time := 0 ps;
    BEGIN
        WAIT UNTIL (inclk0_ipd'EVENT AND inclk0_ipd = '1');
        IF (first_inclk0_edge_detect = '0') THEN
            first_inclk0_edge_detect <= '1';
        ELSE
            last_inclk0_period <= inclk0_period;
            inclk0_period_tmp  := NOW - last_inclk0_edge;
        END IF;
        last_inclk0_edge <= NOW;
        inclk0_period <= inclk0_period_tmp;
    END PROCESS;
   
   
    -- Calculate the inclk1 period
    PROCESS
    VARIABLE inclk1_period_tmp : time := 0 ps;
    BEGIN
    WAIT UNTIL (inclk1_ipd'EVENT AND inclk1_ipd = '1');
        IF (first_inclk1_edge_detect = '0') THEN
            first_inclk1_edge_detect <= '1';
        ELSE
            last_inclk1_period <= inclk1_period;
            inclk1_period_tmp  := NOW - last_inclk1_edge;
        END IF;
        last_inclk1_edge <= NOW;
        inclk1_period <= inclk1_period_tmp;
    END PROCESS;

    process (inclk0_ipd, inclk1_tmp, clkswitch_ipd)
    variable input_value : std_logic := '0';
    variable current_clock : integer := 0;
    variable clk0_count, clk1_count : integer := 0;
    variable clk0_is_bad, clk1_is_bad : std_logic := '0';
    variable primary_clk_is_bad : boolean := false;
    variable current_clk_is_bad : boolean := false;
    variable got_curr_clk_falling_edge_after_clkswitch : boolean := false;
    variable switch_over_count : integer := 0;
    variable active_clock : std_logic := '0';
    variable external_switch : boolean := false;
    variable diff_percent_period : integer := 0;
    variable buf : line;
    variable switch_clock : boolean := false;

    begin
        if (now = 0 ps) then
            if (switch_over_type = "manual" and clkswitch_ipd = '1') then
                current_clock := 1;
                active_clock := '1';
            end if;
        end if;
        if (clkswitch_ipd'event and clkswitch_ipd = '1' and switch_over_type = "auto") then
            external_switch := true;
        elsif (switch_over_type = "manual") then
            if (clkswitch_ipd'event and clkswitch_ipd = '1') then
                switch_clock := true;
            elsif (clkswitch_ipd'event and clkswitch_ipd = '0') then
                switch_clock := false;
            end if;
        end if;

        if (switch_clock = true) then
            if (inclk0_ipd'event or inclk1_tmp'event) then
                if (current_clock = 0) then
                    current_clock := 1;
                    active_clock := '1';
                    clkin <= transport inclk1_tmp;
                elsif (current_clock = 1) then
                    current_clock := 0;
                    active_clock := '0';
                    clkin <= transport inclk0_ipd;
                end if;
                switch_clock := false;
            end if;
        end if;

        -- save the current inclk event value
        if (inclk0_ipd'event) then
            input_value := inclk0_ipd;
        elsif (inclk1_tmp'event) then
            input_value := inclk1_tmp;
        end if;

        -- check if either input clk is bad
        if (inclk0_ipd'event and inclk0_ipd = '1') then
            clk0_count := clk0_count + 1;
            clk0_is_bad := '0';
            clk1_count := 0;
            if (clk0_count > 2) then
                -- no event on other clk for 2 cycles
                clk1_is_bad := '1';
                if (current_clock = 1) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;
        if (inclk1_tmp'event and inclk1_tmp = '1') then
            clk1_count := clk1_count + 1;
            clk1_is_bad := '0';
            clk0_count := 0;
            if (clk1_count > 2) then
                -- no event on other clk for 2 cycles
                clk0_is_bad := '1';
                if (current_clock = 0) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;

        -- check if the bad clk is the primary clock
        if (clk0_is_bad = '1') then
            primary_clk_is_bad := true;
        else
            primary_clk_is_bad := false;
        end if;

        -- actual switching
        if (inclk0_ipd'event and current_clock = 0) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk0_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk0_ipd;
                end if;
            else
                clkin <= transport inclk0_ipd;
            end if;
        elsif (inclk1_tmp'event and current_clock = 1) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk1_tmp = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk1_tmp;
                end if;
            else
                clkin <= transport inclk1_tmp;
            end if;
        else
            if (input_value = '1' and enable_switch_over_counter = "on" and primary_clk_is_bad) then
                switch_over_count := switch_over_count + 1;
            end if;
            if ((input_value = '0')) then
                if (external_switch and (got_curr_clk_falling_edge_after_clkswitch or current_clk_is_bad)) or (primary_clk_is_bad and clkswitch_ipd /= '1' and (enable_switch_over_counter = "off" or switch_over_count = switch_over_counter)) then
                    got_curr_clk_falling_edge_after_clkswitch := false;
                    
                    if(inclk0_period > inclk1_period) then
                        diff_percent_period := (( inclk0_period - inclk1_period ) * 100) / inclk1_period;
                    else
                        diff_percent_period := (( inclk1_period - inclk0_period ) * 100) / inclk0_period;
                    end if;
                    if((diff_percent_period > 20)and ( switch_over_type = "auto")) then
                        WRITE(buf,string'("Warning : The input clock frequencies specified for the specified PLL are too far apart for auto-switch-over feature to work properly. Please make sure that the clock frequencies are 20 percent apart for correct functionality."));
                        writeline(output, buf);
                    end if;

                    if (current_clock = 0) then
                        current_clock := 1;
                    else
                        current_clock := 0;
                    end if;
                    active_clock := not active_clock;
                    switch_over_count := 0;
                    external_switch := false;
                    current_clk_is_bad := false;
                else
                    if(switch_over_type = "auto") then
                        if(current_clock = 0 and clk0_is_bad = '1' and clk1_is_bad = '0' ) then
                            current_clock := 1;
                            active_clock := not active_clock;
                        end if;
                
                        if(current_clock = 1 and clk0_is_bad = '0' and clk1_is_bad = '1' ) then
                            current_clock := 0;
                            active_clock := not active_clock;
                        end if;
                    end if;
                end if;         
                
            end if;
        end if;

        -- schedule outputs
        clkbad(0) <= clk0_is_bad;
        clkbad(1) <= clk1_is_bad;
        activeclock <= active_clock;

    end process;


    n1 : MF_ttn_mn_cntr
        port map (
                clk           => clkin,
                reset         => areset_ipd,
                cout          => refclk,
                initial_value => n_val,
                modulus       => n_val);

inclk_c0 <= refclk when c0_test_source = 1 else
            fbclk   when c0_test_source = 0 else
            inclk_c_from_vco(0);


    c0 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c0,
                reset          => areset_ena_sig,
                cout           => c_clk(0),
                initial        => c_initial_val(0),
                high           => c_high_val(0),
                low            => c_low_val(0),
                mode           => c_mode_val(0),
                ph_tap         => c_ph_val(0));

    inclk_c1 <= refclk when c1_test_source = 1 else
                fbclk  when c1_test_source = 0 else
                c_clk(0) when c1_use_casc_in = "on" else
                inclk_c_from_vco(1);
                

    c1 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c1,
                reset          => areset_ena_sig,
                cout           => c_clk(1),
                initial        => c_initial_val(1),
                high           => c_high_val(1),
                low            => c_low_val(1),
                mode           => c_mode_val(1),
                ph_tap         => c_ph_val(1));

inclk_c2 <= refclk when c2_test_source = 1 else
            fbclk  when c2_test_source = 0 else
            c_clk(1) when c2_use_casc_in = "on" else
            inclk_c_from_vco(2);

    c2 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c2,
                reset          => areset_ena_sig,
                cout           => c_clk(2),
                initial        => c_initial_val(2),
                high           => c_high_val(2),
                low            => c_low_val(2),
                mode           => c_mode_val(2),
                ph_tap         => c_ph_val(2));


    inclk_c3 <= refclk when c3_test_source = 1 else
                fbclk  when c3_test_source = 0 else
                c_clk(2) when c3_use_casc_in = "on" else
                inclk_c_from_vco(3);
                
    c3 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c3,
                reset          => areset_ena_sig,
                cout           => c_clk(3),
                initial        => c_initial_val(3),
                high           => c_high_val(3),
                low            => c_low_val(3),
                mode           => c_mode_val(3),
                ph_tap         => c_ph_val(3));

    inclk_c4 <= refclk when c4_test_source = 1 else
                fbclk  when c4_test_source = 0 else
                c_clk(3) when (c4_use_casc_in = "on") else
                inclk_c_from_vco(4);
                
    c4 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c4,
                reset          => areset_ena_sig,
                cout           => c_clk(4),
                initial        => c_initial_val(4),
                high           => c_high_val(4),
                low            => c_low_val(4),
                mode           => c_mode_val(4),
                ph_tap         => c_ph_val(4));

    inclk_c5 <= refclk when c5_test_source = 1 else
            fbclk  when c5_test_source = 0 else
            c_clk(4) when c5_use_casc_in = "on" else
            inclk_c_from_vco(5);
            
    c5 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c5,
                reset          => areset_ena_sig,
                cout           => c_clk(5),
                initial        => c_initial_val(5),
                high           => c_high_val(5),
                low            => c_low_val(5),
                mode           => c_mode_val(5),
                ph_tap         => c_ph_val(5));

    inclk_c6 <= refclk when c6_test_source = 1 else
                fbclk  when c6_test_source = 0 else
                c_clk(5) when c6_use_casc_in = "on" else
                inclk_c_from_vco(6);
            
    c6 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c6,
                reset          => areset_ena_sig,
                cout           => c_clk(6),
                initial        => c_initial_val(6),
                high           => c_high_val(6),
                low            => c_low_val(6),
                mode           => c_mode_val(6),
                ph_tap         => c_ph_val(6));

    inclk_c7 <= refclk when c7_test_source = 1 else
                fbclk  when c7_test_source = 0 else
                c_clk(6) when c7_use_casc_in = "on" else
                inclk_c_from_vco(7);
            
    c7 : MF_ttn_scale_cntr
                port map (
                clk            => inclk_c7,
                reset          => areset_ena_sig,
                cout           => c_clk(7),
                initial        => c_initial_val(7),
                high           => c_high_val(7),
                low            => c_low_val(7),
                mode           => c_mode_val(7),
                ph_tap         => c_ph_val(7));

    inclk_c8 <= refclk when c8_test_source = 1 else
                fbclk  when c8_test_source = 0 else
                c_clk(7) when c8_use_casc_in = "on" else
                inclk_c_from_vco(8);
            
    c8 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c8,
                reset          => areset_ena_sig,
                cout           => c_clk(8),
                initial        => c_initial_val(8),
                high           => c_high_val(8),
                low            => c_low_val(8),
                mode           => c_mode_val(8),
                ph_tap         => c_ph_val(8));

    inclk_c9 <= refclk when c9_test_source = 1 else
                fbclk  when c9_test_source = 0 else
                c_clk(8) when c9_use_casc_in = "on" else
                inclk_c_from_vco(9);
            
    c9 : MF_ttn_scale_cntr
        port map (
                clk            => inclk_c9,
                reset          => areset_ena_sig,
                cout           => c_clk(9),
                initial        => c_initial_val(9),
                high           => c_high_val(9),
                low            => c_low_val(9),
                mode           => c_mode_val(9),
                ph_tap         => c_ph_val(9));
    
    process(scandone_tmp, lock)
    begin
        if (scandone_tmp'event and (scandone_tmp = '1')) then
            pll_has_just_been_reconfigured <= true;
        elsif (lock'event and (lock = '1')) then
            pll_has_just_been_reconfigured <= false;
        end if;
    end process;
    
    process(inclk_c0, inclk_c1, areset_ipd, sig_stop_vco)
    variable c0_got_first_rising_edge : boolean := false;
    variable c0_count : integer := 2;
    variable c0_initial_count : integer := 1;
    variable c0_tmp, c1_tmp : std_logic := '0';
    variable c1_got_first_rising_edge : boolean := false;
    variable c1_count : integer := 2;
    variable c1_initial_count : integer := 1;
    begin
        if (areset_ipd = '1' or sig_stop_vco = '1') then
            c0_count := 2;
            c1_count := 2;
            c0_initial_count := 1;
            c1_initial_count := 1;
            c0_got_first_rising_edge := false;
            c1_got_first_rising_edge := false;
        else
            if (not c0_got_first_rising_edge) then
                if (inclk_c0'event and inclk_c0 = '1') then
                    if (c0_initial_count = c_initial_val(0)) then
                        c0_got_first_rising_edge := true;
                    else
                        c0_initial_count := c0_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c0'event) then
                c0_count := c0_count + 1;
                if (c0_count = (c_high_val(0) + c_low_val(0)) * 2) then
                    c0_count := 1;
                end if;
            end if;
            if (inclk_c0'event and inclk_c0 = '0') then
                if (c0_count = 1) then
                    c0_tmp := '1';
                    c0_got_first_rising_edge := false;
                else
                    c0_tmp := '0';
                end if;
            end if;

            if (not c1_got_first_rising_edge) then
                if (inclk_c1'event and inclk_c1 = '1') then
                    if (c1_initial_count = c_initial_val(1)) then
                        c1_got_first_rising_edge := true;
                    else
                        c1_initial_count := c1_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c1'event) then
                c1_count := c1_count + 1;
                if (c1_count = (c_high_val(1) + c_low_val(1)) * 2) then
                    c1_count := 1;
                end if;
            end if;
            if (inclk_c1'event and inclk_c1 = '0') then
                if (c1_count = 1) then
                    c1_tmp := '1';
                    c1_got_first_rising_edge := false;
                else
                    c1_tmp := '0';
                end if;
            end if;
        end if;

    end process;

    
    locked <=   pfd_locked WHEN (test_bypass_lock_detect = "on") ELSE
                lock;


    process (scandone_tmp)
    variable buf : line;
    begin
        if (scandone_tmp'event and scandone_tmp = '1') then
            if (reconfig_err = false) then
                ASSERT false REPORT "PLL Reprogramming completed with the following values (Values in parantheses indicate values before reprogramming) :" severity note;
                write (buf, string'("    N modulus = "));
                write (buf, n_val);
                write (buf, string'(" ( "));
                write (buf, n_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M modulus = "));
                write (buf, m_val);
                write (buf, string'(" ( "));
                write (buf, m_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M ph_tap = "));
                write (buf, m_ph_val);
                write (buf, string'(" ( "));
                write (buf, m_ph_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                for i in 0 to (num_output_cntrs-1) loop
                    write (buf, clk_num(i));
                    write (buf, string'(" : "));
                    write (buf, cntrs(i));
                    write (buf, string'(" :   high = "));
                    write (buf, c_high_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_high_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   low = "));
                    write (buf, c_low_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_low_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   mode = "));
                    write (buf, c_mode_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_mode_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   phase tap = "));
                    write (buf, c_ph_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_ph_val_old(i));
                    write (buf, string'(") "));
                    writeline(output, buf);
                end loop;

                IF (pll_reconfig_display_full_setting) THEN
                write (buf, string'("    Charge Pump Current (uA) = "));
                write (buf, cp_curr_val);
                write (buf, string'(" ( "));
                write (buf, cp_curr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (pF) = "));
                write (buf, lfc_val);
                write (buf, string'(" ( "));
                write (buf, lfc_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (Kohm) = "));
                write (buf, lfr_val);
                write (buf, string'(" ( "));
                write (buf, lfr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                
                ELSE
                write (buf, string'("    Charge Pump Current  (bit setting) = "));
                write (buf, alt_conv_integer(cp_curr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, cp_curr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (bit setting)  = "));
                write (buf, alt_conv_integer(lfc_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfc_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (bit setting)  = "));
                write (buf, alt_conv_integer(lfr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                END IF;
                cp_curr_old_bit_setting <= alt_conv_integer(cp_curr_val_bit_setting);
                lfc_old_bit_setting <= alt_conv_integer(lfc_val_bit_setting);
                lfr_old_bit_setting <= alt_conv_integer(lfr_val_bit_setting);
            else ASSERT false REPORT "Errors were encountered during PLL reprogramming. Please refer to error/warning messages above." severity warning;
            end if;
        end if;
        
    end process;

    update_conf_latches <= configupdate_ipd;

    
    process (scandone_tmp,areset_ipd,update_conf_latches, c_clk(0), c_clk(1), c_clk(2), c_clk(3), c_clk(4), c_clk(5), c_clk(6), c_clk(7), c_clk(8), c_clk(9), vco_out, fbclk, scanclk_ipd)
    variable init : boolean := true;
    variable low, high : std_logic_vector(7 downto 0);
    variable low_fast, high_fast : std_logic_vector(3 downto 0);
    variable mode : string(1 to 6) := "bypass";
    variable is_error : boolean := false;
    variable m_tmp, n_tmp : std_logic_vector(8 downto 0);
    variable lfr_val_tmp : string(1 to 2) := "  ";

    variable c_high_val_tmp,c_hval : int_array(0 to 9) := (OTHERS => 1);
    variable c_low_val_tmp,c_lval  : int_array(0 to 9) := (OTHERS => 1);
    variable c_mode_val_tmp : str_array(0 to 9);
    variable m_val_tmp      : integer := 0;
    variable c0_rising_edge_transfer_done : boolean := false;
    variable c1_rising_edge_transfer_done : boolean := false;
    variable c2_rising_edge_transfer_done : boolean := false;
    variable c3_rising_edge_transfer_done : boolean := false;
    variable c4_rising_edge_transfer_done : boolean := false;
    variable c5_rising_edge_transfer_done : boolean := false;
    variable c6_rising_edge_transfer_done : boolean := false;
    variable c7_rising_edge_transfer_done : boolean := false;
    variable c8_rising_edge_transfer_done : boolean := false;
    variable c9_rising_edge_transfer_done : boolean := false;

    -- variables for scaling of multiply_by and divide_by values
    variable i_clk0_mult_by    : integer := 1;
    variable i_clk0_div_by     : integer := 1;
    variable i_clk1_mult_by    : integer := 1;
    variable i_clk1_div_by     : integer := 1;
    variable i_clk2_mult_by    : integer := 1;
    variable i_clk2_div_by     : integer := 1;
    variable i_clk3_mult_by    : integer := 1;
    variable i_clk3_div_by     : integer := 1;
    variable i_clk4_mult_by    : integer := 1;
    variable i_clk4_div_by     : integer := 1;
    variable i_clk5_mult_by    : integer := 1;
    variable i_clk5_div_by     : integer := 1;
    variable i_clk6_mult_by    : integer := 1;
    variable i_clk6_div_by     : integer := 1;
    variable i_clk7_mult_by    : integer := 1;
    variable i_clk7_div_by     : integer := 1;
    variable i_clk8_mult_by    : integer := 1;
    variable i_clk8_div_by     : integer := 1;
    variable i_clk9_mult_by    : integer := 1;
    variable i_clk9_div_by     : integer := 1;
    variable max_d_value       : integer := 1;
    variable new_multiplier    : integer := 1;
    
    -- internal variables for storing the phase shift number.(used in lvds mode only)
    variable i_clk0_phase_shift : integer := 1;
    variable i_clk1_phase_shift : integer := 1;
    variable i_clk2_phase_shift : integer := 1;

    -- user to advanced variables

    variable   max_neg_abs    : integer := 0;
    variable   i_m_initial    : integer;
    variable   i_m            : integer := 1;
    variable   i_n            : integer := 1;
    variable   i_c_high       : int_array(0 to 9);
    variable   i_c_low       : int_array(0 to 9);
    variable   i_c_initial       : int_array(0 to 9);
    variable   i_c_ph       : int_array(0 to 9);
    variable   i_c_mode       : str_array(0 to 9);
    variable   i_m_ph         : integer;
    variable   output_count   : integer;
    variable   new_divisor    : integer;

    variable clk0_cntr : string(1 to 6) := "    c0";
    variable clk1_cntr : string(1 to 6) := "    c1";
    variable clk2_cntr : string(1 to 6) := "    c2";
    variable clk3_cntr : string(1 to 6) := "    c3";
    variable clk4_cntr : string(1 to 6) := "    c4";
    variable clk5_cntr : string(1 to 6) := "    c5";
    variable clk6_cntr : string(1 to 6) := "    c6";
    variable clk7_cntr : string(1 to 6) := "    c7";
    variable clk8_cntr : string(1 to 6) := "    c8";
    variable clk9_cntr : string(1 to 6) := "    c9";

    variable fbk_cntr : string(1 to 2);
    variable fbk_cntr_index : integer;
    variable start_bit : integer;
    variable quiet_time : time := 0 ps;
    variable slowest_clk_old : time := 0 ps;
    variable slowest_clk_new : time := 0 ps;

    variable i : integer := 0;
    variable j : integer := 0;
    variable scanread_active_edge : time := 0 ps;
    variable got_first_scanclk : boolean := false;
    variable scanclk_last_rising_edge : time := 0 ps;
    variable current_scan_data : std_logic_vector(0 to 233) := (OTHERS => '0');

    variable index : integer := 0;
    variable scan_chain_length : integer := GPP_SCAN_CHAIN;
    variable tmp_rem : integer := 0;
    variable scanclk_cycles : integer := 0;
    variable lfc_tmp : std_logic_vector(1 downto 0);
    variable lfr_tmp : std_logic_vector(5 downto 0);
    variable lfr_int : integer := 0;

    variable n_hi,n_lo,m_hi,m_lo : std_logic_vector(7 downto 0);
    variable buf : line;
    variable buf_scan_data : STD_LOGIC_VECTOR(0 TO 1) := (OTHERS => '0');
    variable buf_scan_data_2 : STD_LOGIC_VECTOR(0 TO 2) := (OTHERS => '0');
    
    function slowest_clk (
            C0 : integer; C0_mode : string(1 to 6);
            C1 : integer; C1_mode : string(1 to 6);
            C2 : integer; C2_mode : string(1 to 6);
            C3 : integer; C3_mode : string(1 to 6);
            C4 : integer; C4_mode : string(1 to 6);
            C5 : integer; C5_mode : string(1 to 6);
            C6 : integer; C6_mode : string(1 to 6);
            C7 : integer; C7_mode : string(1 to 6);
            C8 : integer; C8_mode : string(1 to 6);
            C9 : integer; C9_mode : string(1 to 6);
            refclk : time; m_mod : integer) return time is
    variable max_modulus : integer := 1;
    variable q_period : time := 0 ps;
    variable refclk_int : integer := 0;
    begin
        if (C0_mode /= "bypass" and C0_mode /= "   off") then
            max_modulus := C0;
        end if;
        if (C1 > max_modulus and C1_mode /= "bypass" and C1_mode /= "   off") then
            max_modulus := C1;
        end if;
        if (C2 > max_modulus and C2_mode /= "bypass" and C2_mode /= "   off") then
            max_modulus := C2;
        end if;
        if (C3 > max_modulus and C3_mode /= "bypass" and C3_mode /= "   off") then
            max_modulus := C3;
        end if;
        if (C4 > max_modulus and C4_mode /= "bypass" and C4_mode /= "   off") then
            max_modulus := C4;
        end if;
        if (C5 > max_modulus and C5_mode /= "bypass" and C5_mode /= "   off") then
            max_modulus := C5;
        end if;
        if (C6 > max_modulus and C6_mode /= "bypass" and C6_mode /= "   off") then
            max_modulus := C6;
        end if;
        if (C7 > max_modulus and C7_mode /= "bypass" and C7_mode /= "   off") then
            max_modulus := C7;
        end if;
        if (C8 > max_modulus and C8_mode /= "bypass" and C8_mode /= "   off") then
            max_modulus := C8;
        end if;
        if (C9 > max_modulus and C9_mode /= "bypass" and C9_mode /= "   off") then
            max_modulus := C9;
        end if;

        refclk_int := refclk / 1 ps;
        if (m_mod /= 0) then
            q_period := (refclk_int * max_modulus / m_mod) * 1 ps;
        end if;
        return (2*q_period);
    end slowest_clk;

    function int2bin (arg : integer; size : integer) return std_logic_vector is
    variable int_val : integer := arg;
    variable result : std_logic_vector(size-1 downto 0);
    begin
        for i in 0 to result'left loop
            if ((int_val mod 2) = 0) then
                result(i) := '0';
            else
                result(i) := '1';
            end if;
            int_val := int_val/2;
        end loop;
        return result;
    end int2bin;

    function extract_cntr_string (arg:string) return string is
    variable str : string(1 to 6) := "    c0";
    begin
        if (arg = "c0") then
            str := "    c0";
        elsif (arg = "c1") then
            str := "    c1";
        elsif (arg = "c2") then
            str := "    c2";
        elsif (arg = "c3") then
            str := "    c3";
        elsif (arg = "c4") then
            str := "    c4";
        elsif (arg = "c5") then
            str := "    c5";
        elsif (arg = "c6") then
            str := "    c6";
        elsif (arg = "c7") then
            str := "    c7";
        elsif (arg = "c8") then
            str := "    c8";
        elsif (arg = "c9") then
            str := "    c9";
        else str := "    c0";

        end if;

        return str;

    end extract_cntr_string;
    
    function extract_cntr_index (arg:string) return integer is
    variable index : integer := 0;
    begin
        if (arg(6) = '0') then
            index := 0;
        elsif (arg(6) = '1') then
            index := 1;
        elsif (arg(6) = '2') then
            index := 2;
        elsif (arg(6) = '3') then
            index := 3;
        elsif (arg(6) = '4') then
            index := 4;
        elsif (arg(6) = '5') then
            index := 5;
        elsif (arg(6) = '6') then
            index := 6;
        elsif (arg(6) = '7') then
            index := 7;
        elsif (arg(6) = '8') then
            index := 8;
        else index := 9;
        end if;

        return index;
    end extract_cntr_index;

    function output_cntr_num (arg:string) return string is
    variable str : string(1 to 6) := "unused";
    begin
        if (arg = "c0") then
            str := "  clk0";
        elsif (arg = "c1") then
            str := "  clk1";
        elsif (arg = "c2") then
            str := "  clk2";
        elsif (arg = "c3") then
            str := "  clk3";
        elsif (arg = "c4") then
            str := "  clk4";
        elsif (arg = "c5") then
            str := "  clk5";
        elsif (arg = "c6") then
            str := "  clk6";
        elsif (arg = "c7") then
            str := "  clk7";
        elsif (arg = "c8") then
            str := "  clk8";
        elsif (arg = "c9") then
            str := "  clk9";
        else str := "unused";
        end if;
        return str;
    end output_cntr_num;

    begin
        IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val <= i_c_ph;
        END IF;
        
        if (init) then
            if (m = 0) then
                clk9_cntr  := "    c9";
                clk8_cntr  := "    c8";
                clk7_cntr  := "    c7";
                clk6_cntr  := "    c6";
                clk5_cntr  := "    c5";
                clk4_cntr  := "    c4";
                clk3_cntr  := "    c3";
                clk2_cntr  := "    c2";
                clk1_cntr  := "    c1";
                clk0_cntr  := "    c0";
            else
                clk9_cntr  := extract_cntr_string(clk9_counter);
                clk8_cntr  := extract_cntr_string(clk8_counter);
                clk7_cntr  := extract_cntr_string(clk7_counter);
                clk6_cntr  := extract_cntr_string(clk6_counter);
                clk5_cntr  := extract_cntr_string(clk5_counter);
                clk4_cntr  := extract_cntr_string(clk4_counter);
                clk3_cntr  := extract_cntr_string(clk3_counter);
                clk2_cntr  := extract_cntr_string(clk2_counter);
                clk1_cntr  := extract_cntr_string(clk1_counter);
                clk0_cntr  := extract_cntr_string(clk0_counter);
            end if;

    clk_num(9)  <= output_cntr_num(clk9_counter);
    clk_num(8)  <= output_cntr_num(clk8_counter);
    clk_num(7)  <= output_cntr_num(clk7_counter);
    clk_num(6)  <= output_cntr_num(clk6_counter);
    clk_num(5)  <= output_cntr_num(clk5_counter);
                clk_num(4)  <= output_cntr_num(clk4_counter);
                clk_num(3)  <= output_cntr_num(clk3_counter);
                clk_num(2)  <= output_cntr_num(clk2_counter);
                clk_num(1)  <= output_cntr_num(clk1_counter);
                clk_num(0)  <= output_cntr_num(clk0_counter);
            
            i_clk0_counter <= extract_cntr_index(clk0_cntr);
            i_clk1_counter <= extract_cntr_index(clk1_cntr);
            i_clk2_counter <= extract_cntr_index(clk2_cntr);
            i_clk3_counter <= extract_cntr_index(clk3_cntr);
            i_clk4_counter <= extract_cntr_index(clk4_cntr);
            i_clk5_counter <= extract_cntr_index(clk5_cntr);
            i_clk6_counter <= extract_cntr_index(clk6_cntr);
            i_clk7_counter <= extract_cntr_index(clk7_cntr);
            i_clk8_counter <= extract_cntr_index(clk8_cntr);
            i_clk9_counter <= extract_cntr_index(clk9_cntr);


            if (m = 0) then  -- convert user parameters to advanced
                -- set the limit of the divide_by value that can be returned by
                -- the following function.
                max_d_value := 500;

                -- scale down the multiply_by and divide_by values provided by the design
                -- before attempting to use them in the calculations below
                find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                                max_d_value, i_clk0_mult_by, i_clk0_div_by);
                find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                                max_d_value, i_clk1_mult_by, i_clk1_div_by);
                find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                                max_d_value, i_clk2_mult_by, i_clk2_div_by);
                find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                                max_d_value, i_clk3_mult_by, i_clk3_div_by);
                find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                                max_d_value, i_clk4_mult_by, i_clk4_div_by);
                find_simple_integer_fraction(clk5_multiply_by, clk5_divide_by,
                                max_d_value, i_clk5_mult_by, i_clk5_div_by);
                find_simple_integer_fraction(clk6_multiply_by, clk6_divide_by,
                                max_d_value, i_clk6_mult_by, i_clk6_div_by);
                find_simple_integer_fraction(clk7_multiply_by, clk7_divide_by,
                                max_d_value, i_clk7_mult_by, i_clk7_div_by);
                find_simple_integer_fraction(clk8_multiply_by, clk8_divide_by,
                                max_d_value, i_clk8_mult_by, i_clk8_div_by);
                find_simple_integer_fraction(clk9_multiply_by, clk9_divide_by,
                                max_d_value, i_clk9_mult_by, i_clk9_div_by);
                                
                if (vco_frequency_control = "manual_phase") then
                    find_m_and_n_4_manual_phase(inclk0_input_frequency, vco_phase_shift_step,
                                i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                i_clk5_mult_by,i_clk6_mult_by,
                                i_clk7_mult_by,i_clk8_mult_by,i_clk9_mult_by,
                                i_clk0_div_by, i_clk1_div_by,
                                i_clk2_div_by, i_clk3_div_by,
                                i_clk4_div_by, 
                                i_clk5_div_by,i_clk6_div_by,
                                i_clk7_div_by,i_clk8_div_by,i_clk9_div_by,
                                clk0_counter, clk1_counter,
                                clk2_counter, clk3_counter,
                                clk4_counter, 
                                clk5_counter,clk6_counter,
                                clk7_counter,clk8_counter,clk9_counter,
                        i_m, i_n);
                elsif (((pll_type = "fast") or (pll_type = "lvds") OR (pll_type = "left_right")) and ((vco_multiply_by /= 0) and (vco_divide_by /= 0))) then
                    i_n := vco_divide_by;
                    i_m := vco_multiply_by;
                else
                    i_n := 1;

                    if (((pll_type = "fast") or (pll_type = "left_right")) and (compensate_clock = "lvdsclk")) then
                        i_m := i_clk0_mult_by;
                    else
                        i_m := lcm (i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                i_clk5_mult_by,i_clk6_mult_by,
                                i_clk7_mult_by,i_clk8_mult_by,i_clk9_mult_by,
                                inclk0_input_frequency);
                    end if;
                end if;

                if (pll_type = "flvds") then
                    -- Need to readjust phase shift values when the clock multiply value has been readjusted.
                    new_multiplier := clk0_multiply_by / i_clk0_mult_by;
                    i_clk0_phase_shift := str2int(clk0_phase_shift) * new_multiplier;
                    i_clk1_phase_shift := str2int(clk1_phase_shift) * new_multiplier;
                    i_clk2_phase_shift := str2int(clk2_phase_shift) * new_multiplier;
                else
                    i_clk0_phase_shift := str2int(clk0_phase_shift);
                    i_clk1_phase_shift := str2int(clk1_phase_shift);
                    i_clk2_phase_shift := str2int(clk2_phase_shift);
                end if;

                max_neg_abs := maxnegabs(i_clk0_phase_shift, 
                                        i_clk1_phase_shift,
                                        i_clk2_phase_shift,
                                        str2int(clk3_phase_shift),
                                        str2int(clk4_phase_shift),
                                        str2int(clk5_phase_shift),
                                        str2int(clk6_phase_shift),
                                        str2int(clk7_phase_shift),
                                        str2int(clk8_phase_shift),
                                        str2int(clk9_phase_shift)
                                        );
                i_m_ph  := counter_ph(get_phase_degree(max_neg_abs,inclk0_input_frequency), i_m, i_n); 

                i_c_ph(0) := counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(1) := counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(2) := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(3) := counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(4) := counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(5) := counter_ph(get_phase_degree(ph_adjust(str2int(clk5_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(6) := counter_ph(get_phase_degree(ph_adjust(str2int(clk6_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(7) := counter_ph(get_phase_degree(ph_adjust(str2int(clk7_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(8) := counter_ph(get_phase_degree(ph_adjust(str2int(clk8_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(9) := counter_ph(get_phase_degree(ph_adjust(str2int(clk9_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                
                
                i_c_high(0) := counter_high(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);
                i_c_high(1) := counter_high(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
                i_c_high(2) := counter_high(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                i_c_high(3) := counter_high(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
                i_c_high(4) := counter_high(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_c_high(5) := counter_high(output_counter_value(i_clk5_div_by,
                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                i_c_high(6) := counter_high(output_counter_value(i_clk6_div_by,
                                i_clk6_mult_by,  i_m, i_n), clk6_duty_cycle);

                i_c_high(7) := counter_high(output_counter_value(i_clk7_div_by,
                                i_clk7_mult_by,  i_m, i_n), clk7_duty_cycle);

                i_c_high(8) := counter_high(output_counter_value(i_clk8_div_by,
                                i_clk8_mult_by,  i_m, i_n), clk8_duty_cycle);

                i_c_high(9) := counter_high(output_counter_value(i_clk9_div_by,
                                i_clk9_mult_by,  i_m, i_n), clk9_duty_cycle);

                i_c_low(0)  := counter_low(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
                i_c_low(1)  := counter_low(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
                i_c_low(2)  := counter_low(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                i_c_low(3)  := counter_low(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
                i_c_low(4)  := counter_low(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_c_low(5)  := counter_low(output_counter_value(i_clk5_div_by,
                                i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
                i_c_low(6)  := counter_low(output_counter_value(i_clk6_div_by,
                                i_clk6_mult_by,  i_m, i_n), clk6_duty_cycle);
                i_c_low(7)  := counter_low(output_counter_value(i_clk7_div_by,
                                i_clk7_mult_by,  i_m, i_n), clk7_duty_cycle);
                i_c_low(8)  := counter_low(output_counter_value(i_clk8_div_by,
                                i_clk8_mult_by,  i_m, i_n), clk8_duty_cycle);
                i_c_low(9)  := counter_low(output_counter_value(i_clk9_div_by,
                                i_clk9_mult_by,  i_m, i_n), clk9_duty_cycle);

                i_m_initial  := counter_initial(get_phase_degree(max_neg_abs, inclk0_input_frequency), i_m,i_n);
                
                i_c_initial(0) := counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(1) := counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(2) := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(3) := counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(4) := counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(5) := counter_initial(get_phase_degree(ph_adjust(str2int(clk5_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(6) := counter_initial(get_phase_degree(ph_adjust(str2int(clk6_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(7) := counter_initial(get_phase_degree(ph_adjust(str2int(clk7_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(8) := counter_initial(get_phase_degree(ph_adjust(str2int(clk8_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(9) := counter_initial(get_phase_degree(ph_adjust(str2int(clk9_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_mode(0) := counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
                i_c_mode(1) := counter_mode(clk1_duty_cycle, output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
                i_c_mode(2) := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                i_c_mode(3) := counter_mode(clk3_duty_cycle, output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
                i_c_mode(4) := counter_mode(clk4_duty_cycle, output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));
                i_c_mode(5) := counter_mode(clk5_duty_cycle, output_counter_value(i_clk5_div_by, i_clk5_mult_by,  i_m, i_n));
                i_c_mode(6) := counter_mode(clk6_duty_cycle, output_counter_value(i_clk6_div_by, i_clk6_mult_by,  i_m, i_n));
                i_c_mode(7) := counter_mode(clk7_duty_cycle, output_counter_value(i_clk7_div_by, i_clk7_mult_by,  i_m, i_n));
                i_c_mode(8) := counter_mode(clk8_duty_cycle, output_counter_value(i_clk8_div_by, i_clk8_mult_by,  i_m, i_n));
                i_c_mode(9) := counter_mode(clk9_duty_cycle, output_counter_value(i_clk9_div_by, i_clk9_mult_by,  i_m, i_n));

                
 
            else -- m /= 0

                i_n             := n;
                i_m             := m;
                i_m_initial     := m_initial;
                i_m_ph          := m_ph;
                i_c_ph(0)         := c0_ph;
                i_c_ph(1)         := c1_ph;
                i_c_ph(2)         := c2_ph;
                i_c_ph(3)         := c3_ph;
                i_c_ph(4)         := c4_ph;
                i_c_ph(5)         := c5_ph;
                i_c_ph(6)         := c6_ph;
                i_c_ph(7)         := c7_ph;
                i_c_ph(8)         := c8_ph;
                i_c_ph(9)         := c9_ph;
                i_c_high(0)       := c0_high;
                i_c_high(1)       := c1_high;
                i_c_high(2)       := c2_high;
                i_c_high(3)       := c3_high;
                i_c_high(4)       := c4_high;
                i_c_high(5)       := c5_high;
                i_c_high(6)       := c6_high;
                i_c_high(7)       := c7_high;
                i_c_high(8)       := c8_high;
                i_c_high(9)       := c9_high;
                i_c_low(0)        := c0_low;
                i_c_low(1)        := c1_low;
                i_c_low(2)        := c2_low;
                i_c_low(3)        := c3_low;
                i_c_low(4)        := c4_low;
                i_c_low(5)        := c5_low;
                i_c_low(6)        := c6_low;
                i_c_low(7)        := c7_low;
                i_c_low(8)        := c8_low;
                i_c_low(9)        := c9_low;
                i_c_initial(0)    := c0_initial;
                i_c_initial(1)    := c1_initial;
                i_c_initial(2)    := c2_initial;
                i_c_initial(3)    := c3_initial;
                i_c_initial(4)    := c4_initial;
                i_c_initial(5)    := c5_initial;
                i_c_initial(6)    := c6_initial;
                i_c_initial(7)    := c7_initial;
                i_c_initial(8)    := c8_initial;
                i_c_initial(9)    := c9_initial;
                i_c_mode(0)       := translate_string(c0_mode);
                i_c_mode(1)       := translate_string(c1_mode);
                i_c_mode(2)       := translate_string(c2_mode);
                i_c_mode(3)       := translate_string(c3_mode);
                i_c_mode(4)       := translate_string(c4_mode);
                i_c_mode(5)       := translate_string(c5_mode);
                i_c_mode(6)       := translate_string(c6_mode);
                i_c_mode(7)       := translate_string(c7_mode);
                i_c_mode(8)       := translate_string(c8_mode);
                i_c_mode(9)       := translate_string(c9_mode);

            end if; -- user to advanced conversion.

            m_initial_val <= i_m_initial;
            n_val <= i_n;
            m_val <= i_m;

            if (i_m = 1) then
                m_mode_val <= "bypass";
            else
                m_mode_val <= "      ";
            end if;
            if (i_n = 1) then
                n_mode_val <= "bypass";
            else
                n_mode_val <= "      ";
            end if;

            m_ph_val  <= i_m_ph;
            m_ph_initial <= i_m_ph;
            m_val_tmp := i_m;

            for i in 0 to 9 loop
                if (i_c_mode(i) = "bypass") then
                    if (pll_type = "fast" or pll_type = "lvds" OR (pll_type = "left_right")) then
                        i_c_high(i) := 16;
                        i_c_low(i) := 16;
                    else
                        i_c_high(i) := 256;
                        i_c_low(i) := 256;
                    end if;
                end if;
                c_ph_val(i)         <= i_c_ph(i);
                c_initial_val(i)    <= i_c_initial(i);
                c_high_val(i)       <= i_c_high(i);
                c_low_val(i)        <= i_c_low(i);
                c_mode_val(i)       <= i_c_mode(i);
                c_high_val_tmp(i)   := i_c_high(i);
                c_hval(i)           := i_c_high(i);
                c_low_val_tmp(i)    := i_c_low(i);
                c_lval(i)           := i_c_low(i);
                c_mode_val_tmp(i)   := i_c_mode(i);
                c_ph_val_orig(i)    <= i_c_ph(i);
                c_high_val_hold(i)  <= i_c_high(i);
                c_low_val_hold(i)   <= i_c_low(i);
                c_mode_val_hold(i)  <= i_c_mode(i);
            end loop;

            

            if (pll_type = "fast" OR (pll_type = "left_right")) then
                scan_chain_length := FAST_SCAN_CHAIN;
            else
                scan_chain_length := GPP_SCAN_CHAIN;
            end if;

               
            if (pll_type = "fast" or pll_type = "lvds" OR (pll_type = "left_right")) then
                num_output_cntrs <= 7;
            else
                num_output_cntrs <= 10;
            end if;

            init := false;
        elsif (scandone_tmp'EVENT AND scandone_tmp = '1') then
            c0_rising_edge_transfer_done := false;
            c1_rising_edge_transfer_done := false;
            c2_rising_edge_transfer_done := false;
            c3_rising_edge_transfer_done := false;
            c4_rising_edge_transfer_done := false;
            c5_rising_edge_transfer_done := false;
            c6_rising_edge_transfer_done := false;
            c7_rising_edge_transfer_done := false;
            c8_rising_edge_transfer_done := false;
            c9_rising_edge_transfer_done := false;
            update_conf_latches_reg <= '0';
        elsif (update_conf_latches'event and update_conf_latches = '1') then
            initiate_reconfig <= '1';
        elsif (areset_ipd'event AND areset_ipd = '1') then
            if (scandone_tmp = '0') then scandone_tmp <= '1' AFTER scanclk_period; end if;
        elsif (scanclk_ipd'event and scanclk_ipd = '1') then
            IF (initiate_reconfig = '1') THEN
                initiate_reconfig <= '0';
                ASSERT false REPORT "PLL Reprogramming Initiated" severity note;

                update_conf_latches_reg <= update_conf_latches;
                reconfig_err <= false;
                scandone_tmp <= '0';
                cp_curr_old <= cp_curr_val;    
                lfc_old <= lfc_val;    
                lfr_old <= lfr_val;    
                vco_old <= vco_cur;   
                -- LF unused : bit 0,1
                -- LF Capacitance : bits 2,3 : all values are legal
                buf_scan_data := scan_data(2 TO 3);

                IF ((pll_type = "fast") OR (pll_type = "lvds") OR (pll_type = "left_right")) THEN
                    lfc_val <= fpll_loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                ELSE
                    lfc_val <= loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                END IF;
                -- LF Resistance : bits 4-8
                -- valid values - 00000,00100,10000,10100,11000,11011,11100,11110
                IF (scan_data(4 TO 8) = "00000") THEN
                    lfr_val <= "20";
                ELSIF (scan_data(4 TO 8) = "00100") THEN
                    lfr_val <= "16";
                ELSIF (scan_data(4 TO 8) = "10000") THEN
                    lfr_val <= "12";
                ELSIF (scan_data(4 TO 8) = "10100") THEN
                    lfr_val <= "08";
                ELSIF (scan_data(4 TO 8) = "11000") THEN
                    lfr_val <= "06";
                ELSIF (scan_data(4 TO 8) = "11011") THEN
                    lfr_val <= "04";
                ELSIF (scan_data(4 TO 8) = "11100") THEN
                    lfr_val <= "02"; 
                ELSE 
                    lfr_val <= "01";
                END IF;
            
             
                -- VCO post scale assignment   
                if (scan_data(9) = '1') then  -- vco_post_scale = 1
                    i_vco_max <= VCO_MAX_NO_DIVISION/2;
                    i_vco_min <= VCO_MIN_NO_DIVISION/2;
                    vco_cur <= 1;
                else
                    i_vco_max <= vco_max;
                    i_vco_min <= vco_min;  
                    vco_cur <= 2;
                end if;             
                -- CP
                -- Bit 9 : CRBYPASS
                -- Bit 10-14 : unused
                -- Bits 15-17 : all values are legal
        
                buf_scan_data_2 := scan_data(15 TO 17); 
                cp_curr_val <= charge_pump_curr_arr(alt_conv_integer(buf_scan_data_2));    
                -- save old values for display info.
                
                cp_curr_val_bit_setting <= scan_data(15 TO 17);
                lfc_val_bit_setting <= scan_data(2 TO 3);
                lfr_val_bit_setting <= scan_data(4 TO 8);
                
                m_val_old <= m_val;    
                n_val_old <= n_val;    
                m_mode_val_old <= m_mode_val;    
                n_mode_val_old <= n_mode_val;    
                WHILE (i < num_output_cntrs) LOOP
                    c_high_val_old(i) <= c_high_val(i);    
                    c_low_val_old(i) <= c_low_val(i);    
                    c_mode_val_old(i) <= c_mode_val(i);    
                    i := i + 1;
                END LOOP;
                -- M counter
                -- 1. Mode - bypass (bit 18)
                
                IF (scan_data(18) = '1') THEN
                    m_mode_val <= "bypass";  
                -- 3. Mode - odd/even (bit 27)
                ELSIF (scan_data(27) = '1') THEN
                    m_mode_val <= "   odd";    
                ELSE
                    m_mode_val <= "  even"; 
                END IF;
        
                -- 2. High (bit 19-26)
                
                m_hi := scan_data(19 TO 26);    
                
                -- 4. Low (bit 28-35)
                
                m_lo := scan_data(28 TO 35);    
                -- N counter
                -- 1. Mode - bypass (bit 36)
                
                IF (scan_data(36) = '1') THEN
                    n_mode_val <= "bypass"; 
                -- 3. Mode - odd/even (bit 45)
                ELSIF  (scan_data(45) = '1') THEN
                    n_mode_val <= "   odd";   
                ELSE
                    n_mode_val <= "  even";   
                END IF;
        
                -- 2. High (bit 37-44)
                
                n_hi := scan_data(37 TO 44);    
                
                -- 4. Low (bit 46-53)
                
                n_lo := scan_data(46 TO 53);    
                -- C counters (start bit 54) bit 1:mode(bypass),bit 2-9:high,bit 10:mode(odd/even),bit 11-18:low
                
                i := 0;
                WHILE (i < num_output_cntrs) LOOP
                    -- 1. Mode - bypass
                    
                    IF (scan_data(54 + i * 18 + 0) = '1') THEN
                        c_mode_val_tmp(i) := "bypass";    
                    -- 3. Mode - odd/even
                    ELSIF (scan_data(54 + i * 18 + 9) = '1') THEN
                        c_mode_val_tmp(i) := "   odd";    
                    ELSE
                        c_mode_val_tmp(i) := "  even";  
                    END IF;
                    -- 2. Hi
                    
                    high := scan_data(54 + i * 18 + 1 TO 54 + i * 18 + 8);
                    c_hval(i) := alt_conv_integer(high);
                    IF (c_hval(i) /= 0) THEN
                        c_high_val_tmp(i) := c_hval(i);
                    ELSE
                        c_high_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    
                    -- 4. Low 
                    
                    low := scan_data(54 + i * 18 + 10 TO 54 + i * 18 + 17);
                    c_lval(i) := alt_conv_integer(low);
                    IF (c_lval(i) /= 0) THEN
                        c_low_val_tmp(i) := c_lval(i);
                    ELSE
                        c_low_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    i := i + 1;
                END LOOP;
        -- Legality Checks
               
                --  M counter value
    IF(scan_data(18) /= '1') THEN
        IF ((m_hi /= m_lo) and (scan_data(27) /= '1')) THEN
                        reconfig_err <= TRUE;    
                        WRITE(buf,string'("Warning : The M counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                        writeline(output, buf);
                    ELSIF (m_hi /= "00000000") THEN
                        m_val_tmp := alt_conv_integer(m_hi) + alt_conv_integer(m_lo);    
                    ELSE
                        m_val_tmp := alt_conv_integer("000000001");
                    END IF;
                ELSE
                    m_val_tmp := alt_conv_integer("10000000");
                END IF;
                -- N counter value
    IF(scan_data(36) /= '1') THEN
        IF ((n_hi /= n_lo)and (scan_data(45) /= '1')) THEN
                    reconfig_err <= TRUE;    
                    WRITE(buf,string'("Warning : The N counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                    writeline(output, buf);
                ELSIF (n_hi /= "00000000") THEN
                    n_val <= alt_conv_integer(n_hi) + alt_conv_integer(n_lo);    
                ELSE
                    n_val <= alt_conv_integer("000000001");
                END IF;
                ELSE
                    n_val <= alt_conv_integer("10000000");
                END IF;
                -- TODO : Give warnings/errors in the following cases?
                -- 1. Illegal counter values (error)
                -- 2. Change of mode (warning)
                -- 3. Only 50% duty cycle allowed for M counter (odd mode - hi-lo=1,even - hi-lo=0)
                
            END IF;
        end if;

        
        if (fbclk'event and fbclk = '1') then
            m_val <= m_val_tmp;
        end if;
        
        if (update_conf_latches_reg = '1') then
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c0_rising_edge_transfer_done := true;
                c_high_val(0) <= c_high_val_tmp(0);
                c_mode_val(0) <= c_mode_val_tmp(0);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c1_rising_edge_transfer_done := true;
                c_high_val(1) <= c_high_val_tmp(1);
                c_mode_val(1) <= c_mode_val_tmp(1);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c2_rising_edge_transfer_done := true;
                c_high_val(2) <= c_high_val_tmp(2);
                c_mode_val(2) <= c_mode_val_tmp(2);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(3) <= c_high_val_tmp(3);
                c_mode_val(3) <= c_mode_val_tmp(3);
                c3_rising_edge_transfer_done := true;
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(4) <= c_high_val_tmp(4);
                c_mode_val(4) <= c_mode_val_tmp(4);
                c4_rising_edge_transfer_done := true;
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(5) <= c_high_val_tmp(5);
                c_mode_val(5) <= c_mode_val_tmp(5);
                c5_rising_edge_transfer_done := true;
            end if;
    
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(6) <= c_high_val_tmp(6);
                c_mode_val(6) <= c_mode_val_tmp(6);
                c6_rising_edge_transfer_done := true;
            end if;
    
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(7) <= c_high_val_tmp(7);
                c_mode_val(7) <= c_mode_val_tmp(7);
                c7_rising_edge_transfer_done := true;
            end if;
    
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(8) <= c_high_val_tmp(8);
                c_mode_val(8) <= c_mode_val_tmp(8);
                c8_rising_edge_transfer_done := true;
            end if;
    
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(9) <= c_high_val_tmp(9);
                c_mode_val(9) <= c_mode_val_tmp(9);
                c9_rising_edge_transfer_done := true;
            end if;
    
        end if;

        if (scanclk_ipd'event and scanclk_ipd = '0' and c0_rising_edge_transfer_done) then
            c_low_val(0) <= c_low_val_tmp(0);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c1_rising_edge_transfer_done) then
            c_low_val(1) <= c_low_val_tmp(1);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c2_rising_edge_transfer_done) then
            c_low_val(2) <= c_low_val_tmp(2);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c3_rising_edge_transfer_done) then
            c_low_val(3) <= c_low_val_tmp(3);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c4_rising_edge_transfer_done) then
            c_low_val(4) <= c_low_val_tmp(4);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c5_rising_edge_transfer_done) then
            c_low_val(5) <= c_low_val_tmp(5);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c6_rising_edge_transfer_done) then
            c_low_val(6) <= c_low_val_tmp(6);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c7_rising_edge_transfer_done) then
            c_low_val(7) <= c_low_val_tmp(7);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c8_rising_edge_transfer_done) then
            c_low_val(8) <= c_low_val_tmp(8);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c9_rising_edge_transfer_done) then
            c_low_val(9) <= c_low_val_tmp(9);
        end if;

        if (update_phase = '1') then
            if (vco_out(0)'event and vco_out(0) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 0) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 0) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(1)'event and vco_out(1) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 1) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 1) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(2)'event and vco_out(2) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 2) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 2) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(3)'event and vco_out(3) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 3) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 3) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(4)'event and vco_out(4) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 4) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 4) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(5)'event and vco_out(5) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 5) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 5) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(6)'event and vco_out(6) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 6) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 6) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(7)'event and vco_out(7) = '0') then
                for i in 0 to 9 loop
                    if (c_ph_val(i) = 7) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 7) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
        end if;

        

        if (vco_out(0)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 0) then
                    inclk_c_from_vco(i) <= vco_out(0);
                end if;
            end loop;
            if (m_ph_val = 0) then
                inclk_m_from_vco <= vco_out(0);
            end if;
        end if;
        if (vco_out(1)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 1) then
                    inclk_c_from_vco(i) <= vco_out(1);
                end if;
            end loop;
            if (m_ph_val = 1) then
                inclk_m_from_vco <= vco_out(1);
            end if;
        end if;
        if (vco_out(2)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 2) then
                    inclk_c_from_vco(i) <= vco_out(2);
                end if;
            end loop;
            if (m_ph_val = 2) then
                inclk_m_from_vco <= vco_out(2);
            end if;
        end if;
        if (vco_out(3)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 3) then
                    inclk_c_from_vco(i) <= vco_out(3);
                end if;
            end loop;
            if (m_ph_val = 3) then
                inclk_m_from_vco <= vco_out(3);
            end if;
        end if;
        if (vco_out(4)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 4) then
                    inclk_c_from_vco(i) <= vco_out(4);
                end if;
            end loop;
            if (m_ph_val = 4) then
                inclk_m_from_vco <= vco_out(4);
            end if;
        end if;
        if (vco_out(5)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 5) then
                    inclk_c_from_vco(i) <= vco_out(5);
                end if;
            end loop;
            if (m_ph_val = 5) then
                inclk_m_from_vco <= vco_out(5);
            end if;
        end if;
        if (vco_out(6)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 6) then
                    inclk_c_from_vco(i) <= vco_out(6);
                end if;
            end loop;
            if (m_ph_val = 6) then
                inclk_m_from_vco <= vco_out(6);
            end if;
        end if;
        if (vco_out(7)'event) then
                for i in 0 to 9 loop
                if (c_ph_val(i) = 7) then
                    inclk_c_from_vco(i) <= vco_out(7);
                end if;
            end loop;
            if (m_ph_val = 7) then
                inclk_m_from_vco <= vco_out(7);
            end if;
        end if;
        


   
        if (scanclk_ipd'event AND scanclk_ipd = '0' AND now > 0 ps) then
            scanclkena_reg <= scanclkena_ipd;
            if (scanclkena_reg = '1') then
                scandata_in <= scandata_ipd;
                scandata_out <= scandataout_tmp;
            end if;
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '1' and now > 0 ps) then
            if (got_first_scanclk) then
                scanclk_period <= now - scanclk_last_rising_edge;
            else
                got_first_scanclk := true;
            end if;
            if (scanclkena_reg = '1') then
            for j in scan_chain_length - 1 downto 1 loop
                scan_data(j) <= scan_data(j-1);
            end loop;
            scan_data(0) <= scandata_in;
            end if;
            scanclk_last_rising_edge := now;
        end if;
    end process;

-- PLL Phase Reconfiguration

PROCESS(scanclk_ipd, areset_ipd,phasestep_ipd)
    VARIABLE i : INTEGER := 0;
    VARIABLE c_ph : INTEGER := 0;
    VARIABLE m_ph : INTEGER := 0;
    VARIABLE select_counter :  INTEGER := 0;
BEGIN
    IF (NOW = 0 ps) THEN
        m_ph_val_tmp <= m_ph_initial;
    END IF;
            
    -- Latch phase enable (same as phasestep) on neg edge of scan clock
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '0') THEN
        phasestep_reg <= phasestep_ipd;
    END IF;  
     
    IF (phasestep_ipd'EVENT and phasestep_ipd = '1') THEN
        IF (update_phase = '0') THEN 
            phasestep_high_count <= 0;  -- phase adjustments must be 1 cycle apart
                                        -- if not, next phasestep cycle is skipped
        END IF;
    END IF;     
    -- revert counter phase tap values to POF programmed values
    -- if PLL is reset

    IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val_tmp <= c_ph_val_orig;
            m_ph_val_tmp <= m_ph_initial;
    END IF;
    
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '1') THEN
    IF (phasestep_reg = '1') THEN
        IF (phasestep_high_count = 1) THEN
            phasecounterselect_reg <= phasecounterselect_ipd;
            phaseupdown_reg <= phaseupdown_ipd;
            -- start reconfiguration
            IF (phasecounterselect_ipd < "1100") THEN -- no counters selected 
            IF (phasecounterselect_ipd = "0000") THEN
                            i := 0;
                            WHILE (i < num_output_cntrs) LOOP
                                c_ph := c_ph_val(i);
                                IF (phaseupdown_ipd = '1') THEN
                                    c_ph := (c_ph + 1) mod num_phase_taps;
                                ELSIF (c_ph = 0) THEN
                                    c_ph := num_phase_taps - 1;
                                ELSE
                                    c_ph := (c_ph - 1) mod num_phase_taps;
                                END IF;
                                c_ph_val_tmp(i) <= c_ph;
                                i := i + 1;
                            END LOOP;
            ELSIF (phasecounterselect_ipd = "0001") THEN
                            m_ph := m_ph_val;
                            IF (phaseupdown_ipd = '1') THEN
                                m_ph := (m_ph + 1) mod num_phase_taps;
                            ELSIF (m_ph = 0) THEN
                                m_ph := num_phase_taps - 1;
                            ELSE
                                m_ph := (m_ph - 1) mod num_phase_taps;
                            END IF;
                            m_ph_val_tmp <= m_ph;
                        ELSE
                            select_counter := alt_conv_integer(phasecounterselect_ipd) - 2;
                            c_ph := c_ph_val(select_counter);
                            IF (phaseupdown_ipd = '1') THEN
                                c_ph := (c_ph + 1) mod num_phase_taps;
                            ELSIF (c_ph = 0) THEN
                                c_ph := num_phase_taps - 1;
                            ELSE
                                c_ph := (c_ph - 1) mod num_phase_taps;
                            END IF;
                                c_ph_val_tmp(select_counter) <= c_ph;
                        END IF; 
                        update_phase <= '1','0' AFTER (0.5 * scanclk_period);
                    END IF;
                END IF;
                phasestep_high_count <= phasestep_high_count + 1; 
       
        END IF;
    END IF;
END PROCESS;

    scandataout_tmp <= scan_data(FAST_SCAN_CHAIN-2) when (pll_type = "fast" or pll_type = "lvds" or pll_type = "left_right") else scan_data(GPP_SCAN_CHAIN-2);

    process (schedule_vco, areset_ipd, pfdena_ipd, refclk, fbclk)
    variable sched_time : time := 0 ps;

    TYPE time_array is ARRAY (0 to 7) of time;
    variable init : boolean := true;
    variable refclk_period : time;
    variable m_times_vco_period : time;
    variable new_m_times_vco_period : time;

    variable phase_shift : time_array := (OTHERS => 0 ps);
    variable last_phase_shift : time_array := (OTHERS => 0 ps);

    variable l_index : integer := 1;
    variable cycle_to_adjust : integer := 0;

    variable stop_vco : boolean := false;

    variable locked_tmp : std_logic := '0';
    variable pll_is_locked : boolean := false;
    variable cycles_pfd_low : integer := 0;
    variable cycles_pfd_high : integer := 0;
    variable cycles_to_lock : integer := 0;
    variable cycles_to_unlock : integer := 0;

    variable got_first_refclk : boolean := false;
    variable got_second_refclk : boolean := false;
    variable got_first_fbclk : boolean := false;

    variable refclk_time : time := 0 ps;
    variable fbclk_time : time := 0 ps;
    variable first_fbclk_time : time := 0 ps;

    variable fbclk_period : time := 0 ps;

    variable first_schedule : boolean := true;

    variable vco_val : std_logic := '0';
    variable vco_period_was_phase_adjusted : boolean := false;
    variable phase_adjust_was_scheduled : boolean := false;

    variable loop_xplier : integer;
    variable loop_initial : integer := 0;
    variable loop_ph : integer := 0;
    variable loop_time_delay : integer := 0;

    variable initial_delay : time := 0 ps;
    variable vco_per : time;
    variable tmp_rem : integer;
    variable my_rem : integer;
    variable fbk_phase : integer := 0;

    variable pull_back_M : integer := 0;
    variable total_pull_back : integer := 0;
    variable fbk_delay : integer := 0;

    variable offset : time := 0 ps;

    variable tmp_vco_per : integer := 0;
    variable high_time : time;
    variable low_time : time;

    variable got_refclk_posedge : boolean := false;
    variable got_fbclk_posedge : boolean := false;
    variable inclk_out_of_range : boolean := false;
    variable no_warn : boolean := false;

    variable ext_fbk_cntr_modulus : integer := 1;
    variable init_clks : boolean := true;
    variable pll_is_in_reset : boolean := false;
    variable buf : line;
    begin
        if (init) then

            -- jump-start the VCO
            -- add 1 ps delay to ensure all signals are updated to initial
            -- values
            schedule_vco <= transport not schedule_vco after 1 ps;

            init := false;
        end if;

        if (schedule_vco'event) then
            if (init_clks) then
                refclk_period := inclk0_input_frequency * n_val * 1 ps;

                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                init_clks := false;
            end if;
            sched_time := 0 ps;
            for i in 0 to 7 loop
                last_phase_shift(i) := phase_shift(i);
            end loop;
            cycle_to_adjust := 0;
            l_index := 1;
            m_times_vco_period := new_m_times_vco_period;
        end if;

        -- areset was asserted
        if (areset_ipd'event and areset_ipd = '1') then
            assert false report family_name & " PLL was reset" severity note;
            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;
        end if;

        if (areset_ipd = '1') then
            pll_is_in_reset := true;
            got_first_refclk := false;
            got_second_refclk := false;

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after 1 ps;
            end loop;
        end if;


        if (schedule_vco'event and (areset_ipd = '1' or stop_vco)) then

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after last_phase_shift(i);
                phase_shift(i) := 0 ps;
                last_phase_shift(i) := 0 ps;
            end loop;

            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;

            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := 0 ps;
            got_first_fbclk := false;
            fbclk_time := 0 ps;
            first_fbclk_time := 0 ps;
            fbclk_period := 0 ps;

            first_schedule := true;
            vco_val := '0';
            vco_period_was_phase_adjusted := false;
            phase_adjust_was_scheduled := false;

        elsif ((schedule_vco'event or areset_ipd'event) and areset_ipd = '0'  and (not stop_vco) and now > 0 ps) then

            -- note areset deassert time
            -- note it as refclk_time to prevent false triggering
            -- of stop_vco after areset
            if (areset_ipd'event and areset_ipd = '0' and pll_is_in_reset) then
                refclk_time := now;
                locked_tmp := '0';
            end if;

            pll_is_in_reset := false;
            -- calculate loop_xplier : this will be different from m_val
            -- in external_feedback_mode
            loop_xplier := m_val;
            loop_initial := m_initial_val - 1;
            loop_ph := m_ph_val;


            -- convert initial value to delay
            initial_delay := (loop_initial * m_times_vco_period)/loop_xplier;

            -- convert loop ph_tap to delay
            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            tmp_vco_per := (m_times_vco_period/1 ps) / loop_xplier;
            if (my_rem /= 0) then
                tmp_vco_per := tmp_vco_per + 1;
            end if;
            fbk_phase := (loop_ph * tmp_vco_per)/8;

            pull_back_M := initial_delay/1 ps + fbk_phase;

            total_pull_back := pull_back_M;

            if (simulation_type = "timing") then
                total_pull_back := total_pull_back + pll_compensation_delay;
            end if;
            while (total_pull_back > refclk_period/1 ps) loop
                total_pull_back := total_pull_back - refclk_period/1 ps;
            end loop;

            if (total_pull_back > 0) then
                offset := refclk_period - (total_pull_back * 1 ps);
            end if;
            
            fbk_delay := total_pull_back - fbk_phase;
            if (fbk_delay < 0) then
                offset := offset - (fbk_phase * 1 ps);
                fbk_delay := total_pull_back;
            end if;

            -- assign m_delay
            m_delay <= transport fbk_delay after 1 ps;

            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            for i in 1 to loop_xplier loop
                -- adjust cycles
                tmp_vco_per := (m_times_vco_period/1 ps)/loop_xplier;
                if (my_rem /= 0 and l_index <= my_rem) then
                    tmp_rem := (loop_xplier * l_index) rem my_rem;
                    cycle_to_adjust := (loop_xplier * l_index) / my_rem;
                    if (tmp_rem /= 0) then
                        cycle_to_adjust := cycle_to_adjust + 1;
                    end if;
                end if;
                if (cycle_to_adjust = i) then
                    tmp_vco_per := tmp_vco_per + 1;
                    l_index := l_index + 1;
                end if;

                -- calculate high and low periods
                vco_per := tmp_vco_per * 1 ps;
                high_time := (tmp_vco_per/2) * 1 ps;
                if (tmp_vco_per rem 2 /= 0) then
                    high_time := high_time + 1 ps;
                end if;
                low_time := vco_per - high_time;

                -- schedule the rising and falling edges
                for j in 1 to 2 loop
                    vco_val := not vco_val;
                    if (vco_val = '0') then
                        sched_time := sched_time + high_time;
                    elsif (vco_val = '1') then
                        sched_time := sched_time + low_time;
                    end if;

                    -- schedule the phase taps
                    for k in 0 to 7 loop
                        phase_shift(k) := (k * vco_per)/8;
                        if (first_schedule) then
                            vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                        else
                            vco_out(k) <= transport vco_val after (sched_time + last_phase_shift(k));
                        end if;
                    end loop;
                end loop;
            end loop;

            -- schedule once more
            if (first_schedule) then
                vco_val := not vco_val;
                if (vco_val = '0') then
                    sched_time := sched_time + high_time;
                elsif (vco_val = '1') then
                    sched_time := sched_time + low_time;
                end if;
                -- schedule the phase taps
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                    vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                end loop;
                first_schedule := false;
            end if;

            schedule_vco <= transport not schedule_vco after sched_time;

            if (vco_period_was_phase_adjusted) then
                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := true;

                vco_per := m_times_vco_period/loop_xplier;
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                end loop;
            end if;
        end if;
-- Bypass lock detect

if (refclk'event and refclk = '1' and areset_ipd = '0') then
    if (test_bypass_lock_detect = "on") then
        if (pfdena_ipd = '1') then
            cycles_pfd_low := 0;
            if (pfd_locked = '0') then
                if (cycles_pfd_high = lock_high) then
                    assert false report family_name & " PLL locked in test mode on PFD enable assertion." severity warning;
                    pfd_locked <= '1';
                end if;
                cycles_pfd_high := cycles_pfd_high + 1;
            end if;
        end if;
        
        if (pfdena_ipd = '0') then
            cycles_pfd_high := 0;
            if (pfd_locked = '1') then
                if (cycles_pfd_low = lock_low) then
                    assert false report family_name & " PLL lost lock in test mode on PFD enable de-assertion." severity warning;
                    pfd_locked <= '0';
                end if;
                cycles_pfd_low := cycles_pfd_low + 1;
            end if;
        end if;
    end if;
        
            
        if (refclk'event and refclk = '1' and areset_ipd = '0') then
            got_refclk_posedge := true;
            if (not got_first_refclk) then
                got_first_refclk := true;
            else
                got_second_refclk := true;
                refclk_period := now - refclk_time;

                -- check if incoming freq. will cause VCO range to be
                -- exceeded
                if ( (i_vco_max /= 0 and i_vco_min /= 0 and pfdena_ipd = '1') and
                    (((refclk_period/1 ps)/loop_xplier > i_vco_max) or
                    ((refclk_period/1 ps)/loop_xplier < i_vco_min)) ) then
                    if (pll_is_locked) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        if (inclk_out_of_range) then
                            pll_is_locked := false;
                            locked_tmp := '0';
                            cycles_to_lock := 0;
                            vco_period_was_phase_adjusted := false;
                            phase_adjust_was_scheduled := false;
                            assert false report family_name & " PLL lost lock." severity note;
                        end if;
                    elsif (not no_warn) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may not lock. Please use the correct frequency." severity warning;
                        no_warn := true;
                    end if;
                    inclk_out_of_range := true;
                else
                    vco_over  <= '0';
                    vco_under <= '0';
                    inclk_out_of_range := false;
                    no_warn := false;
                end if;
            end if;
        end if;

            if (stop_vco) then
                stop_vco := false;
                schedule_vco <= not schedule_vco;
            end if;

            refclk_time := now;
        else
            got_refclk_posedge := false;
        end if;

-- Update M counter value on feedback clock edge

        if (fbclk'event and fbclk = '1') then
            got_fbclk_posedge := true;
            if (not got_first_fbclk) then
                got_first_fbclk := true;
            else
                fbclk_period := now - fbclk_time;
            end if;

            -- need refclk_period here, so initialized to proper value above
            if ( ( (now - refclk_time > 1.5 * refclk_period) and pfdena_ipd = '1' and pll_is_locked) or
                ( (now - refclk_time > 5 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = false) or
                ( (now - refclk_time > 50 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = true) ) then
                stop_vco := true;
                -- reset
                got_first_refclk := false;
                got_first_fbclk := false;
                got_second_refclk := false;
                if (pll_is_locked) then
                    pll_is_locked := false;
                    locked_tmp := '0';
                    assert false report family_name & " PLL lost lock due to loss of input clock or the input clock is not detected within the allowed time frame." severity note;
                    if ((i_vco_max = 0) and (i_vco_min = 0)) then
                        assert false report "Please run timing simulation to check whether the input clock is operating within the supported VCO range or not." severity note;
                    end if;
                end if;
                cycles_to_lock := 0;
                cycles_to_unlock := 0;
                first_schedule := true;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := false;
            end if;
            fbclk_time := now;
        else
            got_fbclk_posedge := false;
        end if;

        if ((got_refclk_posedge or got_fbclk_posedge) and got_second_refclk and pfdena_ipd = '1' and (not inclk_out_of_range)) then

            -- now we know actual incoming period
            if ( abs(fbclk_time - refclk_time) <= 5 ps or
                (got_first_fbclk and abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                -- considered in phase
                if (cycles_to_lock = real_lock_high) then
                    if (not pll_is_locked) then
                        assert false report family_name & " PLL locked to incoming clock" severity note;
                    end if;
                    pll_is_locked := true;
                    locked_tmp := '1';
                    cycles_to_unlock := 0;
                end if;
                -- increment lock counter only if second part of above
                -- time check is NOT true
                if (not(abs(refclk_period - abs(fbclk_time - refclk_time)) <= lock_window)) then
                    cycles_to_lock := cycles_to_lock + 1;
                end if;

                -- adjust m_times_vco_period
                new_m_times_vco_period := refclk_period;
            else
                -- if locked, begin unlock
                if (pll_is_locked) then
                    cycles_to_unlock := cycles_to_unlock + 1;
                    if (cycles_to_unlock = lock_low) then
                        pll_is_locked := false;
                        locked_tmp := '0';
                        cycles_to_lock := 0;
                        vco_period_was_phase_adjusted := false;
                        phase_adjust_was_scheduled := false;
                        assert false report family_name & " PLL lost lock." severity note;
                        got_first_refclk := false;
                        got_first_fbclk := false;
                        got_second_refclk := false;
                    end if;
                end if;
                if ( abs(refclk_period - fbclk_period) <= 2 ps ) then
                    -- frequency is still good
                    if (now = fbclk_time and (not phase_adjust_was_scheduled)) then
                        if ( abs(fbclk_time - refclk_time) > refclk_period/2) then
                            new_m_times_vco_period := m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                            vco_period_was_phase_adjusted := true;
                        else
                            new_m_times_vco_period := m_times_vco_period - abs(fbclk_time - refclk_time);
                            vco_period_was_phase_adjusted := true;
                        end if;

                    end if;
                else
                    phase_adjust_was_scheduled := false;
                    new_m_times_vco_period := refclk_period;
                end if;
            end if;
        end if;

        if (pfdena_ipd = '0') then
            if (pll_is_locked) then
                locked_tmp := 'X';
            end if;
            pll_is_locked := false;
            cycles_to_lock := 0;
        end if;

        -- give message only at time of deassertion
        if (pfdena_ipd'event and pfdena_ipd = '0') then
            assert false report "PFDENA deasserted." severity note;
        elsif (pfdena_ipd'event and pfdena_ipd = '1') then
            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := now;
        end if;

        if (reconfig_err) then
            lock <= '0';
        else
            lock <= locked_tmp;
        end if;

        -- signal to calculate quiet_time
        sig_refclk_period <= refclk_period;

        if (stop_vco = true) then
            sig_stop_vco <= '1';
        else
            sig_stop_vco <= '0';
        end if;
        
        pll_locked <= pll_is_locked;
    end process;

    clk0_tmp <= c_clk(i_clk0_counter);
    clk_pfd(0) <= clk0_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(0)   <= clk_pfd(0) WHEN (test_bypass_lock_detect = "on") ELSE 
                clk0_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else
                'X';

    clk1_tmp <= c_clk(i_clk1_counter);
    clk_pfd(1) <= clk1_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(1)   <= clk_pfd(1) WHEN (test_bypass_lock_detect = "on") ELSE
                clk1_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk2_tmp <= c_clk(i_clk2_counter);
    clk_pfd(2) <= clk2_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(2)   <= clk_pfd(2) WHEN (test_bypass_lock_detect = "on") ELSE
                clk2_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk3_tmp <= c_clk(i_clk3_counter);
    clk_pfd(3) <= clk3_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(3)   <= clk_pfd(3) WHEN (test_bypass_lock_detect = "on") ELSE
                clk3_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk4_tmp <= c_clk(i_clk4_counter);
    clk_pfd(4) <= clk4_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(4)   <= clk_pfd(4) WHEN (test_bypass_lock_detect = "on") ELSE
                clk4_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk5_tmp <= c_clk(i_clk5_counter);
    clk_pfd(5) <= clk5_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(5)   <= clk_pfd(5) WHEN (test_bypass_lock_detect = "on") ELSE
                clk5_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';


    clk6_tmp <= c_clk(i_clk6_counter);
    clk_pfd(6) <= clk6_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(6)   <= clk_pfd(6) WHEN (test_bypass_lock_detect = "on") ELSE
                clk6_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';


    clk7_tmp <= c_clk(i_clk7_counter);
    clk_pfd(7) <= clk7_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(7)   <= clk_pfd(7) WHEN (test_bypass_lock_detect = "on") ELSE
                clk7_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';


    clk8_tmp <= c_clk(i_clk8_counter);
    clk_pfd(8) <= clk8_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(8)   <= clk_pfd(8) WHEN (test_bypass_lock_detect = "on") ELSE
                clk8_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';


    clk9_tmp <= c_clk(i_clk9_counter);
    clk_pfd(9) <= clk9_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(9)   <= clk_pfd(9) WHEN (test_bypass_lock_detect = "on") ELSE
                clk9_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';



scandataout <= scandata_out;
scandone <= NOT scandone_tmp;
phasedone <= NOT update_phase;
vcooverrange <= 'Z' WHEN (vco_range_detector_high_bits = -1) ELSE vco_over;
vcounderrange <= 'Z' WHEN (vco_range_detector_low_bits = -1) ELSE vco_under;
fbout <= fbclk;
end vital_pll;
-- END ARCHITECTURE VITAL_PLL

-- cycloneiii_msg
--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_cda_mn_cntr
--
-- Description : Simulation model for the M and N counter. This is a
--               common model for the input counter and the loop feedback
--               counter of the CycloneIII PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_arith.all;
USE IEEE.std_logic_unsigned.all;

ENTITY MF_cda_mn_cntr is
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer := 1;
            time_delay    : IN integer := 0
        );
END MF_cda_mn_cntr;

ARCHITECTURE behave of MF_cda_mn_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
            first_rising_edge := false;
            tmp_cout := clk;
        elsif (not first_rising_edge) then
            if (count < modulus) then
                count := count + 1;
            else
                count := 1;
                tmp_cout := not tmp_cout;
            end if;
        end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_cda_scale_cntr
--
-- Description : Simulation model for the output scale-down counters.
--               This is a common model for the C0, C1, C2, C3, C4 and C5
--               output counters of the StratixII PLL.
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_cda_scale_cntr is
    PORT(   clk            : IN std_logic;
            reset          : IN std_logic := '0';
            initial        : IN integer := 1;
            high           : IN integer := 1;
            low            : IN integer := 1;
            mode           : IN string := "bypass";
            ph_tap         : IN integer := 0;
            cout           : OUT std_logic
        );
END MF_cda_scale_cntr;

ARCHITECTURE behave of MF_cda_scale_cntr is
begin
    process (clk, reset)
    variable tmp_cout : std_logic := '0';
    variable count : integer := 1;
    variable output_shift_count : integer := 1;
    variable first_rising_edge : boolean := false;
    begin
        if (reset = '1') then
            count := 1;
            output_shift_count := 1;
            tmp_cout := '0';
            first_rising_edge := false;
        elsif (clk'event) then
            if (mode = "   off") then
                tmp_cout := '0';
            elsif (mode = "bypass") then
                tmp_cout := clk;
                first_rising_edge := true;
            elsif (not first_rising_edge) then
                if (clk = '1') then
                    if (output_shift_count = initial) then
                        tmp_cout := clk;
                        first_rising_edge := true;
                    else
                        output_shift_count := output_shift_count + 1;
                    end if;
                end if;
            elsif (output_shift_count < initial) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                end if;
            else
                count := count + 1;
                if (mode = "  even" and (count = (high*2) + 1)) then
                    tmp_cout := '0';
                elsif (mode = "   odd" and (count = high*2)) then
                    tmp_cout := '0';
                elsif (count = (high + low)*2 + 1) then
                    tmp_cout := '1';
                    count := 1;  -- reset count
                end if;
            end if;
        end if;
        cout <= transport tmp_cout;
    end process;

end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_cycloneiii_pll
--
-- Description : Simulation model for the StratixII PLL.
--               In the functional mode, it is also the model for the altpll
--               megafunction.
--
-- Limitations : Does not support Spread Spectrum and Bandwidth.
--
-- Outputs     : Up to 10 output clocks, each defined by its own set of
--               parameters. Locked output (active high) indicates when the
--               PLL locks. clkbad and activeclock are used for
--               clock switchover to indicate which input clock has gone
--               bad, when the clock switchover initiates and which input
--               clock is being used as the reference, respectively.
--               scandataout is the data output of the serial scan chain.
--
--///////////////////////////////////////////////////////////////////////////
LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE STD.TEXTIO.all;
USE work.MF_pllpack.all;
USE work.MF_cda_mn_cntr;
USE work.MF_cda_scale_cntr;
USE work.dffp;
USE work.MF_pll_reg;

-- New Features : The list below outlines key new features in TITAN:
--                1. Dynamic Phase Reconfiguration
--                2. Dynamic PLL Reconfiguration (different protocol)
--                3. More output counters

ENTITY MF_cycloneiii_pll is
    GENERIC (
        operation_mode              : string := "normal";
        pll_type                    : string := "auto";  -- AUTO/FAST/ENHANCED/LEFT_RIGHT/TOP_BOTTOM
        compensate_clock            : string := "clock0";
        
        inclk0_input_frequency      : integer := 0;
        inclk1_input_frequency      : integer := 0;
        
        self_reset_on_loss_lock     : string  := "off";
        switch_over_type            : string  := "auto";
        switch_over_counter         : integer := 1;
        enable_switch_over_counter  : string := "off";

        
        bandwidth                    : integer := 0;
        bandwidth_type               : string  := "auto";
        use_dc_coupling              : string  := "false";

        
        
        lock_c                      : integer := 4;
        sim_gate_lock_device_behavior : string := "off";
        lock_high                   : integer := 0;
        lock_low                    : integer := 0;
        lock_window_ui              : string := "0.05";
        lock_window                 : time := 5 ps;
        test_bypass_lock_detect     : string := "off";
        

        clk0_output_frequency       : integer := 0;
        clk0_multiply_by            : integer := 0;
        clk0_divide_by              : integer := 0;
        clk0_phase_shift            : string := "0";
        clk0_duty_cycle             : integer := 50;

        clk1_output_frequency       : integer := 0;
        clk1_multiply_by            : integer := 0;
        clk1_divide_by              : integer := 0;
        clk1_phase_shift            : string := "0";
        clk1_duty_cycle             : integer := 50;

        clk2_output_frequency       : integer := 0;
        clk2_multiply_by            : integer := 0;
        clk2_divide_by              : integer := 0;
        clk2_phase_shift            : string := "0";
        clk2_duty_cycle             : integer := 50;

        clk3_output_frequency       : integer := 0;
        clk3_multiply_by            : integer := 0;
        clk3_divide_by              : integer := 0;
        clk3_phase_shift            : string := "0";
        clk3_duty_cycle             : integer := 50;

        clk4_output_frequency       : integer := 0;
        clk4_multiply_by            : integer := 0;
        clk4_divide_by              : integer := 0;
        clk4_phase_shift            : string := "0";
        clk4_duty_cycle             : integer := 50;

        
        
        
        
        

        pfd_min                     : integer := 0;
        pfd_max                     : integer := 0;
        vco_min                     : integer := 0;
        vco_max                     : integer := 0;
        vco_center                  : integer := 0;

        -- ADVANCED USER PARAMETERS
        m_initial                   : integer := 1;
        m                           : integer := 0;
        n                           : integer := 1;

        c0_high                     : integer := 1;
        c0_low                      : integer := 1;
        c0_initial                  : integer := 1; 
        c0_mode                     : string := "bypass";
        c0_ph                       : integer := 0;

        c1_high                     : integer := 1;
        c1_low                      : integer := 1;
        c1_initial                  : integer := 1;
        c1_mode                     : string := "bypass";
        c1_ph                       : integer := 0;

        c2_high                     : integer := 1;
        c2_low                      : integer := 1;
        c2_initial                  : integer := 1;
        c2_mode                     : string := "bypass";
        c2_ph                       : integer := 0;

        c3_high                     : integer := 1;
        c3_low                      : integer := 1;
        c3_initial                  : integer := 1;
        c3_mode                     : string := "bypass";
        c3_ph                       : integer := 0;

        c4_high                     : integer := 1;
        c4_low                      : integer := 1;
        c4_initial                  : integer := 1;
        c4_mode                     : string := "bypass";
        c4_ph                       : integer := 0;
        
        
        
        
        
        
        m_ph                        : integer := 0;
        
        clk0_counter                : string := "unused";
        clk1_counter                : string := "unused";
        clk2_counter                : string := "unused";
        clk3_counter                : string := "unused";
        clk4_counter                : string := "unused";
        
        c1_use_casc_in              : string := "off";
        c2_use_casc_in              : string := "off";
        c3_use_casc_in              : string := "off";
        c4_use_casc_in              : string := "off";
        
        m_test_source               : integer := -1;
        c0_test_source              : integer := -1;
        c1_test_source              : integer := -1;
        c2_test_source              : integer := -1;
        c3_test_source              : integer := -1;
        c4_test_source              : integer := -1;
        
        vco_multiply_by             : integer := 0;
        vco_divide_by               : integer := 0;
        vco_post_scale              : integer := 1;
        vco_frequency_control       : string  := "auto";
        vco_phase_shift_step        : integer := 0;
        
        charge_pump_current         : integer := 10;
        loop_filter_r               : string := " 1.0";
        loop_filter_c               : integer := 0;

        
        pll_compensation_delay      : integer := 0;
        simulation_type             : string := "functional";
        
        clk0_use_even_counter_mode  : string := "off";
        clk1_use_even_counter_mode  : string := "off";
        clk2_use_even_counter_mode  : string := "off";
        clk3_use_even_counter_mode  : string := "off";
        clk4_use_even_counter_mode  : string := "off";
        
        clk0_use_even_counter_value : string := "off";
        clk1_use_even_counter_value : string := "off";
        clk2_use_even_counter_value : string := "off";
        clk3_use_even_counter_value : string := "off";
        clk4_use_even_counter_value : string := "off";
            
-- Test only
        init_block_reset_a_count    : integer := 1;
        init_block_reset_b_count    : integer := 1;
        charge_pump_current_bits : integer := 0;
        lock_window_ui_bits : integer := 0;
        loop_filter_c_bits : integer := 0;
        loop_filter_r_bits : integer := 0;
        test_counter_c0_delay_chain_bits : integer := 0;
        test_counter_c1_delay_chain_bits : integer := 0;
        test_counter_c2_delay_chain_bits : integer := 0;
        test_counter_c3_delay_chain_bits : integer := 0;
        test_counter_c4_delay_chain_bits : integer := 0;
        test_counter_c5_delay_chain_bits : integer := 0;
        test_counter_m_delay_chain_bits : integer := 0;
        test_counter_n_delay_chain_bits : integer := 0;
        test_feedback_comp_delay_chain_bits : integer := 0;
        test_input_comp_delay_chain_bits : integer := 0;
        test_volt_reg_output_mode_bits : integer := 0;
        test_volt_reg_output_voltage_bits : integer := 0;
        test_volt_reg_test_mode : string := "false";
        vco_range_detector_high_bits : integer := -1;
        vco_range_detector_low_bits : integer := -1;
        scan_chain_mif_file : string := "";

        auto_settings : string  := "true";     
-- Simulation only generics
        family_name                 : string  := "StratixIII";

        use_vco_bypass              : string := "false"
    );

    PORT
    (
        inclk                       : in std_logic_vector(1 downto 0);
        fbin                         : in std_logic := '0';
        fbout                        : out std_logic;
        clkswitch                   : in std_logic := '0';
        areset                      : in std_logic := '0';
        pfdena                      : in std_logic := '1';
        scandata                    : in std_logic := '0';
        scanclk                     : in std_logic := '0';
        scanclkena                  : in std_logic := '1';
        configupdate                : in std_logic := '0';
        clk                         : out std_logic_vector(4 downto 0);
        phasecounterselect          : in std_logic_vector(2 downto 0) := "000";
        phaseupdown                 : in std_logic := '0';
        phasestep                   : in std_logic := '0';
        clkbad                      : out std_logic_vector(1 downto 0);
        activeclock                 : out std_logic;
        locked                      : out std_logic;
        scandataout                 : out std_logic;
        scandone                    : out std_logic;
        phasedone                   : out std_logic;
        vcooverrange                : out std_logic;
        vcounderrange               : out std_logic

    );
END MF_cycloneiii_pll;

ARCHITECTURE vital_pll of MF_cycloneiii_pll is

function get_vco_min_no_division(i_vco_post_scale : INTEGER) return INTEGER is
begin
    if (i_vco_post_scale = 1) then
        return vco_min * 2;
    else
        return vco_min;
    end if;
end;

function get_vco_max_no_division(i_vco_post_scale : INTEGER) return INTEGER is
begin
    if (i_vco_post_scale = 1) then
        return vco_max * 2;
    else
        return vco_max;
    end if;
end;

TYPE int_array is ARRAY(NATURAL RANGE <>) of integer;
TYPE str_array is ARRAY(NATURAL RANGE <>) of string(1 to 6);
TYPE str_array1 is ARRAY(NATURAL RANGE <>) of string(1 to 9);
TYPE std_logic_array is ARRAY(NATURAL RANGE <>) of std_logic;

constant VCO_MIN_NO_DIVISION   : integer := get_vco_min_no_division(vco_post_scale);
constant VCO_MAX_NO_DIVISION   : integer := get_vco_max_no_division(vco_post_scale);

-- internal advanced parameter signals
signal   i_vco_min      : integer := vco_min;
signal   i_vco_max      : integer := vco_max;
signal   i_vco_center   : integer;
signal   i_pfd_min      : integer;
signal   i_pfd_max      : integer;
    signal   c_ph_val       : int_array(0 to 4) := (OTHERS => 0);
    signal   c_ph_val_tmp   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_high_val     : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val      : int_array(0 to 4) := (OTHERS => 1);
    signal   c_initial_val  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_mode_val     : str_array(0 to 4);
    signal   clk_num     : str_array(0 to 4);

-- old values
    signal   c_high_val_old : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val_old  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_ph_val_old   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_mode_val_old : str_array(0 to 4);
-- hold registers
    signal   c_high_val_hold : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val_hold  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_ph_val_hold   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_mode_val_hold : str_array(0 to 4);

-- temp registers
    signal   sig_c_ph_val_tmp   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_ph_val_orig  : int_array(0 to 4) := (OTHERS => 0);

signal   real_lock_high : integer := 0;
signal   i_clk4_counter         : integer := 4;
signal   i_clk3_counter         : integer := 3;
signal   i_clk2_counter         : integer := 2;
signal   i_clk1_counter         : integer := 1;
signal   i_clk0_counter         : integer := 0;
signal   i_charge_pump_current  : integer;
signal   i_loop_filter_r        : integer;

-- end internal advanced parameter signals

-- CONSTANTS
CONSTANT    SCAN_CHAIN : integer := 144;
CONSTANT    GPP_SCAN_CHAIN : integer := 234;
CONSTANT    FAST_SCAN_CHAIN : integer := 180;
    CONSTANT cntrs : str_array(4 downto 0) := ("    C4", "    C3", "    C2", "    C1", "    C0");
CONSTANT    ss_cntrs : str_array(0 to 3) := ("     M", "    M2", "     N", "    N2");
            
CONSTANT    loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    fpll_loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    charge_pump_curr_arr : int_array(0 to 15) := (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

CONSTANT    num_phase_taps : integer := 8;
-- signals

signal    vcc : std_logic := '1';
          
signal    fbclk       : std_logic;
signal    refclk      : std_logic;
signal    vco_over    : std_logic := '0';
signal    vco_under   : std_logic := '1';

signal pll_locked : boolean := false;


    signal c_clk : std_logic_array(0 to 4);
signal vco_out : std_logic_vector(7 downto 0) := (OTHERS => '0');

-- signals to assign values to counter params
signal    m_val : integer := 1;
signal    n_val : integer := 1;
signal    m_ph_val : integer := 0;
signal    m_ph_initial : integer := 0;
signal    m_ph_val_tmp  : integer := 0;
signal    m_initial_val : integer := m_initial;
         
signal    m_mode_val : string(1 to 6) := "      ";
signal    n_mode_val : string(1 to 6) := "      ";
signal    lfc_val : integer := 0;
signal    vco_cur : integer := vco_post_scale;
signal    cp_curr_val : integer := 0;
signal    lfr_val : string(1 to 2) := "  ";
         
signal    cp_curr_old_bit_setting : integer := charge_pump_current_bits;
signal    cp_curr_val_bit_setting : std_logic_vector(2 downto 0) := (OTHERS => '0');
signal    lfr_old_bit_setting : integer := loop_filter_r_bits;
signal    lfr_val_bit_setting : std_logic_vector(4 downto 0) := (OTHERS => '0');
signal    lfc_old_bit_setting : integer := loop_filter_c_bits; 
signal    lfc_val_bit_setting : std_logic_vector(1 downto 0) := (OTHERS => '0');
         
signal    pll_reconfig_display_full_setting : boolean := FALSE; -- display full setting, change to true
-- old    values
signal    m_val_old : integer := 1;
signal    n_val_old : integer := 1;
signal    m_mode_val_old : string(1 to 6) := "      ";
signal    n_mode_val_old : string(1 to 6) := "      ";
signal    m_ph_val_old : integer := 0;
signal    lfc_old : integer := 0;
signal    vco_old : integer := 0;
signal    cp_curr_old : integer := 0;
signal    lfr_old : string(1 to 2) := "  ";
    signal num_output_cntrs : integer := 5;
signal    scanclk_period : time := 1 ps;
    signal scan_data : std_logic_vector(0 to 143) := (OTHERS => '0');


    signal clk_pfd : std_logic_vector(0 to 4);
signal    clk0_tmp : std_logic;
signal    clk1_tmp : std_logic;
signal    clk2_tmp : std_logic;
signal    clk3_tmp : std_logic;
signal    clk4_tmp : std_logic;

signal    update_conf_latches : std_logic := '0';
signal    update_conf_latches_reg : std_logic := '0';

signal    clkin : std_logic := '0';
signal    gate_locked : std_logic := '0';
signal    pfd_locked : std_logic := '0';
signal    lock : std_logic := '0';
signal    about_to_lock : boolean := false;
signal    reconfig_err : boolean := false;

signal    inclk_c0 : std_logic;
signal    inclk_c1 : std_logic;
signal    inclk_c2 : std_logic;
signal    inclk_c3 : std_logic;
signal    inclk_c4 : std_logic;
signal inclk_m : std_logic;
signal devpor : std_logic;
signal devclrn : std_logic;

signal inclk0_ipd : std_logic;
signal inclk1_ipd : std_logic;
signal pfdena_ipd : std_logic;
signal areset_ipd : std_logic;
signal fbin_ipd : std_logic;
signal scanclk_ipd : std_logic;
signal scanclkena_ipd, scanclkena_reg : std_logic;
signal scandata_ipd : std_logic;
signal clkswitch_ipd : std_logic;
    signal phasecounterselect_ipd : std_logic_vector(2 downto 0);
signal phaseupdown_ipd : std_logic;
signal phasestep_ipd : std_logic;
signal configupdate_ipd : std_logic;
-- registered signals

signal sig_offset : time := 0 ps;
signal sig_refclk_time : time := 0 ps;
signal sig_fbclk_period : time := 0 ps;
signal sig_vco_period_was_phase_adjusted : boolean := false;
signal sig_phase_adjust_was_scheduled : boolean := false;
signal sig_stop_vco : std_logic := '0';
signal sig_m_times_vco_period : time := 0 ps;
signal sig_new_m_times_vco_period : time := 0 ps;
signal sig_got_refclk_posedge : boolean := false;
signal sig_got_fbclk_posedge : boolean := false;
signal sig_got_second_refclk : boolean := false;

signal m_delay : integer := 0;
signal n_delay : integer := 0;

signal inclk1_tmp : std_logic := '0';


signal reset_low : std_logic := '0';

-- Phase Reconfig

    SIGNAL phasecounterselect_reg   :  std_logic_vector(2 DOWNTO 0);

SIGNAL phaseupdown_reg          :  std_logic := '0';
SIGNAL phasestep_reg            :  std_logic := '0';
SIGNAL phasestep_high_count     :  integer := 0;
SIGNAL update_phase             :  std_logic := '0';

signal scandataout_tmp : std_logic := '0';
signal scandata_in : std_logic := '0';
signal scandata_out : std_logic := '0';
signal scandone_tmp : std_logic := '1';
signal initiate_reconfig : std_logic := '0';

signal sig_refclk_period : time := (inclk0_input_frequency * 1 ps) * n;

signal schedule_vco : std_logic := '0';

signal areset_ena_sig : std_logic := '0';
signal pll_in_test_mode : boolean := false;
signal pll_has_just_been_reconfigured : boolean := false;

    signal inclk_c_from_vco : std_logic_array(0 to 4);

signal inclk_m_from_vco : std_logic;

SIGNAL inclk0_period              : time := 0 ps;
SIGNAL last_inclk0_period         : time := 0 ps;
SIGNAL last_inclk0_edge         : time := 0 ps;
SIGNAL first_inclk0_edge_detect : STD_LOGIC := '0';
SIGNAL inclk1_period              : time := 0 ps;
SIGNAL last_inclk1_period         : time := 0 ps;
SIGNAL last_inclk1_edge         : time := 0 ps;
SIGNAL first_inclk1_edge_detect : STD_LOGIC := '0';



COMPONENT MF_cda_mn_cntr
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic;
        initial_value : IN integer := 1;
        modulus       : IN integer := 1;
        time_delay    : IN integer := 0
    );
END COMPONENT;

COMPONENT MF_cda_scale_cntr
    PORT (
        clk            : IN std_logic;
        reset          : IN std_logic := '0';
        cout           : OUT std_logic;
        initial        : IN integer := 1;
        high           : IN integer := 1;
        low            : IN integer := 1;
        mode           : IN string := "bypass";
        ph_tap         : IN integer := 0
    );
END COMPONENT;

COMPONENT dffp

    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

COMPONENT MF_pll_reg
    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        inclk0_ipd <= inclk(0);
        inclk1_ipd <= inclk(1);
        areset_ipd <= areset;
        pfdena_ipd <= pfdena;
        scanclk_ipd <= scanclk;
        scanclkena_ipd <= scanclkena;
        scandata_ipd <= scandata;
        configupdate_ipd <= configupdate;
        clkswitch_ipd <= clkswitch;
        phaseupdown_ipd <= phaseupdown;
        phasestep_ipd <= phasestep;
        phasecounterselect_ipd(0) <= phasecounterselect(0);
        phasecounterselect_ipd(1) <= phasecounterselect(1);
        phasecounterselect_ipd(2) <= phasecounterselect(2);

    end block;

inclk_m <=  fbclk when m_test_source = 0 else
            refclk when m_test_source = 1 else
            inclk_m_from_vco;

    areset_ena_sig <= areset_ipd or sig_stop_vco;

   
    pll_in_test_mode <= true when   (m_test_source /= -1 or c0_test_source /= -1 or
                                    c1_test_source /= -1 or c2_test_source /= -1 or
                                    c3_test_source /= -1 or c4_test_source /= -1)
                                    else false;

    real_lock_high <= lock_high WHEN (sim_gate_lock_device_behavior = "on") ELSE 0;   
    m1 : MF_cda_mn_cntr
        port map (  clk           => inclk_m,
                    reset         => areset_ena_sig,
                    cout          => fbclk,
                    initial_value => m_initial_val,
                    modulus       => m_val,
                    time_delay    => m_delay
                );

    -- add delta delay to inclk1 to ensure inclk0 and inclk1 are processed
    -- in different simulation deltas.
    inclk1_tmp <= inclk1_ipd;

    -- Calculate the inclk0 period
    PROCESS
    VARIABLE inclk0_period_tmp : time := 0 ps;
    BEGIN
        WAIT UNTIL (inclk0_ipd'EVENT AND inclk0_ipd = '1');
        IF (first_inclk0_edge_detect = '0') THEN
            first_inclk0_edge_detect <= '1';
        ELSE
            last_inclk0_period <= inclk0_period;
            inclk0_period_tmp  := NOW - last_inclk0_edge;
        END IF;
        last_inclk0_edge <= NOW;
        inclk0_period <= inclk0_period_tmp;
    END PROCESS;
   
   
    -- Calculate the inclk1 period
    PROCESS
    VARIABLE inclk1_period_tmp : time := 0 ps;
    BEGIN
    WAIT UNTIL (inclk1_ipd'EVENT AND inclk1_ipd = '1');
        IF (first_inclk1_edge_detect = '0') THEN
            first_inclk1_edge_detect <= '1';
        ELSE
            last_inclk1_period <= inclk1_period;
            inclk1_period_tmp  := NOW - last_inclk1_edge;
        END IF;
        last_inclk1_edge <= NOW;
        inclk1_period <= inclk1_period_tmp;
    END PROCESS;

    process (inclk0_ipd, inclk1_tmp, clkswitch_ipd)
    variable input_value : std_logic := '0';
    variable current_clock : integer := 0;
    variable clk0_count, clk1_count : integer := 0;
    variable clk0_is_bad, clk1_is_bad : std_logic := '0';
    variable primary_clk_is_bad : boolean := false;
    variable current_clk_is_bad : boolean := false;
    variable got_curr_clk_falling_edge_after_clkswitch : boolean := false;
    variable switch_over_count : integer := 0;
    variable active_clock : std_logic := '0';
    variable external_switch : boolean := false;
    variable diff_percent_period : integer := 0;
    variable buf : line;
    variable switch_clock : boolean := false;

    begin
        if (now = 0 ps) then
            if (switch_over_type = "manual" and clkswitch_ipd = '1') then
                current_clock := 1;
                active_clock := '1';
            end if;
        end if;
        if (clkswitch_ipd'event and clkswitch_ipd = '1' and switch_over_type = "auto") then
            external_switch := true;
        elsif (switch_over_type = "manual") then
            if (clkswitch_ipd'event and clkswitch_ipd = '1') then
                switch_clock := true;
            elsif (clkswitch_ipd'event and clkswitch_ipd = '0') then
                switch_clock := false;
            end if;
        end if;

        if (switch_clock = true) then
            if (inclk0_ipd'event or inclk1_tmp'event) then
                if (current_clock = 0) then
                    current_clock := 1;
                    active_clock := '1';
                    clkin <= transport inclk1_tmp;
                elsif (current_clock = 1) then
                    current_clock := 0;
                    active_clock := '0';
                    clkin <= transport inclk0_ipd;
                end if;
                switch_clock := false;
            end if;
        end if;

        -- save the current inclk event value
        if (inclk0_ipd'event) then
            input_value := inclk0_ipd;
        elsif (inclk1_tmp'event) then
            input_value := inclk1_tmp;
        end if;

        -- check if either input clk is bad
        if (inclk0_ipd'event and inclk0_ipd = '1') then
            clk0_count := clk0_count + 1;
            clk0_is_bad := '0';
            clk1_count := 0;
            if (clk0_count > 2) then
                -- no event on other clk for 2 cycles
                clk1_is_bad := '1';
                if (current_clock = 1) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;
        if (inclk1_tmp'event and inclk1_tmp = '1') then
            clk1_count := clk1_count + 1;
            clk1_is_bad := '0';
            clk0_count := 0;
            if (clk1_count > 2) then
                -- no event on other clk for 2 cycles
                clk0_is_bad := '1';
                if (current_clock = 0) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;

        -- check if the bad clk is the primary clock
        if (clk0_is_bad = '1') then
            primary_clk_is_bad := true;
        else
            primary_clk_is_bad := false;
        end if;

        -- actual switching
        if (inclk0_ipd'event and current_clock = 0) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk0_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk0_ipd;
                end if;
            else
                clkin <= transport inclk0_ipd;
            end if;
        elsif (inclk1_tmp'event and current_clock = 1) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk1_tmp = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk1_tmp;
                end if;
            else
                clkin <= transport inclk1_tmp;
            end if;
        else
            if (input_value = '1' and enable_switch_over_counter = "on" and primary_clk_is_bad) then
                switch_over_count := switch_over_count + 1;
            end if;
            if ((input_value = '0')) then
                if (external_switch and (got_curr_clk_falling_edge_after_clkswitch or current_clk_is_bad)) or (primary_clk_is_bad and clkswitch_ipd /= '1' and (enable_switch_over_counter = "off" or switch_over_count = switch_over_counter)) then
                    got_curr_clk_falling_edge_after_clkswitch := false;
                    
                    if(inclk0_period > inclk1_period) then
                        diff_percent_period := (( inclk0_period - inclk1_period ) * 100) / inclk1_period;
                    else
                        diff_percent_period := (( inclk1_period - inclk0_period ) * 100) / inclk0_period;
                    end if;
                    if((diff_percent_period > 20)and ( switch_over_type = "auto")) then
                        WRITE(buf,string'("Warning : The input clock frequencies specified for the specified PLL are too far apart for auto-switch-over feature to work properly. Please make sure that the clock frequencies are 20 percent apart for correct functionality."));
                        writeline(output, buf);
                    end if;

                    if (current_clock = 0) then
                        current_clock := 1;
                    else
                        current_clock := 0;
                    end if;
                    active_clock := not active_clock;
                    switch_over_count := 0;
                    external_switch := false;
                    current_clk_is_bad := false;
                else
                    if(switch_over_type = "auto") then
                        if(current_clock = 0 and clk0_is_bad = '1' and clk1_is_bad = '0' ) then
                            current_clock := 1;
                            active_clock := not active_clock;
                        end if;
                
                        if(current_clock = 1 and clk0_is_bad = '0' and clk1_is_bad = '1' ) then
                            current_clock := 0;
                            active_clock := not active_clock;
                        end if;
                    end if;
                end if;         
                
            end if;
        end if;

        -- schedule outputs
        clkbad(0) <= clk0_is_bad;
        clkbad(1) <= clk1_is_bad;
        activeclock <= active_clock;

    end process;


    n1 : MF_cda_mn_cntr
        port map (
                clk           => clkin,
                reset         => areset_ipd,
                cout          => refclk,
                initial_value => n_val,
                modulus       => n_val);

inclk_c0 <= refclk when c0_test_source = 1 else
            fbclk   when c0_test_source = 0 else
            inclk_c_from_vco(0);


    c0 : MF_cda_scale_cntr
        port map (
                clk            => inclk_c0,
                reset          => areset_ena_sig,
                cout           => c_clk(0),
                initial        => c_initial_val(0),
                high           => c_high_val(0),
                low            => c_low_val(0),
                mode           => c_mode_val(0),
                ph_tap         => c_ph_val(0));

    inclk_c1 <= refclk when c1_test_source = 1 else
                fbclk  when c1_test_source = 0 else
                c_clk(0) when c1_use_casc_in = "on" else
                inclk_c_from_vco(1);
                

    c1 : MF_cda_scale_cntr
        port map (
                clk            => inclk_c1,
                reset          => areset_ena_sig,
                cout           => c_clk(1),
                initial        => c_initial_val(1),
                high           => c_high_val(1),
                low            => c_low_val(1),
                mode           => c_mode_val(1),
                ph_tap         => c_ph_val(1));

inclk_c2 <= refclk when c2_test_source = 1 else
            fbclk  when c2_test_source = 0 else
            c_clk(1) when c2_use_casc_in = "on" else
            inclk_c_from_vco(2);

    c2 : MF_cda_scale_cntr
        port map (
                clk            => inclk_c2,
                reset          => areset_ena_sig,
                cout           => c_clk(2),
                initial        => c_initial_val(2),
                high           => c_high_val(2),
                low            => c_low_val(2),
                mode           => c_mode_val(2),
                ph_tap         => c_ph_val(2));


    inclk_c3 <= refclk when c3_test_source = 1 else
                fbclk  when c3_test_source = 0 else
                c_clk(2) when c3_use_casc_in = "on" else
                inclk_c_from_vco(3);
                
    c3 : MF_cda_scale_cntr
        port map (
                clk            => inclk_c3,
                reset          => areset_ena_sig,
                cout           => c_clk(3),
                initial        => c_initial_val(3),
                high           => c_high_val(3),
                low            => c_low_val(3),
                mode           => c_mode_val(3),
                ph_tap         => c_ph_val(3));

    inclk_c4 <= refclk when c4_test_source = 1 else
                fbclk  when c4_test_source = 0 else
                c_clk(3) when (c4_use_casc_in = "on") else
                inclk_c_from_vco(4);
                
    c4 : MF_cda_scale_cntr
        port map (
                clk            => inclk_c4,
                reset          => areset_ena_sig,
                cout           => c_clk(4),
                initial        => c_initial_val(4),
                high           => c_high_val(4),
                low            => c_low_val(4),
                mode           => c_mode_val(4),
                ph_tap         => c_ph_val(4));

            

            

            

            

            
    
    process(scandone_tmp, lock)
    begin
        if (scandone_tmp'event and (scandone_tmp = '1')) then
            pll_has_just_been_reconfigured <= true;
        elsif (lock'event and (lock = '1')) then
            pll_has_just_been_reconfigured <= false;
        end if;
    end process;
    
    process(inclk_c0, inclk_c1, areset_ipd, sig_stop_vco)
    variable c0_got_first_rising_edge : boolean := false;
    variable c0_count : integer := 2;
    variable c0_initial_count : integer := 1;
    variable c0_tmp, c1_tmp : std_logic := '0';
    variable c1_got_first_rising_edge : boolean := false;
    variable c1_count : integer := 2;
    variable c1_initial_count : integer := 1;
    begin
        if (areset_ipd = '1' or sig_stop_vco = '1') then
            c0_count := 2;
            c1_count := 2;
            c0_initial_count := 1;
            c1_initial_count := 1;
            c0_got_first_rising_edge := false;
            c1_got_first_rising_edge := false;
        else
            if (not c0_got_first_rising_edge) then
                if (inclk_c0'event and inclk_c0 = '1') then
                    if (c0_initial_count = c_initial_val(0)) then
                        c0_got_first_rising_edge := true;
                    else
                        c0_initial_count := c0_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c0'event) then
                c0_count := c0_count + 1;
                if (c0_count = (c_high_val(0) + c_low_val(0)) * 2) then
                    c0_count := 1;
                end if;
            end if;
            if (inclk_c0'event and inclk_c0 = '0') then
                if (c0_count = 1) then
                    c0_tmp := '1';
                    c0_got_first_rising_edge := false;
                else
                    c0_tmp := '0';
                end if;
            end if;

            if (not c1_got_first_rising_edge) then
                if (inclk_c1'event and inclk_c1 = '1') then
                    if (c1_initial_count = c_initial_val(1)) then
                        c1_got_first_rising_edge := true;
                    else
                        c1_initial_count := c1_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c1'event) then
                c1_count := c1_count + 1;
                if (c1_count = (c_high_val(1) + c_low_val(1)) * 2) then
                    c1_count := 1;
                end if;
            end if;
            if (inclk_c1'event and inclk_c1 = '0') then
                if (c1_count = 1) then
                    c1_tmp := '1';
                    c1_got_first_rising_edge := false;
                else
                    c1_tmp := '0';
                end if;
            end if;
        end if;

    end process;

    
    locked <=   pfd_locked WHEN (test_bypass_lock_detect = "on") ELSE
                lock;


    process (scandone_tmp)
    variable buf : line;
    begin
        if (scandone_tmp'event and scandone_tmp = '1') then
            if (reconfig_err = false) then
                ASSERT false REPORT "PLL Reprogramming completed with the following values (Values in parantheses indicate values before reprogramming) :" severity note;
                write (buf, string'("    N modulus = "));
                write (buf, n_val);
                write (buf, string'(" ( "));
                write (buf, n_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M modulus = "));
                write (buf, m_val);
                write (buf, string'(" ( "));
                write (buf, m_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M ph_tap = "));
                write (buf, m_ph_val);
                write (buf, string'(" ( "));
                write (buf, m_ph_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                for i in 0 to (num_output_cntrs-1) loop
                    write (buf, clk_num(i));
                    write (buf, string'(" : "));
                    write (buf, cntrs(i));
                    write (buf, string'(" :   high = "));
                    write (buf, c_high_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_high_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   low = "));
                    write (buf, c_low_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_low_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   mode = "));
                    write (buf, c_mode_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_mode_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   phase tap = "));
                    write (buf, c_ph_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_ph_val_old(i));
                    write (buf, string'(") "));
                    writeline(output, buf);
                end loop;

                IF (pll_reconfig_display_full_setting) THEN
                write (buf, string'("    Charge Pump Current (uA) = "));
                write (buf, cp_curr_val);
                write (buf, string'(" ( "));
                write (buf, cp_curr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (pF) = "));
                write (buf, lfc_val);
                write (buf, string'(" ( "));
                write (buf, lfc_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (Kohm) = "));
                write (buf, lfr_val);
                write (buf, string'(" ( "));
                write (buf, lfr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                
                ELSE
                write (buf, string'("    Charge Pump Current  (bit setting) = "));
                write (buf, alt_conv_integer(cp_curr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, cp_curr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (bit setting)  = "));
                write (buf, alt_conv_integer(lfc_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfc_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (bit setting)  = "));
                write (buf, alt_conv_integer(lfr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                END IF;
                cp_curr_old_bit_setting <= alt_conv_integer(cp_curr_val_bit_setting);
                lfc_old_bit_setting <= alt_conv_integer(lfc_val_bit_setting);
                lfr_old_bit_setting <= alt_conv_integer(lfr_val_bit_setting);
            else ASSERT false REPORT "Errors were encountered during PLL reprogramming. Please refer to error/warning messages above." severity warning;
            end if;
        end if;
        
    end process;

    update_conf_latches <= configupdate_ipd;

    
    process (scandone_tmp,areset_ipd,update_conf_latches, c_clk(0), c_clk(1), c_clk(2), c_clk(3), c_clk(4), vco_out, fbclk, scanclk_ipd)
    variable init : boolean := true;
    variable low, high : std_logic_vector(7 downto 0);
    variable low_fast, high_fast : std_logic_vector(3 downto 0);
    variable mode : string(1 to 6) := "bypass";
    variable is_error : boolean := false;
    variable m_tmp, n_tmp : std_logic_vector(8 downto 0);
    variable lfr_val_tmp : string(1 to 2) := "  ";

    variable c_high_val_tmp,c_hval : int_array(0 to 4) := (OTHERS => 1);
    variable c_low_val_tmp,c_lval  : int_array(0 to 4) := (OTHERS => 1);
    variable c_mode_val_tmp : str_array(0 to 4);
    variable m_val_tmp      : integer := 0;
    variable c0_rising_edge_transfer_done : boolean := false;
    variable c1_rising_edge_transfer_done : boolean := false;
    variable c2_rising_edge_transfer_done : boolean := false;
    variable c3_rising_edge_transfer_done : boolean := false;
    variable c4_rising_edge_transfer_done : boolean := false;

    -- variables for scaling of multiply_by and divide_by values
    variable i_clk0_mult_by    : integer := 1;
    variable i_clk0_div_by     : integer := 1;
    variable i_clk1_mult_by    : integer := 1;
    variable i_clk1_div_by     : integer := 1;
    variable i_clk2_mult_by    : integer := 1;
    variable i_clk2_div_by     : integer := 1;
    variable i_clk3_mult_by    : integer := 1;
    variable i_clk3_div_by     : integer := 1;
    variable i_clk4_mult_by    : integer := 1;
    variable i_clk4_div_by     : integer := 1;
    variable max_d_value       : integer := 1;
    variable new_multiplier    : integer := 1;
    
    -- internal variables for storing the phase shift number.(used in lvds mode only)
    variable i_clk0_phase_shift : integer := 1;
    variable i_clk1_phase_shift : integer := 1;
    variable i_clk2_phase_shift : integer := 1;

    -- user to advanced variables

    variable   max_neg_abs    : integer := 0;
    variable   i_m_initial    : integer;
    variable   i_m            : integer := 1;
    variable   i_n            : integer := 1;
    variable   i_c_high       : int_array(0 to 4);
    variable   i_c_low       : int_array(0 to 4);
    variable   i_c_initial       : int_array(0 to 4);
    variable   i_c_ph       : int_array(0 to 4);
    variable   i_c_mode       : str_array(0 to 4);
    variable   i_m_ph         : integer;
    variable   output_count   : integer;
    variable   new_divisor    : integer;

    variable clk0_cntr : string(1 to 6) := "    c0";
    variable clk1_cntr : string(1 to 6) := "    c1";
    variable clk2_cntr : string(1 to 6) := "    c2";
    variable clk3_cntr : string(1 to 6) := "    c3";
    variable clk4_cntr : string(1 to 6) := "    c4";

    variable fbk_cntr : string(1 to 2);
    variable fbk_cntr_index : integer;
    variable start_bit : integer;
    variable quiet_time : time := 0 ps;
    variable slowest_clk_old : time := 0 ps;
    variable slowest_clk_new : time := 0 ps;

    variable i : integer := 0;
    variable j : integer := 0;
    variable scanread_active_edge : time := 0 ps;
    variable got_first_scanclk : boolean := false;
    variable scanclk_last_rising_edge : time := 0 ps;
    variable current_scan_data : std_logic_vector(0 to 143) := (OTHERS => '0');

    variable index : integer := 0;
    variable scan_chain_length : integer := GPP_SCAN_CHAIN;
    variable tmp_rem : integer := 0;
    variable scanclk_cycles : integer := 0;
    variable lfc_tmp : std_logic_vector(1 downto 0);
    variable lfr_tmp : std_logic_vector(5 downto 0);
    variable lfr_int : integer := 0;

    variable n_hi,n_lo,m_hi,m_lo : std_logic_vector(7 downto 0);
    variable buf : line;
    variable buf_scan_data : STD_LOGIC_VECTOR(0 TO 1) := (OTHERS => '0');
    variable buf_scan_data_2 : STD_LOGIC_VECTOR(0 TO 2) := (OTHERS => '0');
    
    function slowest_clk (
            C0 : integer; C0_mode : string(1 to 6);
            C1 : integer; C1_mode : string(1 to 6);
            C2 : integer; C2_mode : string(1 to 6);
            C3 : integer; C3_mode : string(1 to 6);
            C4 : integer; C4_mode : string(1 to 6);
            C5 : integer; C5_mode : string(1 to 6);
            C6 : integer; C6_mode : string(1 to 6);
            C7 : integer; C7_mode : string(1 to 6);
            C8 : integer; C8_mode : string(1 to 6);
            C9 : integer; C9_mode : string(1 to 6);
            refclk : time; m_mod : integer) return time is
    variable max_modulus : integer := 1;
    variable q_period : time := 0 ps;
    variable refclk_int : integer := 0;
    begin
        if (C0_mode /= "bypass" and C0_mode /= "   off") then
            max_modulus := C0;
        end if;
        if (C1 > max_modulus and C1_mode /= "bypass" and C1_mode /= "   off") then
            max_modulus := C1;
        end if;
        if (C2 > max_modulus and C2_mode /= "bypass" and C2_mode /= "   off") then
            max_modulus := C2;
        end if;
        if (C3 > max_modulus and C3_mode /= "bypass" and C3_mode /= "   off") then
            max_modulus := C3;
        end if;
        if (C4 > max_modulus and C4_mode /= "bypass" and C4_mode /= "   off") then
            max_modulus := C4;
        end if;
        if (C5 > max_modulus and C5_mode /= "bypass" and C5_mode /= "   off") then
            max_modulus := C5;
        end if;
        if (C6 > max_modulus and C6_mode /= "bypass" and C6_mode /= "   off") then
            max_modulus := C6;
        end if;
        if (C7 > max_modulus and C7_mode /= "bypass" and C7_mode /= "   off") then
            max_modulus := C7;
        end if;
        if (C8 > max_modulus and C8_mode /= "bypass" and C8_mode /= "   off") then
            max_modulus := C8;
        end if;
        if (C9 > max_modulus and C9_mode /= "bypass" and C9_mode /= "   off") then
            max_modulus := C9;
        end if;

        refclk_int := refclk / 1 ps;
        if (m_mod /= 0) then
            q_period := (refclk_int * max_modulus / m_mod) * 1 ps;
        end if;
        return (2*q_period);
    end slowest_clk;

    function int2bin (arg : integer; size : integer) return std_logic_vector is
    variable int_val : integer := arg;
    variable result : std_logic_vector(size-1 downto 0);
    begin
        for i in 0 to result'left loop
            if ((int_val mod 2) = 0) then
                result(i) := '0';
            else
                result(i) := '1';
            end if;
            int_val := int_val/2;
        end loop;
        return result;
    end int2bin;

    function extract_cntr_string (arg:string) return string is
    variable str : string(1 to 6) := "    c0";
    begin
        if (arg = "c0") then
            str := "    c0";
        elsif (arg = "c1") then
            str := "    c1";
        elsif (arg = "c2") then
            str := "    c2";
        elsif (arg = "c3") then
            str := "    c3";
        elsif (arg = "c4") then
            str := "    c4";
        elsif (arg = "c5") then
            str := "    c5";
        elsif (arg = "c6") then
            str := "    c6";
        elsif (arg = "c7") then
            str := "    c7";
        elsif (arg = "c8") then
            str := "    c8";
        elsif (arg = "c9") then
            str := "    c9";
        else str := "    c0";

        end if;

        return str;

    end extract_cntr_string;
    
    function extract_cntr_index (arg:string) return integer is
    variable index : integer := 0;
    begin
        if (arg(6) = '0') then
            index := 0;
        elsif (arg(6) = '1') then
            index := 1;
        elsif (arg(6) = '2') then
            index := 2;
        elsif (arg(6) = '3') then
            index := 3;
        elsif (arg(6) = '4') then
            index := 4;
        elsif (arg(6) = '5') then
            index := 5;
        elsif (arg(6) = '6') then
            index := 6;
        elsif (arg(6) = '7') then
            index := 7;
        elsif (arg(6) = '8') then
            index := 8;
        else index := 9;
        end if;

        return index;
    end extract_cntr_index;

    function output_cntr_num (arg:string) return string is
    variable str : string(1 to 6) := "unused";
    begin
        if (arg = "c0") then
            str := "  clk0";
        elsif (arg = "c1") then
            str := "  clk1";
        elsif (arg = "c2") then
            str := "  clk2";
        elsif (arg = "c3") then
            str := "  clk3";
        elsif (arg = "c4") then
            str := "  clk4";
        elsif (arg = "c5") then
            str := "  clk5";
        elsif (arg = "c6") then
            str := "  clk6";
        elsif (arg = "c7") then
            str := "  clk7";
        elsif (arg = "c8") then
            str := "  clk8";
        elsif (arg = "c9") then
            str := "  clk9";
        else str := "unused";
        end if;
        return str;
    end output_cntr_num;

    begin
        IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val <= i_c_ph;
        END IF;
        
        if (init) then
            if (m = 0) then
                clk4_cntr  := "    c4";
                clk3_cntr  := "    c3";
                clk2_cntr  := "    c2";
                clk1_cntr  := "    c1";
                clk0_cntr  := "    c0";
            else
                clk4_cntr  := extract_cntr_string(clk4_counter);
                clk3_cntr  := extract_cntr_string(clk3_counter);
                clk2_cntr  := extract_cntr_string(clk2_counter);
                clk1_cntr  := extract_cntr_string(clk1_counter);
                clk0_cntr  := extract_cntr_string(clk0_counter);
            end if;

                clk_num(4)  <= output_cntr_num(clk4_counter);
                clk_num(3)  <= output_cntr_num(clk3_counter);
                clk_num(2)  <= output_cntr_num(clk2_counter);
                clk_num(1)  <= output_cntr_num(clk1_counter);
                clk_num(0)  <= output_cntr_num(clk0_counter);
            
            i_clk0_counter <= extract_cntr_index(clk0_cntr);
            i_clk1_counter <= extract_cntr_index(clk1_cntr);
            i_clk2_counter <= extract_cntr_index(clk2_cntr);
            i_clk3_counter <= extract_cntr_index(clk3_cntr);
            i_clk4_counter <= extract_cntr_index(clk4_cntr);


            if (m = 0) then  -- convert user parameters to advanced
                -- set the limit of the divide_by value that can be returned by
                -- the following function.
                max_d_value := 500;

                -- scale down the multiply_by and divide_by values provided by the design
                -- before attempting to use them in the calculations below
                find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                                max_d_value, i_clk0_mult_by, i_clk0_div_by);
                find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                                max_d_value, i_clk1_mult_by, i_clk1_div_by);
                find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                                max_d_value, i_clk2_mult_by, i_clk2_div_by);
                find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                                max_d_value, i_clk3_mult_by, i_clk3_div_by);
                find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                                max_d_value, i_clk4_mult_by, i_clk4_div_by);
                                
                if (vco_frequency_control = "manual_phase") then
                    find_m_and_n_4_manual_phase(inclk0_input_frequency, vco_phase_shift_step,
                                i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                1,1,1,1,1,
                                i_clk0_div_by, i_clk1_div_by,
                                i_clk2_div_by, i_clk3_div_by,
                                i_clk4_div_by, 
                                1,1,1,1,1,
                                clk0_counter, clk1_counter,
                                clk2_counter, clk3_counter,
                                clk4_counter, 
                                "unused","unused","unused","unused","unused",
                        i_m, i_n);
                elsif (((pll_type = "fast") or (pll_type = "lvds") OR (pll_type = "left_right")) and ((vco_multiply_by /= 0) and (vco_divide_by /= 0))) then
                    i_n := vco_divide_by;
                    i_m := vco_multiply_by;
                else
                    i_n := 1;

                    if (((pll_type = "fast") or (pll_type = "left_right")) and (compensate_clock = "lvdsclk")) then
                        i_m := i_clk0_mult_by;
                    else
                        i_m := lcm (i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                1,1,1,1,1,
                                inclk0_input_frequency);
                    end if;
                end if;

                if (pll_type = "flvds") then
                    -- Need to readjust phase shift values when the clock multiply value has been readjusted.
                    new_multiplier := clk0_multiply_by / i_clk0_mult_by;
                    i_clk0_phase_shift := str2int(clk0_phase_shift) * new_multiplier;
                    i_clk1_phase_shift := str2int(clk1_phase_shift) * new_multiplier;
                    i_clk2_phase_shift := str2int(clk2_phase_shift) * new_multiplier;
                else
                    i_clk0_phase_shift := str2int(clk0_phase_shift);
                    i_clk1_phase_shift := str2int(clk1_phase_shift);
                    i_clk2_phase_shift := str2int(clk2_phase_shift);
                end if;

                max_neg_abs := maxnegabs(i_clk0_phase_shift, 
                                        i_clk1_phase_shift,
                                        i_clk2_phase_shift,
                                        str2int(clk3_phase_shift),
                                        str2int(clk4_phase_shift),
                                        0,
                                        0,
                                        0,
                                        0,
                                        0
                                        );
                i_m_ph  := counter_ph(get_phase_degree(max_neg_abs,inclk0_input_frequency), i_m, i_n); 

                i_c_ph(0) := counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(1) := counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(2) := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(3) := counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(4) := counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                
                
                i_c_high(0) := counter_high(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);
                i_c_high(1) := counter_high(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
                i_c_high(2) := counter_high(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                i_c_high(3) := counter_high(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
                i_c_high(4) := counter_high(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);




                i_c_low(0)  := counter_low(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
                i_c_low(1)  := counter_low(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
                i_c_low(2)  := counter_low(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                i_c_low(3)  := counter_low(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
                i_c_low(4)  := counter_low(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);

                i_m_initial  := counter_initial(get_phase_degree(max_neg_abs, inclk0_input_frequency), i_m,i_n);
                
                i_c_initial(0) := counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(1) := counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(2) := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(3) := counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(4) := counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_mode(0) := counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
                i_c_mode(1) := counter_mode(clk1_duty_cycle, output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
                i_c_mode(2) := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                i_c_mode(3) := counter_mode(clk3_duty_cycle, output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
                i_c_mode(4) := counter_mode(clk4_duty_cycle, output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));

                
 
            else -- m /= 0

                i_n             := n;
                i_m             := m;
                i_m_initial     := m_initial;
                i_m_ph          := m_ph;
                i_c_ph(0)         := c0_ph;
                i_c_ph(1)         := c1_ph;
                i_c_ph(2)         := c2_ph;
                i_c_ph(3)         := c3_ph;
                i_c_ph(4)         := c4_ph;
                i_c_high(0)       := c0_high;
                i_c_high(1)       := c1_high;
                i_c_high(2)       := c2_high;
                i_c_high(3)       := c3_high;
                i_c_high(4)       := c4_high;
                i_c_low(0)        := c0_low;
                i_c_low(1)        := c1_low;
                i_c_low(2)        := c2_low;
                i_c_low(3)        := c3_low;
                i_c_low(4)        := c4_low;
                i_c_initial(0)    := c0_initial;
                i_c_initial(1)    := c1_initial;
                i_c_initial(2)    := c2_initial;
                i_c_initial(3)    := c3_initial;
                i_c_initial(4)    := c4_initial;
                i_c_mode(0)       := translate_string(c0_mode);
                i_c_mode(1)       := translate_string(c1_mode);
                i_c_mode(2)       := translate_string(c2_mode);
                i_c_mode(3)       := translate_string(c3_mode);
                i_c_mode(4)       := translate_string(c4_mode);

            end if; -- user to advanced conversion.

            m_initial_val <= i_m_initial;
            n_val <= i_n;
            m_val <= i_m;

            if (i_m = 1) then
                m_mode_val <= "bypass";
            else
                m_mode_val <= "      ";
            end if;
            if (i_n = 1) then
                n_mode_val <= "bypass";
            else
                n_mode_val <= "      ";
            end if;

            m_ph_val  <= i_m_ph;
            m_ph_initial <= i_m_ph;
            m_val_tmp := i_m;

            for i in 0 to 4 loop
                if (i_c_mode(i) = "bypass") then
                    if (pll_type = "fast" or pll_type = "lvds" OR (pll_type = "left_right")) then
                        i_c_high(i) := 16;
                        i_c_low(i) := 16;
                    else
                        i_c_high(i) := 256;
                        i_c_low(i) := 256;
                    end if;
                end if;
                c_ph_val(i)         <= i_c_ph(i);
                c_initial_val(i)    <= i_c_initial(i);
                c_high_val(i)       <= i_c_high(i);
                c_low_val(i)        <= i_c_low(i);
                c_mode_val(i)       <= i_c_mode(i);
                c_high_val_tmp(i)   := i_c_high(i);
                c_hval(i)           := i_c_high(i);
                c_low_val_tmp(i)    := i_c_low(i);
                c_lval(i)           := i_c_low(i);
                c_mode_val_tmp(i)   := i_c_mode(i);
                c_ph_val_orig(i)    <= i_c_ph(i);
                c_high_val_hold(i)  <= i_c_high(i);
                c_low_val_hold(i)   <= i_c_low(i);
                c_mode_val_hold(i)  <= i_c_mode(i);
            end loop;

            

            scan_chain_length := SCAN_CHAIN;

               
            num_output_cntrs <= 5;

            init := false;
        elsif (scandone_tmp'EVENT AND scandone_tmp = '1') then
            c0_rising_edge_transfer_done := false;
            c1_rising_edge_transfer_done := false;
            c2_rising_edge_transfer_done := false;
            c3_rising_edge_transfer_done := false;
            c4_rising_edge_transfer_done := false;
            update_conf_latches_reg <= '0';
        elsif (update_conf_latches'event and update_conf_latches = '1') then
            initiate_reconfig <= '1';
        elsif (areset_ipd'event AND areset_ipd = '1') then
            if (scandone_tmp = '0') then scandone_tmp <= '1' AFTER scanclk_period; end if;
        elsif (scanclk_ipd'event and scanclk_ipd = '1') then
            IF (initiate_reconfig = '1') THEN
                initiate_reconfig <= '0';
                ASSERT false REPORT "PLL Reprogramming Initiated" severity note;

                update_conf_latches_reg <= update_conf_latches;
                reconfig_err <= false;
                scandone_tmp <= '0';
                cp_curr_old <= cp_curr_val;    
                lfc_old <= lfc_val;    
                lfr_old <= lfr_val;    
                vco_old <= vco_cur;   
                -- LF unused : bit 0,1
                -- LF Capacitance : bits 2,3 : all values are legal
                buf_scan_data := scan_data(2 TO 3);

                IF ((pll_type = "fast") OR (pll_type = "lvds") OR (pll_type = "left_right")) THEN
                    lfc_val <= fpll_loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                ELSE
                    lfc_val <= loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                END IF;
                -- LF Resistance : bits 4-8
                -- valid values - 00000,00100,10000,10100,11000,11011,11100,11110
                IF (scan_data(4 TO 8) = "00000") THEN
                    lfr_val <= "20";
                ELSIF (scan_data(4 TO 8) = "00100") THEN
                    lfr_val <= "16";
                ELSIF (scan_data(4 TO 8) = "10000") THEN
                    lfr_val <= "12";
                ELSIF (scan_data(4 TO 8) = "10100") THEN
                    lfr_val <= "08";
                ELSIF (scan_data(4 TO 8) = "11000") THEN
                    lfr_val <= "06";
                ELSIF (scan_data(4 TO 8) = "11011") THEN
                    lfr_val <= "04";
                ELSIF (scan_data(4 TO 8) = "11100") THEN
                    lfr_val <= "02"; 
                ELSE 
                    lfr_val <= "01";
                END IF;
            
             
                -- VCO post scale assignment   
                if (scan_data(9) = '1') then  -- vco_post_scale = 1
                    i_vco_max <= VCO_MAX_NO_DIVISION/2;
                    i_vco_min <= VCO_MIN_NO_DIVISION/2;
                    vco_cur <= 1;
                else
                    i_vco_max <= vco_max;
                    i_vco_min <= vco_min;  
                    vco_cur <= 2;
                end if;             
                -- CP
                -- Bit 9 : CRBYPASS
                -- Bit 10-14 : unused
                -- Bits 15-17 : all values are legal
        
                buf_scan_data_2 := scan_data(15 TO 17); 
                cp_curr_val <= charge_pump_curr_arr(alt_conv_integer(buf_scan_data_2));    
                -- save old values for display info.
                
                cp_curr_val_bit_setting <= scan_data(15 TO 17);
                lfc_val_bit_setting <= scan_data(2 TO 3);
                lfr_val_bit_setting <= scan_data(4 TO 8);
                
                m_val_old <= m_val;    
                n_val_old <= n_val;    
                m_mode_val_old <= m_mode_val;    
                n_mode_val_old <= n_mode_val;    
                WHILE (i < num_output_cntrs) LOOP
                    c_high_val_old(i) <= c_high_val(i);    
                    c_low_val_old(i) <= c_low_val(i);    
                    c_mode_val_old(i) <= c_mode_val(i);    
                    i := i + 1;
                END LOOP;
                -- M counter
                -- 1. Mode - bypass (bit 18)
                
                IF (scan_data(18) = '1') THEN
                    n_mode_val <= "bypass"; 
                -- 3. Mode - odd/even (bit 27)
                ELSIF (scan_data(27) = '1') THEN
                    n_mode_val <= "   odd";
                ELSE
                    n_mode_val <= "  even"; 
                END IF;
        
                -- 2. High (bit 19-26)
                
                n_hi := scan_data(19 TO 26);    
                
                -- 4. Low (bit 28-35)
                
                n_lo := scan_data(28 TO 35);    
                -- N counter
                -- 1. Mode - bypass (bit 36)
                
                IF (scan_data(36) = '1') THEN
                    m_mode_val <= "bypass";    
                -- 3. Mode - odd/even (bit 45)
                ELSIF  (scan_data(45) = '1') THEN
                    m_mode_val <= "   odd"; 
                ELSE
                    m_mode_val <= "  even";   
                END IF;
        
                -- 2. High (bit 37-44)
                
                m_hi := scan_data(37 TO 44);    
                
                -- 4. Low (bit 46-53)
                
                m_lo := scan_data(46 TO 53);    
                -- C counters (start bit 54) bit 1:mode(bypass),bit 2-9:high,bit 10:mode(odd/even),bit 11-18:low
                
                i := 0;
                WHILE (i < num_output_cntrs) LOOP
                    -- 1. Mode - bypass
                    
                    IF (scan_data(54 + i * 18 + 0) = '1') THEN
                        c_mode_val_tmp(i) := "bypass";    
                    -- 3. Mode - odd/even
                    ELSIF (scan_data(54 + i * 18 + 9) = '1') THEN
                        c_mode_val_tmp(i) := "   odd";    
                    ELSE
                        c_mode_val_tmp(i) := "  even";  
                    END IF;
                    -- 2. Hi
                    
                    high := scan_data(54 + i * 18 + 1 TO 54 + i * 18 + 8);
                    c_hval(i) := alt_conv_integer(high);
                    IF (c_hval(i) /= 0) THEN
                        c_high_val_tmp(i) := c_hval(i);
                    ELSE
                        c_high_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    
                    -- 4. Low 
                    
                    low := scan_data(54 + i * 18 + 10 TO 54 + i * 18 + 17);
                    c_lval(i) := alt_conv_integer(low);
                    IF (c_lval(i) /= 0) THEN
                        c_low_val_tmp(i) := c_lval(i);
                    ELSE
                        c_low_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    i := i + 1;
                END LOOP;
        -- Legality Checks
               
                --  M counter value
    IF(scan_data(36) /= '1') THEN
        IF ((m_hi /= m_lo) and (scan_data(45) /= '1')) THEN           
                        reconfig_err <= TRUE;    
                        WRITE(buf,string'("Warning : The M counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                        writeline(output, buf);
                    ELSIF (m_hi /= "00000000") THEN
                        m_val_tmp := alt_conv_integer(m_hi) + alt_conv_integer(m_lo);    
                    ELSE
                        m_val_tmp := alt_conv_integer("000000001");
                    END IF;
                ELSE
                    m_val_tmp := alt_conv_integer("10000000");
                END IF;
                -- N counter value
    IF(scan_data(18) /= '1') THEN             
        IF ((n_hi /= n_lo)and (scan_data(27) /= '1')) THEN         
                    reconfig_err <= TRUE;    
                    WRITE(buf,string'("Warning : The N counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                    writeline(output, buf);
                ELSIF (n_hi /= "00000000") THEN
                    n_val <= alt_conv_integer(n_hi) + alt_conv_integer(n_lo);    
                ELSE
                    n_val <= alt_conv_integer("000000001");
                END IF;
                ELSE
                    n_val <= alt_conv_integer("10000000");
                END IF;
                -- TODO : Give warnings/errors in the following cases?
                -- 1. Illegal counter values (error)
                -- 2. Change of mode (warning)
                -- 3. Only 50% duty cycle allowed for M counter (odd mode - hi-lo=1,even - hi-lo=0)
                
            END IF;
        end if;

        
        if (fbclk'event and fbclk = '1') then
            m_val <= m_val_tmp;
        end if;
        
        if (update_conf_latches_reg = '1') then
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c0_rising_edge_transfer_done := true;
                c_high_val(0) <= c_high_val_tmp(0);
                c_mode_val(0) <= c_mode_val_tmp(0);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c1_rising_edge_transfer_done := true;
                c_high_val(1) <= c_high_val_tmp(1);
                c_mode_val(1) <= c_mode_val_tmp(1);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c2_rising_edge_transfer_done := true;
                c_high_val(2) <= c_high_val_tmp(2);
                c_mode_val(2) <= c_mode_val_tmp(2);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(3) <= c_high_val_tmp(3);
                c_mode_val(3) <= c_mode_val_tmp(3);
                c3_rising_edge_transfer_done := true;
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(4) <= c_high_val_tmp(4);
                c_mode_val(4) <= c_mode_val_tmp(4);
                c4_rising_edge_transfer_done := true;
            end if;
    
    
    
    
    
        end if;

        if (scanclk_ipd'event and scanclk_ipd = '0' and c0_rising_edge_transfer_done) then
            c_low_val(0) <= c_low_val_tmp(0);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c1_rising_edge_transfer_done) then
            c_low_val(1) <= c_low_val_tmp(1);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c2_rising_edge_transfer_done) then
            c_low_val(2) <= c_low_val_tmp(2);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c3_rising_edge_transfer_done) then
            c_low_val(3) <= c_low_val_tmp(3);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c4_rising_edge_transfer_done) then
            c_low_val(4) <= c_low_val_tmp(4);
        end if;

        if (update_phase = '1') then
            if (vco_out(0)'event and vco_out(0) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 0) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 0) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(1)'event and vco_out(1) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 1) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 1) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(2)'event and vco_out(2) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 2) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 2) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(3)'event and vco_out(3) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 3) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 3) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(4)'event and vco_out(4) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 4) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 4) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(5)'event and vco_out(5) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 5) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 5) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(6)'event and vco_out(6) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 6) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 6) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(7)'event and vco_out(7) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 7) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 7) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
        end if;

        

        if (vco_out(0)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 0) then
                    inclk_c_from_vco(i) <= vco_out(0);
                end if;
            end loop;
            if (m_ph_val = 0) then
                inclk_m_from_vco <= vco_out(0);
            end if;
        end if;
        if (vco_out(1)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 1) then
                    inclk_c_from_vco(i) <= vco_out(1);
                end if;
            end loop;
            if (m_ph_val = 1) then
                inclk_m_from_vco <= vco_out(1);
            end if;
        end if;
        if (vco_out(2)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 2) then
                    inclk_c_from_vco(i) <= vco_out(2);
                end if;
            end loop;
            if (m_ph_val = 2) then
                inclk_m_from_vco <= vco_out(2);
            end if;
        end if;
        if (vco_out(3)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 3) then
                    inclk_c_from_vco(i) <= vco_out(3);
                end if;
            end loop;
            if (m_ph_val = 3) then
                inclk_m_from_vco <= vco_out(3);
            end if;
        end if;
        if (vco_out(4)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 4) then
                    inclk_c_from_vco(i) <= vco_out(4);
                end if;
            end loop;
            if (m_ph_val = 4) then
                inclk_m_from_vco <= vco_out(4);
            end if;
        end if;
        if (vco_out(5)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 5) then
                    inclk_c_from_vco(i) <= vco_out(5);
                end if;
            end loop;
            if (m_ph_val = 5) then
                inclk_m_from_vco <= vco_out(5);
            end if;
        end if;
        if (vco_out(6)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 6) then
                    inclk_c_from_vco(i) <= vco_out(6);
                end if;
            end loop;
            if (m_ph_val = 6) then
                inclk_m_from_vco <= vco_out(6);
            end if;
        end if;
        if (vco_out(7)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 7) then
                    inclk_c_from_vco(i) <= vco_out(7);
                end if;
            end loop;
            if (m_ph_val = 7) then
                inclk_m_from_vco <= vco_out(7);
            end if;
        end if;
        


   
        if (scanclk_ipd'event AND scanclk_ipd = '0' AND now > 0 ps) then
            scanclkena_reg <= scanclkena_ipd;
            if (scanclkena_reg = '1') then
                scandata_in <= scandata_ipd;
                scandata_out <= scandataout_tmp;
            end if;
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '1' and now > 0 ps) then
            if (got_first_scanclk) then
                scanclk_period <= now - scanclk_last_rising_edge;
            else
                got_first_scanclk := true;
            end if;
            if (scanclkena_reg = '1') then
            for j in scan_chain_length - 1 downto 1 loop
                scan_data(j) <= scan_data(j-1);
            end loop;
            scan_data(0) <= scandata_in;
            end if;
            scanclk_last_rising_edge := now;
        end if;
    end process;

-- PLL Phase Reconfiguration

PROCESS(scanclk_ipd, areset_ipd,phasestep_ipd)
    VARIABLE i : INTEGER := 0;
    VARIABLE c_ph : INTEGER := 0;
    VARIABLE m_ph : INTEGER := 0;
    VARIABLE select_counter :  INTEGER := 0;
BEGIN
    IF (NOW = 0 ps) THEN
        m_ph_val_tmp <= m_ph_initial;
    END IF;
            
    -- Latch phase enable (same as phasestep) on neg edge of scan clock
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '0') THEN
        phasestep_reg <= phasestep_ipd;
    END IF;  
     
    IF (phasestep_ipd'EVENT and phasestep_ipd = '1') THEN
        IF (update_phase = '0') THEN 
            phasestep_high_count <= 0;  -- phase adjustments must be 1 cycle apart
                                        -- if not, next phasestep cycle is skipped
        END IF;
    END IF;     
    -- revert counter phase tap values to POF programmed values
    -- if PLL is reset

    IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val_tmp <= c_ph_val_orig;
            m_ph_val_tmp <= m_ph_initial;
    END IF;
    
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '1') THEN
    IF (phasestep_reg = '1') THEN
        IF (phasestep_high_count = 1) THEN
            phasecounterselect_reg <= phasecounterselect_ipd;
            phaseupdown_reg <= phaseupdown_ipd;
            -- start reconfiguration
            IF (phasecounterselect_ipd < "111")  THEN -- no counters selected
            IF (phasecounterselect_ipd = "000") THEN
                            i := 0;
                            WHILE (i < num_output_cntrs) LOOP
                                c_ph := c_ph_val(i);
                                IF (phaseupdown_ipd = '1') THEN
                                    c_ph := (c_ph + 1) mod num_phase_taps;
                                ELSIF (c_ph = 0) THEN
                                    c_ph := num_phase_taps - 1;
                                ELSE
                                    c_ph := (c_ph - 1) mod num_phase_taps;
                                END IF;
                                c_ph_val_tmp(i) <= c_ph;
                                i := i + 1;
                            END LOOP;
            ELSIF (phasecounterselect_ipd = "001") THEN
                            m_ph := m_ph_val;
                            IF (phaseupdown_ipd = '1') THEN
                                m_ph := (m_ph + 1) mod num_phase_taps;
                            ELSIF (m_ph = 0) THEN
                                m_ph := num_phase_taps - 1;
                            ELSE
                                m_ph := (m_ph - 1) mod num_phase_taps;
                            END IF;
                            m_ph_val_tmp <= m_ph;
                        ELSE
                            select_counter := alt_conv_integer(phasecounterselect_ipd) - 2;
                            c_ph := c_ph_val(select_counter);
                            IF (phaseupdown_ipd = '1') THEN
                                c_ph := (c_ph + 1) mod num_phase_taps;
                            ELSIF (c_ph = 0) THEN
                                c_ph := num_phase_taps - 1;
                            ELSE
                                c_ph := (c_ph - 1) mod num_phase_taps;
                            END IF;
                                c_ph_val_tmp(select_counter) <= c_ph;
                        END IF; 
                        update_phase <= '1','0' AFTER (0.5 * scanclk_period);
                    END IF;
                END IF;
                phasestep_high_count <= phasestep_high_count + 1; 
       
        END IF;
    END IF;
END PROCESS;

    scandataout_tmp <= scan_data(SCAN_CHAIN - 2);

    process (schedule_vco, areset_ipd, pfdena_ipd, refclk, fbclk)
    variable sched_time : time := 0 ps;

    TYPE time_array is ARRAY (0 to 7) of time;
    variable init : boolean := true;
    variable refclk_period : time;
    variable m_times_vco_period : time;
    variable new_m_times_vco_period : time;

    variable phase_shift : time_array := (OTHERS => 0 ps);
    variable last_phase_shift : time_array := (OTHERS => 0 ps);

    variable l_index : integer := 1;
    variable cycle_to_adjust : integer := 0;

    variable stop_vco : boolean := false;

    variable locked_tmp : std_logic := '0';
    variable pll_is_locked : boolean := false;
    variable cycles_pfd_low : integer := 0;
    variable cycles_pfd_high : integer := 0;
    variable cycles_to_lock : integer := 0;
    variable cycles_to_unlock : integer := 0;

    variable got_first_refclk : boolean := false;
    variable got_second_refclk : boolean := false;
    variable got_first_fbclk : boolean := false;

    variable refclk_time : time := 0 ps;
    variable fbclk_time : time := 0 ps;
    variable first_fbclk_time : time := 0 ps;

    variable fbclk_period : time := 0 ps;

    variable first_schedule : boolean := true;

    variable vco_val : std_logic := '0';
    variable vco_period_was_phase_adjusted : boolean := false;
    variable phase_adjust_was_scheduled : boolean := false;

    variable loop_xplier : integer;
    variable loop_initial : integer := 0;
    variable loop_ph : integer := 0;
    variable loop_time_delay : integer := 0;

    variable initial_delay : time := 0 ps;
    variable vco_per : time;
    variable tmp_rem : integer;
    variable my_rem : integer;
    variable fbk_phase : integer := 0;

    variable pull_back_M : integer := 0;
    variable total_pull_back : integer := 0;
    variable fbk_delay : integer := 0;

    variable offset : time := 0 ps;

    variable tmp_vco_per : integer := 0;
    variable high_time : time;
    variable low_time : time;

    variable got_refclk_posedge : boolean := false;
    variable got_fbclk_posedge : boolean := false;
    variable inclk_out_of_range : boolean := false;
    variable no_warn : boolean := false;

    variable ext_fbk_cntr_modulus : integer := 1;
    variable init_clks : boolean := true;
    variable pll_is_in_reset : boolean := false;
    variable buf : line;
    begin
        if (init) then

            -- jump-start the VCO
            -- add 1 ps delay to ensure all signals are updated to initial
            -- values
            schedule_vco <= transport not schedule_vco after 1 ps;

            init := false;
        end if;

        if (schedule_vco'event) then
            if (init_clks) then
                refclk_period := inclk0_input_frequency * n_val * 1 ps;

                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                init_clks := false;
            end if;
            sched_time := 0 ps;
            for i in 0 to 7 loop
                last_phase_shift(i) := phase_shift(i);
            end loop;
            cycle_to_adjust := 0;
            l_index := 1;
            m_times_vco_period := new_m_times_vco_period;
        end if;

        -- areset was asserted
        if (areset_ipd'event and areset_ipd = '1') then
            assert false report family_name & " PLL was reset" severity note;
            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;
        end if;

        if (areset_ipd = '1') then
            pll_is_in_reset := true;
            got_first_refclk := false;
            got_second_refclk := false;

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after 1 ps;
            end loop;
        end if;


        if (schedule_vco'event and (areset_ipd = '1' or stop_vco)) then

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after last_phase_shift(i);
                phase_shift(i) := 0 ps;
                last_phase_shift(i) := 0 ps;
            end loop;

            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;

            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := 0 ps;
            got_first_fbclk := false;
            fbclk_time := 0 ps;
            first_fbclk_time := 0 ps;
            fbclk_period := 0 ps;

            first_schedule := true;
            vco_val := '0';
            vco_period_was_phase_adjusted := false;
            phase_adjust_was_scheduled := false;

        elsif ((schedule_vco'event or areset_ipd'event) and areset_ipd = '0'  and (not stop_vco) and now > 0 ps) then

            -- note areset deassert time
            -- note it as refclk_time to prevent false triggering
            -- of stop_vco after areset
            if (areset_ipd'event and areset_ipd = '0' and pll_is_in_reset) then
                refclk_time := now;
                locked_tmp := '0';
            end if;

            pll_is_in_reset := false;
            -- calculate loop_xplier : this will be different from m_val
            -- in external_feedback_mode
            loop_xplier := m_val;
            loop_initial := m_initial_val - 1;
            loop_ph := m_ph_val;


            -- convert initial value to delay
            initial_delay := (loop_initial * m_times_vco_period)/loop_xplier;

            -- convert loop ph_tap to delay
            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            tmp_vco_per := (m_times_vco_period/1 ps) / loop_xplier;
            if (my_rem /= 0) then
                tmp_vco_per := tmp_vco_per + 1;
            end if;
            fbk_phase := (loop_ph * tmp_vco_per)/8;

            pull_back_M := initial_delay/1 ps + fbk_phase;

            total_pull_back := pull_back_M;

            if (simulation_type = "timing") then
                total_pull_back := total_pull_back + pll_compensation_delay;
            end if;
            while (total_pull_back > refclk_period/1 ps) loop
                total_pull_back := total_pull_back - refclk_period/1 ps;
            end loop;

            if (total_pull_back > 0) then
                offset := refclk_period - (total_pull_back * 1 ps);
            end if;
            
            fbk_delay := total_pull_back - fbk_phase;
            if (fbk_delay < 0) then
                offset := offset - (fbk_phase * 1 ps);
                fbk_delay := total_pull_back;
            end if;

            -- assign m_delay
            m_delay <= transport fbk_delay after 1 ps;

            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            for i in 1 to loop_xplier loop
                -- adjust cycles
                tmp_vco_per := (m_times_vco_period/1 ps)/loop_xplier;
                if (my_rem /= 0 and l_index <= my_rem) then
                    tmp_rem := (loop_xplier * l_index) rem my_rem;
                    cycle_to_adjust := (loop_xplier * l_index) / my_rem;
                    if (tmp_rem /= 0) then
                        cycle_to_adjust := cycle_to_adjust + 1;
                    end if;
                end if;
                if (cycle_to_adjust = i) then
                    tmp_vco_per := tmp_vco_per + 1;
                    l_index := l_index + 1;
                end if;

                -- calculate high and low periods
                vco_per := tmp_vco_per * 1 ps;
                high_time := (tmp_vco_per/2) * 1 ps;
                if (tmp_vco_per rem 2 /= 0) then
                    high_time := high_time + 1 ps;
                end if;
                low_time := vco_per - high_time;

                -- schedule the rising and falling edges
                for j in 1 to 2 loop
                    vco_val := not vco_val;
                    if (vco_val = '0') then
                        sched_time := sched_time + high_time;
                    elsif (vco_val = '1') then
                        sched_time := sched_time + low_time;
                    end if;

                    -- schedule the phase taps
                    for k in 0 to 7 loop
                        phase_shift(k) := (k * vco_per)/8;
                        if (first_schedule) then
                            vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                        else
                            vco_out(k) <= transport vco_val after (sched_time + last_phase_shift(k));
                        end if;
                    end loop;
                end loop;
            end loop;

            -- schedule once more
            if (first_schedule) then
                vco_val := not vco_val;
                if (vco_val = '0') then
                    sched_time := sched_time + high_time;
                elsif (vco_val = '1') then
                    sched_time := sched_time + low_time;
                end if;
                -- schedule the phase taps
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                    vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                end loop;
                first_schedule := false;
            end if;

            schedule_vco <= transport not schedule_vco after sched_time;

            if (vco_period_was_phase_adjusted) then
                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := true;

                vco_per := m_times_vco_period/loop_xplier;
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                end loop;
            end if;
        end if;
-- Bypass lock detect

if (refclk'event and refclk = '1' and areset_ipd = '0') then
    if (test_bypass_lock_detect = "on") then
        if (pfdena_ipd = '1') then
            cycles_pfd_low := 0;
            if (pfd_locked = '0') then
                if (cycles_pfd_high = lock_high) then
                    assert false report family_name & " PLL locked in test mode on PFD enable assertion." severity warning;
                    pfd_locked <= '1';
                end if;
                cycles_pfd_high := cycles_pfd_high + 1;
            end if;
        end if;
        
        if (pfdena_ipd = '0') then
            cycles_pfd_high := 0;
            if (pfd_locked = '1') then
                if (cycles_pfd_low = lock_low) then
                    assert false report family_name & " PLL lost lock in test mode on PFD enable de-assertion." severity warning;
                    pfd_locked <= '0';
                end if;
                cycles_pfd_low := cycles_pfd_low + 1;
            end if;
        end if;
    end if;
        
            
        if (refclk'event and refclk = '1' and areset_ipd = '0') then
            got_refclk_posedge := true;
            if (not got_first_refclk) then
                got_first_refclk := true;
            else
                got_second_refclk := true;
                refclk_period := now - refclk_time;

                -- check if incoming freq. will cause VCO range to be
                -- exceeded
                if ( (i_vco_max /= 0 and i_vco_min /= 0 and pfdena_ipd = '1') and
                    (((refclk_period/1 ps)/loop_xplier > i_vco_max) or
                    ((refclk_period/1 ps)/loop_xplier < i_vco_min)) ) then
                    if (pll_is_locked) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        if (inclk_out_of_range) then
                            pll_is_locked := false;
                            locked_tmp := '0';
                            cycles_to_lock := 0;
                            vco_period_was_phase_adjusted := false;
                            phase_adjust_was_scheduled := false;
                            assert false report family_name & " PLL lost lock." severity note;
                        end if;
                    elsif (not no_warn) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may not lock. Please use the correct frequency." severity warning;
                        no_warn := true;
                    end if;
                    inclk_out_of_range := true;
                else
                    vco_over  <= '0';
                    vco_under <= '0';
                    inclk_out_of_range := false;
                    no_warn := false;
                end if;
            end if;
        end if;

            if (stop_vco) then
                stop_vco := false;
                schedule_vco <= not schedule_vco;
            end if;

            refclk_time := now;
        else
            got_refclk_posedge := false;
        end if;

-- Update M counter value on feedback clock edge

        if (fbclk'event and fbclk = '1') then
            got_fbclk_posedge := true;
            if (not got_first_fbclk) then
                got_first_fbclk := true;
            else
                fbclk_period := now - fbclk_time;
            end if;

            -- need refclk_period here, so initialized to proper value above
            if ( ( (now - refclk_time > 1.5 * refclk_period) and pfdena_ipd = '1' and pll_is_locked) or
                ( (now - refclk_time > 5 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = false) or
                ( (now - refclk_time > 50 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = true) ) then
                stop_vco := true;
                -- reset
                got_first_refclk := false;
                got_first_fbclk := false;
                got_second_refclk := false;
                if (pll_is_locked) then
                    pll_is_locked := false;
                    locked_tmp := '0';
                    assert false report family_name & " PLL lost lock due to loss of input clock or the input clock is not detected within the allowed time frame." severity note;
                    if ((i_vco_max = 0) and (i_vco_min = 0)) then
                        assert false report "Please run timing simulation to check whether the input clock is operating within the supported VCO range or not." severity note;
                    end if;
                end if;
                cycles_to_lock := 0;
                cycles_to_unlock := 0;
                first_schedule := true;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := false;
            end if;
            fbclk_time := now;
        else
            got_fbclk_posedge := false;
        end if;

        if ((got_refclk_posedge or got_fbclk_posedge) and got_second_refclk and pfdena_ipd = '1' and (not inclk_out_of_range)) then

            -- now we know actual incoming period
            if ( abs(fbclk_time - refclk_time) <= 5 ps or
                (got_first_fbclk and abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                -- considered in phase
                if (cycles_to_lock = real_lock_high) then
                    if (not pll_is_locked) then
                        assert false report family_name & " PLL locked to incoming clock" severity note;
                    end if;
                    pll_is_locked := true;
                    locked_tmp := '1';
                    cycles_to_unlock := 0;
                end if;
                -- increment lock counter only if second part of above
                -- time check is NOT true
                if (not(abs(refclk_period - abs(fbclk_time - refclk_time)) <= lock_window)) then
                    cycles_to_lock := cycles_to_lock + 1;
                end if;

                -- adjust m_times_vco_period
                new_m_times_vco_period := refclk_period;
            else
                -- if locked, begin unlock
                if (pll_is_locked) then
                    cycles_to_unlock := cycles_to_unlock + 1;
                    if (cycles_to_unlock = lock_low) then
                        pll_is_locked := false;
                        locked_tmp := '0';
                        cycles_to_lock := 0;
                        vco_period_was_phase_adjusted := false;
                        phase_adjust_was_scheduled := false;
                        assert false report family_name & " PLL lost lock." severity note;
                        got_first_refclk := false;
                        got_first_fbclk := false;
                        got_second_refclk := false;
                    end if;
                end if;
                if ( abs(refclk_period - fbclk_period) <= 2 ps ) then
                    -- frequency is still good
                    if (now = fbclk_time and (not phase_adjust_was_scheduled)) then
                        if ( abs(fbclk_time - refclk_time) > refclk_period/2) then
                            new_m_times_vco_period := m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                            vco_period_was_phase_adjusted := true;
                        else
                            new_m_times_vco_period := m_times_vco_period - abs(fbclk_time - refclk_time);
                            vco_period_was_phase_adjusted := true;
                        end if;

                    end if;
                else
                    phase_adjust_was_scheduled := false;
                    new_m_times_vco_period := refclk_period;
                end if;
            end if;
        end if;

        if (pfdena_ipd = '0') then
            if (pll_is_locked) then
                locked_tmp := 'X';
            end if;
            pll_is_locked := false;
            cycles_to_lock := 0;
        end if;

        -- give message only at time of deassertion
        if (pfdena_ipd'event and pfdena_ipd = '0') then
            assert false report "PFDENA deasserted." severity note;
        elsif (pfdena_ipd'event and pfdena_ipd = '1') then
            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := now;
        end if;

        if (reconfig_err) then
            lock <= '0';
        else
            lock <= locked_tmp;
        end if;

        -- signal to calculate quiet_time
        sig_refclk_period <= refclk_period;

        if (stop_vco = true) then
            sig_stop_vco <= '1';
        else
            sig_stop_vco <= '0';
        end if;
        
        pll_locked <= pll_is_locked;
    end process;

    clk0_tmp <= c_clk(i_clk0_counter);
    clk_pfd(0) <= clk0_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(0)   <= clk_pfd(0) WHEN (test_bypass_lock_detect = "on") ELSE 
                clk0_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else
                'X';

    clk1_tmp <= c_clk(i_clk1_counter);
    clk_pfd(1) <= clk1_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(1)   <= clk_pfd(1) WHEN (test_bypass_lock_detect = "on") ELSE
                clk1_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk2_tmp <= c_clk(i_clk2_counter);
    clk_pfd(2) <= clk2_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(2)   <= clk_pfd(2) WHEN (test_bypass_lock_detect = "on") ELSE
                clk2_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk3_tmp <= c_clk(i_clk3_counter);
    clk_pfd(3) <= clk3_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(3)   <= clk_pfd(3) WHEN (test_bypass_lock_detect = "on") ELSE
                clk3_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk4_tmp <= c_clk(i_clk4_counter);
    clk_pfd(4) <= clk4_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(4)   <= clk_pfd(4) WHEN (test_bypass_lock_detect = "on") ELSE
                clk4_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';












scandataout <= scandata_out;
scandone <= NOT scandone_tmp;
phasedone <= NOT update_phase;
vcooverrange <= 'Z' WHEN (vco_range_detector_high_bits = -1) ELSE vco_over;
vcounderrange <= 'Z' WHEN (vco_range_detector_low_bits = -1) ELSE vco_under;
fbout <= fbclk;
end vital_pll;
-- END ARCHITECTURE VITAL_PLL
-- cycloneiii_msg


--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stingray_mn_cntr
--
-- Description : Simulation model for the M and N counter. This is a
--               common model for the input counter and the loop feedback
--               counter of the CycloneIIIGL PLL.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_arith.all;
USE IEEE.std_logic_unsigned.all;

ENTITY MF_stingray_mn_cntr is
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic;
            initial_value : IN integer := 1;
            modulus       : IN integer := 1;
            time_delay    : IN integer := 0
        );
END MF_stingray_mn_cntr;

ARCHITECTURE behave of MF_stingray_mn_cntr is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    begin
        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
            first_rising_edge := false;
            tmp_cout := clk;
        elsif (not first_rising_edge) then
            if (count < modulus) then
                count := count + 1;
            else
                count := 1;
                tmp_cout := not tmp_cout;
            end if;
        end if;
        end if;
        cout <= transport tmp_cout after time_delay * 1 ps;
    end process;
end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stingray_post_divider
--
-- Description : Simulation model that models the icdrclk output.
--
--///////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;
USE IEEE.std_logic_arith.all;
USE IEEE.std_logic_unsigned.all;

ENTITY MF_stingray_post_divider is
    GENERIC ( dpa_divider : integer := 1
        );
    PORT(  clk           : IN std_logic;
            reset         : IN std_logic := '0';
            cout          : OUT std_logic
        );
END MF_stingray_post_divider;

ARCHITECTURE behave of MF_stingray_post_divider is
begin

    process (clk, reset)
    variable count : integer := 1;
    variable first_rising_edge : boolean := true;
    variable tmp_cout : std_logic;
    variable modules : integer := 0;
    variable init : boolean := true;
    begin
        if (init = true) then
            if (dpa_divider = 0) then
                modules := 1;
            else
                modules := dpa_divider;
            end if;
            init := false;
        end if;

        if (reset = '1') then
            count := 1;
            tmp_cout := '0';
            first_rising_edge := true;
        elsif (clk'event) then
            if (clk = '1' and first_rising_edge) then
            first_rising_edge := false;
            tmp_cout := clk;
        elsif (not first_rising_edge) then
            if (count < modules) then
                count := count + 1;
            else
                count := 1;
                tmp_cout := not tmp_cout;
            end if;
        end if;
        end if;
        cout <= transport tmp_cout;
    end process;
end behave;

--/////////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_stingray_scale_cntr
--
-- Description : Simulation model for the output scale-down counters.
--               This is a common model for the C0, C1, C2, C3, C4 and C5
--               output counters of the Stingray PLL.
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY MF_stingray_scale_cntr is
    PORT(   clk            : IN std_logic;
            reset          : IN std_logic := '0';
            initial        : IN integer := 1;
            high           : IN integer := 1;
            low            : IN integer := 1;
            mode           : IN string := "bypass";
            ph_tap         : IN integer := 0;
            cout           : OUT std_logic
        );
END MF_stingray_scale_cntr;

ARCHITECTURE behave of MF_stingray_scale_cntr is
begin
    process (clk, reset)
    variable tmp_cout : std_logic := '0';
    variable count : integer := 1;
    variable output_shift_count : integer := 1;
    variable first_rising_edge : boolean := false;
    begin
        if (reset = '1') then
            count := 1;
            output_shift_count := 1;
            tmp_cout := '0';
            first_rising_edge := false;
        elsif (clk'event) then
            if (mode = "   off") then
                tmp_cout := '0';
            elsif (mode = "bypass") then
                tmp_cout := clk;
                first_rising_edge := true;
            elsif (not first_rising_edge) then
                if (clk = '1') then
                    if (output_shift_count = initial) then
                        tmp_cout := clk;
                        first_rising_edge := true;
                    else
                        output_shift_count := output_shift_count + 1;
                    end if;
                end if;
            elsif (output_shift_count < initial) then
                if (clk = '1') then
                    output_shift_count := output_shift_count + 1;
                end if;
            else
                count := count + 1;
                if (mode = "  even" and (count = (high*2) + 1)) then
                    tmp_cout := '0';
                elsif (mode = "   odd" and (count = high*2)) then
                    tmp_cout := '0';
                elsif (count = (high + low)*2 + 1) then
                    tmp_cout := '1';
                    count := 1;  -- reset count
                end if;
            end if;
        end if;
        cout <= transport tmp_cout;
    end process;

end behave;

--///////////////////////////////////////////////////////////////////////////
--
-- Entity Name : MF_cycloneiiigl_pll
--
-- Description : Simulation model for the Stingray PLL.
--               In the functional mode, it is also the model for the altpll
--               megafunction.
--
-- Limitations : Does not support Spread Spectrum and Bandwidth.
--
-- Outputs     : Up to 10 output clocks, each defined by its own set of
--               parameters. Locked output (active high) indicates when the
--               PLL locks. clkbad and activeclock are used for
--               clock switchover to indicate which input clock has gone
--               bad, when the clock switchover initiates and which input
--               clock is being used as the reference, respectively.
--               scandataout is the data output of the serial scan chain.
--
--///////////////////////////////////////////////////////////////////////////
LIBRARY IEEE, std;
USE IEEE.std_logic_1164.all;
USE STD.TEXTIO.all;
USE work.MF_pllpack.all;
USE work.MF_stingray_mn_cntr;
USE work.MF_stingray_scale_cntr;
USE work.dffp;
USE work.MF_pll_reg;


ENTITY MF_cycloneiiigl_pll is
    GENERIC (
        operation_mode              : string := "normal";
        pll_type                    : string := "auto";  -- AUTO/FAST/ENHANCED/LEFT_RIGHT/TOP_BOTTOM
        compensate_clock            : string := "clock0";
        
        inclk0_input_frequency      : integer := 0;
        inclk1_input_frequency      : integer := 0;
        
        self_reset_on_loss_lock     : string  := "off";
        switch_over_type            : string  := "auto";
        switch_over_counter         : integer := 1;
        enable_switch_over_counter  : string := "off";
        
        bandwidth                    : integer := 0;
        bandwidth_type               : string  := "auto";
        use_dc_coupling              : string  := "false";
        
        lock_c                      : integer := 4;
        sim_gate_lock_device_behavior : string := "off";
        lock_high                   : integer := 0;
        lock_low                    : integer := 0;
        lock_window_ui              : string := "0.05";
        lock_window                 : time := 5 ps;
        test_bypass_lock_detect     : string := "off";
        

        clk0_output_frequency       : integer := 0;
        clk0_multiply_by            : integer := 0;
        clk0_divide_by              : integer := 0;
        clk0_phase_shift            : string := "0";
        clk0_duty_cycle             : integer := 50;

        clk1_output_frequency       : integer := 0;
        clk1_multiply_by            : integer := 0;
        clk1_divide_by              : integer := 0;
        clk1_phase_shift            : string := "0";
        clk1_duty_cycle             : integer := 50;

        clk2_output_frequency       : integer := 0;
        clk2_multiply_by            : integer := 0;
        clk2_divide_by              : integer := 0;
        clk2_phase_shift            : string := "0";
        clk2_duty_cycle             : integer := 50;

        clk3_output_frequency       : integer := 0;
        clk3_multiply_by            : integer := 0;
        clk3_divide_by              : integer := 0;
        clk3_phase_shift            : string := "0";
        clk3_duty_cycle             : integer := 50;

        clk4_output_frequency       : integer := 0;
        clk4_multiply_by            : integer := 0;
        clk4_divide_by              : integer := 0;
        clk4_phase_shift            : string := "0";
        clk4_duty_cycle             : integer := 50;

        pfd_min                     : integer := 0;
        pfd_max                     : integer := 0;
        vco_min                     : integer := 0;
        vco_max                     : integer := 0;
        vco_center                  : integer := 0;

        -- ADVANCED USER PARAMETERS
        m_initial                   : integer := 1;
        m                           : integer := 0;
        n                           : integer := 1;

        c0_high                     : integer := 1;
        c0_low                      : integer := 1;
        c0_initial                  : integer := 1; 
        c0_mode                     : string := "bypass";
        c0_ph                       : integer := 0;

        c1_high                     : integer := 1;
        c1_low                      : integer := 1;
        c1_initial                  : integer := 1;
        c1_mode                     : string := "bypass";
        c1_ph                       : integer := 0;

        c2_high                     : integer := 1;
        c2_low                      : integer := 1;
        c2_initial                  : integer := 1;
        c2_mode                     : string := "bypass";
        c2_ph                       : integer := 0;

        c3_high                     : integer := 1;
        c3_low                      : integer := 1;
        c3_initial                  : integer := 1;
        c3_mode                     : string := "bypass";
        c3_ph                       : integer := 0;

        c4_high                     : integer := 1;
        c4_low                      : integer := 1;
        c4_initial                  : integer := 1;
        c4_mode                     : string := "bypass";
        c4_ph                       : integer := 0;

        m_ph                        : integer := 0;

        clk0_counter                : string := "unused";
        clk1_counter                : string := "unused";
        clk2_counter                : string := "unused";
        clk3_counter                : string := "unused";
        clk4_counter                : string := "unused";
        
        c1_use_casc_in              : string := "off";
        c2_use_casc_in              : string := "off";
        c3_use_casc_in              : string := "off";
        c4_use_casc_in              : string := "off";
        
        m_test_source               : integer := -1;
        c0_test_source              : integer := -1;
        c1_test_source              : integer := -1;
        c2_test_source              : integer := -1;
        c3_test_source              : integer := -1;
        c4_test_source              : integer := -1;
        
        vco_multiply_by             : integer := 0;
        vco_divide_by               : integer := 0;
        vco_post_scale              : integer := 1;
        vco_frequency_control       : string  := "auto";
        vco_phase_shift_step        : integer := 0;

        dpa_multiply_by             : integer := 0;
        dpa_divide_by               : integer := 0;
        dpa_divider                 : integer := 1;

        charge_pump_current         : integer := 10;
        loop_filter_r               : string := " 1.0";
        loop_filter_c               : integer := 0;
      
        pll_compensation_delay      : integer := 0;
        simulation_type             : string := "functional";
        
        clk0_use_even_counter_mode  : string := "off";
        clk1_use_even_counter_mode  : string := "off";
        clk2_use_even_counter_mode  : string := "off";
        clk3_use_even_counter_mode  : string := "off";
        clk4_use_even_counter_mode  : string := "off";
        
        clk0_use_even_counter_value : string := "off";
        clk1_use_even_counter_value : string := "off";
        clk2_use_even_counter_value : string := "off";
        clk3_use_even_counter_value : string := "off";
        clk4_use_even_counter_value : string := "off";
            
-- Test only
        init_block_reset_a_count    : integer := 1;
        init_block_reset_b_count    : integer := 1;
        charge_pump_current_bits : integer := 0;
        lock_window_ui_bits : integer := 0;
        loop_filter_c_bits : integer := 0;
        loop_filter_r_bits : integer := 0;
        test_counter_c0_delay_chain_bits : integer := 0;
        test_counter_c1_delay_chain_bits : integer := 0;
        test_counter_c2_delay_chain_bits : integer := 0;
        test_counter_c3_delay_chain_bits : integer := 0;
        test_counter_c4_delay_chain_bits : integer := 0;
        test_counter_m_delay_chain_bits : integer := 0;
        test_counter_n_delay_chain_bits : integer := 0;
        test_feedback_comp_delay_chain_bits : integer := 0;
        test_input_comp_delay_chain_bits : integer := 0;
        test_volt_reg_output_mode_bits : integer := 0;
        test_volt_reg_output_voltage_bits : integer := 0;
        test_volt_reg_test_mode : string := "false";
        vco_range_detector_high_bits : integer := -1;
        vco_range_detector_low_bits : integer := -1;
        scan_chain_mif_file : string := "";

        auto_settings : string  := "true";     
-- Simulation only generics
        family_name                 : string  := "Stingray";

        use_vco_bypass              : string := "false"
    );

    PORT
    (
        inclk                       : in std_logic_vector(1 downto 0);
        fbin                         : in std_logic := '0';
        fbout                        : out std_logic;
        clkswitch                   : in std_logic := '0';
        areset                      : in std_logic := '0';
        pfdena                      : in std_logic := '1';
        scandata                    : in std_logic := '0';
        scanclk                     : in std_logic := '0';
        scanclkena                  : in std_logic := '1';
        configupdate                : in std_logic := '0';
        clk                         : out std_logic_vector(4 downto 0);
        phasecounterselect          : in std_logic_vector(2 downto 0) := "000";
        phaseupdown                 : in std_logic := '0';
        phasestep                   : in std_logic := '0';
        clkbad                      : out std_logic_vector(1 downto 0);
        activeclock                 : out std_logic;
        locked                      : out std_logic;
        scandataout                 : out std_logic;
        scandone                    : out std_logic;
        phasedone                   : out std_logic;
        vcooverrange                : out std_logic;
        vcounderrange               : out std_logic;
        fref                        : out std_logic;
        icdrclk                     : out std_logic
    );
END MF_cycloneiiigl_pll;

ARCHITECTURE vital_pll of MF_cycloneiiigl_pll is

TYPE int_array is ARRAY(NATURAL RANGE <>) of integer;
TYPE str_array is ARRAY(NATURAL RANGE <>) of string(1 to 6);
TYPE str_array1 is ARRAY(NATURAL RANGE <>) of string(1 to 9);
TYPE std_logic_array is ARRAY(NATURAL RANGE <>) of std_logic;

-- internal advanced parameter signals
signal   i_vco_min      : integer := vco_min * (vco_post_scale/2);
signal   i_vco_max      : integer := vco_max * (vco_post_scale/2);
signal   i_vco_center   : integer;
signal   i_pfd_min      : integer;
signal   i_pfd_max      : integer;
    signal   c_ph_val       : int_array(0 to 4) := (OTHERS => 0);
    signal   c_ph_val_tmp   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_high_val     : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val      : int_array(0 to 4) := (OTHERS => 1);
    signal   c_initial_val  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_mode_val     : str_array(0 to 4);
    signal   clk_num     : str_array(0 to 4);

-- old values
    signal   c_high_val_old : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val_old  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_ph_val_old   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_mode_val_old : str_array(0 to 4);
-- hold registers
    signal   c_high_val_hold : int_array(0 to 4) := (OTHERS => 1);
    signal   c_low_val_hold  : int_array(0 to 4) := (OTHERS => 1);
    signal   c_ph_val_hold   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_mode_val_hold : str_array(0 to 4);

-- temp registers
    signal   sig_c_ph_val_tmp   : int_array(0 to 4) := (OTHERS => 0);
    signal   c_ph_val_orig  : int_array(0 to 4) := (OTHERS => 0);

signal   real_lock_high : integer := 0;
signal   i_clk4_counter         : integer := 4;
signal   i_clk3_counter         : integer := 3;
signal   i_clk2_counter         : integer := 2;
signal   i_clk1_counter         : integer := 1;
signal   i_clk0_counter         : integer := 0;
signal   i_charge_pump_current  : integer;
signal   i_loop_filter_r        : integer;

-- end internal advanced parameter signals

-- CONSTANTS
CONSTANT    SCAN_CHAIN : integer := 144;
CONSTANT    GPP_SCAN_CHAIN : integer := 234;
CONSTANT    FAST_SCAN_CHAIN : integer := 180;
    CONSTANT cntrs : str_array(4 downto 0) := ("    C4", "    C3", "    C2", "    C1", "    C0");
CONSTANT    ss_cntrs : str_array(0 to 3) := ("     M", "    M2", "     N", "    N2");
            
CONSTANT    loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    fpll_loop_filter_c_arr : int_array(0 to 3) := (0,0,0,0);
CONSTANT    charge_pump_curr_arr : int_array(0 to 15) := (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

CONSTANT    num_phase_taps : integer := 8;
-- signals

signal    vcc : std_logic := '1';
          
signal    fbclk       : std_logic;
signal    refclk      : std_logic;

signal    icdr_clk     : std_logic;

signal    vco_over    : std_logic := '0';
signal    vco_under   : std_logic := '1';

signal pll_locked : boolean := false;


    signal c_clk : std_logic_array(0 to 4);
signal vco_out : std_logic_vector(7 downto 0) := (OTHERS => '0');

-- signals to assign values to counter params
signal    m_val : integer := 1;
signal    n_val : integer := 1;
signal    m_ph_val : integer := 0;
signal    m_ph_initial : integer := 0;
signal    m_ph_val_tmp  : integer := 0;
signal    m_initial_val : integer := m_initial;
         
signal    m_mode_val : string(1 to 6) := "      ";
signal    n_mode_val : string(1 to 6) := "      ";
signal    lfc_val : integer := 0;
signal    vco_cur : integer := vco_post_scale;
signal    cp_curr_val : integer := 0;
signal    lfr_val : string(1 to 2) := "  ";
         
signal    cp_curr_old_bit_setting : integer := charge_pump_current_bits;
signal    cp_curr_val_bit_setting : std_logic_vector(2 downto 0) := (OTHERS => '0');
signal    lfr_old_bit_setting : integer := loop_filter_r_bits;
signal    lfr_val_bit_setting : std_logic_vector(4 downto 0) := (OTHERS => '0');
signal    lfc_old_bit_setting : integer := loop_filter_c_bits; 
signal    lfc_val_bit_setting : std_logic_vector(1 downto 0) := (OTHERS => '0');
         
signal    pll_reconfig_display_full_setting : boolean := FALSE; -- display full setting, change to true
-- old    values
signal    m_val_old : integer := 1;
signal    n_val_old : integer := 1;
signal    m_mode_val_old : string(1 to 6) := "      ";
signal    n_mode_val_old : string(1 to 6) := "      ";
signal    m_ph_val_old : integer := 0;
signal    lfc_old : integer := 0;
signal    vco_old : integer := 0;
signal    cp_curr_old : integer := 0;
signal    lfr_old : string(1 to 2) := "  ";
    signal num_output_cntrs : integer := 5;
signal    scanclk_period : time := 1 ps;
    signal scan_data : std_logic_vector(0 to 143) := (OTHERS => '0');


    signal clk_pfd : std_logic_vector(0 to 4);
signal    clk0_tmp : std_logic;
signal    clk1_tmp : std_logic;
signal    clk2_tmp : std_logic;
signal    clk3_tmp : std_logic;
signal    clk4_tmp : std_logic;

signal    update_conf_latches : std_logic := '0';
signal    update_conf_latches_reg : std_logic := '0';

signal    clkin : std_logic := '0';
signal    gate_locked : std_logic := '0';
signal    pfd_locked : std_logic := '0';
signal    lock : std_logic := '0';
signal    about_to_lock : boolean := false;
signal    reconfig_err : boolean := false;

signal    inclk_c0 : std_logic;
signal    inclk_c1 : std_logic;
signal    inclk_c2 : std_logic;
signal    inclk_c3 : std_logic;
signal    inclk_c4 : std_logic;
signal inclk_m : std_logic;
signal devpor : std_logic;
signal devclrn : std_logic;

signal inclk0_ipd : std_logic;
signal inclk1_ipd : std_logic;
signal pfdena_ipd : std_logic;
signal areset_ipd : std_logic;
signal fbin_ipd : std_logic;
signal scanclk_ipd : std_logic;
signal scanclkena_ipd, scanclkena_reg : std_logic;
signal scandata_ipd : std_logic;
signal clkswitch_ipd : std_logic;
    signal phasecounterselect_ipd : std_logic_vector(2 downto 0);
signal phaseupdown_ipd : std_logic;
signal phasestep_ipd : std_logic;
signal configupdate_ipd : std_logic;
-- registered signals

signal sig_offset : time := 0 ps;
signal sig_refclk_time : time := 0 ps;
signal sig_fbclk_period : time := 0 ps;
signal sig_vco_period_was_phase_adjusted : boolean := false;
signal sig_phase_adjust_was_scheduled : boolean := false;
signal sig_stop_vco : std_logic := '0';
signal sig_m_times_vco_period : time := 0 ps;
signal sig_new_m_times_vco_period : time := 0 ps;
signal sig_got_refclk_posedge : boolean := false;
signal sig_got_fbclk_posedge : boolean := false;
signal sig_got_second_refclk : boolean := false;

signal m_delay : integer := 0;
signal n_delay : integer := 0;

signal inclk1_tmp : std_logic := '0';


signal reset_low : std_logic := '0';

-- Phase Reconfig

    SIGNAL phasecounterselect_reg   :  std_logic_vector(2 DOWNTO 0);

SIGNAL phaseupdown_reg          :  std_logic := '0';
SIGNAL phasestep_reg            :  std_logic := '0';
SIGNAL phasestep_high_count     :  integer := 0;
SIGNAL update_phase             :  std_logic := '0';

signal scandataout_tmp : std_logic := '0';
signal scandata_in : std_logic := '0';
signal scandata_out : std_logic := '0';
signal scandone_tmp : std_logic := '1';
signal initiate_reconfig : std_logic := '0';

signal sig_refclk_period : time := (inclk0_input_frequency * 1 ps) * n;

signal schedule_vco : std_logic := '0';

signal areset_ena_sig : std_logic := '0';
signal pll_in_test_mode : boolean := false;
signal pll_has_just_been_reconfigured : boolean := false;

    signal inclk_c_from_vco : std_logic_array(0 to 4);

signal inclk_m_from_vco : std_logic;

SIGNAL inclk0_period              : time := 0 ps;
SIGNAL last_inclk0_period         : time := 0 ps;
SIGNAL last_inclk0_edge         : time := 0 ps;
SIGNAL first_inclk0_edge_detect : STD_LOGIC := '0';
SIGNAL inclk1_period              : time := 0 ps;
SIGNAL last_inclk1_period         : time := 0 ps;
SIGNAL last_inclk1_edge         : time := 0 ps;
SIGNAL first_inclk1_edge_detect : STD_LOGIC := '0';



COMPONENT MF_stingray_mn_cntr
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic;
        initial_value : IN integer := 1;
        modulus       : IN integer := 1;
        time_delay    : IN integer := 0
    );
END COMPONENT;

COMPONENT MF_stingray_post_divider
    GENERIC ( dpa_divider : integer := 0
    );
    PORT (
        clk           : IN std_logic;
        reset         : IN std_logic := '0';
        cout          : OUT std_logic
    );
END COMPONENT;


COMPONENT MF_stingray_scale_cntr
    PORT (
        clk            : IN std_logic;
        reset          : IN std_logic := '0';
        cout           : OUT std_logic;
        initial        : IN integer := 1;
        high           : IN integer := 1;
        low            : IN integer := 1;
        mode           : IN string := "bypass";
        ph_tap         : IN integer := 0
    );
END COMPONENT;

COMPONENT dffp

    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

COMPONENT MF_pll_reg
    PORT(
        Q                              :  out   STD_LOGIC := '0';
        D                              :  in    STD_LOGIC := '1';
        CLRN                           :  in    STD_LOGIC := '1';
        PRN                            :  in    STD_LOGIC := '1';
        CLK                            :  in    STD_LOGIC := '0';
        ENA                            :  in    STD_LOGIC := '1');
END COMPONENT;

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    WireDelay : block
    begin
        inclk0_ipd <= inclk(0);
        inclk1_ipd <= inclk(1);
        areset_ipd <= areset;
        pfdena_ipd <= pfdena;
        scanclk_ipd <= scanclk;
        scanclkena_ipd <= scanclkena;
        scandata_ipd <= scandata;
        configupdate_ipd <= configupdate;
        clkswitch_ipd <= clkswitch;
        phaseupdown_ipd <= phaseupdown;
        phasestep_ipd <= phasestep;
        phasecounterselect_ipd(0) <= phasecounterselect(0);
        phasecounterselect_ipd(1) <= phasecounterselect(1);
        phasecounterselect_ipd(2) <= phasecounterselect(2);

    end block;

inclk_m <=  fbclk when m_test_source = 0 else
            refclk when m_test_source = 1 else
            inclk_m_from_vco;

    areset_ena_sig <= areset_ipd or sig_stop_vco;

   
    pll_in_test_mode <= true when   (m_test_source /= -1 or c0_test_source /= -1 or
                                    c1_test_source /= -1 or c2_test_source /= -1 or
                                    c3_test_source /= -1 or c4_test_source /= -1)
                                    else false;

    real_lock_high <= lock_high WHEN (sim_gate_lock_device_behavior = "on") ELSE 0;   
    m1 : MF_stingray_mn_cntr
        port map (  clk           => inclk_m,
                    reset         => areset_ena_sig,
                    cout          => fbclk,
                    initial_value => m_initial_val,
                    modulus       => m_val,
                    time_delay    => m_delay
                );

    -- add delta delay to inclk1 to ensure inclk0 and inclk1 are processed
    -- in different simulation deltas.
    inclk1_tmp <= inclk1_ipd;

    -- Calculate the inclk0 period
    PROCESS
    VARIABLE inclk0_period_tmp : time := 0 ps;
    BEGIN
        WAIT UNTIL (inclk0_ipd'EVENT AND inclk0_ipd = '1');
        IF (first_inclk0_edge_detect = '0') THEN
            first_inclk0_edge_detect <= '1';
        ELSE
            last_inclk0_period <= inclk0_period;
            inclk0_period_tmp  := NOW - last_inclk0_edge;
        END IF;
        last_inclk0_edge <= NOW;
        inclk0_period <= inclk0_period_tmp;
    END PROCESS;
   
   
    -- Calculate the inclk1 period
    PROCESS
    VARIABLE inclk1_period_tmp : time := 0 ps;
    BEGIN
    WAIT UNTIL (inclk1_ipd'EVENT AND inclk1_ipd = '1');
        IF (first_inclk1_edge_detect = '0') THEN
            first_inclk1_edge_detect <= '1';
        ELSE
            last_inclk1_period <= inclk1_period;
            inclk1_period_tmp  := NOW - last_inclk1_edge;
        END IF;
        last_inclk1_edge <= NOW;
        inclk1_period <= inclk1_period_tmp;
    END PROCESS;

    process (inclk0_ipd, inclk1_tmp, clkswitch_ipd)
    variable input_value : std_logic := '0';
    variable current_clock : integer := 0;
    variable clk0_count, clk1_count : integer := 0;
    variable clk0_is_bad, clk1_is_bad : std_logic := '0';
    variable primary_clk_is_bad : boolean := false;
    variable current_clk_is_bad : boolean := false;
    variable got_curr_clk_falling_edge_after_clkswitch : boolean := false;
    variable switch_over_count : integer := 0;
    variable active_clock : std_logic := '0';
    variable external_switch : boolean := false;
    variable diff_percent_period : integer := 0;
    variable buf : line;
    variable switch_clock : boolean := false;

    begin
        if (now = 0 ps) then
            if (switch_over_type = "manual" and clkswitch_ipd = '1') then
                current_clock := 1;
                active_clock := '1';
            end if;
        end if;
        if (clkswitch_ipd'event and clkswitch_ipd = '1' and switch_over_type = "auto") then
            external_switch := true;
        elsif (switch_over_type = "manual") then
            if (clkswitch_ipd'event and clkswitch_ipd = '1') then
                switch_clock := true;
            elsif (clkswitch_ipd'event and clkswitch_ipd = '0') then
                switch_clock := false;
            end if;
        end if;

        if (switch_clock = true) then
            if (inclk0_ipd'event or inclk1_tmp'event) then
                if (current_clock = 0) then
                    current_clock := 1;
                    active_clock := '1';
                    clkin <= transport inclk1_tmp;
                elsif (current_clock = 1) then
                    current_clock := 0;
                    active_clock := '0';
                    clkin <= transport inclk0_ipd;
                end if;
                switch_clock := false;
            end if;
        end if;

        -- save the current inclk event value
        if (inclk0_ipd'event) then
            input_value := inclk0_ipd;
        elsif (inclk1_tmp'event) then
            input_value := inclk1_tmp;
        end if;

        -- check if either input clk is bad
        if (inclk0_ipd'event and inclk0_ipd = '1') then
            clk0_count := clk0_count + 1;
            clk0_is_bad := '0';
            clk1_count := 0;
            if (clk0_count > 2) then
                -- no event on other clk for 2 cycles
                clk1_is_bad := '1';
                if (current_clock = 1) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;
        if (inclk1_tmp'event and inclk1_tmp = '1') then
            clk1_count := clk1_count + 1;
            clk1_is_bad := '0';
            clk0_count := 0;
            if (clk1_count > 2) then
                -- no event on other clk for 2 cycles
                clk0_is_bad := '1';
                if (current_clock = 0) then
                    current_clk_is_bad := true;
                end if;
            end if;
        end if;

        -- check if the bad clk is the primary clock
        if (clk0_is_bad = '1') then
            primary_clk_is_bad := true;
        else
            primary_clk_is_bad := false;
        end if;

        -- actual switching
        if (inclk0_ipd'event and current_clock = 0) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk0_ipd = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk0_ipd;
                end if;
            else
                clkin <= transport inclk0_ipd;
            end if;
        elsif (inclk1_tmp'event and current_clock = 1) then
            if (external_switch) then
                if (not got_curr_clk_falling_edge_after_clkswitch) then
                    if (inclk1_tmp = '0') then
                        got_curr_clk_falling_edge_after_clkswitch := true;
                    end if;
                    clkin <= transport inclk1_tmp;
                end if;
            else
                clkin <= transport inclk1_tmp;
            end if;
        else
            if (input_value = '1' and enable_switch_over_counter = "on" and primary_clk_is_bad) then
                switch_over_count := switch_over_count + 1;
            end if;
            if ((input_value = '0')) then
                if (external_switch and (got_curr_clk_falling_edge_after_clkswitch or current_clk_is_bad)) or (primary_clk_is_bad and clkswitch_ipd /= '1' and (enable_switch_over_counter = "off" or switch_over_count = switch_over_counter)) then
                    got_curr_clk_falling_edge_after_clkswitch := false;
                    
                    if(inclk0_period > inclk1_period) then
                        diff_percent_period := (( inclk0_period - inclk1_period ) * 100) / inclk1_period;
                    else
                        diff_percent_period := (( inclk1_period - inclk0_period ) * 100) / inclk0_period;
                    end if;
                    if((diff_percent_period > 20)and ( switch_over_type = "auto")) then
                        WRITE(buf,string'("Warning : The input clock frequencies specified for the specified PLL are too far apart for auto-switch-over feature to work properly. Please make sure that the clock frequencies are 20 percent apart for correct functionality."));
                        writeline(output, buf);
                    end if;

                    if (current_clock = 0) then
                        current_clock := 1;
                    else
                        current_clock := 0;
                    end if;
                    active_clock := not active_clock;
                    switch_over_count := 0;
                    external_switch := false;
                    current_clk_is_bad := false;
                else
                    if(switch_over_type = "auto") then
                        if(current_clock = 0 and clk0_is_bad = '1' and clk1_is_bad = '0' ) then
                            current_clock := 1;
                            active_clock := not active_clock;
                        end if;
                
                        if(current_clock = 1 and clk0_is_bad = '0' and clk1_is_bad = '1' ) then
                            current_clock := 0;
                            active_clock := not active_clock;
                        end if;
                    end if;
                end if;         
                
            end if;
        end if;

        -- schedule outputs
        clkbad(0) <= clk0_is_bad;
        clkbad(1) <= clk1_is_bad;
        activeclock <= active_clock;

    end process;


    n1 : MF_stingray_mn_cntr
        port map (
                clk           => clkin,
                reset         => areset_ipd,
                cout          => refclk,
                initial_value => n_val,
                modulus       => n_val);

    d1 : MF_stingray_post_divider
        generic map ( dpa_divider => dpa_divider)
        port map (
                clk           => inclk_m_from_vco,
                reset         => areset_ipd,
                cout          => icdr_clk);


inclk_c0 <= refclk when c0_test_source = 1 else
            fbclk   when c0_test_source = 0 else
            inclk_c_from_vco(0);


    c0 : MF_stingray_scale_cntr
        port map (
                clk            => inclk_c0,
                reset          => areset_ena_sig,
                cout           => c_clk(0),
                initial        => c_initial_val(0),
                high           => c_high_val(0),
                low            => c_low_val(0),
                mode           => c_mode_val(0),
                ph_tap         => c_ph_val(0));

    inclk_c1 <= refclk when c1_test_source = 1 else
                fbclk  when c1_test_source = 0 else
                c_clk(0) when c1_use_casc_in = "on" else
                inclk_c_from_vco(1);
                

    c1 : MF_stingray_scale_cntr
        port map (
                clk            => inclk_c1,
                reset          => areset_ena_sig,
                cout           => c_clk(1),
                initial        => c_initial_val(1),
                high           => c_high_val(1),
                low            => c_low_val(1),
                mode           => c_mode_val(1),
                ph_tap         => c_ph_val(1));

inclk_c2 <= refclk when c2_test_source = 1 else
            fbclk  when c2_test_source = 0 else
            c_clk(1) when c2_use_casc_in = "on" else
            inclk_c_from_vco(2);

    c2 : MF_stingray_scale_cntr
        port map (
                clk            => inclk_c2,
                reset          => areset_ena_sig,
                cout           => c_clk(2),
                initial        => c_initial_val(2),
                high           => c_high_val(2),
                low            => c_low_val(2),
                mode           => c_mode_val(2),
                ph_tap         => c_ph_val(2));


    inclk_c3 <= refclk when c3_test_source = 1 else
                fbclk  when c3_test_source = 0 else
                c_clk(2) when c3_use_casc_in = "on" else
                inclk_c_from_vco(3);
                
    c3 : MF_stingray_scale_cntr
        port map (
                clk            => inclk_c3,
                reset          => areset_ena_sig,
                cout           => c_clk(3),
                initial        => c_initial_val(3),
                high           => c_high_val(3),
                low            => c_low_val(3),
                mode           => c_mode_val(3),
                ph_tap         => c_ph_val(3));

    inclk_c4 <= refclk when c4_test_source = 1 else
                fbclk  when c4_test_source = 0 else
                c_clk(3) when (c4_use_casc_in = "on") else
                inclk_c_from_vco(4);
                
    c4 : MF_stingray_scale_cntr
        port map (
                clk            => inclk_c4,
                reset          => areset_ena_sig,
                cout           => c_clk(4),
                initial        => c_initial_val(4),
                high           => c_high_val(4),
                low            => c_low_val(4),
                mode           => c_mode_val(4),
                ph_tap         => c_ph_val(4));

            

            

            

            

            
    
    process(scandone_tmp, lock)
    begin
        if (scandone_tmp'event and (scandone_tmp = '1')) then
            pll_has_just_been_reconfigured <= true;
        elsif (lock'event and (lock = '1')) then
            pll_has_just_been_reconfigured <= false;
        end if;
    end process;
    
    process(inclk_c0, inclk_c1, areset_ipd, sig_stop_vco)
    variable c0_got_first_rising_edge : boolean := false;
    variable c0_count : integer := 2;
    variable c0_initial_count : integer := 1;
    variable c0_tmp, c1_tmp : std_logic := '0';
    variable c1_got_first_rising_edge : boolean := false;
    variable c1_count : integer := 2;
    variable c1_initial_count : integer := 1;
    begin
        if (areset_ipd = '1' or sig_stop_vco = '1') then
            c0_count := 2;
            c1_count := 2;
            c0_initial_count := 1;
            c1_initial_count := 1;
            c0_got_first_rising_edge := false;
            c1_got_first_rising_edge := false;
        else
            if (not c0_got_first_rising_edge) then
                if (inclk_c0'event and inclk_c0 = '1') then
                    if (c0_initial_count = c_initial_val(0)) then
                        c0_got_first_rising_edge := true;
                    else
                        c0_initial_count := c0_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c0'event) then
                c0_count := c0_count + 1;
                if (c0_count = (c_high_val(0) + c_low_val(0)) * 2) then
                    c0_count := 1;
                end if;
            end if;
            if (inclk_c0'event and inclk_c0 = '0') then
                if (c0_count = 1) then
                    c0_tmp := '1';
                    c0_got_first_rising_edge := false;
                else
                    c0_tmp := '0';
                end if;
            end if;

            if (not c1_got_first_rising_edge) then
                if (inclk_c1'event and inclk_c1 = '1') then
                    if (c1_initial_count = c_initial_val(1)) then
                        c1_got_first_rising_edge := true;
                    else
                        c1_initial_count := c1_initial_count + 1;
                    end if;
                end if;
            elsif (inclk_c1'event) then
                c1_count := c1_count + 1;
                if (c1_count = (c_high_val(1) + c_low_val(1)) * 2) then
                    c1_count := 1;
                end if;
            end if;
            if (inclk_c1'event and inclk_c1 = '0') then
                if (c1_count = 1) then
                    c1_tmp := '1';
                    c1_got_first_rising_edge := false;
                else
                    c1_tmp := '0';
                end if;
            end if;
        end if;

    end process;

    
    locked <=   pfd_locked WHEN (test_bypass_lock_detect = "on") ELSE
                lock;


    process (scandone_tmp)
    variable buf : line;
    begin
        if (scandone_tmp'event and scandone_tmp = '1') then
            if (reconfig_err = false) then
                ASSERT false REPORT "PLL Reprogramming completed with the following values (Values in parantheses indicate values before reprogramming) :" severity note;
                write (buf, string'("    N modulus = "));
                write (buf, n_val);
                write (buf, string'(" ( "));
                write (buf, n_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M modulus = "));
                write (buf, m_val);
                write (buf, string'(" ( "));
                write (buf, m_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                write (buf, string'("    M ph_tap = "));
                write (buf, m_ph_val);
                write (buf, string'(" ( "));
                write (buf, m_ph_val_old);
                write (buf, string'(" )"));
                writeline (output, buf);

                for i in 0 to (num_output_cntrs-1) loop
                    write (buf, clk_num(i));
                    write (buf, string'(" : "));
                    write (buf, cntrs(i));
                    write (buf, string'(" :   high = "));
                    write (buf, c_high_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_high_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   low = "));
                    write (buf, c_low_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_low_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   mode = "));
                    write (buf, c_mode_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_mode_val_old(i));
                    write (buf, string'(") "));
                    write (buf, string'(" ,   phase tap = "));
                    write (buf, c_ph_val(i));
                    write (buf, string'(" ("));
                    write (buf, c_ph_val_old(i));
                    write (buf, string'(") "));
                    writeline(output, buf);
                end loop;

                IF (pll_reconfig_display_full_setting) THEN
                write (buf, string'("    Charge Pump Current (uA) = "));
                write (buf, cp_curr_val);
                write (buf, string'(" ( "));
                write (buf, cp_curr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (pF) = "));
                write (buf, lfc_val);
                write (buf, string'(" ( "));
                write (buf, lfc_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (Kohm) = "));
                write (buf, lfr_val);
                write (buf, string'(" ( "));
                write (buf, lfr_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);

                
                ELSE
                write (buf, string'("    Charge Pump Current  (bit setting) = "));
                write (buf, alt_conv_integer(cp_curr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, cp_curr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Capacitor (bit setting)  = "));
                write (buf, alt_conv_integer(lfc_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfc_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);

                write (buf, string'("    Loop Filter Resistor (bit setting)  = "));
                write (buf, alt_conv_integer(lfr_val_bit_setting));
                write (buf, string'(" ( "));
                write (buf, lfr_old_bit_setting);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                write (buf, string'("    VCO_Post_Scale = "));
                write (buf, vco_cur);
                write (buf, string'(" ( "));
                write (buf, vco_old);
                write (buf, string'(" ) "));
                writeline (output, buf);
                
                END IF;
                cp_curr_old_bit_setting <= alt_conv_integer(cp_curr_val_bit_setting);
                lfc_old_bit_setting <= alt_conv_integer(lfc_val_bit_setting);
                lfr_old_bit_setting <= alt_conv_integer(lfr_val_bit_setting);
            else ASSERT false REPORT "Errors were encountered during PLL reprogramming. Please refer to error/warning messages above." severity warning;
            end if;
        end if;
        
    end process;

    update_conf_latches <= configupdate_ipd;

    
    process (scandone_tmp,areset_ipd,update_conf_latches, c_clk(0), c_clk(1), c_clk(2), c_clk(3), c_clk(4), vco_out, fbclk, scanclk_ipd)
    variable init : boolean := true;
    variable low, high : std_logic_vector(7 downto 0);
    variable low_fast, high_fast : std_logic_vector(3 downto 0);
    variable mode : string(1 to 6) := "bypass";
    variable is_error : boolean := false;
    variable m_tmp, n_tmp : std_logic_vector(8 downto 0);
    variable lfr_val_tmp : string(1 to 2) := "  ";

    variable c_high_val_tmp,c_hval : int_array(0 to 4) := (OTHERS => 1);
    variable c_low_val_tmp,c_lval  : int_array(0 to 4) := (OTHERS => 1);
    variable c_mode_val_tmp : str_array(0 to 4);
    variable m_val_tmp      : integer := 0;
    variable c0_rising_edge_transfer_done : boolean := false;
    variable c1_rising_edge_transfer_done : boolean := false;
    variable c2_rising_edge_transfer_done : boolean := false;
    variable c3_rising_edge_transfer_done : boolean := false;
    variable c4_rising_edge_transfer_done : boolean := false;

    -- variables for scaling of multiply_by and divide_by values
    variable i_clk0_mult_by    : integer := 1;
    variable i_clk0_div_by     : integer := 1;
    variable i_clk1_mult_by    : integer := 1;
    variable i_clk1_div_by     : integer := 1;
    variable i_clk2_mult_by    : integer := 1;
    variable i_clk2_div_by     : integer := 1;
    variable i_clk3_mult_by    : integer := 1;
    variable i_clk3_div_by     : integer := 1;
    variable i_clk4_mult_by    : integer := 1;
    variable i_clk4_div_by     : integer := 1;
    variable max_d_value       : integer := 1;
    variable new_multiplier    : integer := 1;
    
    -- internal variables for storing the phase shift number.(used in lvds mode only)
    variable i_clk0_phase_shift : integer := 1;
    variable i_clk1_phase_shift : integer := 1;
    variable i_clk2_phase_shift : integer := 1;

    -- user to advanced variables

    variable   max_neg_abs    : integer := 0;
    variable   i_m_initial    : integer;
    variable   i_m            : integer := 1;
    variable   i_n            : integer := 1;
    variable   i_c_high       : int_array(0 to 4);
    variable   i_c_low       : int_array(0 to 4);
    variable   i_c_initial       : int_array(0 to 4);
    variable   i_c_ph       : int_array(0 to 4);
    variable   i_c_mode       : str_array(0 to 4);
    variable   i_m_ph         : integer;
    variable   output_count   : integer;
    variable   new_divisor    : integer;

    variable clk0_cntr : string(1 to 6) := "    c0";
    variable clk1_cntr : string(1 to 6) := "    c1";
    variable clk2_cntr : string(1 to 6) := "    c2";
    variable clk3_cntr : string(1 to 6) := "    c3";
    variable clk4_cntr : string(1 to 6) := "    c4";

    variable fbk_cntr : string(1 to 2);
    variable fbk_cntr_index : integer;
    variable start_bit : integer;
    variable quiet_time : time := 0 ps;
    variable slowest_clk_old : time := 0 ps;
    variable slowest_clk_new : time := 0 ps;

    variable i : integer := 0;
    variable j : integer := 0;
    variable scanread_active_edge : time := 0 ps;
    variable got_first_scanclk : boolean := false;
    variable scanclk_last_rising_edge : time := 0 ps;
    variable current_scan_data : std_logic_vector(0 to 143) := (OTHERS => '0');

    variable index : integer := 0;
    variable scan_chain_length : integer := GPP_SCAN_CHAIN;
    variable tmp_rem : integer := 0;
    variable scanclk_cycles : integer := 0;
    variable lfc_tmp : std_logic_vector(1 downto 0);
    variable lfr_tmp : std_logic_vector(5 downto 0);
    variable lfr_int : integer := 0;

    variable n_hi,n_lo,m_hi,m_lo : std_logic_vector(7 downto 0);
    variable buf : line;
    variable buf_scan_data : STD_LOGIC_VECTOR(0 TO 1) := (OTHERS => '0');
    variable buf_scan_data_2 : STD_LOGIC_VECTOR(0 TO 2) := (OTHERS => '0');
    
    function slowest_clk (
            C0 : integer; C0_mode : string(1 to 6);
            C1 : integer; C1_mode : string(1 to 6);
            C2 : integer; C2_mode : string(1 to 6);
            C3 : integer; C3_mode : string(1 to 6);
            C4 : integer; C4_mode : string(1 to 6);
            C5 : integer; C5_mode : string(1 to 6);
            C6 : integer; C6_mode : string(1 to 6);
            C7 : integer; C7_mode : string(1 to 6);
            C8 : integer; C8_mode : string(1 to 6);
            C9 : integer; C9_mode : string(1 to 6);
            refclk : time; m_mod : integer) return time is
    variable max_modulus : integer := 1;
    variable q_period : time := 0 ps;
    variable refclk_int : integer := 0;
    begin
        if (C0_mode /= "bypass" and C0_mode /= "   off") then
            max_modulus := C0;
        end if;
        if (C1 > max_modulus and C1_mode /= "bypass" and C1_mode /= "   off") then
            max_modulus := C1;
        end if;
        if (C2 > max_modulus and C2_mode /= "bypass" and C2_mode /= "   off") then
            max_modulus := C2;
        end if;
        if (C3 > max_modulus and C3_mode /= "bypass" and C3_mode /= "   off") then
            max_modulus := C3;
        end if;
        if (C4 > max_modulus and C4_mode /= "bypass" and C4_mode /= "   off") then
            max_modulus := C4;
        end if;
        if (C5 > max_modulus and C5_mode /= "bypass" and C5_mode /= "   off") then
            max_modulus := C5;
        end if;
        if (C6 > max_modulus and C6_mode /= "bypass" and C6_mode /= "   off") then
            max_modulus := C6;
        end if;
        if (C7 > max_modulus and C7_mode /= "bypass" and C7_mode /= "   off") then
            max_modulus := C7;
        end if;
        if (C8 > max_modulus and C8_mode /= "bypass" and C8_mode /= "   off") then
            max_modulus := C8;
        end if;
        if (C9 > max_modulus and C9_mode /= "bypass" and C9_mode /= "   off") then
            max_modulus := C9;
        end if;

        refclk_int := refclk / 1 ps;
        if (m_mod /= 0) then
            q_period := (refclk_int * max_modulus / m_mod) * 1 ps;
        end if;
        return (2*q_period);
    end slowest_clk;

    function int2bin (arg : integer; size : integer) return std_logic_vector is
    variable int_val : integer := arg;
    variable result : std_logic_vector(size-1 downto 0);
    begin
        for i in 0 to result'left loop
            if ((int_val mod 2) = 0) then
                result(i) := '0';
            else
                result(i) := '1';
            end if;
            int_val := int_val/2;
        end loop;
        return result;
    end int2bin;

    function extract_cntr_string (arg:string) return string is
    variable str : string(1 to 6) := "    c0";
    begin
        if (arg = "c0") then
            str := "    c0";
        elsif (arg = "c1") then
            str := "    c1";
        elsif (arg = "c2") then
            str := "    c2";
        elsif (arg = "c3") then
            str := "    c3";
        elsif (arg = "c4") then
            str := "    c4";
        elsif (arg = "c5") then
            str := "    c5";
        elsif (arg = "c6") then
            str := "    c6";
        elsif (arg = "c7") then
            str := "    c7";
        elsif (arg = "c8") then
            str := "    c8";
        elsif (arg = "c9") then
            str := "    c9";
        else str := "    c0";

        end if;

        return str;

    end extract_cntr_string;
    
    function extract_cntr_index (arg:string) return integer is
    variable index : integer := 0;
    begin
        if (arg(6) = '0') then
            index := 0;
        elsif (arg(6) = '1') then
            index := 1;
        elsif (arg(6) = '2') then
            index := 2;
        elsif (arg(6) = '3') then
            index := 3;
        elsif (arg(6) = '4') then
            index := 4;
        elsif (arg(6) = '5') then
            index := 5;
        elsif (arg(6) = '6') then
            index := 6;
        elsif (arg(6) = '7') then
            index := 7;
        elsif (arg(6) = '8') then
            index := 8;
        else index := 9;
        end if;

        return index;
    end extract_cntr_index;

    function output_cntr_num (arg:string) return string is
    variable str : string(1 to 6) := "unused";
    begin
        if (arg = "c0") then
            str := "  clk0";
        elsif (arg = "c1") then
            str := "  clk1";
        elsif (arg = "c2") then
            str := "  clk2";
        elsif (arg = "c3") then
            str := "  clk3";
        elsif (arg = "c4") then
            str := "  clk4";
        elsif (arg = "c5") then
            str := "  clk5";
        elsif (arg = "c6") then
            str := "  clk6";
        elsif (arg = "c7") then
            str := "  clk7";
        elsif (arg = "c8") then
            str := "  clk8";
        elsif (arg = "c9") then
            str := "  clk9";
        else str := "unused";
        end if;
        return str;
    end output_cntr_num;

    begin
        IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val <= i_c_ph;
        END IF;
        
        if (init) then
            if (m = 0) then
                clk4_cntr  := "    c4";
                clk3_cntr  := "    c3";
                clk2_cntr  := "    c2";
                clk1_cntr  := "    c1";
                clk0_cntr  := "    c0";
            else
                clk4_cntr  := extract_cntr_string(clk4_counter);
                clk3_cntr  := extract_cntr_string(clk3_counter);
                clk2_cntr  := extract_cntr_string(clk2_counter);
                clk1_cntr  := extract_cntr_string(clk1_counter);
                clk0_cntr  := extract_cntr_string(clk0_counter);
            end if;

                clk_num(4)  <= output_cntr_num(clk4_counter);
                clk_num(3)  <= output_cntr_num(clk3_counter);
                clk_num(2)  <= output_cntr_num(clk2_counter);
                clk_num(1)  <= output_cntr_num(clk1_counter);
                clk_num(0)  <= output_cntr_num(clk0_counter);
            
            i_clk0_counter <= extract_cntr_index(clk0_cntr);
            i_clk1_counter <= extract_cntr_index(clk1_cntr);
            i_clk2_counter <= extract_cntr_index(clk2_cntr);
            i_clk3_counter <= extract_cntr_index(clk3_cntr);
            i_clk4_counter <= extract_cntr_index(clk4_cntr);


            if (m = 0) then  -- convert user parameters to advanced
                -- set the limit of the divide_by value that can be returned by
                -- the following function.
                max_d_value := 500;

                -- scale down the multiply_by and divide_by values provided by the design
                -- before attempting to use them in the calculations below
                find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                                max_d_value, i_clk0_mult_by, i_clk0_div_by);
                find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                                max_d_value, i_clk1_mult_by, i_clk1_div_by);
                find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                                max_d_value, i_clk2_mult_by, i_clk2_div_by);
                find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                                max_d_value, i_clk3_mult_by, i_clk3_div_by);
                find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                                max_d_value, i_clk4_mult_by, i_clk4_div_by);
                                
                if (vco_frequency_control = "manual_phase") then
                    find_m_and_n_4_manual_phase(inclk0_input_frequency, vco_phase_shift_step,
                                i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                1,1,1,1,1,
                                i_clk0_div_by, i_clk1_div_by,
                                i_clk2_div_by, i_clk3_div_by,
                                i_clk4_div_by, 
                                1,1,1,1,1,
                                clk0_counter, clk1_counter,
                                clk2_counter, clk3_counter,
                                clk4_counter, 
                                "unused","unused","unused","unused","unused",
                        i_m, i_n);
                elsif (((pll_type = "fast") or (pll_type = "lvds") OR (pll_type = "left_right")) and ((vco_multiply_by /= 0) and (vco_divide_by /= 0))) then
                    i_n := vco_divide_by;
                    i_m := vco_multiply_by;
                elsif ((dpa_multiply_by /= 0) and (dpa_divide_by /= 0)) then
                    i_n := dpa_divide_by;
                    i_m := dpa_multiply_by;
                else
                    i_n := 1;

                    if (((pll_type = "fast") or (pll_type = "left_right")) and (compensate_clock = "lvdsclk")) then
                        i_m := i_clk0_mult_by;
                    else
                        i_m := lcm (i_clk0_mult_by, i_clk1_mult_by,
                                i_clk2_mult_by, i_clk3_mult_by,
                                i_clk4_mult_by, 
                                1,1,1,1,1,
                                inclk0_input_frequency);
                    end if;
                end if;

                if (pll_type = "flvds") then
                    -- Need to readjust phase shift values when the clock multiply value has been readjusted.
                    new_multiplier := clk0_multiply_by / i_clk0_mult_by;
                    i_clk0_phase_shift := str2int(clk0_phase_shift) * new_multiplier;
                    i_clk1_phase_shift := str2int(clk1_phase_shift) * new_multiplier;
                    i_clk2_phase_shift := str2int(clk2_phase_shift) * new_multiplier;
                else
                    i_clk0_phase_shift := str2int(clk0_phase_shift);
                    i_clk1_phase_shift := str2int(clk1_phase_shift);
                    i_clk2_phase_shift := str2int(clk2_phase_shift);
                end if;

                max_neg_abs := maxnegabs(i_clk0_phase_shift, 
                                        i_clk1_phase_shift,
                                        i_clk2_phase_shift,
                                        str2int(clk3_phase_shift),
                                        str2int(clk4_phase_shift),
                                        0,
                                        0,
                                        0,
                                        0,
                                        0
                                        );
                i_m_ph  := counter_ph(get_phase_degree(max_neg_abs,inclk0_input_frequency), i_m, i_n); 

                i_c_ph(0) := counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(1) := counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(2) := counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift,max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(3) := counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                i_c_ph(4) := counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs),inclk0_input_frequency), i_m, i_n);
                
                
                i_c_high(0) := counter_high(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);
                i_c_high(1) := counter_high(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
                i_c_high(2) := counter_high(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
                i_c_high(3) := counter_high(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
                i_c_high(4) := counter_high(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);




                i_c_low(0)  := counter_low(output_counter_value(i_clk0_div_by,
                                i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
                i_c_low(1)  := counter_low(output_counter_value(i_clk1_div_by,
                                i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
                i_c_low(2)  := counter_low(output_counter_value(i_clk2_div_by,
                                i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
                i_c_low(3)  := counter_low(output_counter_value(i_clk3_div_by,
                                i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
                i_c_low(4)  := counter_low(output_counter_value(i_clk4_div_by,
                                i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);

                i_m_initial  := counter_initial(get_phase_degree(max_neg_abs, inclk0_input_frequency), i_m,i_n);
                
                i_c_initial(0) := counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(1) := counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(2) := counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(3) := counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_initial(4) := counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs), inclk0_input_frequency), i_m, i_n);
                i_c_mode(0) := counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
                i_c_mode(1) := counter_mode(clk1_duty_cycle, output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
                i_c_mode(2) := counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
                i_c_mode(3) := counter_mode(clk3_duty_cycle, output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
                i_c_mode(4) := counter_mode(clk4_duty_cycle, output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));

                
 
            else -- m /= 0

                i_n             := n;
                i_m             := m;
                i_m_initial     := m_initial;
                i_m_ph          := m_ph;
                i_c_ph(0)         := c0_ph;
                i_c_ph(1)         := c1_ph;
                i_c_ph(2)         := c2_ph;
                i_c_ph(3)         := c3_ph;
                i_c_ph(4)         := c4_ph;
                i_c_high(0)       := c0_high;
                i_c_high(1)       := c1_high;
                i_c_high(2)       := c2_high;
                i_c_high(3)       := c3_high;
                i_c_high(4)       := c4_high;
                i_c_low(0)        := c0_low;
                i_c_low(1)        := c1_low;
                i_c_low(2)        := c2_low;
                i_c_low(3)        := c3_low;
                i_c_low(4)        := c4_low;
                i_c_initial(0)    := c0_initial;
                i_c_initial(1)    := c1_initial;
                i_c_initial(2)    := c2_initial;
                i_c_initial(3)    := c3_initial;
                i_c_initial(4)    := c4_initial;
                i_c_mode(0)       := translate_string(c0_mode);
                i_c_mode(1)       := translate_string(c1_mode);
                i_c_mode(2)       := translate_string(c2_mode);
                i_c_mode(3)       := translate_string(c3_mode);
                i_c_mode(4)       := translate_string(c4_mode);

            end if; -- user to advanced conversion.

            m_initial_val <= i_m_initial;
            n_val <= i_n;
            m_val <= i_m;

            if (i_m = 1) then
                m_mode_val <= "bypass";
            else
                m_mode_val <= "      ";
            end if;
            if (i_n = 1) then
                n_mode_val <= "bypass";
            else
                n_mode_val <= "      ";
            end if;

            m_ph_val  <= i_m_ph;
            m_ph_initial <= i_m_ph;
            m_val_tmp := i_m;

            for i in 0 to 4 loop
                if (i_c_mode(i) = "bypass") then
                    if (pll_type = "fast" or pll_type = "lvds" OR (pll_type = "left_right")) then
                        i_c_high(i) := 16;
                        i_c_low(i) := 16;
                    else
                        i_c_high(i) := 256;
                        i_c_low(i) := 256;
                    end if;
                end if;
                c_ph_val(i)         <= i_c_ph(i);
                c_initial_val(i)    <= i_c_initial(i);
                c_high_val(i)       <= i_c_high(i);
                c_low_val(i)        <= i_c_low(i);
                c_mode_val(i)       <= i_c_mode(i);
                c_high_val_tmp(i)   := i_c_high(i);
                c_hval(i)           := i_c_high(i);
                c_low_val_tmp(i)    := i_c_low(i);
                c_lval(i)           := i_c_low(i);
                c_mode_val_tmp(i)   := i_c_mode(i);
                c_ph_val_orig(i)    <= i_c_ph(i);
                c_high_val_hold(i)  <= i_c_high(i);
                c_low_val_hold(i)   <= i_c_low(i);
                c_mode_val_hold(i)  <= i_c_mode(i);
            end loop;

            

            scan_chain_length := SCAN_CHAIN;

               
            num_output_cntrs <= 5;

            init := false;
        elsif (scandone_tmp'EVENT AND scandone_tmp = '1') then
            c0_rising_edge_transfer_done := false;
            c1_rising_edge_transfer_done := false;
            c2_rising_edge_transfer_done := false;
            c3_rising_edge_transfer_done := false;
            c4_rising_edge_transfer_done := false;
            update_conf_latches_reg <= '0';
        elsif (update_conf_latches'event and update_conf_latches = '1') then
            initiate_reconfig <= '1';
        elsif (areset_ipd'event AND areset_ipd = '1') then
            if (scandone_tmp = '0') then scandone_tmp <= '1' AFTER scanclk_period; end if;
        elsif (scanclk_ipd'event and scanclk_ipd = '1') then
            IF (initiate_reconfig = '1') THEN
                initiate_reconfig <= '0';
                ASSERT false REPORT "PLL Reprogramming Initiated" severity note;

                update_conf_latches_reg <= update_conf_latches;
                reconfig_err <= false;
                scandone_tmp <= '0';
                cp_curr_old <= cp_curr_val;    
                lfc_old <= lfc_val;    
                lfr_old <= lfr_val;    
                vco_old <= vco_cur;   
                -- LF unused : bit 0,1
                -- LF Capacitance : bits 2,3 : all values are legal
                buf_scan_data := scan_data(2 TO 3);

                IF ((pll_type = "fast") OR (pll_type = "lvds") OR (pll_type = "left_right")) THEN
                    lfc_val <= fpll_loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                ELSE
                    lfc_val <= loop_filter_c_arr(alt_conv_integer(buf_scan_data));    
                END IF;
                -- LF Resistance : bits 4-8
                -- valid values - 00000,00100,10000,10100,11000,11011,11100,11110
                IF (scan_data(4 TO 8) = "00000") THEN
                    lfr_val <= "20";
                ELSIF (scan_data(4 TO 8) = "00100") THEN
                    lfr_val <= "16";
                ELSIF (scan_data(4 TO 8) = "10000") THEN
                    lfr_val <= "12";
                ELSIF (scan_data(4 TO 8) = "10100") THEN
                    lfr_val <= "08";
                ELSIF (scan_data(4 TO 8) = "11000") THEN
                    lfr_val <= "06";
                ELSIF (scan_data(4 TO 8) = "11011") THEN
                    lfr_val <= "04";
                ELSIF (scan_data(4 TO 8) = "11100") THEN
                    lfr_val <= "02"; 
                ELSE 
                    lfr_val <= "01";
                END IF;
            
             
                -- VCO post scale assignment   
                if (scan_data(9) = '1') then  -- vco_post_scale = 1
                    i_vco_max <= vco_max/2;
                    i_vco_min <= vco_min/2;
                    vco_cur <= 1;
                else
                    i_vco_max <= vco_max;
                    i_vco_min <= vco_min;  
                    vco_cur <= 2;
                end if;             
                -- CP
                -- Bit 9 : CRBYPASS
                -- Bit 10-14 : unused
                -- Bits 15-17 : all values are legal
        
                buf_scan_data_2 := scan_data(15 TO 17); 
                cp_curr_val <= charge_pump_curr_arr(alt_conv_integer(buf_scan_data_2));    
                -- save old values for display info.
                
                cp_curr_val_bit_setting <= scan_data(15 TO 17);
                lfc_val_bit_setting <= scan_data(2 TO 3);
                lfr_val_bit_setting <= scan_data(4 TO 8);
                
                m_val_old <= m_val;    
                n_val_old <= n_val;    
                m_mode_val_old <= m_mode_val;    
                n_mode_val_old <= n_mode_val;    
                WHILE (i < num_output_cntrs) LOOP
                    c_high_val_old(i) <= c_high_val(i);    
                    c_low_val_old(i) <= c_low_val(i);    
                    c_mode_val_old(i) <= c_mode_val(i);    
                    i := i + 1;
                END LOOP;
                -- M counter
                -- 1. Mode - bypass (bit 18)
                
                IF (scan_data(18) = '1') THEN
                    n_mode_val <= "bypass"; 
                -- 3. Mode - odd/even (bit 27)
                ELSIF (scan_data(27) = '1') THEN
                    n_mode_val <= "   odd";
                ELSE
                    n_mode_val <= "  even"; 
                END IF;
        
                -- 2. High (bit 19-26)
                
                n_hi := scan_data(19 TO 26);    
                
                -- 4. Low (bit 28-35)
                
                n_lo := scan_data(28 TO 35);    
                -- N counter
                -- 1. Mode - bypass (bit 36)
                
                IF (scan_data(36) = '1') THEN
                    m_mode_val <= "bypass";    
                -- 3. Mode - odd/even (bit 45)
                ELSIF  (scan_data(45) = '1') THEN
                    m_mode_val <= "   odd"; 
                ELSE
                    m_mode_val <= "  even";   
                END IF;
        
                -- 2. High (bit 37-44)
                
                m_hi := scan_data(37 TO 44);    
                
                -- 4. Low (bit 46-53)
                
                m_lo := scan_data(46 TO 53);    
                -- C counters (start bit 54) bit 1:mode(bypass),bit 2-9:high,bit 10:mode(odd/even),bit 11-18:low
                
                i := 0;
                WHILE (i < num_output_cntrs) LOOP
                    -- 1. Mode - bypass
                    
                    IF (scan_data(54 + i * 18 + 0) = '1') THEN
                        c_mode_val_tmp(i) := "bypass";    
                    -- 3. Mode - odd/even
                    ELSIF (scan_data(54 + i * 18 + 9) = '1') THEN
                        c_mode_val_tmp(i) := "   odd";    
                    ELSE
                        c_mode_val_tmp(i) := "  even";  
                    END IF;
                    -- 2. Hi
                    
                    high := scan_data(54 + i * 18 + 1 TO 54 + i * 18 + 8);
                    c_hval(i) := alt_conv_integer(high);
                    IF (c_hval(i) /= 0) THEN
                        c_high_val_tmp(i) := c_hval(i);
                    ELSE
                        c_high_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    
                    -- 4. Low 
                    
                    low := scan_data(54 + i * 18 + 10 TO 54 + i * 18 + 17);
                    c_lval(i) := alt_conv_integer(low);
                    IF (c_lval(i) /= 0) THEN
                        c_low_val_tmp(i) := c_lval(i);
                    ELSE
                        c_low_val_tmp(i) := alt_conv_integer("000000001");
                    END IF;
                    i := i + 1;
                END LOOP;
        -- Legality Checks
               
                --  M counter value
    IF(scan_data(36) /= '1') THEN
        IF ((m_hi /= m_lo) and (scan_data(45) /= '1')) THEN           
                        reconfig_err <= TRUE;    
                        WRITE(buf,string'("Warning : The M counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                        writeline(output, buf);
                    ELSIF (m_hi /= "00000000") THEN
                        m_val_tmp := alt_conv_integer(m_hi) + alt_conv_integer(m_lo);    
                    ELSE
                        m_val_tmp := alt_conv_integer("000000001");
                    END IF;
                ELSE
                    m_val_tmp := alt_conv_integer("10000000");
                END IF;
                -- N counter value
    IF(scan_data(18) /= '1') THEN             
        IF ((n_hi /= n_lo)and (scan_data(27) /= '1')) THEN         
                    reconfig_err <= TRUE;    
                    WRITE(buf,string'("Warning : The N counter of the " & family_name & " Fast PLL should be configured for 50%% duty cycle only. In this case the HIGH and LOW moduli programmed will result in a duty cycle other than 50%%, which is illegal. Reconfiguration may not work"));   
                    writeline(output, buf);
                ELSIF (n_hi /= "00000000") THEN
                    n_val <= alt_conv_integer(n_hi) + alt_conv_integer(n_lo);    
                ELSE
                    n_val <= alt_conv_integer("000000001");
                END IF;
                ELSE
                    n_val <= alt_conv_integer("10000000");
                END IF;
                -- TODO : Give warnings/errors in the following cases?
                -- 1. Illegal counter values (error)
                -- 2. Change of mode (warning)
                -- 3. Only 50% duty cycle allowed for M counter (odd mode - hi-lo=1,even - hi-lo=0)
                
            END IF;
        end if;

        
        if (fbclk'event and fbclk = '1') then
            m_val <= m_val_tmp;
        end if;
        
        if (update_conf_latches_reg = '1') then
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c0_rising_edge_transfer_done := true;
                c_high_val(0) <= c_high_val_tmp(0);
                c_mode_val(0) <= c_mode_val_tmp(0);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c1_rising_edge_transfer_done := true;
                c_high_val(1) <= c_high_val_tmp(1);
                c_mode_val(1) <= c_mode_val_tmp(1);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c2_rising_edge_transfer_done := true;
                c_high_val(2) <= c_high_val_tmp(2);
                c_mode_val(2) <= c_mode_val_tmp(2);
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(3) <= c_high_val_tmp(3);
                c_mode_val(3) <= c_mode_val_tmp(3);
                c3_rising_edge_transfer_done := true;
            end if;
            if (scanclk_ipd'event and scanclk_ipd = '1') then
                c_high_val(4) <= c_high_val_tmp(4);
                c_mode_val(4) <= c_mode_val_tmp(4);
                c4_rising_edge_transfer_done := true;
            end if;
    
    
    
    
    
        end if;

        if (scanclk_ipd'event and scanclk_ipd = '0' and c0_rising_edge_transfer_done) then
            c_low_val(0) <= c_low_val_tmp(0);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c1_rising_edge_transfer_done) then
            c_low_val(1) <= c_low_val_tmp(1);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c2_rising_edge_transfer_done) then
            c_low_val(2) <= c_low_val_tmp(2);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c3_rising_edge_transfer_done) then
            c_low_val(3) <= c_low_val_tmp(3);
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '0' and c4_rising_edge_transfer_done) then
            c_low_val(4) <= c_low_val_tmp(4);
        end if;

        if (update_phase = '1') then
            if (vco_out(0)'event and vco_out(0) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 0) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 0) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(1)'event and vco_out(1) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 1) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 1) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(2)'event and vco_out(2) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 2) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 2) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(3)'event and vco_out(3) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 3) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 3) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(4)'event and vco_out(4) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 4) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 4) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(5)'event and vco_out(5) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 5) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 5) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(6)'event and vco_out(6) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 6) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 6) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
            if (vco_out(7)'event and vco_out(7) = '0') then
                for i in 0 to 4 loop
                    if (c_ph_val(i) = 7) then
                        c_ph_val(i) <= c_ph_val_tmp(i);
                    end if;
                end loop;
                if (m_ph_val = 7) then
                    m_ph_val <= m_ph_val_tmp;
                end if;
            end if;
        end if;

        

        if (vco_out(0)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 0) then
                    inclk_c_from_vco(i) <= vco_out(0);
                end if;
            end loop;
            if (m_ph_val = 0) then
                inclk_m_from_vco <= vco_out(0);
            end if;
        end if;
        if (vco_out(1)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 1) then
                    inclk_c_from_vco(i) <= vco_out(1);
                end if;
            end loop;
            if (m_ph_val = 1) then
                inclk_m_from_vco <= vco_out(1);
            end if;
        end if;
        if (vco_out(2)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 2) then
                    inclk_c_from_vco(i) <= vco_out(2);
                end if;
            end loop;
            if (m_ph_val = 2) then
                inclk_m_from_vco <= vco_out(2);
            end if;
        end if;
        if (vco_out(3)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 3) then
                    inclk_c_from_vco(i) <= vco_out(3);
                end if;
            end loop;
            if (m_ph_val = 3) then
                inclk_m_from_vco <= vco_out(3);
            end if;
        end if;
        if (vco_out(4)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 4) then
                    inclk_c_from_vco(i) <= vco_out(4);
                end if;
            end loop;
            if (m_ph_val = 4) then
                inclk_m_from_vco <= vco_out(4);
            end if;
        end if;
        if (vco_out(5)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 5) then
                    inclk_c_from_vco(i) <= vco_out(5);
                end if;
            end loop;
            if (m_ph_val = 5) then
                inclk_m_from_vco <= vco_out(5);
            end if;
        end if;
        if (vco_out(6)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 6) then
                    inclk_c_from_vco(i) <= vco_out(6);
                end if;
            end loop;
            if (m_ph_val = 6) then
                inclk_m_from_vco <= vco_out(6);
            end if;
        end if;
        if (vco_out(7)'event) then
                for i in 0 to 4 loop
                if (c_ph_val(i) = 7) then
                    inclk_c_from_vco(i) <= vco_out(7);
                end if;
            end loop;
            if (m_ph_val = 7) then
                inclk_m_from_vco <= vco_out(7);
            end if;
        end if;
        


   
        if (scanclk_ipd'event AND scanclk_ipd = '0' AND now > 0 ps) then
            scanclkena_reg <= scanclkena_ipd;
            if (scanclkena_reg = '1') then
                scandata_in <= scandata_ipd;
                scandata_out <= scandataout_tmp;
            end if;
        end if;
        if (scanclk_ipd'event and scanclk_ipd = '1' and now > 0 ps) then
            if (got_first_scanclk) then
                scanclk_period <= now - scanclk_last_rising_edge;
            else
                got_first_scanclk := true;
            end if;
            if (scanclkena_reg = '1') then
            for j in scan_chain_length - 1 downto 1 loop
                scan_data(j) <= scan_data(j-1);
            end loop;
            scan_data(0) <= scandata_in;
            end if;
            scanclk_last_rising_edge := now;
        end if;
    end process;

-- PLL Phase Reconfiguration

PROCESS(scanclk_ipd, areset_ipd,phasestep_ipd)
    VARIABLE i : INTEGER := 0;
    VARIABLE c_ph : INTEGER := 0;
    VARIABLE m_ph : INTEGER := 0;
    VARIABLE select_counter :  INTEGER := 0;
BEGIN
    IF (NOW = 0 ps) THEN
        m_ph_val_tmp <= m_ph_initial;
    END IF;
            
    -- Latch phase enable (same as phasestep) on neg edge of scan clock
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '0') THEN
        phasestep_reg <= phasestep_ipd;
    END IF;  
     
    IF (phasestep_ipd'EVENT and phasestep_ipd = '1') THEN
        IF (update_phase = '0') THEN 
            phasestep_high_count <= 0;  -- phase adjustments must be 1 cycle apart
                                        -- if not, next phasestep cycle is skipped
        END IF;
    END IF;     
    -- revert counter phase tap values to POF programmed values
    -- if PLL is reset

    IF (areset_ipd'EVENT AND areset_ipd = '1') then
            c_ph_val_tmp <= c_ph_val_orig;
            m_ph_val_tmp <= m_ph_initial;
    END IF;
    
    IF (scanclk_ipd'EVENT AND scanclk_ipd = '1') THEN
    IF (phasestep_reg = '1') THEN
        IF (phasestep_high_count = 1) THEN
            phasecounterselect_reg <= phasecounterselect_ipd;
            phaseupdown_reg <= phaseupdown_ipd;
            -- start reconfiguration
            IF (phasecounterselect_ipd < "111")  THEN -- no counters selected
            IF (phasecounterselect_ipd = "000") THEN
                            i := 0;
                            WHILE (i < num_output_cntrs) LOOP
                                c_ph := c_ph_val(i);
                                IF (phaseupdown_ipd = '1') THEN
                                    c_ph := (c_ph + 1) mod num_phase_taps;
                                ELSIF (c_ph = 0) THEN
                                    c_ph := num_phase_taps - 1;
                                ELSE
                                    c_ph := (c_ph - 1) mod num_phase_taps;
                                END IF;
                                c_ph_val_tmp(i) <= c_ph;
                                i := i + 1;
                            END LOOP;
            ELSIF (phasecounterselect_ipd = "001") THEN
                            m_ph := m_ph_val;
                            IF (phaseupdown_ipd = '1') THEN
                                m_ph := (m_ph + 1) mod num_phase_taps;
                            ELSIF (m_ph = 0) THEN
                                m_ph := num_phase_taps - 1;
                            ELSE
                                m_ph := (m_ph - 1) mod num_phase_taps;
                            END IF;
                            m_ph_val_tmp <= m_ph;
                        ELSE
                            select_counter := alt_conv_integer(phasecounterselect_ipd) - 2;
                            c_ph := c_ph_val(select_counter);
                            IF (phaseupdown_ipd = '1') THEN
                                c_ph := (c_ph + 1) mod num_phase_taps;
                            ELSIF (c_ph = 0) THEN
                                c_ph := num_phase_taps - 1;
                            ELSE
                                c_ph := (c_ph - 1) mod num_phase_taps;
                            END IF;
                                c_ph_val_tmp(select_counter) <= c_ph;
                        END IF; 
                        update_phase <= '1','0' AFTER (0.5 * scanclk_period);
                    END IF;
                END IF;
                phasestep_high_count <= phasestep_high_count + 1; 
       
        END IF;
    END IF;
END PROCESS;

    scandataout_tmp <= scan_data(SCAN_CHAIN - 2);

    process (schedule_vco, areset_ipd, pfdena_ipd, refclk, fbclk)
    variable sched_time : time := 0 ps;

    TYPE time_array is ARRAY (0 to 7) of time;
    variable init : boolean := true;
    variable refclk_period : time;
    variable m_times_vco_period : time;
    variable new_m_times_vco_period : time;

    variable phase_shift : time_array := (OTHERS => 0 ps);
    variable last_phase_shift : time_array := (OTHERS => 0 ps);

    variable l_index : integer := 1;
    variable cycle_to_adjust : integer := 0;

    variable stop_vco : boolean := false;

    variable locked_tmp : std_logic := '0';
    variable pll_is_locked : boolean := false;
    variable cycles_pfd_low : integer := 0;
    variable cycles_pfd_high : integer := 0;
    variable cycles_to_lock : integer := 0;
    variable cycles_to_unlock : integer := 0;

    variable got_first_refclk : boolean := false;
    variable got_second_refclk : boolean := false;
    variable got_first_fbclk : boolean := false;

    variable refclk_time : time := 0 ps;
    variable fbclk_time : time := 0 ps;
    variable first_fbclk_time : time := 0 ps;

    variable fbclk_period : time := 0 ps;

    variable first_schedule : boolean := true;

    variable vco_val : std_logic := '0';
    variable vco_period_was_phase_adjusted : boolean := false;
    variable phase_adjust_was_scheduled : boolean := false;

    variable loop_xplier : integer;
    variable loop_initial : integer := 0;
    variable loop_ph : integer := 0;
    variable loop_time_delay : integer := 0;

    variable initial_delay : time := 0 ps;
    variable vco_per : time;
    variable tmp_rem : integer;
    variable my_rem : integer;
    variable fbk_phase : integer := 0;

    variable pull_back_M : integer := 0;
    variable total_pull_back : integer := 0;
    variable fbk_delay : integer := 0;

    variable offset : time := 0 ps;

    variable tmp_vco_per : integer := 0;
    variable high_time : time;
    variable low_time : time;

    variable got_refclk_posedge : boolean := false;
    variable got_fbclk_posedge : boolean := false;
    variable inclk_out_of_range : boolean := false;
    variable no_warn : boolean := false;

    variable ext_fbk_cntr_modulus : integer := 1;
    variable init_clks : boolean := true;
    variable pll_is_in_reset : boolean := false;
    variable buf : line;
    begin
        if (init) then

            -- jump-start the VCO
            -- add 1 ps delay to ensure all signals are updated to initial
            -- values
            schedule_vco <= transport not schedule_vco after 1 ps;

            init := false;
        end if;

        if (schedule_vco'event) then
            if (init_clks) then
                refclk_period := inclk0_input_frequency * n_val * 1 ps;

                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                init_clks := false;
            end if;
            sched_time := 0 ps;
            for i in 0 to 7 loop
                last_phase_shift(i) := phase_shift(i);
            end loop;
            cycle_to_adjust := 0;
            l_index := 1;
            m_times_vco_period := new_m_times_vco_period;
        end if;

        -- areset was asserted
        if (areset_ipd'event and areset_ipd = '1') then
            assert false report family_name & " PLL was reset" severity note;
            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;
        end if;


        if (schedule_vco'event and (areset_ipd = '1' or stop_vco)) then

            if (areset_ipd = '1') then
                pll_is_in_reset := true;
                got_first_refclk := false;
                got_second_refclk := false;
            end if;

            -- drop VCO taps to 0
            for i in 0 to 7 loop
                vco_out(i) <= transport '0' after last_phase_shift(i);
                phase_shift(i) := 0 ps;
                last_phase_shift(i) := 0 ps;
            end loop;

            -- reset lock parameters
            pll_is_locked := false;
            cycles_to_lock := 0;
            cycles_to_unlock := 0;

            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := 0 ps;
            got_first_fbclk := false;
            fbclk_time := 0 ps;
            first_fbclk_time := 0 ps;
            fbclk_period := 0 ps;

            first_schedule := true;
            vco_val := '0';
            vco_period_was_phase_adjusted := false;
            phase_adjust_was_scheduled := false;

        elsif ((schedule_vco'event or areset_ipd'event) and areset_ipd = '0'  and (not stop_vco) and now > 0 ps) then

            -- note areset deassert time
            -- note it as refclk_time to prevent false triggering
            -- of stop_vco after areset
            if (areset_ipd'event and areset_ipd = '0' and pll_is_in_reset) then
                refclk_time := now;
                pll_is_in_reset := false;
                locked_tmp := '0';
            end if;

            -- calculate loop_xplier : this will be different from m_val
            -- in external_feedback_mode
            loop_xplier := m_val;
            loop_initial := m_initial_val - 1;
            loop_ph := m_ph_val;


            -- convert initial value to delay
            initial_delay := (loop_initial * m_times_vco_period)/loop_xplier;

            -- convert loop ph_tap to delay
            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            tmp_vco_per := (m_times_vco_period/1 ps) / loop_xplier;
            if (my_rem /= 0) then
                tmp_vco_per := tmp_vco_per + 1;
            end if;
            fbk_phase := (loop_ph * tmp_vco_per)/8;

            pull_back_M := initial_delay/1 ps + fbk_phase;

            total_pull_back := pull_back_M;

            if (simulation_type = "timing") then
                total_pull_back := total_pull_back + pll_compensation_delay;
            end if;
            while (total_pull_back > refclk_period/1 ps) loop
                total_pull_back := total_pull_back - refclk_period/1 ps;
            end loop;

            if (total_pull_back > 0) then
                offset := refclk_period - (total_pull_back * 1 ps);
            end if;
            
            fbk_delay := total_pull_back - fbk_phase;
            if (fbk_delay < 0) then
                offset := offset - (fbk_phase * 1 ps);
                fbk_delay := total_pull_back;
            end if;

            -- assign m_delay
            m_delay <= transport fbk_delay after 1 ps;

            my_rem := (m_times_vco_period/1 ps) rem loop_xplier;
            for i in 1 to loop_xplier loop
                -- adjust cycles
                tmp_vco_per := (m_times_vco_period/1 ps)/loop_xplier;
                if (my_rem /= 0 and l_index <= my_rem) then
                    tmp_rem := (loop_xplier * l_index) rem my_rem;
                    cycle_to_adjust := (loop_xplier * l_index) / my_rem;
                    if (tmp_rem /= 0) then
                        cycle_to_adjust := cycle_to_adjust + 1;
                    end if;
                end if;
                if (cycle_to_adjust = i) then
                    tmp_vco_per := tmp_vco_per + 1;
                    l_index := l_index + 1;
                end if;

                -- calculate high and low periods
                vco_per := tmp_vco_per * 1 ps;
                high_time := (tmp_vco_per/2) * 1 ps;
                if (tmp_vco_per rem 2 /= 0) then
                    high_time := high_time + 1 ps;
                end if;
                low_time := vco_per - high_time;

                -- schedule the rising and falling edges
                for j in 1 to 2 loop
                    vco_val := not vco_val;
                    if (vco_val = '0') then
                        sched_time := sched_time + high_time;
                    elsif (vco_val = '1') then
                        sched_time := sched_time + low_time;
                    end if;

                    -- schedule the phase taps
                    for k in 0 to 7 loop
                        phase_shift(k) := (k * vco_per)/8;
                        if (first_schedule) then
                            vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                        else
                            vco_out(k) <= transport vco_val after (sched_time + last_phase_shift(k));
                        end if;
                    end loop;
                end loop;
            end loop;

            -- schedule once more
            if (first_schedule) then
                vco_val := not vco_val;
                if (vco_val = '0') then
                    sched_time := sched_time + high_time;
                elsif (vco_val = '1') then
                    sched_time := sched_time + low_time;
                end if;
                -- schedule the phase taps
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                    vco_out(k) <= transport vco_val after (sched_time + phase_shift(k));
                end loop;
                first_schedule := false;
            end if;

            schedule_vco <= transport not schedule_vco after sched_time;

            if (vco_period_was_phase_adjusted) then
                m_times_vco_period := refclk_period;
                new_m_times_vco_period := refclk_period;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := true;

                vco_per := m_times_vco_period/loop_xplier;
                for k in 0 to 7 loop
                    phase_shift(k) := (k * vco_per)/8;
                end loop;
            end if;
        end if;
-- Bypass lock detect

if (refclk'event and refclk = '1' and areset_ipd = '0') then
    if (test_bypass_lock_detect = "on") then
        if (pfdena_ipd = '1') then
            cycles_pfd_low := 0;
            if (pfd_locked = '0') then
                if (cycles_pfd_high = lock_high) then
                    assert false report family_name & " PLL locked in test mode on PFD enable assertion." severity warning;
                    pfd_locked <= '1';
                end if;
                cycles_pfd_high := cycles_pfd_high + 1;
            end if;
        end if;
        
        if (pfdena_ipd = '0') then
            cycles_pfd_high := 0;
            if (pfd_locked = '1') then
                if (cycles_pfd_low = lock_low) then
                    assert false report family_name & " PLL lost lock in test mode on PFD enable de-assertion." severity warning;
                    pfd_locked <= '0';
                end if;
                cycles_pfd_low := cycles_pfd_low + 1;
            end if;
        end if;
    end if;
        
            
        if (refclk'event and refclk = '1' and areset_ipd = '0') then
            got_refclk_posedge := true;
            if (not got_first_refclk) then
                got_first_refclk := true;
            else
                got_second_refclk := true;
                refclk_period := now - refclk_time;

                -- check if incoming freq. will cause VCO range to be
                -- exceeded
                if ( (i_vco_max /= 0 and i_vco_min /= 0 and pfdena_ipd = '1') and
                    (((refclk_period/1 ps)/loop_xplier > i_vco_max) or
                    ((refclk_period/1 ps)/loop_xplier < i_vco_min)) ) then
                    if (pll_is_locked) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        if (inclk_out_of_range) then
                            pll_is_locked := false;
                            locked_tmp := '0';
                            cycles_to_lock := 0;
                            vco_period_was_phase_adjusted := false;
                            phase_adjust_was_scheduled := false;
                            assert false report family_name & " PLL lost lock." severity note;
                        end if;
                    elsif (not no_warn) then
                        if ((refclk_period/1 ps)/loop_xplier > i_vco_max) then
                            assert false report "Input clock freq. is over VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_over <= '1';
                        end if;
                        if ((refclk_period/1 ps)/loop_xplier < i_vco_min) then
                            assert false report "Input clock freq. is under VCO range. " & family_name & " PLL may lose lock" severity warning;
                            vco_under <= '1';
                        end if;
                        assert false report " Input clock freq. is not within VCO range : " & family_name & " PLL may not lock. Please use the correct frequency." severity warning;
                        no_warn := true;
                    end if;
                    inclk_out_of_range := true;
                else
                    vco_over  <= '0';
                    vco_under <= '0';
                    inclk_out_of_range := false;
                    no_warn := false;
                end if;
            end if;
        end if;

            if (stop_vco) then
                stop_vco := false;
                schedule_vco <= not schedule_vco;
            end if;

            refclk_time := now;
        else
            got_refclk_posedge := false;
        end if;

-- Update M counter value on feedback clock edge

        if (fbclk'event and fbclk = '1') then
            got_fbclk_posedge := true;
            if (not got_first_fbclk) then
                got_first_fbclk := true;
            else
                fbclk_period := now - fbclk_time;
            end if;

            -- need refclk_period here, so initialized to proper value above
            if ( ( (now - refclk_time > 1.5 * refclk_period) and pfdena_ipd = '1' and pll_is_locked) or
                ( (now - refclk_time > 5 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = false) or
                ( (now - refclk_time > 50 * refclk_period) and pfdena_ipd = '1' and pll_has_just_been_reconfigured = true) ) then
                stop_vco := true;
                -- reset
                got_first_refclk := false;
                got_first_fbclk := false;
                got_second_refclk := false;
                if (pll_is_locked) then
                    pll_is_locked := false;
                    locked_tmp := '0';
                    assert false report family_name & " PLL lost lock due to loss of input clock or the input clock is not detected within the allowed time frame." severity note;
                    if ((i_vco_max = 0) and (i_vco_min = 0)) then
                        assert false report "Please run timing simulation to check whether the input clock is operating within the supported VCO range or not." severity note;
                    end if;
                end if;
                cycles_to_lock := 0;
                cycles_to_unlock := 0;
                first_schedule := true;
                vco_period_was_phase_adjusted := false;
                phase_adjust_was_scheduled := false;
            end if;
            fbclk_time := now;
        else
            got_fbclk_posedge := false;
        end if;

        if ((got_refclk_posedge or got_fbclk_posedge) and got_second_refclk and pfdena_ipd = '1' and (not inclk_out_of_range)) then

            -- now we know actual incoming period
            if ( abs(fbclk_time - refclk_time) <= 5 ps or
                (got_first_fbclk and abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5 ps)) then
                -- considered in phase
                if (cycles_to_lock = real_lock_high) then
                    if (not pll_is_locked) then
                        assert false report family_name & " PLL locked to incoming clock" severity note;
                    end if;
                    pll_is_locked := true;
                    locked_tmp := '1';
                    cycles_to_unlock := 0;
                end if;
                -- increment lock counter only if second part of above
                -- time check is NOT true
                if (not(abs(refclk_period - abs(fbclk_time - refclk_time)) <= lock_window)) then
                    cycles_to_lock := cycles_to_lock + 1;
                end if;

                -- adjust m_times_vco_period
                new_m_times_vco_period := refclk_period;
            else
                -- if locked, begin unlock
                if (pll_is_locked) then
                    cycles_to_unlock := cycles_to_unlock + 1;
                    if (cycles_to_unlock = lock_low) then
                        pll_is_locked := false;
                        locked_tmp := '0';
                        cycles_to_lock := 0;
                        vco_period_was_phase_adjusted := false;
                        phase_adjust_was_scheduled := false;
                        assert false report family_name & " PLL lost lock." severity note;
                        got_first_refclk := false;
                        got_first_fbclk := false;
                        got_second_refclk := false;
                    end if;
                end if;
                if ( abs(refclk_period - fbclk_period) <= 2 ps ) then
                    -- frequency is still good
                    if (now = fbclk_time and (not phase_adjust_was_scheduled)) then
                        if ( abs(fbclk_time - refclk_time) > refclk_period/2) then
                            new_m_times_vco_period := m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                            vco_period_was_phase_adjusted := true;
                        else
                            new_m_times_vco_period := m_times_vco_period - abs(fbclk_time - refclk_time);
                            vco_period_was_phase_adjusted := true;
                        end if;

                    end if;
                else
                    phase_adjust_was_scheduled := false;
                    new_m_times_vco_period := refclk_period;
                end if;
            end if;
        end if;

        if (pfdena_ipd = '0') then
            if (pll_is_locked) then
                locked_tmp := 'X';
            end if;
            pll_is_locked := false;
            cycles_to_lock := 0;
        end if;

        -- give message only at time of deassertion
        if (pfdena_ipd'event and pfdena_ipd = '0') then
            assert false report "PFDENA deasserted." severity note;
        elsif (pfdena_ipd'event and pfdena_ipd = '1') then
            got_first_refclk := false;
            got_second_refclk := false;
            refclk_time := now;
        end if;

        if (reconfig_err) then
            lock <= '0';
        else
            lock <= locked_tmp;
        end if;

        -- signal to calculate quiet_time
        sig_refclk_period <= refclk_period;

        if (stop_vco = true) then
            sig_stop_vco <= '1';
        else
            sig_stop_vco <= '0';
        end if;
        
        pll_locked <= pll_is_locked;
    end process;

    clk0_tmp <= c_clk(i_clk0_counter);
    clk_pfd(0) <= clk0_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(0)   <= clk_pfd(0) WHEN (test_bypass_lock_detect = "on") ELSE 
                clk0_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else
                'X';

    clk1_tmp <= c_clk(i_clk1_counter);
    clk_pfd(1) <= clk1_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(1)   <= clk_pfd(1) WHEN (test_bypass_lock_detect = "on") ELSE
                clk1_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk2_tmp <= c_clk(i_clk2_counter);
    clk_pfd(2) <= clk2_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(2)   <= clk_pfd(2) WHEN (test_bypass_lock_detect = "on") ELSE
                clk2_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk3_tmp <= c_clk(i_clk3_counter);
    clk_pfd(3) <= clk3_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(3)   <= clk_pfd(3) WHEN (test_bypass_lock_detect = "on") ELSE
                clk3_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    clk4_tmp <= c_clk(i_clk4_counter);
    clk_pfd(4) <= clk4_tmp WHEN (pfd_locked = '1') ELSE 'X';
    clk(4)   <= clk_pfd(4) WHEN (test_bypass_lock_detect = "on") ELSE
                clk4_tmp when (areset_ipd = '1' or pll_in_test_mode) or (pll_locked and (not reconfig_err)) else 'X';

    scandataout <= scandata_out;
    scandone <= NOT scandone_tmp;
    phasedone <= NOT update_phase;
    vcooverrange <= 'Z' WHEN (vco_range_detector_high_bits = -1) ELSE vco_over;
    vcounderrange <= 'Z' WHEN (vco_range_detector_low_bits = -1) ELSE vco_under;
    fbout <= fbclk;
    fref <= refclk;
    icdrclk <= icdr_clk;
end vital_pll;
-- END ARCHITECTURE VITAL_PLL

-- START ENTITY HEADER ---------------------------------------------------------
--
-- Entity Name      : ALTPLL
--
-- Description      : Phase-Locked Loop (PLL) behavioral model. Model supports
--                    basic PLL features such as clock division and
--                    multiplication, programmable duty cycle and phase shifts,
--                    various feedback modes and clock delays. Also supports
--                    real-time reconfiguration of PLL "parameters" and clock
--                    switchover between the 2 input reference clocks.
--                    Up to 10 clock outputs may be used.
--
-- Limitations      : Applicable to Stratix, Stratix-GX, Stratix II and Cyclone II
--                    device families only. There is no support in the model for
--                    spread-spectrum feature.
--
-- Expected results : Up to 10 different output clocks, each defined by its own
--                    parameters. Locked output (active high) indicates when
--                    the PLL locks. clkbad, clkloss and activeclock highlights
--                    which clock has gone bad, when clock switchover initiates,
--                    and which input clock (0 or 1) is the reference clock,
--                    respectively. scandataout is the data output of the serial
--                    scan chain.
--
-- END ENTITY HEADER -----------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use work.ALTERA_DEVICE_FAMILIES.all;
use work.MF_stratix_pll;
use work.MF_stratixii_pll;
use work.MF_stratixiii_pll;
use work.MF_cycloneiii_pll;
use work.MF_cycloneiiigl_pll;
use work.pll_iobuf;

-- ENTITY DECLARATION
entity altpll is
generic (
        intended_device_family     : string := "Stratix" ;
        operation_mode             : string := "NORMAL" ;
        pll_type                   : string := "AUTO" ;
        qualify_conf_done          : string := "OFF" ;
        compensate_clock           : string := "CLK0" ;
        scan_chain                 : string := "LONG";
        primary_clock              : string := "inclk0" ;
        inclk0_input_frequency     : natural;   -- required parameter
        inclk1_input_frequency     : natural := 0;
        gate_lock_signal           : string := "NO";
        gate_lock_counter          : integer := 0;
        lock_high                  : natural := 1;
        lock_low                   : natural := 0;
        valid_lock_multiplier      : natural := 1;
        invalid_lock_multiplier    : natural := 5;
        switch_over_type           : string := "AUTO" ;
        switch_over_on_lossclk     : string := "OFF" ;
        switch_over_on_gated_lock  : string := "OFF" ;
        enable_switch_over_counter : string := "OFF";
        switch_over_counter        : natural := 0;
        feedback_source            : string := "EXTCLK0" ;
        bandwidth                  : natural := 0;
        bandwidth_type             : string := "UNUSED";
        lpm_hint                   : string := "UNUSED";
        spread_frequency           : natural := 0;
        down_spread                : string := "0.0";
        self_reset_on_gated_loss_lock : string := "OFF";
        self_reset_on_loss_lock      : string := "OFF";
        lock_window_ui             : string := "0.05";
        width_clock                : natural := 6;
        width_phasecounterselect   : natural := 4;
        using_fbmimicbidir_port    : string := "ON";
        charge_pump_current_bits   : natural := 9999;
        loop_filter_c_bits         : natural := 9999;
        loop_filter_r_bits         : natural := 9999;
        scan_chain_mif_file        : string  := "UNUSED";

        -- simulation-only parameters
        simulation_type            : string := "functional";
        source_is_pll              : string := "off";
        skip_vco                   : string := "off";
        -- internal clock (i.e. clock that feeds the core) specifications
        clk9_multiply_by           : natural := 1;
        clk8_multiply_by           : natural := 1;
        clk7_multiply_by           : natural := 1;
        clk6_multiply_by           : natural := 1;
        clk5_multiply_by           : natural := 1;
        clk4_multiply_by           : natural := 1;
        clk3_multiply_by           : natural := 1;
        clk2_multiply_by           : natural := 1;
        clk1_multiply_by           : natural := 1;
        clk0_multiply_by           : natural := 1;
        clk9_divide_by             : natural := 1;
        clk8_divide_by             : natural := 1;
        clk7_divide_by             : natural := 1;
        clk6_divide_by             : natural := 1;
        clk5_divide_by             : natural := 1;
        clk4_divide_by             : natural := 1;
        clk3_divide_by             : natural := 1;
        clk2_divide_by             : natural := 1;
        clk1_divide_by             : natural := 1;
        clk0_divide_by             : natural := 1;
        clk9_phase_shift           : string := "0";
        clk8_phase_shift           : string := "0";
        clk7_phase_shift           : string := "0";
        clk6_phase_shift           : string := "0";
        clk5_phase_shift           : string := "0";
        clk4_phase_shift           : string := "0";
        clk3_phase_shift           : string := "0";
        clk2_phase_shift           : string := "0";
        clk1_phase_shift           : string := "0";
        clk0_phase_shift           : string := "0";
        clk5_time_delay            : string := "0";
        clk4_time_delay            : string := "0";
        clk3_time_delay            : string := "0";
        clk2_time_delay            : string := "0";
        clk1_time_delay            : string := "0";
        clk0_time_delay            : string := "0";
        clk9_duty_cycle            : natural := 50;
        clk8_duty_cycle            : natural := 50;
        clk7_duty_cycle            : natural := 50;
        clk6_duty_cycle            : natural := 50;
        clk5_duty_cycle            : natural := 50;
        clk4_duty_cycle            : natural := 50;
        clk3_duty_cycle            : natural := 50;
        clk2_duty_cycle            : natural := 50;
        clk1_duty_cycle            : natural := 50;
        clk0_duty_cycle            : natural := 50;
        clk9_use_even_counter_mode : string := "OFF";
        clk8_use_even_counter_mode : string := "OFF";
        clk7_use_even_counter_mode : string := "OFF";
        clk6_use_even_counter_mode : string := "OFF";
        clk5_use_even_counter_mode : string := "OFF";
        clk4_use_even_counter_mode : string := "OFF";
        clk3_use_even_counter_mode : string := "OFF";
        clk2_use_even_counter_mode : string := "OFF";
        clk1_use_even_counter_mode : string := "OFF";
        clk0_use_even_counter_mode : string := "OFF";
        clk9_use_even_counter_value  : string := "OFF";
        clk8_use_even_counter_value  : string := "OFF";
        clk7_use_even_counter_value  : string := "OFF";
        clk6_use_even_counter_value  : string := "OFF";
        clk5_use_even_counter_value  : string := "OFF";
        clk4_use_even_counter_value  : string := "OFF";
        clk3_use_even_counter_value  : string := "OFF";
        clk2_use_even_counter_value  : string := "OFF";
        clk1_use_even_counter_value  : string := "OFF";
        clk0_use_even_counter_value  : string := "OFF";

        clk2_output_frequency      : natural := 0;
        clk1_output_frequency      : natural := 0;
        clk0_output_frequency      : natural := 0;        
        
        -- external clock (i.e. clock that feeds pins) specifications
        extclk3_multiply_by        : natural := 1;
        extclk2_multiply_by        : natural := 1;
        extclk1_multiply_by        : natural := 1;
        extclk0_multiply_by        : natural := 1;
        extclk3_divide_by          : natural := 1;
        extclk2_divide_by          : natural := 1;
        extclk1_divide_by          : natural := 1;
        extclk0_divide_by          : natural := 1;
        extclk3_phase_shift        : string := "0";
        extclk2_phase_shift        : string := "0";
        extclk1_phase_shift        : string := "0";
        extclk0_phase_shift        : string := "0";
        extclk3_time_delay         : string := "0";
        extclk2_time_delay         : string := "0";
        extclk1_time_delay         : string := "0";
        extclk0_time_delay         : string := "0";
        extclk3_duty_cycle         : natural := 50;
        extclk2_duty_cycle         : natural := 50;
        extclk1_duty_cycle         : natural := 50;
        extclk0_duty_cycle         : natural := 50;

        -- The following 4 parameters are for Stratix II pll in lvds mode only 
        vco_multiply_by            : integer := 0;
        vco_divide_by              : integer := 0;
        sclkout0_phase_shift       : string := "0";
        sclkout1_phase_shift       : string := "0";
        
        dpa_multiply_by            : integer := 0;
        dpa_divide_by              : integer := 0;
        dpa_divider                : integer := 0;


        -- advanced user parameters
        vco_min                    : natural := 0;
        vco_max                    : natural := 0;
        vco_center                 : natural := 0;
        pfd_min                    : natural := 0;
        pfd_max                    : natural := 0;
        m_initial                  : natural := 1;
        m                          : natural := 0; -- m must default to 0 to force altpll to calculate the internal parameters for itself
        n                          : natural := 1;
        m2                         : natural := 1;
        n2                         : natural := 1;
        ss                         : natural := 0;
        c0_high                    : natural := 1;
        c1_high                    : natural := 1;
        c2_high                    : natural := 1;
        c3_high                    : natural := 1;
        c4_high                    : natural := 1;
        c5_high                    : natural := 1;
        c6_high                    : natural := 1;
        c7_high                    : natural := 1;
        c8_high                    : natural := 1;
        c9_high                    : natural := 1;
        l0_high                    : natural := 1;
        l1_high                    : natural := 1;
        g0_high                    : natural := 1;
        g1_high                    : natural := 1;
        g2_high                    : natural := 1;
        g3_high                    : natural := 1;
        e0_high                    : natural := 1;
        e1_high                    : natural := 1;
        e2_high                    : natural := 1;
        e3_high                    : natural := 1;
        c0_low                     : natural := 1;
        c1_low                     : natural := 1;
        c2_low                     : natural := 1;
        c3_low                     : natural := 1;
        c4_low                     : natural := 1;
        c5_low                     : natural := 1;
        c6_low                     : natural := 1;
        c7_low                     : natural := 1;
        c8_low                     : natural := 1;
        c9_low                     : natural := 1;
        l0_low                     : natural := 1;
        l1_low                     : natural := 1;
        g0_low                     : natural := 1;
        g1_low                     : natural := 1;
        g2_low                     : natural := 1;
        g3_low                     : natural := 1;
        e0_low                     : natural := 1;
        e1_low                     : natural := 1;
        e2_low                     : natural := 1;
        e3_low                     : natural := 1;
        c0_initial                 : natural := 1;
        c1_initial                 : natural := 1;
        c2_initial                 : natural := 1;
        c3_initial                 : natural := 1;
        c4_initial                 : natural := 1;
        c5_initial                 : natural := 1;
        c6_initial                 : natural := 1;
        c7_initial                 : natural := 1;
        c8_initial                 : natural := 1;
        c9_initial                 : natural := 1;
        l0_initial                 : natural := 1;
        l1_initial                 : natural := 1;
        g0_initial                 : natural := 1;
        g1_initial                 : natural := 1;
        g2_initial                 : natural := 1;
        g3_initial                 : natural := 1;
        e0_initial                 : natural := 1;
        e1_initial                 : natural := 1;
        e2_initial                 : natural := 1;
        e3_initial                 : natural := 1;
        c0_mode                    : string := "bypass" ;
        c1_mode                    : string := "bypass" ;
        c2_mode                    : string := "bypass" ;
        c3_mode                    : string := "bypass" ;
        c4_mode                    : string := "bypass" ;
        c5_mode                    : string := "bypass" ;
        c6_mode                    : string := "bypass" ;
        c7_mode                    : string := "bypass" ;
        c8_mode                    : string := "bypass" ;
        c9_mode                    : string := "bypass" ;
        l0_mode                    : string := "bypass" ;
        l1_mode                    : string := "bypass" ;
        g0_mode                    : string := "bypass" ;
        g1_mode                    : string := "bypass" ;
        g2_mode                    : string := "bypass" ;
        g3_mode                    : string := "bypass" ;
        e0_mode                    : string := "bypass" ;
        e1_mode                    : string := "bypass" ;
        e2_mode                    : string := "bypass" ;
        e3_mode                    : string := "bypass" ;
        c0_ph                      : natural := 0;
        c1_ph                      : natural := 0;
        c2_ph                      : natural := 0;
        c3_ph                      : natural := 0;
        c4_ph                      : natural := 0;
        c5_ph                      : natural := 0;
        c6_ph                      : natural := 0;
        c7_ph                      : natural := 0;
        c8_ph                      : natural := 0;
        c9_ph                      : natural := 0;
        l0_ph                      : natural := 0;
        l1_ph                      : natural := 0;
        g0_ph                      : natural := 0;
        g1_ph                      : natural := 0;
        g2_ph                      : natural := 0;
        g3_ph                      : natural := 0;
        e0_ph                      : natural := 0;
        e1_ph                      : natural := 0;
        e2_ph                      : natural := 0;
        e3_ph                      : natural := 0;
        m_ph                       : natural := 0;
        l0_time_delay              : natural := 0;
        l1_time_delay              : natural := 0;
        g0_time_delay              : natural := 0;
        g1_time_delay              : natural := 0;
        g2_time_delay              : natural := 0;
        g3_time_delay              : natural := 0;
        e0_time_delay              : natural := 0;
        e1_time_delay              : natural := 0;
        e2_time_delay              : natural := 0;
        e3_time_delay              : natural := 0;
        m_time_delay               : natural := 0;
        n_time_delay               : natural := 0;
        c1_use_casc_in             : string := "off";
        c2_use_casc_in             : string := "off";
        c3_use_casc_in             : string := "off";
        c4_use_casc_in             : string := "off";
        c5_use_casc_in             : string := "off";
        c6_use_casc_in             : string := "off";
        c7_use_casc_in             : string := "off";
        c8_use_casc_in             : string := "off";
        c9_use_casc_in             : string := "off";
        extclk3_counter            : string := "e3" ;
        extclk2_counter            : string := "e2" ;
        extclk1_counter            : string := "e1" ;
        extclk0_counter            : string := "e0" ;
        clk9_counter               : string := "c9" ;
        clk8_counter               : string := "c8" ;
        clk7_counter               : string := "c7" ;
        clk6_counter               : string := "c6" ;
        clk5_counter               : string := "l1" ;
        clk4_counter               : string := "l0" ;
        clk3_counter               : string := "g3" ;
        clk2_counter               : string := "g2" ;
        clk1_counter               : string := "g1" ;
        clk0_counter               : string := "g0" ;
        enable0_counter            : string := "l0";
        enable1_counter            : string := "l0";
        charge_pump_current        : natural := 2;
        loop_filter_r              : string := " 1.000000";
        loop_filter_c              : natural := 5;
        vco_post_scale             : natural := 0;
        vco_frequency_control      : string := "AUTO";
        vco_phase_shift_step       : natural := 0;

        m_test_source              : integer := 5;
        c0_test_source             : integer := 5;
        c1_test_source             : integer := 5;
        c2_test_source             : integer := 5;
        c3_test_source             : integer := 5;
        c4_test_source             : integer := 5;
        c5_test_source             : integer := 5;
        c6_test_source             : integer := 5;
        c7_test_source             : integer := 5;
        c8_test_source             : integer := 5;
        c9_test_source             : integer := 5;
        sim_gate_lock_device_behavior : string := "OFF";
        lpm_type                   : string := "altpll";
        
        -- The following parameter are used to define the connectivity for some
        --  of the input and output ports.
        port_clkena0 : string := "PORT_CONNECTIVITY";
        port_clkena1 : string := "PORT_CONNECTIVITY";
        port_clkena2 : string := "PORT_CONNECTIVITY";
        port_clkena3 : string := "PORT_CONNECTIVITY";
        port_clkena4 : string := "PORT_CONNECTIVITY";
        port_clkena5 : string := "PORT_CONNECTIVITY";
        port_extclkena0 : string := "PORT_CONNECTIVITY";
        port_extclkena1 : string := "PORT_CONNECTIVITY";
        port_extclkena2 : string := "PORT_CONNECTIVITY";
        port_extclkena3 : string := "PORT_CONNECTIVITY";
        port_extclk0 : string := "PORT_CONNECTIVITY";
        port_extclk1 : string := "PORT_CONNECTIVITY";
        port_extclk2 : string := "PORT_CONNECTIVITY";
        port_extclk3 : string := "PORT_CONNECTIVITY";
        port_clk0 : string := "PORT_CONNECTIVITY";
        port_clk1 : string := "PORT_CONNECTIVITY";
        port_clk2 : string := "PORT_CONNECTIVITY";
        port_clk3 : string := "PORT_CONNECTIVITY";
        port_clk4 : string := "PORT_CONNECTIVITY";
        port_clk5 : string := "PORT_CONNECTIVITY";
        port_clk6 : string := "PORT_CONNECTIVITY";
        port_clk7 : string := "PORT_CONNECTIVITY";
        port_clk8 : string := "PORT_CONNECTIVITY";
        port_clk9 : string := "PORT_CONNECTIVITY";
        port_scandata : string := "PORT_CONNECTIVITY";
        port_scandataout : string := "PORT_CONNECTIVITY";
        port_scandone : string := "PORT_CONNECTIVITY";
        port_sclkout1 : string := "PORT_CONNECTIVITY";
        port_sclkout0 : string := "PORT_CONNECTIVITY";
        port_clkbad0 : string := "PORT_CONNECTIVITY";
        port_clkbad1 : string := "PORT_CONNECTIVITY";
        port_activeclock : string := "PORT_CONNECTIVITY";
        port_clkloss : string := "PORT_CONNECTIVITY";
        port_inclk1 : string := "PORT_CONNECTIVITY";
        port_inclk0 : string := "PORT_CONNECTIVITY";
        port_fbin : string := "PORT_CONNECTIVITY";
        port_fbout : string := "PORT_CONNECTIVITY";
        port_pllena : string := "PORT_CONNECTIVITY";
        port_clkswitch : string := "PORT_CONNECTIVITY";
        port_areset : string := "PORT_CONNECTIVITY";
        port_pfdena : string := "PORT_CONNECTIVITY";
        port_scanclk : string := "PORT_CONNECTIVITY";
        port_scanaclr : string := "PORT_CONNECTIVITY";
        port_scanread : string := "PORT_CONNECTIVITY";
        port_scanwrite : string := "PORT_CONNECTIVITY";
        port_enable0 : string := "PORT_CONNECTIVITY";
        port_enable1 : string := "PORT_CONNECTIVITY";
        port_locked : string := "PORT_CONNECTIVITY";
        port_configupdate : string := "PORT_CONNECTIVITY";
        port_phasecounterselect : string := "PORT_CONNECTIVITY";
        port_phasedone : string := "PORT_CONNECTIVITY";
        port_phasestep : string := "PORT_CONNECTIVITY";
        port_phaseupdown : string := "PORT_CONNECTIVITY";
        port_vcooverrange : string := "PORT_CONNECTIVITY";
        port_vcounderrange : string := "PORT_CONNECTIVITY";
        port_scanclkena : string := "PORT_CONNECTIVITY"
);
port (
        inclk       : in std_logic_vector(1 downto 0) := (others => '0'); -- input clocks, up to 2 can be used
        fbin        : in std_logic := '0';  -- external feedback port
        pllena      : in std_logic := '1';  -- PLL enable signal
        clkswitch   : in std_logic := '0';  -- switch between inclk0 and inclk1
        areset      : in std_logic := '0';  -- asynchronous reset
        pfdena      : in std_logic := '1';  -- enable Phase Frequency Detector (PFD)
        clkena      : in std_logic_vector(5 downto 0) := (others => '1');  -- enable clk0-clk5 outputs
        extclkena   : in std_logic_vector(3 downto 0) := (others => '1');  -- enable extclk0-extclk3 outputs
        scanclk     : in std_logic := '0';  -- clock for scan chain
        scanclkena  : in std_logic := '1';
        scanaclr    : in std_logic := '0';  -- asynchronous clear for the scan chain
        scanread    : in std_logic := '0';  -- determines when the scan chain can read in data from the scandata port
        scanwrite   : in std_logic := '0';  -- determines when the scan chain can write out data into pll
        scandata    : in std_logic := '0';  -- data for the scan chain
        comparator  : in std_logic := '0';  -- control the enable0 pulse generation to achieve data realignment in lvds.
        phasecounterselect : in std_logic_vector(width_phasecounterselect-1 downto 0) := (others => '0'); 
        phaseupdown  : in std_logic := '0';
        phasestep    : in std_logic := '0';
        configupdate : in std_logic := '0';
        fbmimicbidir : inout std_logic := '1';

        clk         : out std_logic_vector(width_clock-1 downto 0); -- internal clock outputs (feeds the core)
        extclk      : out std_logic_vector(3 downto 0); -- external clock outputs (feeds pins)
        clkbad      : out std_logic_vector(1 downto 0); -- indicates if inclk0/inclk1 has gone bad
        enable0     : out std_logic;                    -- load enable pulse 0 for lvds
        enable1     : out std_logic;                    -- load enable pulse 1 for lvds
        activeclock : out std_logic;                    -- indicates which input clock is being used
        clkloss     : out std_logic;                    -- indicates when clock switchover initiates
        locked      : out std_logic;                    -- indicates when the PLL locks
        scandataout : out std_logic;                    -- data output from the scan chain
        scandone    : out std_logic;                    -- indicates when pll reconfiguration is complete
        sclkout0    : out std_logic;                    -- serial clock output 0 for lvds
        sclkout1    : out std_logic;                     -- serial clock output 1 for lvds
        phasedone     : out std_logic;
        vcooverrange  : out std_logic;
        vcounderrange : out std_logic;
        fbout         : out std_logic;
        fref          : out std_logic;
        icdrclk       : out std_logic

);
end altpll;

-- BEGINNING OF ARCHITECURE BEHAVIOR
architecture behavior of altpll is

-----------------------
-- CONSTANT DECLARATION
-----------------------
constant IS_STRATIXII : boolean := FEATURE_FAMILY_STRATIXII(intended_device_family);
constant IS_STRATIXIII : boolean := FEATURE_FAMILY_STRATIXIII(intended_device_family);
constant IS_CYCLONEII : boolean := FEATURE_FAMILY_CYCLONEII(intended_device_family);
constant IS_CYCLONEIII : boolean := FEATURE_FAMILY_CYCLONEIII(intended_device_family);
constant IS_PIRANHA : boolean := FEATURE_FAMILY_ARRIAIIGX(intended_device_family);
constant IS_STINGRAY : boolean := FEATURE_FAMILY_CYCLONEIVGX(intended_device_family);

-- converts uppercase parameter values (e.g. "AUTO") to lowercase ("auto")
-- as expected by stratix_pll model
function alpha_tolower (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";

begin
    for i in 1 to string_length loop
        case given_string(i) is
            when 'A' => result_string(i) := 'a';
            when 'B' => result_string(i) := 'b';
            when 'C' => result_string(i) := 'c';
            when 'D' => result_string(i) := 'd';
            when 'E' => result_string(i) := 'e';
            when 'F' => result_string(i) := 'f';
            when 'G' => result_string(i) := 'g';
            when 'H' => result_string(i) := 'h';
            when 'I' => result_string(i) := 'i';
            when 'J' => result_string(i) := 'j';
            when 'K' => result_string(i) := 'k';
            when 'L' => result_string(i) := 'l';
            when 'M' => result_string(i) := 'm';
            when 'N' => result_string(i) := 'n';
            when 'O' => result_string(i) := 'o';
            when 'P' => result_string(i) := 'p';
            when 'Q' => result_string(i) := 'q';
            when 'R' => result_string(i) := 'r';
            when 'S' => result_string(i) := 's';
            when 'T' => result_string(i) := 't';
            when 'U' => result_string(i) := 'u';
            when 'V' => result_string(i) := 'v';
            when 'W' => result_string(i) := 'w';
            when 'X' => result_string(i) := 'x';
            when 'Y' => result_string(i) := 'y';
            when 'Z' => result_string(i) := 'z';
            when others => result_string(i) := given_string(i);
        end case;
    end loop;

    return (result_string(1 to string_length));
end;

-- The following functions are used to set the default parameters' values for
-- Stratix II if user do not specify these parameters' values.

function get_clk0_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "g0") then
        return "c0";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

-- get feedback source for stratixii
function get_clk1_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "g1") then
        return "c1";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;


function get_clk2_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "g2") then
        return "c2";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

function get_clk3_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "g3") then
        return "c3";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

function get_clk4_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "l0") then
        return "c4";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

function get_clk5_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "l1") then
        return "c5";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

function get_clk_counter (counter_value : string; port_usage : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := counter_value'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (port_usage /= "PORT_USED") then
        return "unused";
    else
        result_string(1 to string_length) := alpha_tolower(counter_value);
        return (result_string(1 to string_length));
    end if;
end;

function get_enable0_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "l0") then
        return "c0";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

function get_enable1_counter (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "l0") then
        return "c1";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

-- get feedback source for stratixii
function get_feedback_source (given_string : string) return string is
    -- VARIABLE DECLARATION
    variable string_length : integer := given_string'length;
    variable result_string : string(1 to 20) := "                    ";
begin
    if (given_string = "extclk0") then
        return "clk0";
    else
        result_string(1 to string_length) := alpha_tolower(given_string);
        return (result_string(1 to string_length));
    end if;
end;

-- get charge_pump_current for stratixii
function get_charge_pump_current (m_value : integer; charge_pump_current : integer) return integer is
begin
    if (m_value = 0) then
        return 52;
    else
        return charge_pump_current;
    end if;
end;

-- get loop_filter_c for stratixii
function get_loop_filter_c (m_value : integer; loop_filter_c : integer) return integer is
begin
    if (m_value = 0) then
        return 16;
    else
        return loop_filter_c;
    end if;
end;

function get_test_source (test_source : integer) return integer is
begin
    if (test_source = 5) then
        return -1;
    else
        return test_source;
    end if;
end;

function get_vco_min_s (vco_min : integer) return integer is
begin
    if (vco_min = 0 AND m /= 0 ) then
        return 1000;
    else
        return vco_min;
    end if;
end;

function get_vco_min_s2 (vco_min : integer) return integer is
begin
    if (vco_min = 0 AND m /= 0) then
        return 700;
    else
        return vco_min;
    end if;
end;

function get_vco_min_c2 (vco_min : integer) return integer is
begin
    if (vco_min = 0 AND m /= 0) then
        return 300;
    else
        return vco_min;
    end if;
end;

function get_vco_min_s3 (vco_min : integer) return integer is
begin
    if (vco_min = 0 AND m /= 0) then
        return 100;
    else
        return vco_min;
    end if;
end;

function get_vco_min_c3 (vco_min : integer) return integer is
begin
    if (vco_min = 0 AND m /= 0) then
        return 200;
    else
        return vco_min;
    end if;
end;

function get_vco_max (vco_max : integer) return integer is
begin
    if (vco_max = 0 AND m /= 0) then
        return 3600;
    else
        return vco_max;
    end if;
end;

-- COMPONENT DECLARATION
component MF_stratix_pll
generic (
    operation_mode            : string := "normal";
    pll_type                  : string := "auto";
    qualify_conf_done         : string := "off";
    compensate_clock          : string := "clk0";
    scan_chain                : string := "long";
    primary_clock             : string := "inclk0";
    inclk0_input_frequency    : integer := 1000;
    inclk1_input_frequency    : integer := 1000;
    gate_lock_signal          : string := "no";
    gate_lock_counter         : integer := 0;
    valid_lock_multiplier     : integer := 1;
    invalid_lock_multiplier   : integer := 5;
    switch_over_on_lossclk    : string := "off";
    switch_over_on_gated_lock : string := "off";
    enable_switch_over_counter : string := "off";
    switch_over_counter       : integer := 0;
    feedback_source           : string := "extclk0";
    bandwidth                 : integer := 0;
    bandwidth_type            : string := "auto";
    spread_frequency          : integer := 0;
    down_spread               : string := "0.0";
    simulation_type           : string := "functional";
    skip_vco                  : string := "off";
    family_name               : string := "Stratix";
    
    clk0_multiply_by : integer := 1;
    clk0_divide_by   : integer := 1;
    clk0_phase_shift : string := "0";
    clk0_time_delay  : string := "0";
    clk0_duty_cycle  : integer := 50;

    clk1_multiply_by : integer := 1;
    clk1_divide_by   : integer := 1;
    clk1_phase_shift : string := "0";
    clk1_time_delay  : string := "0";
    clk1_duty_cycle  : integer := 50;

    clk2_multiply_by : integer := 1;
    clk2_divide_by   : integer := 1;
    clk2_phase_shift : string := "0";
    clk2_time_delay  : string := "0";
    clk2_duty_cycle  : integer := 50;

    clk3_multiply_by : integer := 1;
    clk3_divide_by   : integer := 1;
    clk3_phase_shift : string := "0";
    clk3_time_delay  : string := "0";
    clk3_duty_cycle  : integer := 50;

    clk4_multiply_by : integer := 1;
    clk4_divide_by   : integer := 1;
    clk4_phase_shift : string := "0";
    clk4_time_delay  : string := "0";
    clk4_duty_cycle  : integer := 50;

    clk5_multiply_by : integer := 1;
    clk5_divide_by   : integer := 1;
    clk5_phase_shift : string := "0";
    clk5_time_delay  : string := "0";
    clk5_duty_cycle  : integer := 50;

    extclk0_multiply_by : integer := 1;
    extclk0_divide_by   : integer := 1;
    extclk0_phase_shift : string := "0";
    extclk0_time_delay  : string := "0";
    extclk0_duty_cycle  : integer := 50;

    extclk1_multiply_by : integer := 1;
    extclk1_divide_by   : integer := 1;
    extclk1_phase_shift : string := "0";
    extclk1_time_delay  : string := "0";
    extclk1_duty_cycle  : integer := 50;

    extclk2_multiply_by : integer := 1;
    extclk2_divide_by   : integer := 1;
    extclk2_phase_shift : string := "0";
    extclk2_time_delay  : string := "0";
    extclk2_duty_cycle  : integer := 50;

    extclk3_multiply_by : integer := 1;
    extclk3_divide_by   : integer := 1;
    extclk3_phase_shift : string := "0";
    extclk3_time_delay  : string := "0";
    extclk3_duty_cycle  : integer := 50;

    vco_min    : integer := 0;
    vco_max    : integer := 0;
    vco_center : integer := 0;
    pfd_min    : integer := 0;
    pfd_max    : integer := 0;

-- ADVANCED USER PARAMETERS
    m_initial : integer := 1;     -- 1-1024
    m         : integer := 1;     -- 1-1024
    n         : integer := 1;     -- 1-1024
    m2        : integer := 1;     -- 1-1024
    n2        : integer := 1;     -- 1-1024
    ss        : integer := 0;

    l0_high       : integer := 1;    -- 1-512
    l0_low        : integer := 1;    -- 1-512
    l0_initial    : integer := 1;    -- 1-512
    l0_mode       : string := "bypass";       -- bypass,odd,even
    l0_ph         : integer := 0;
    l0_time_delay : integer := 0;

    l1_high       : integer := 1;
    l1_low        : integer := 1;
    l1_initial    : integer := 1;
    l1_mode       : string := "bypass";
    l1_ph         : integer := 0;
    l1_time_delay : integer := 0;

    g0_high       : integer := 1;
    g0_low        : integer := 1;
    g0_initial    : integer := 1;
    g0_mode       : string := "bypass";
    g0_ph         : integer := 0;
    g0_time_delay : integer := 0;

    g1_high       : integer := 1;
    g1_low        : integer := 1;
    g1_initial    : integer := 1;
    g1_mode       : string := "bypass";
    g1_ph         : integer := 0;
    g1_time_delay : integer := 0;

    g2_high       : integer := 1;
    g2_low        : integer := 1;
    g2_initial    : integer := 1; 
    g2_mode       : string := "bypass";
    g2_ph         : integer := 0;
    g2_time_delay : integer := 0;

    g3_high       : integer := 1;
    g3_low        : integer := 1;
    g3_initial    : integer := 1;
    g3_mode       : string := "bypass";
    g3_ph         : integer := 0;
    g3_time_delay : integer := 0;

    e0_high       : integer := 1;
    e0_low        : integer := 1;
    e0_initial    : integer := 1;
    e0_mode       : string := "bypass";
    e0_ph         : integer := 0;
    e0_time_delay : integer := 0;

    e1_high       : integer := 1;
    e1_low        : integer := 1;
    e1_initial    : integer := 1;
    e1_mode       : string := "bypass";
    e1_ph         : integer := 0;
    e1_time_delay : integer := 0;

    e2_high       : integer := 1;
    e2_low        : integer := 1;
    e2_initial    : integer := 1;
    e2_mode       : string := "bypass";
    e2_ph         : integer := 0;
    e2_time_delay : integer := 0;

    e3_high       : integer := 1;
    e3_low        : integer := 1;
    e3_initial    : integer := 1;
    e3_mode       : string := "bypass";
    e3_ph         : integer := 0;
    e3_time_delay : integer := 0;

    m_ph : integer := 0;
    m_time_delay : integer := 0;
    n_time_delay : integer := 0;

    extclk0_counter : string := "e0";
    extclk1_counter : string := "e1";
    extclk2_counter : string := "e2";
    extclk3_counter : string := "e3";

    clk0_counter : string := "g0";
    clk1_counter : string := "g1";
    clk2_counter : string := "g2";
    clk3_counter : string := "g3";
    clk4_counter : string := "l0";
    clk5_counter : string := "l1";

    enable0_counter : string := "l0";
    enable1_counter : string := "l0";

    charge_pump_current : integer := 2;

    loop_filter_r : string := "1.0";
    loop_filter_c : natural := 5
);
port (
    inclk       : in std_logic_vector(1 downto 0) := (OTHERS=>'0');
    fbin        : in std_logic := '0';
    ena         : in std_logic := '1';
    clkswitch   : in std_logic := '0';
    areset      : in std_logic := '0';
    pfdena      : in std_logic := '1';
    clkena      : in std_logic_vector(5 downto 0) := (OTHERS=>'1');
    extclkena   : in std_logic_vector(3 downto 0) := (OTHERS=>'1');
    scanclk     : in std_logic := '0';
    scanaclr    : in std_logic := '0';
    scandata    : in std_logic := '0';
    clk         : out std_logic_vector(5 downto 0);
    extclk      : out std_logic_vector(3 downto 0);
    clkbad      : out std_logic_vector(1 downto 0);
    activeclock : out std_logic;
    clkloss     : out std_logic;
    locked      : out std_logic;
    scandataout : out std_logic;

    -- lvds specific ports
    comparator  : in std_logic := '0';
    enable0     : out std_logic;
    enable1     : out std_logic
);
end component;


component MF_stratixii_pll
generic (
    operation_mode            : string := "normal";
    pll_type                  : string := "auto";
    qualify_conf_done         : string := "off";
    compensate_clock          : string := "clk0";
    inclk0_input_frequency    : integer := 1000;
    inclk1_input_frequency    : integer := 1000;
    gate_lock_signal          : string := "no";
    gate_lock_counter         : integer := 0;
    valid_lock_multiplier     : integer := 1;
    invalid_lock_multiplier   : integer := 5;
    switch_over_type          : string  := "auto";
    switch_over_on_lossclk    : string := "off";
    switch_over_on_gated_lock : string := "off";
    enable_switch_over_counter : string := "off";
    switch_over_counter       : integer := 0;
    feedback_source           : string := "extclk0";
    bandwidth                 : integer := 0;
    bandwidth_type            : string := "auto";
    spread_frequency          : integer := 0;
    down_spread               : string := "0.0";
    self_reset_on_gated_loss_lock : string := "OFF";
    simulation_type           : string := "functional";
    family_name               : string := "StratixII";

    clk0_output_frequency : natural := 0;
    clk0_multiply_by      : integer := 1;
    clk0_divide_by        : integer := 1;
    clk0_phase_shift      : string := "0";
    clk0_duty_cycle       : integer := 50;

    clk1_output_frequency : natural := 0;
    clk1_multiply_by      : integer := 1;
    clk1_divide_by        : integer := 1;
    clk1_phase_shift      : string := "0";
    clk1_duty_cycle       : integer := 50;

    clk2_output_frequency : natural := 0;
    clk2_multiply_by      : integer := 1;
    clk2_divide_by        : integer := 1;
    clk2_phase_shift      : string := "0";
    clk2_duty_cycle       : integer := 50;

    clk3_multiply_by      : integer := 1;
    clk3_divide_by        : integer := 1;
    clk3_phase_shift      : string := "0";
    clk3_duty_cycle       : integer := 50;

    clk4_multiply_by      : integer := 1;
    clk4_divide_by        : integer := 1;
    clk4_phase_shift      : string := "0";
    clk4_duty_cycle       : integer := 50;

    clk5_multiply_by      : integer := 1;
    clk5_divide_by        : integer := 1;
    clk5_phase_shift      : string := "0";
    clk5_duty_cycle       : integer := 50;

    vco_min    : integer := 0;
    vco_max    : integer := 0;
    vco_center : integer := 0;
    pfd_min    : integer := 0;
    pfd_max    : integer := 0;

-- ADVANCED USER PARAMETERS
    m_initial : integer := 1;     -- 1-1024
    m         : integer := 1;     -- 1-1024
    n         : integer := 1;     -- 1-1024
    m2        : integer := 1;     -- 1-1024
    n2        : integer := 1;     -- 1-1024
    ss        : integer := 0;

    c0_high       : integer := 1;    -- 1-512
    c0_low        : integer := 1;    -- 1-512
    c0_initial    : integer := 1;    -- 1-512
    c0_mode       : string := "bypass";       -- bypass,odd,even
    c0_ph         : integer := 0;

    c1_high       : integer := 1;
    c1_low        : integer := 1;
    c1_initial    : integer := 1;
    c1_mode       : string := "bypass";
    c1_ph         : integer := 0;

    c2_high       : integer := 1;
    c2_low        : integer := 1;
    c2_initial    : integer := 1;
    c2_mode       : string := "bypass";
    c2_ph         : integer := 0;

    c3_high       : integer := 1;
    c3_low        : integer := 1;
    c3_initial    : integer := 1;
    c3_mode       : string := "bypass";
    c3_ph         : integer := 0;

    c4_high       : integer := 1;
    c4_low        : integer := 1;
    c4_initial    : integer := 1; 
    c4_mode       : string := "bypass";
    c4_ph         : integer := 0;

    c5_high       : integer := 1;
    c5_low        : integer := 1;
    c5_initial    : integer := 1;
    c5_mode       : string := "bypass";
    c5_ph         : integer := 0;

    m_ph : integer := 0;

    c1_use_casc_in   : string := "off";
    c2_use_casc_in   : string := "off";
    c3_use_casc_in   : string := "off";
    c4_use_casc_in   : string := "off";
    c5_use_casc_in   : string := "off";

    m_test_source    : integer := 5;
    c0_test_source   : integer := 5;
    c1_test_source   : integer := 5;
    c2_test_source   : integer := 5;
    c3_test_source   : integer := 5;
    c4_test_source   : integer := 5;
    c5_test_source   : integer := 5;
        
    clk0_counter     : string := "c0";
    clk1_counter     : string := "c1";
    clk2_counter     : string := "c2";
    clk3_counter     : string := "c3";
    clk4_counter     : string := "c4";
    clk5_counter     : string := "c5";

    enable0_counter : string := "c0";
    enable1_counter : string := "c0";
    sclkout0_phase_shift : string := "0";
    sclkout1_phase_shift : string := "0";
    vco_multiply_by : integer := 0;
    vco_divide_by   : integer := 0;

    charge_pump_current : integer := 2;

    loop_filter_r : string := "1.0";
    loop_filter_c : natural := 5;
    sim_gate_lock_device_behavior : string := "OFF"
);
port (
    inclk       : in std_logic_vector(1 downto 0) := (OTHERS=>'0');
    fbin        : in std_logic := '0';
    ena         : in std_logic := '1';
    clkswitch   : in std_logic := '0';
    areset      : in std_logic := '0';
    pfdena      : in std_logic := '1';
    scanclk     : in std_logic := '1';
    scanread    : in std_logic := '1';
    scanwrite   : in std_logic := '1';
    scandata    : in std_logic := '1';
    testin      : in std_logic_vector(3 downto 0) := (OTHERS=>'0');
    clk         : out std_logic_vector(5 downto 0);
    clkbad      : out std_logic_vector(1 downto 0);
    activeclock : out std_logic;
    clkloss     : out std_logic;
    locked      : out std_logic;
    scandataout : out std_logic;
    scandone    : out std_logic;

    -- lvds specific ports
    enable0     : out std_logic;
    enable1     : out std_logic;
    sclkout     : out std_logic_vector(1 downto 0)
);
end component;

component MF_stratixiii_pll
generic (
    operation_mode            : string := "normal";
    pll_type                  : string := "auto";
    compensate_clock          : string := "clk0";
    inclk0_input_frequency    : integer := 1000;
    inclk1_input_frequency    : integer := 1000;
    self_reset_on_loss_lock   : string := "off"; 
    switch_over_type          : string  := "auto";
    enable_switch_over_counter : string := "off";
    switch_over_counter       : integer := 0;
    bandwidth                 : integer := 0;
    bandwidth_type            : string := "auto";
    lock_high               : integer := 0;
    lock_low                : integer := 0;
    lock_window_ui          : string  := " 0.05";
    lock_c                  : integer := 4;
    simulation_type           : string := "functional";
    family_name               : string := "StratixIII";

    clk0_output_frequency : natural := 0;
    clk0_multiply_by      : integer := 1;
    clk0_divide_by        : integer := 1;
    clk0_phase_shift      : string := "0";
    clk0_duty_cycle       : integer := 50;
    clk0_use_even_counter_mode  : string := "OFF";
    clk0_use_even_counter_value : string := "OFF";

    clk1_output_frequency : natural := 0;
    clk1_multiply_by      : integer := 1;
    clk1_divide_by        : integer := 1;
    clk1_phase_shift      : string := "0";
    clk1_duty_cycle       : integer := 50;
    clk1_use_even_counter_mode  : string := "OFF";
    clk1_use_even_counter_value : string := "OFF";

    clk2_output_frequency : natural := 0;
    clk2_multiply_by      : integer := 1;
    clk2_divide_by        : integer := 1;
    clk2_phase_shift      : string := "0";
    clk2_duty_cycle       : integer := 50;
    clk2_use_even_counter_mode  : string := "OFF";
    clk2_use_even_counter_value : string := "OFF";

    clk3_multiply_by      : integer := 1;
    clk3_divide_by        : integer := 1;
    clk3_phase_shift      : string := "0";
    clk3_duty_cycle       : integer := 50;
    clk3_use_even_counter_mode  : string := "OFF";
    clk3_use_even_counter_value : string := "OFF";

    clk4_multiply_by      : integer := 1;
    clk4_divide_by        : integer := 1;
    clk4_phase_shift      : string := "0";
    clk4_duty_cycle       : integer := 50;
    clk4_use_even_counter_mode  : string := "OFF";
    clk4_use_even_counter_value : string := "OFF";

    clk5_multiply_by      : integer := 1;
    clk5_divide_by        : integer := 1;
    clk5_phase_shift      : string := "0";
    clk5_duty_cycle       : integer := 50;
    clk5_use_even_counter_mode  : string := "OFF";
    clk5_use_even_counter_value : string := "OFF";

    clk6_multiply_by      : integer := 1;
    clk6_divide_by        : integer := 1;
    clk6_phase_shift      : string := "0";
    clk6_duty_cycle       : integer := 50;
    clk6_use_even_counter_mode  : string := "OFF";
    clk6_use_even_counter_value : string := "OFF";

    clk7_multiply_by      : integer := 1;
    clk7_divide_by        : integer := 1;
    clk7_phase_shift      : string := "0";
    clk7_duty_cycle       : integer := 50;
    clk7_use_even_counter_mode  : string := "OFF";
    clk7_use_even_counter_value : string := "OFF";

    clk8_multiply_by      : integer := 1;
    clk8_divide_by        : integer := 1;
    clk8_phase_shift      : string := "0";
    clk8_duty_cycle       : integer := 50;
    clk8_use_even_counter_mode  : string := "OFF";
    clk8_use_even_counter_value : string := "OFF";

    clk9_multiply_by      : integer := 1;
    clk9_divide_by        : integer := 1;
    clk9_phase_shift      : string := "0";
    clk9_duty_cycle       : integer := 50;
    clk9_use_even_counter_mode  : string := "OFF";
    clk9_use_even_counter_value : string := "OFF";

    vco_min    : integer := 0;
    vco_max    : integer := 0;
    vco_center : integer := 0;
    pfd_min    : integer := 0;
    pfd_max    : integer := 0;

-- ADVANCED USER PARAMETERS
    m_initial : integer := 1;     -- 1-1024
    m         : integer := 1;     -- 1-1024
    n         : integer := 1;     -- 1-1024

    c0_high       : integer := 1;    -- 1-512
    c0_low        : integer := 1;    -- 1-512
    c0_initial    : integer := 1;    -- 1-512
    c0_mode       : string := "bypass";       -- bypass,odd,even
    c0_ph         : integer := 0;

    c1_high       : integer := 1;
    c1_low        : integer := 1;
    c1_initial    : integer := 1;
    c1_mode       : string := "bypass";
    c1_ph         : integer := 0;

    c2_high       : integer := 1;
    c2_low        : integer := 1;
    c2_initial    : integer := 1;
    c2_mode       : string := "bypass";
    c2_ph         : integer := 0;

    c3_high       : integer := 1;
    c3_low        : integer := 1;
    c3_initial    : integer := 1;
    c3_mode       : string := "bypass";
    c3_ph         : integer := 0;

    c4_high       : integer := 1;
    c4_low        : integer := 1;
    c4_initial    : integer := 1; 
    c4_mode       : string := "bypass";
    c4_ph         : integer := 0;

    c5_high       : integer := 1;
    c5_low        : integer := 1;
    c5_initial    : integer := 1;
    c5_mode       : string := "bypass";
    c5_ph         : integer := 0;

    c6_high       : integer := 1;
    c6_low        : integer := 1;
    c6_initial    : integer := 1;
    c6_mode       : string := "bypass";
    c6_ph         : integer := 0;

    c7_high       : integer := 1;
    c7_low        : integer := 1;
    c7_initial    : integer := 1;
    c7_mode       : string := "bypass";
    c7_ph         : integer := 0;

    c8_high       : integer := 1;
    c8_low        : integer := 1;
    c8_initial    : integer := 1; 
    c8_mode       : string := "bypass";
    c8_ph         : integer := 0;

    c9_high       : integer := 1;
    c9_low        : integer := 1;
    c9_initial    : integer := 1;
    c9_mode       : string := "bypass";
    c9_ph         : integer := 0;

    m_ph : integer := 0;

    c1_use_casc_in   : string := "off";
    c2_use_casc_in   : string := "off";
    c3_use_casc_in   : string := "off";
    c4_use_casc_in   : string := "off";
    c5_use_casc_in   : string := "off";
    c6_use_casc_in   : string := "off";
    c7_use_casc_in   : string := "off";
    c8_use_casc_in   : string := "off";
    c9_use_casc_in   : string := "off";

    m_test_source    : integer := -1;
    c0_test_source   : integer := -1;
    c1_test_source   : integer := -1;
    c2_test_source   : integer := -1;
    c3_test_source   : integer := -1;
    c4_test_source   : integer := -1;
    c5_test_source   : integer := -1;
    c6_test_source   : integer := -1;
    c7_test_source   : integer := -1;
    c8_test_source   : integer := -1;
    c9_test_source   : integer := -1;
        
    clk0_counter     : string := "c0";
    clk1_counter     : string := "c1";
    clk2_counter     : string := "c2";
    clk3_counter     : string := "c3";
    clk4_counter     : string := "c4";
    clk5_counter     : string := "c5";
    clk6_counter     : string := "c6";
    clk7_counter     : string := "c7";
    clk8_counter     : string := "c8";
    clk9_counter     : string := "c9";

    vco_multiply_by : integer := 0;
    vco_divide_by   : integer := 0;
    
    dpa_multiply_by : integer := 0;
    dpa_divide_by   : integer := 0;
    dpa_divider     : integer := 0;

    vco_frequency_control : string  := "AUTO";
    vco_phase_shift_step  : natural := 0;
    charge_pump_current_bits   : natural := 9999;
    loop_filter_c_bits         : natural := 9999;
    loop_filter_r_bits         : natural := 9999;

    charge_pump_current : integer := 2;

    loop_filter_r : string := "1.0";
    loop_filter_c : natural := 5
);
port (
    inclk       : in std_logic_vector(1 downto 0) := (OTHERS=>'0');
    fbin        : in std_logic := '0';
    clkswitch   : in std_logic := '0';
    areset      : in std_logic := '0';
    pfdena      : in std_logic := '1';
    scanclk     : in std_logic := '1';
    scandata    : in std_logic := '1';
    scanclkena  : in std_logic := '1';
    configupdate : in std_logic := '0';
    phasecounterselect : in std_logic_vector(3 downto 0) := (OTHERS=>'0');
    phaseupdown : in std_logic := '0';
    phasestep   : in std_logic := '0';

    clk         : out std_logic_vector(9 downto 0);
    clkbad      : out std_logic_vector(1 downto 0);
    activeclock : out std_logic;
    locked      : out std_logic;
    scandataout : out std_logic;
    scandone    : out std_logic;
    phasedone   : out std_logic;
    vcooverrange : out std_logic;
    vcounderrange : out std_logic;
    fbout       : out std_logic
);
end component;

component MF_cycloneiii_pll
generic (
    operation_mode            : string := "normal";
    pll_type                  : string := "auto";
    compensate_clock          : string := "clk0";
    inclk0_input_frequency    : integer := 1000;
    inclk1_input_frequency    : integer := 1000;
    self_reset_on_loss_lock   : string := "off"; 
    switch_over_type          : string  := "auto";
    enable_switch_over_counter : string := "off";
    switch_over_counter       : integer := 0;
    bandwidth                 : integer := 0;
    bandwidth_type            : string := "auto";
    lock_high               : integer := 0;
    lock_low                : integer := 0;
    lock_window_ui          : string  := "0.05";
    lock_c                  : integer := 4;
    simulation_type           : string := "functional";
    family_name               : string := "CycloneIII";

    clk0_output_frequency : natural := 0;
    clk0_multiply_by      : integer := 1;
    clk0_divide_by        : integer := 1;
    clk0_phase_shift      : string := "0";
    clk0_duty_cycle       : integer := 50;
    clk0_use_even_counter_mode  : string := "OFF";
    clk0_use_even_counter_value : string := "OFF";

    clk1_output_frequency : natural := 0;
    clk1_multiply_by      : integer := 1;
    clk1_divide_by        : integer := 1;
    clk1_phase_shift      : string := "0";
    clk1_duty_cycle       : integer := 50;
    clk1_use_even_counter_mode  : string := "OFF";
    clk1_use_even_counter_value : string := "OFF";

    clk2_output_frequency : natural := 0;
    clk2_multiply_by      : integer := 1;
    clk2_divide_by        : integer := 1;
    clk2_phase_shift      : string := "0";
    clk2_duty_cycle       : integer := 50;
    clk2_use_even_counter_mode  : string := "OFF";
    clk2_use_even_counter_value : string := "OFF";

    clk3_multiply_by      : integer := 1;
    clk3_divide_by        : integer := 1;
    clk3_phase_shift      : string := "0";
    clk3_duty_cycle       : integer := 50;
    clk3_use_even_counter_mode  : string := "OFF";
    clk3_use_even_counter_value : string := "OFF";

    clk4_multiply_by      : integer := 1;
    clk4_divide_by        : integer := 1;
    clk4_phase_shift      : string := "0";
    clk4_duty_cycle       : integer := 50;
    clk4_use_even_counter_mode  : string := "OFF";
    clk4_use_even_counter_value : string := "OFF";

    vco_min    : integer := 0;
    vco_max    : integer := 0;
    vco_center : integer := 0;
    pfd_min    : integer := 0;
    pfd_max    : integer := 0;

-- ADVANCED USER PARAMETERS
    m_initial : integer := 1;     -- 1-1024
    m         : integer := 1;     -- 1-1024
    n         : integer := 1;     -- 1-1024

    c0_high       : integer := 1;    -- 1-512
    c0_low        : integer := 1;    -- 1-512
    c0_initial    : integer := 1;    -- 1-512
    c0_mode       : string := "bypass";       -- bypass,odd,even
    c0_ph         : integer := 0;

    c1_high       : integer := 1;
    c1_low        : integer := 1;
    c1_initial    : integer := 1;
    c1_mode       : string := "bypass";
    c1_ph         : integer := 0;

    c2_high       : integer := 1;
    c2_low        : integer := 1;
    c2_initial    : integer := 1;
    c2_mode       : string := "bypass";
    c2_ph         : integer := 0;

    c3_high       : integer := 1;
    c3_low        : integer := 1;
    c3_initial    : integer := 1;
    c3_mode       : string := "bypass";
    c3_ph         : integer := 0;

    c4_high       : integer := 1;
    c4_low        : integer := 1;
    c4_initial    : integer := 1; 
    c4_mode       : string := "bypass";
    c4_ph         : integer := 0;

    m_ph : integer := 0;

    c1_use_casc_in   : string := "off";
    c2_use_casc_in   : string := "off";
    c3_use_casc_in   : string := "off";
    c4_use_casc_in   : string := "off";

    m_test_source    : integer := -1;
    c0_test_source   : integer := -1;
    c1_test_source   : integer := -1;
    c2_test_source   : integer := -1;
    c3_test_source   : integer := -1;
    c4_test_source   : integer := -1;
        
    clk0_counter     : string := "c0";
    clk1_counter     : string := "c1";
    clk2_counter     : string := "c2";
    clk3_counter     : string := "c3";
    clk4_counter     : string := "c4";

    vco_multiply_by : integer := 0;
    vco_divide_by   : integer := 0;

    vco_frequency_control : string  := "AUTO";
    vco_phase_shift_step  : natural := 0;
    charge_pump_current_bits   : natural := 9999;
    loop_filter_c_bits         : natural := 9999;
    loop_filter_r_bits         : natural := 9999;

    charge_pump_current : integer := 2;

    loop_filter_r : string := "1.0";
    loop_filter_c : natural := 5
);
port (
    inclk       : in std_logic_vector(1 downto 0) := (OTHERS=>'0');
    fbin        : in std_logic := '0';
    clkswitch   : in std_logic := '0';
    areset      : in std_logic := '0';
    pfdena      : in std_logic := '1';
    scanclk     : in std_logic := '1';
    scandata    : in std_logic := '1';
    scanclkena  : in std_logic := '1';
    configupdate : in std_logic := '0';
    phasecounterselect : in std_logic_vector(2 downto 0) := (OTHERS=>'0');
    phaseupdown : in std_logic := '0';
    phasestep   : in std_logic := '0';

    clk         : out std_logic_vector(4 downto 0);
    clkbad      : out std_logic_vector(1 downto 0);
    activeclock : out std_logic;
    locked      : out std_logic;
    scandataout : out std_logic;
    scandone    : out std_logic;
    phasedone   : out std_logic;
    vcooverrange : out std_logic;
    vcounderrange : out std_logic;
    fbout       : out std_logic
);
end component;

component MF_cycloneiiigl_pll
generic (
    operation_mode            : string := "normal";
    pll_type                  : string := "auto";
    compensate_clock          : string := "clk0";
    inclk0_input_frequency    : integer := 1000;
    inclk1_input_frequency    : integer := 1000;
    self_reset_on_loss_lock   : string := "off"; 
    switch_over_type          : string  := "auto";
    enable_switch_over_counter : string := "off";
    switch_over_counter       : integer := 0;
    bandwidth                 : integer := 0;
    bandwidth_type            : string := "auto";
    lock_high               : integer := 0;
    lock_low                : integer := 0;
    lock_window_ui          : string  := "0.05";
    lock_c                  : integer := 4;
    simulation_type           : string := "functional";
    family_name               : string := "CycloneIIIGL";

    clk0_output_frequency : natural := 0;
    clk0_multiply_by      : integer := 1;
    clk0_divide_by        : integer := 1;
    clk0_phase_shift      : string := "0";
    clk0_duty_cycle       : integer := 50;
    clk0_use_even_counter_mode  : string := "OFF";
    clk0_use_even_counter_value : string := "OFF";

    clk1_output_frequency : natural := 0;
    clk1_multiply_by      : integer := 1;
    clk1_divide_by        : integer := 1;
    clk1_phase_shift      : string := "0";
    clk1_duty_cycle       : integer := 50;
    clk1_use_even_counter_mode  : string := "OFF";
    clk1_use_even_counter_value : string := "OFF";

    clk2_output_frequency : natural := 0;
    clk2_multiply_by      : integer := 1;
    clk2_divide_by        : integer := 1;
    clk2_phase_shift      : string := "0";
    clk2_duty_cycle       : integer := 50;
    clk2_use_even_counter_mode  : string := "OFF";
    clk2_use_even_counter_value : string := "OFF";

    clk3_multiply_by      : integer := 1;
    clk3_divide_by        : integer := 1;
    clk3_phase_shift      : string := "0";
    clk3_duty_cycle       : integer := 50;
    clk3_use_even_counter_mode  : string := "OFF";
    clk3_use_even_counter_value : string := "OFF";

    clk4_multiply_by      : integer := 1;
    clk4_divide_by        : integer := 1;
    clk4_phase_shift      : string := "0";
    clk4_duty_cycle       : integer := 50;
    clk4_use_even_counter_mode  : string := "OFF";
    clk4_use_even_counter_value : string := "OFF";

    vco_min    : integer := 0;
    vco_max    : integer := 0;
    vco_center : integer := 0;
    dpa_multiply_by : integer := 0;
    dpa_divide_by   : integer := 0;
    dpa_divider : integer := 0;
    pfd_min    : integer := 0;
    pfd_max    : integer := 0;

-- ADVANCED USER PARAMETERS
    m_initial : integer := 1;     -- 1-1024
    m         : integer := 1;     -- 1-1024
    n         : integer := 1;     -- 1-1024

    c0_high       : integer := 1;    -- 1-512
    c0_low        : integer := 1;    -- 1-512
    c0_initial    : integer := 1;    -- 1-512
    c0_mode       : string := "bypass";       -- bypass,odd,even
    c0_ph         : integer := 0;

    c1_high       : integer := 1;
    c1_low        : integer := 1;
    c1_initial    : integer := 1;
    c1_mode       : string := "bypass";
    c1_ph         : integer := 0;

    c2_high       : integer := 1;
    c2_low        : integer := 1;
    c2_initial    : integer := 1;
    c2_mode       : string := "bypass";
    c2_ph         : integer := 0;

    c3_high       : integer := 1;
    c3_low        : integer := 1;
    c3_initial    : integer := 1;
    c3_mode       : string := "bypass";
    c3_ph         : integer := 0;

    c4_high       : integer := 1;
    c4_low        : integer := 1;
    c4_initial    : integer := 1; 
    c4_mode       : string := "bypass";
    c4_ph         : integer := 0;

    m_ph : integer := 0;

    c1_use_casc_in   : string := "off";
    c2_use_casc_in   : string := "off";
    c3_use_casc_in   : string := "off";
    c4_use_casc_in   : string := "off";

    m_test_source    : integer := -1;
    c0_test_source   : integer := -1;
    c1_test_source   : integer := -1;
    c2_test_source   : integer := -1;
    c3_test_source   : integer := -1;
    c4_test_source   : integer := -1;
        
    clk0_counter     : string := "c0";
    clk1_counter     : string := "c1";
    clk2_counter     : string := "c2";
    clk3_counter     : string := "c3";
    clk4_counter     : string := "c4";

    vco_multiply_by : integer := 0;
    vco_divide_by   : integer := 0;

    vco_frequency_control : string  := "AUTO";
    vco_phase_shift_step  : natural := 0;
    charge_pump_current_bits   : natural := 9999;
    loop_filter_c_bits         : natural := 9999;
    loop_filter_r_bits         : natural := 9999;

    charge_pump_current : integer := 2;

    loop_filter_r : string := "1.0";
    loop_filter_c : natural := 5
);
port (
    inclk       : in std_logic_vector(1 downto 0) := (OTHERS=>'0');
    fbin        : in std_logic := '0';
    clkswitch   : in std_logic := '0';
    areset      : in std_logic := '0';
    pfdena      : in std_logic := '1';
    scanclk     : in std_logic := '1';
    scandata    : in std_logic := '1';
    scanclkena  : in std_logic := '1';
    configupdate : in std_logic := '0';
    phasecounterselect : in std_logic_vector(2 downto 0) := (OTHERS=>'0');
    phaseupdown : in std_logic := '0';
    phasestep   : in std_logic := '0';

    clk         : out std_logic_vector(4 downto 0);
    clkbad      : out std_logic_vector(1 downto 0);
    activeclock : out std_logic;
    locked      : out std_logic;
    scandataout : out std_logic;
    scandone    : out std_logic;
    phasedone   : out std_logic;
    vcooverrange : out std_logic;
    vcounderrange : out std_logic;
    fbout       : out std_logic;
    fref        : out std_logic;
    icdrclk     : out std_logic
);
end component;

component pll_iobuf
port (
        i  : in    std_logic;
        oe : in    std_logic;
        io : inout std_logic;
        o  : out   std_logic
);
end component;

signal locked_tmp : std_logic;
signal clk_tmp : std_logic_vector(6 downto 0);

signal fbin_wire : std_logic;
signal pllena_wire : std_logic;
signal clkswitch_wire : std_logic;
signal areset_wire : std_logic;
signal pfdena_wire : std_logic;
signal scanclk_wire : std_logic;
signal scanaclr_wire : std_logic;
signal scanread_wire : std_logic;
signal scanwrite_wire : std_logic;
signal scandata_wire : std_logic;
signal clkena_wire  : std_logic_vector(5 downto 0);
signal extclkena_wire  : std_logic_vector(3 downto 0);
signal clk_wire  : std_logic_vector(9 downto 0);
signal extclk_wire  : std_logic_vector(3 downto 0);
signal clkbad_wire  : std_logic_vector(1 downto 0);
signal activeclock_wire : std_logic;
signal clkloss_wire : std_logic;
signal scandataout_wire : std_logic;
signal scandone_wire : std_logic;
signal sclkout0_wire : std_logic;
signal sclkout1_wire : std_logic;
signal locked_wire : std_logic;
signal configupdate_wire : std_logic;
signal phasecounterselect_wire : std_logic_vector(3 downto 0);
signal phasestep_wire : std_logic;
signal phaseupdown_wire : std_logic;
signal scanclkena_wire : std_logic;
signal phasedone_wire : std_logic;
signal vcooverrange_wire : std_logic;
signal vcounderrange_wire : std_logic;
signal fbout_wire : std_logic;
signal iobuf_o : std_logic;
signal stratix3_fbin : std_logic;
signal oe_wire : std_logic;
signal pll_lock_sync : std_logic := '1';
signal fref_wire : std_logic;
signal icdrclk_wire : std_logic;

begin

-- checking for invalid parameters
MSG: process
begin

    if (clk5_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk5_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk4_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk4_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk3_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk3_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk2_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk2_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk1_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk1_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk0_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The clk0_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk5_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk5_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk4_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk4_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk3_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk3_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk2_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk2_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk1_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk1_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (clk0_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The clk0_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;


    if (extclk3_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk3_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk2_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk2_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk1_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk1_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk0_multiply_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk0_multiply_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;


    if (extclk3_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk3_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk2_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk2_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk1_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk1_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if (extclk0_divide_by <= 0) then
        ASSERT FALSE
        REPORT "The extclk0_divide_by parameter must be greater than 0"
        SEVERITY ERROR;
    end if;

    if not ((alpha_tolower(primary_clock) = "inclk0") or (alpha_tolower(primary_clock) = "inclk1")) then
        ASSERT FALSE
        REPORT "The primary clock is set to an illegal value"
        SEVERITY ERROR;
    end if;    
    
    if ((IS_PIRANHA) and (alpha_tolower(operation_mode) = "external_feedback")) then
        ASSERT FALSE
        REPORT "The external feedback mode is not supported for the ARRIA II family."
        SEVERITY ERROR;
    end if;
    
    if((IS_PIRANHA) and ((alpha_tolower(pll_type) = "top_bottom") or (alpha_tolower(pll_type) = "left_right"))) then
        ASSERT FALSE
        REPORT "A pll_type specification is not supported for the ARRIA II family.  It will be ignored."
        SEVERITY WARNING;
    end if;
    
    if((IS_PIRANHA) and ((port_clk7 /= "PORT_UNUSED") or (port_clk8 /= "PORT_UNUSED") or (port_clk9 /= "PORT_UNUSED"))) then
        ASSERT FALSE
        REPORT "One or more clock outputs used in the design are not supported in ARRIA II family."
        SEVERITY ERROR;
    end if;

    wait;
end process MSG;

-- For fast mode, the stratix pll atom model will give active low signal on locked output.
-- Therefore, need to invert the lock signal for fast mode as in user view, locked signal is
-- always active high.
locked_wire <= (not locked_tmp) when ((not IS_STRATIXII) and
                                (not IS_CYCLONEII) and
                                alpha_tolower(pll_type) = "fast")
            else (locked_tmp and pll_lock_sync) when (IS_STRATIXIII) or
                                (IS_CYCLONEIII) or
                                (IS_STINGRAY)
            else locked_tmp;

clkena_wire(0) <= clkena(0) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena0 = "PORT_USED")) and
                        (port_clkena0 /= "PORT_UNUSED")
            else '1';
clkena_wire(1) <= clkena(1) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena1 = "PORT_USED")) and
                        (port_clkena1 /= "PORT_UNUSED")
            else '1';
clkena_wire(2) <= clkena(2) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena2 = "PORT_USED")) and
                        (port_clkena2 /= "PORT_UNUSED")
            else '1';
clkena_wire(3) <= clkena(3) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena3 = "PORT_USED")) and
                        (port_clkena3 /= "PORT_UNUSED")
            else '1';
clkena_wire(4) <= clkena(4) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena4 = "PORT_USED")) and
                        (port_clkena4 /= "PORT_UNUSED")
            else '1';
clkena_wire(5) <= clkena(5) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_clkena5 = "PORT_USED")) and
                        (port_clkena5 /= "PORT_UNUSED")
            else '1';

extclkena_wire(0) <= extclkena(0) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_extclkena0 = "PORT_USED")) and
                        (port_extclkena0 /= "PORT_UNUSED")
            else '1';
extclkena_wire(1) <= extclkena(1) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_extclkena1 = "PORT_USED")) and
                        (port_extclkena1 /= "PORT_UNUSED")
            else '1';
extclkena_wire(2) <= extclkena(2) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_extclkena2 = "PORT_USED")) and
                        (port_extclkena2 /= "PORT_UNUSED")
            else '1';
extclkena_wire(3) <= extclkena(3) when ((alpha_tolower(pll_type) /= "fast") or
                        (port_extclkena3 = "PORT_USED")) and
                        (port_extclkena3 /= "PORT_UNUSED")
            else '1';

fbin_wire <= fbin when ((port_fbin = "PORT_CONNECTIVITY") or
                        (port_fbin = "PORT_USED"))
            else '0';

pllena_wire <= pllena when ((port_pllena = "PORT_CONNECTIVITY") or
                        (port_pllena = "PORT_USED"))
            else '1';

clkswitch_wire <= clkswitch when ((port_clkswitch = "PORT_CONNECTIVITY") or
                        (port_clkswitch = "PORT_USED"))
            else '0';

areset_wire <= areset when ((port_areset = "PORT_CONNECTIVITY") or
                        (port_areset = "PORT_USED"))
            else '0';

pfdena_wire <= pfdena when ((port_pfdena = "PORT_CONNECTIVITY") or
                        (port_pfdena = "PORT_USED"))
            else '1';

scanclk_wire <= scanclk when (port_scanclk /= "PORT_UNUSED")
            else '0';

scandata_wire <= scandata when (port_scandata /= "PORT_UNUSED")
            else '0';

scanaclr_wire <= scanaclr when (port_scanaclr /= "PORT_UNUSED")
            else '0';

scanread_wire <= scanread when (port_scanread /= "PORT_UNUSED")
            else '0';

scanwrite_wire <= scanwrite when (port_scanwrite /= "PORT_UNUSED")
            else '0';

configupdate_wire <= configupdate when (port_configupdate /= "PORT_UNUSED")
            else '0';

phasecounterselect_wire(width_phasecounterselect-1 downto 0) <= phasecounterselect(width_phasecounterselect-1 downto 0) when (port_phasecounterselect /= "PORT_UNUSED")
            else (others => '0');

phasecounterselect3 :  if (width_phasecounterselect < 3)  generate
    phasecounterselect_wire(3) <= '0';
end generate phasecounterselect3;

phasestep_wire <= phasestep when (port_phasestep /= "PORT_UNUSED")
            else '0';

phaseupdown_wire <= phaseupdown when (port_phaseupdown /= "PORT_UNUSED")
            else '0';

scanclkena_wire <= scanclkena when (port_scanclkena /= "PORT_UNUSED")
            else '1';

clk(0) <= clk_wire(0) when (port_clk0 /= "PORT_UNUSED")
            else '0';
clk(1) <= clk_wire(1) when (port_clk1 /= "PORT_UNUSED")
            else '0';
clk(2) <= clk_wire(2) when (port_clk2 /= "PORT_UNUSED")
            else '0';
clk(3) <= clk_wire(3) when (port_clk3 /= "PORT_UNUSED")
            else '0';
clk(4) <= clk_wire(4) when (port_clk4 /= "PORT_UNUSED")
            else '0';

CLK5 :  if (width_clock = 6)  generate
    clk(5) <= clk_wire(5) when (port_clk5 /= "PORT_UNUSED")
            else '0';
end generate CLK5;

CLK5TO6: if (width_clock = 7)  generate
    clk(5) <= clk_wire(5) when (port_clk5 /= "PORT_UNUSED")
            else '0';
    clk(6) <= clk_wire(6) when (port_clk6 /= "PORT_UNUSED")
            else '0';
end generate CLK5TO6;

CLK5TO9: if (width_clock = 10)  generate
    clk(5) <= clk_wire(5) when (port_clk5 /= "PORT_UNUSED")
            else '0';

    clk(6) <= clk_wire(6) when (port_clk6 /= "PORT_UNUSED")
            else '0';
    clk(7) <= clk_wire(7) when (port_clk7 /= "PORT_UNUSED")
            else '0';
    clk(8) <= clk_wire(8) when (port_clk8 /= "PORT_UNUSED")
            else '0';
    clk(9) <= clk_wire(9) when (port_clk9 /= "PORT_UNUSED")
            else '0';
end generate CLK5TO9;
            
extclk(0) <= extclk_wire(0) when (port_extclk0 /= "PORT_UNUSED")
            else '0';
extclk(1) <= extclk_wire(1) when (port_extclk1 /= "PORT_UNUSED")
            else '0';
extclk(2) <= extclk_wire(2) when (port_extclk2 /= "PORT_UNUSED")
            else '0';
extclk(3) <= extclk_wire(3) when (port_extclk3 /= "PORT_UNUSED")
            else '0';

clkbad(0)  <= clkbad_wire(0) when (port_clkbad0 /= "PORT_UNUSED")
            else '0';
clkbad(1)  <= clkbad_wire(1) when (port_clkbad1 /= "PORT_UNUSED")
            else '0';
activeclock <= activeclock_wire when (port_activeclock /= "PORT_UNUSED")
            else '0';
clkloss <= clkloss_wire when (port_clkloss /= "PORT_UNUSED")
            else '0';

scandataout <= scandataout_wire when (port_scandataout /= "PORT_UNUSED")
            else '0';
            
scandone <= scandone_wire when (port_scandone /= "PORT_UNUSED")
            else '0';

sclkout0  <= sclkout0_wire when (port_sclkout0 /= "PORT_UNUSED")
            else '0';
sclkout1  <= sclkout1_wire when (port_sclkout1 /= "PORT_UNUSED")
            else '0';

locked  <= locked_wire when (port_locked /= "PORT_UNUSED")
            else '0';

phasedone <= phasedone_wire when (port_phasedone /= "PORT_UNUSED")
            else '0';

vcooverrange <= vcooverrange_wire when (port_vcooverrange /= "PORT_UNUSED")
            else '0';

vcounderrange <= vcounderrange_wire when (port_vcounderrange /= "PORT_UNUSED")
            else '0';

fbout <= fbout_wire when (port_fbout /= "PORT_UNUSED")
            else '0';

stratix3_fbin <= iobuf_o when ((using_fbmimicbidir_port = "ON") and (alpha_tolower(operation_mode) = "zero_delay_buffer") and (IS_STRATIXIII) and (not IS_PIRANHA))
            else fbout_wire when ((alpha_tolower(operation_mode) = "zero_delay_buffer") and (IS_PIRANHA)) 
            else fbin;

oe_wire <= '1';

fref <= fref_wire;

icdrclk <= icdrclk_wire;

-- Instantiate stratix_pll
STRATIX_ALTPLL:
if (FEATURE_FAMILY_HAS_STRATIX_STYLE_PLL(intended_device_family) = true) generate
    M0: MF_stratix_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        qualify_conf_done       => alpha_tolower(qualify_conf_done),
        compensate_clock        => alpha_tolower(compensate_clock),
        scan_chain              => alpha_tolower(scan_chain),
        primary_clock           => alpha_tolower(primary_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        gate_lock_signal        => alpha_tolower(gate_lock_signal),
        gate_lock_counter       => gate_lock_counter,
        valid_lock_multiplier   => valid_lock_multiplier,
        invalid_lock_multiplier => invalid_lock_multiplier,
        switch_over_on_lossclk  => alpha_tolower(switch_over_on_lossclk),
        switch_over_on_gated_lock => alpha_tolower(switch_over_on_gated_lock),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        feedback_source         => alpha_tolower(feedback_source),
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        spread_frequency        => spread_frequency,
        down_spread             => down_spread,
        simulation_type         => alpha_tolower(simulation_type),
        skip_vco                => alpha_tolower(skip_vco),
        family_name             => intended_device_family,

        -- internal clock specifications
        clk5_multiply_by    => clk5_multiply_by,
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk5_divide_by      => clk5_divide_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk5_phase_shift    => clk5_phase_shift,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk5_time_delay     => clk5_time_delay,
        clk4_time_delay     => clk4_time_delay,
        clk3_time_delay     => clk3_time_delay,
        clk2_time_delay     => clk2_time_delay,
        clk1_time_delay     => clk1_time_delay,
        clk0_time_delay     => clk0_time_delay,
        clk5_duty_cycle     => clk5_duty_cycle,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,

        -- external clock specifications
        extclk3_multiply_by     => extclk3_multiply_by,
        extclk2_multiply_by     => extclk2_multiply_by,
        extclk1_multiply_by     => extclk1_multiply_by,
        extclk0_multiply_by     => extclk0_multiply_by,
        extclk3_divide_by       => extclk3_divide_by,
        extclk2_divide_by       => extclk2_divide_by,
        extclk1_divide_by       => extclk1_divide_by,
        extclk0_divide_by       => extclk0_divide_by,
        extclk3_phase_shift     => extclk3_phase_shift,
        extclk2_phase_shift     => extclk2_phase_shift,
        extclk1_phase_shift     => extclk1_phase_shift,
        extclk0_phase_shift     => extclk0_phase_shift,
        extclk3_time_delay      => extclk3_time_delay,
        extclk2_time_delay      => extclk2_time_delay,
        extclk1_time_delay      => extclk1_time_delay,
        extclk0_time_delay      => extclk0_time_delay,
        extclk3_duty_cycle      => extclk3_duty_cycle,
        extclk2_duty_cycle      => extclk2_duty_cycle,
        extclk1_duty_cycle      => extclk1_duty_cycle,
        extclk0_duty_cycle      => extclk0_duty_cycle,

        -- advanced user parameters
        vco_min         => get_vco_min_s(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        m2              => m2,
        n2              => n2,
        ss              => ss,
        l0_high         => l0_high,
        l1_high         => l1_high,
        g0_high         => g0_high,
        g1_high         => g1_high,
        g2_high         => g2_high,
        g3_high         => g3_high,
        e0_high         => e0_high,
        e1_high         => e1_high,
        e2_high         => e2_high,
        e3_high         => e3_high,
        l0_low          => l0_low,
        l1_low          => l1_low,
        g0_low          => g0_low,
        g1_low          => g1_low,
        g2_low          => g2_low,
        g3_low          => g3_low,
        e0_low          => e0_low,
        e1_low          => e1_low,
        e2_low          => e2_low,
        e3_low          => e3_low,
        l0_initial      => l0_initial,
        l1_initial      => l1_initial,
        g0_initial      => g0_initial,
        g1_initial      => g1_initial,
        g2_initial      => g2_initial,
        g3_initial      => g3_initial,
        e0_initial      => e0_initial,
        e1_initial      => e1_initial,
        e2_initial      => e2_initial,
        e3_initial      => e3_initial,
        l0_mode         => alpha_tolower(l0_mode),
        l1_mode         => alpha_tolower(l1_mode),
        g0_mode         => alpha_tolower(g0_mode),
        g1_mode         => alpha_tolower(g1_mode),
        g2_mode         => alpha_tolower(g2_mode),
        g3_mode         => alpha_tolower(g3_mode),
        e0_mode         => alpha_tolower(e0_mode),
        e1_mode         => alpha_tolower(e1_mode),
        e2_mode         => alpha_tolower(e2_mode),
        e3_mode         => alpha_tolower(e3_mode),
        l0_ph           => l0_ph,
        l1_ph           => l1_ph,
        g0_ph           => g0_ph,
        g1_ph           => g1_ph,
        g2_ph           => g2_ph,
        g3_ph           => g3_ph,
        e0_ph           => e0_ph,
        e1_ph           => e1_ph,
        e2_ph           => e2_ph,
        e3_ph           => e3_ph,
        m_ph            => m_ph,
        l0_time_delay   => l0_time_delay,
        l1_time_delay   => l1_time_delay,
        g0_time_delay   => g0_time_delay,
        g1_time_delay   => g1_time_delay,
        g2_time_delay   => g2_time_delay,
        g3_time_delay   => g3_time_delay,
        e0_time_delay   => e0_time_delay,
        e1_time_delay   => e1_time_delay,
        e2_time_delay   => e2_time_delay,
        e3_time_delay   => e3_time_delay,
        m_time_delay    => m_time_delay,
        n_time_delay    => n_time_delay,

        extclk3_counter => alpha_tolower(extclk3_counter),
        extclk2_counter => alpha_tolower(extclk2_counter),
        extclk1_counter => alpha_tolower(extclk1_counter),
        extclk0_counter => alpha_tolower(extclk0_counter),
        clk5_counter    => alpha_tolower(clk5_counter),
        clk4_counter    => alpha_tolower(clk4_counter),
        clk3_counter    => alpha_tolower(clk3_counter),
        clk2_counter    => alpha_tolower(clk2_counter),
        clk1_counter    => alpha_tolower(clk1_counter),
        clk0_counter    => alpha_tolower(clk0_counter),
        enable0_counter => alpha_tolower(enable0_counter),
        enable1_counter => alpha_tolower(enable1_counter),

        charge_pump_current => charge_pump_current,
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => loop_filter_c
    )
    port map (
        inclk       => inclk,
        fbin        => fbin_wire,
        ena         => pllena_wire,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        clkena      => clkena_wire,
        extclkena   => extclkena_wire,
        scanclk     => scanclk_wire,
        scanaclr    => scanaclr_wire,
        scandata    => scandata_wire,
        comparator  => comparator,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_wire(3),
        clk(4)      => clk_wire(4),
        clk(5)      => clk_wire(5),
        extclk      => extclk_wire,
        clkbad      => clkbad_wire,
        enable0     => enable0,
        enable1     => enable1,
        activeclock => activeclock_wire,
        clkloss     => clkloss_wire,
        locked      => locked_tmp,
        scandataout => scandataout_wire
    );
end generate STRATIX_ALTPLL;

-- Instantiate stratixii_pll
STRATIXII_ALTPLL:
if ((FEATURE_FAMILY_HAS_STRATIXII_STYLE_PLL(intended_device_family) = true) and
        (FEATURE_FAMILY_BASE_CYCLONEII(intended_device_family) = false)) generate
    M1 : MF_stratixii_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        qualify_conf_done       => alpha_tolower(qualify_conf_done),
        compensate_clock        => alpha_tolower(compensate_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        gate_lock_signal        => alpha_tolower(gate_lock_signal),
        gate_lock_counter       => gate_lock_counter,
        valid_lock_multiplier   => valid_lock_multiplier,
        invalid_lock_multiplier => invalid_lock_multiplier,
        switch_over_type        => alpha_tolower(switch_over_type),
        switch_over_on_lossclk  => alpha_tolower(switch_over_on_lossclk),
        switch_over_on_gated_lock => alpha_tolower(switch_over_on_gated_lock),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        feedback_source         => get_feedback_source(feedback_source),
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        spread_frequency        => spread_frequency,
        down_spread             => down_spread,
        self_reset_on_gated_loss_lock => self_reset_on_gated_loss_lock,
        simulation_type         => alpha_tolower(simulation_type),
        family_name             => intended_device_family,
        
        -- internal clock specifications
        clk5_multiply_by    => clk5_multiply_by,
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk5_divide_by      => clk5_divide_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk5_phase_shift    => clk5_phase_shift,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk5_duty_cycle     => clk5_duty_cycle,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,

        -- advanced user parameters
        vco_min         => get_vco_min_s2(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        m2              => m2,
        n2              => n2,
        ss              => ss,
        c0_high         => c0_high,
        c1_high         => c1_high,
        c2_high         => c2_high,
        c3_high         => c3_high,
        c4_high         => c4_high,
        c5_high         => c5_high,
        c0_low          => c0_low,
        c1_low          => c1_low,
        c2_low          => c2_low,
        c3_low          => c3_low,
        c4_low          => c4_low,
        c5_low          => c5_low,
        c0_initial      => c0_initial,
        c1_initial      => c1_initial,
        c2_initial      => c2_initial,
        c3_initial      => c3_initial,
        c4_initial      => c4_initial,
        c5_initial      => c5_initial,
        c0_mode         => alpha_tolower(c0_mode),
        c1_mode         => alpha_tolower(c1_mode),
        c2_mode         => alpha_tolower(c2_mode),
        c3_mode         => alpha_tolower(c3_mode),
        c4_mode         => alpha_tolower(c4_mode),
        c5_mode         => alpha_tolower(c5_mode),
        c0_ph           => c0_ph,
        c1_ph           => c1_ph,
        c2_ph           => c2_ph,
        c3_ph           => c3_ph,
        c4_ph           => c4_ph,
        c5_ph           => c5_ph,
        m_ph            => m_ph,
        c1_use_casc_in  => c1_use_casc_in,
        c2_use_casc_in  => c2_use_casc_in,
        c3_use_casc_in  => c3_use_casc_in,
        c4_use_casc_in  => c4_use_casc_in,
        c5_use_casc_in  => c5_use_casc_in,
        m_test_source   => m_test_source,
        c0_test_source  => c0_test_source,
        c1_test_source  => c1_test_source,
        c2_test_source  => c2_test_source,
        c3_test_source  => c3_test_source,
        c4_test_source  => c4_test_source,
        c5_test_source  => c5_test_source,
        clk5_counter    => get_clk5_counter(clk5_counter),
        clk4_counter    => get_clk4_counter(clk4_counter),
        clk3_counter    => get_clk3_counter(clk3_counter),
        clk2_counter    => get_clk2_counter(clk2_counter),
        clk1_counter    => get_clk1_counter(clk1_counter),
        clk0_counter    => get_clk0_counter(clk0_counter),
        enable0_counter => get_enable0_counter(enable0_counter),
        enable1_counter => get_enable1_counter(enable1_counter),
        sclkout0_phase_shift => sclkout0_phase_shift,
        sclkout1_phase_shift => sclkout1_phase_shift,
        vco_multiply_by => vco_multiply_by,
        vco_divide_by   => vco_divide_by,
        charge_pump_current => get_charge_pump_current(m, charge_pump_current),
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => get_loop_filter_c(m, loop_filter_c),
        sim_gate_lock_device_behavior => alpha_tolower(sim_gate_lock_device_behavior)
    )
    port map (
        inclk       => inclk,
        fbin        => fbin_wire,
        ena         => pllena_wire,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        scanclk     => scanclk_wire,
        scanread    => scanread_wire,
        scanwrite   => scanwrite_wire,
        scandata    => scandata_wire,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_wire(3),
        clk(4)      => clk_wire(4),
        clk(5)      => clk_wire(5),
        clkbad      => clkbad_wire,
        enable0     => enable0,
        enable1     => enable1,
        activeclock => activeclock_wire,
        clkloss     => clkloss_wire,
        locked      => locked_tmp,
        scandataout => scandataout_wire,
        scandone    => scandone_wire,
        sclkout(0)  => sclkout0_wire,
        sclkout(1)  => sclkout1_wire
    );
end generate STRATIXII_ALTPLL;

-- Instantiate cycloneii_pll
CYCLONEII_ALTPLL:
if (FEATURE_FAMILY_BASE_CYCLONEII(intended_device_family) = true) generate
    M3 : MF_stratixii_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        qualify_conf_done       => alpha_tolower(qualify_conf_done),
        compensate_clock        => alpha_tolower(compensate_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        gate_lock_signal        => alpha_tolower(gate_lock_signal),
        gate_lock_counter       => gate_lock_counter,
        valid_lock_multiplier   => valid_lock_multiplier,
        invalid_lock_multiplier => invalid_lock_multiplier,
        switch_over_type        => "manual",
        switch_over_on_lossclk  => alpha_tolower(switch_over_on_lossclk),
        switch_over_on_gated_lock => alpha_tolower(switch_over_on_gated_lock),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        feedback_source         => get_feedback_source(feedback_source),
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        spread_frequency        => spread_frequency,
        down_spread             => down_spread,
        simulation_type         => alpha_tolower(simulation_type),
        family_name             => intended_device_family,
        
        -- internal clock specifications
        clk5_multiply_by    => clk5_multiply_by,
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk5_divide_by      => clk5_divide_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk5_phase_shift    => clk5_phase_shift,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk5_duty_cycle     => clk5_duty_cycle,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,
        clk2_output_frequency  => clk2_output_frequency,
        clk1_output_frequency  => clk1_output_frequency,
        clk0_output_frequency  => clk0_output_frequency,

        -- advanced user parameters
        vco_min         => get_vco_min_c2(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        m2              => m2,
        n2              => n2,
        ss              => ss,
        c0_high         => c0_high,
        c1_high         => c1_high,
        c2_high         => c2_high,
        c3_high         => c3_high,
        c4_high         => c4_high,
        c5_high         => c5_high,
        c0_low          => c0_low,
        c1_low          => c1_low,
        c2_low          => c2_low,
        c3_low          => c3_low,
        c4_low          => c4_low,
        c5_low          => c5_low,
        c0_initial      => c0_initial,
        c1_initial      => c1_initial,
        c2_initial      => c2_initial,
        c3_initial      => c3_initial,
        c4_initial      => c4_initial,
        c5_initial      => c5_initial,
        c0_mode         => alpha_tolower(c0_mode),
        c1_mode         => alpha_tolower(c1_mode),
        c2_mode         => alpha_tolower(c2_mode),
        c3_mode         => alpha_tolower(c3_mode),
        c4_mode         => alpha_tolower(c4_mode),
        c5_mode         => alpha_tolower(c5_mode),
        c0_ph           => c0_ph,
        c1_ph           => c1_ph,
        c2_ph           => c2_ph,
        c3_ph           => c3_ph,
        c4_ph           => c4_ph,
        c5_ph           => c5_ph,
        m_ph            => m_ph,
        c1_use_casc_in  => c1_use_casc_in,
        c2_use_casc_in  => c2_use_casc_in,
        c3_use_casc_in  => c3_use_casc_in,
        c4_use_casc_in  => c4_use_casc_in,
        c5_use_casc_in  => c5_use_casc_in,
        clk5_counter    => get_clk5_counter(clk5_counter),
        clk4_counter    => get_clk4_counter(clk4_counter),
        clk3_counter    => get_clk3_counter(clk3_counter),
        clk2_counter    => get_clk2_counter(clk2_counter),
        clk1_counter    => get_clk1_counter(clk1_counter),
        clk0_counter    => get_clk0_counter(clk0_counter),
        enable0_counter => get_enable0_counter(enable0_counter),
        enable1_counter => get_enable1_counter(enable1_counter),
        sclkout0_phase_shift => sclkout0_phase_shift,
        sclkout1_phase_shift => sclkout1_phase_shift,
        vco_multiply_by => vco_multiply_by,
        vco_divide_by   => vco_divide_by,
        charge_pump_current => get_charge_pump_current(m, charge_pump_current),
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => get_loop_filter_c(m, loop_filter_c),
        sim_gate_lock_device_behavior => alpha_tolower(sim_gate_lock_device_behavior)
    )
    port map (
        inclk       => inclk,
        fbin        => open,
        ena         => pllena_wire,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        scanclk     => open,
        scanread    => open,
        scanwrite   => open,
        scandata    => open,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_tmp(0),
        clk(4)      => clk_tmp(1),
        clk(5)      => clk_tmp(2),
        clkbad      => open,
        enable0     => open,
        enable1     => open,
        activeclock => open,
        clkloss     => open,
        locked      => locked_tmp,
        scandataout => open,
        scandone    => open,
        sclkout     => open
    );
end generate CYCLONEII_ALTPLL;

-- Instantiate stratixiii_pll
STRATIXIII_ALTPLL:
if (IS_STRATIXIII) generate
    M4 : MF_stratixiii_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        compensate_clock        => alpha_tolower(compensate_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        self_reset_on_loss_lock => alpha_tolower(self_reset_on_loss_lock),
        switch_over_type        => alpha_tolower(switch_over_type),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        lock_high               => lock_high,
        lock_low                => lock_low,
        lock_window_ui          => lock_window_ui,
        simulation_type         => alpha_tolower(simulation_type),
        family_name             => intended_device_family,
        
        -- internal clock specifications
        clk9_multiply_by    => clk9_multiply_by,
        clk8_multiply_by    => clk8_multiply_by,
        clk7_multiply_by    => clk7_multiply_by,
        clk6_multiply_by    => clk6_multiply_by,
        clk5_multiply_by    => clk5_multiply_by,
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk9_divide_by      => clk9_divide_by,
        clk8_divide_by      => clk8_divide_by,
        clk7_divide_by      => clk7_divide_by,
        clk6_divide_by      => clk6_divide_by,
        clk5_divide_by      => clk5_divide_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk9_phase_shift    => clk9_phase_shift,
        clk8_phase_shift    => clk8_phase_shift,
        clk7_phase_shift    => clk7_phase_shift,
        clk6_phase_shift    => clk6_phase_shift,
        clk5_phase_shift    => clk5_phase_shift,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk9_duty_cycle     => clk9_duty_cycle,
        clk8_duty_cycle     => clk8_duty_cycle,
        clk7_duty_cycle     => clk7_duty_cycle,
        clk6_duty_cycle     => clk6_duty_cycle,
        clk5_duty_cycle     => clk5_duty_cycle,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,

        -- advanced user parameters
        vco_min         => get_vco_min_s3(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        c0_high         => c0_high,
        c1_high         => c1_high,
        c2_high         => c2_high,
        c3_high         => c3_high,
        c4_high         => c4_high,
        c5_high         => c5_high,
        c6_high         => c6_high,
        c7_high         => c7_high,
        c8_high         => c8_high,
        c9_high         => c9_high,
        c0_low          => c0_low,
        c1_low          => c1_low,
        c2_low          => c2_low,
        c3_low          => c3_low,
        c4_low          => c4_low,
        c5_low          => c5_low,
        c6_low          => c6_low,
        c7_low          => c7_low,
        c8_low          => c8_low,
        c9_low          => c9_low,
        c0_initial      => c0_initial,
        c1_initial      => c1_initial,
        c2_initial      => c2_initial,
        c3_initial      => c3_initial,
        c4_initial      => c4_initial,
        c5_initial      => c5_initial,
        c6_initial      => c6_initial,
        c7_initial      => c7_initial,
        c8_initial      => c8_initial,
        c9_initial      => c9_initial,
        c0_mode         => alpha_tolower(c0_mode),
        c1_mode         => alpha_tolower(c1_mode),
        c2_mode         => alpha_tolower(c2_mode),
        c3_mode         => alpha_tolower(c3_mode),
        c4_mode         => alpha_tolower(c4_mode),
        c5_mode         => alpha_tolower(c5_mode),
        c6_mode         => alpha_tolower(c6_mode),
        c7_mode         => alpha_tolower(c7_mode),
        c8_mode         => alpha_tolower(c8_mode),
        c9_mode         => alpha_tolower(c9_mode),
        c0_ph           => c0_ph,
        c1_ph           => c1_ph,
        c2_ph           => c2_ph,
        c3_ph           => c3_ph,
        c4_ph           => c4_ph,
        c5_ph           => c5_ph,
        c6_ph           => c6_ph,
        c7_ph           => c7_ph,
        c8_ph           => c8_ph,
        c9_ph           => c9_ph,
        m_ph            => m_ph,
        c1_use_casc_in  => c1_use_casc_in,
        c2_use_casc_in  => c2_use_casc_in,
        c3_use_casc_in  => c3_use_casc_in,
        c4_use_casc_in  => c4_use_casc_in,
        c5_use_casc_in  => c5_use_casc_in,
        c6_use_casc_in  => c6_use_casc_in,
        c7_use_casc_in  => c7_use_casc_in,
        c8_use_casc_in  => c8_use_casc_in,
        c9_use_casc_in  => c9_use_casc_in,
        m_test_source   => get_test_source(m_test_source),
        c0_test_source  => get_test_source(c0_test_source),
        c1_test_source  => get_test_source(c1_test_source),
        c2_test_source  => get_test_source(c2_test_source),
        c3_test_source  => get_test_source(c3_test_source),
        c4_test_source  => get_test_source(c4_test_source),
        c5_test_source  => get_test_source(c5_test_source),
        c6_test_source  => get_test_source(c6_test_source),
        c7_test_source  => get_test_source(c7_test_source),
        c8_test_source  => get_test_source(c8_test_source),
        c9_test_source  => get_test_source(c9_test_source),
        clk9_counter    => get_clk_counter(clk9_counter, port_clk9),
        clk8_counter    => get_clk_counter(clk8_counter, port_clk8),
        clk7_counter    => get_clk_counter(clk7_counter, port_clk7),
        clk6_counter    => get_clk_counter(clk6_counter, port_clk6),
        clk5_counter    => get_clk_counter(get_clk5_counter(clk5_counter), port_clk5),
        clk4_counter    => get_clk_counter(get_clk4_counter(clk4_counter), port_clk4),
        clk3_counter    => get_clk_counter(get_clk3_counter(clk3_counter), port_clk3),
        clk2_counter    => get_clk_counter(get_clk2_counter(clk2_counter), port_clk2),
        clk1_counter    => get_clk_counter(get_clk1_counter(clk1_counter), port_clk1),
        clk0_counter    => get_clk_counter(get_clk0_counter(clk0_counter), port_clk0),
        dpa_multiply_by => dpa_multiply_by,
        dpa_divide_by   => dpa_divide_by,
        dpa_divider     => dpa_divider,
        vco_multiply_by => vco_multiply_by,
        vco_divide_by   => vco_divide_by,
        vco_frequency_control => alpha_tolower(vco_frequency_control),
        vco_phase_shift_step  => vco_phase_shift_step,
        charge_pump_current => charge_pump_current,
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => loop_filter_c,
        charge_pump_current_bits  => charge_pump_current_bits,
        loop_filter_c_bits        => loop_filter_c_bits,
        loop_filter_r_bits        => loop_filter_r_bits,
        clk9_use_even_counter_mode => alpha_tolower(clk0_use_even_counter_mode),
        clk8_use_even_counter_mode => alpha_tolower(clk1_use_even_counter_mode),
        clk7_use_even_counter_mode => alpha_tolower(clk2_use_even_counter_mode),
        clk6_use_even_counter_mode => alpha_tolower(clk3_use_even_counter_mode),
        clk5_use_even_counter_mode => alpha_tolower(clk4_use_even_counter_mode),
        clk4_use_even_counter_mode => alpha_tolower(clk5_use_even_counter_mode),
        clk3_use_even_counter_mode => alpha_tolower(clk6_use_even_counter_mode),
        clk2_use_even_counter_mode => alpha_tolower(clk7_use_even_counter_mode),
        clk1_use_even_counter_mode => alpha_tolower(clk8_use_even_counter_mode),
        clk0_use_even_counter_mode => alpha_tolower(clk9_use_even_counter_mode),
        clk9_use_even_counter_value => alpha_tolower(clk9_use_even_counter_value),
        clk8_use_even_counter_value => alpha_tolower(clk8_use_even_counter_value),
        clk7_use_even_counter_value => alpha_tolower(clk7_use_even_counter_value),
        clk6_use_even_counter_value => alpha_tolower(clk6_use_even_counter_value),
        clk5_use_even_counter_value => alpha_tolower(clk5_use_even_counter_value),
        clk4_use_even_counter_value => alpha_tolower(clk4_use_even_counter_value),
        clk3_use_even_counter_value => alpha_tolower(clk3_use_even_counter_value),
        clk2_use_even_counter_value => alpha_tolower(clk2_use_even_counter_value),
        clk1_use_even_counter_value => alpha_tolower(clk1_use_even_counter_value),
        clk0_use_even_counter_value => alpha_tolower(clk0_use_even_counter_value)
    )
    port map (
        inclk       => inclk,
        fbin        => stratix3_fbin,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        scanclk     => scanclk_wire,
        scandata    => scandata_wire,
        scanclkena  => scanclkena_wire,
        phasecounterselect => phasecounterselect_wire,
        phaseupdown => phaseupdown_wire,
        phasestep   => phasestep_wire,
        configupdate => configupdate_wire,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_wire(3),
        clk(4)      => clk_wire(4),
        clk(5)      => clk_wire(5),
        clk(6)      => clk_wire(6),
        clk(7)      => clk_wire(7),
        clk(8)      => clk_wire(8),
        clk(9)      => clk_wire(9),
        clkbad      => clkbad_wire,
        activeclock => activeclock_wire,
        locked      => locked_tmp,
        scandataout => scandataout_wire,
        scandone    => scandone_wire,
        phasedone   => phasedone_wire,
        vcooverrange => vcooverrange_wire,
        vcounderrange => vcounderrange_wire,
        fbout       => fbout_wire
    );
end generate STRATIXIII_ALTPLL;

-- Instantiate cycloneiii_pll
CYCLONEIII_ALTPLL:
if ((not IS_STINGRAY) and
        (IS_CYCLONEIII)) generate
    M5 : MF_cycloneiii_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        compensate_clock        => alpha_tolower(compensate_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        self_reset_on_loss_lock => alpha_tolower(self_reset_on_loss_lock),
        switch_over_type        => alpha_tolower(switch_over_type),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        lock_high               => lock_high,
        lock_low                => lock_low,
        lock_window_ui          => lock_window_ui,
        simulation_type         => alpha_tolower(simulation_type),
        family_name             => intended_device_family,
        
        -- internal clock specifications
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,

        -- advanced user parameters
        vco_min         => get_vco_min_c3(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        c0_high         => c0_high,
        c1_high         => c1_high,
        c2_high         => c2_high,
        c3_high         => c3_high,
        c4_high         => c4_high,
        c0_low          => c0_low,
        c1_low          => c1_low,
        c2_low          => c2_low,
        c3_low          => c3_low,
        c4_low          => c4_low,
        c0_initial      => c0_initial,
        c1_initial      => c1_initial,
        c2_initial      => c2_initial,
        c3_initial      => c3_initial,
        c4_initial      => c4_initial,
        c0_mode         => alpha_tolower(c0_mode),
        c1_mode         => alpha_tolower(c1_mode),
        c2_mode         => alpha_tolower(c2_mode),
        c3_mode         => alpha_tolower(c3_mode),
        c4_mode         => alpha_tolower(c4_mode),
        c0_ph           => c0_ph,
        c1_ph           => c1_ph,
        c2_ph           => c2_ph,
        c3_ph           => c3_ph,
        c4_ph           => c4_ph,
        m_ph            => m_ph,
        c1_use_casc_in  => c1_use_casc_in,
        c2_use_casc_in  => c2_use_casc_in,
        c3_use_casc_in  => c3_use_casc_in,
        c4_use_casc_in  => c4_use_casc_in,
        m_test_source   => get_test_source(m_test_source),
        c0_test_source  => get_test_source(c0_test_source),
        c1_test_source  => get_test_source(c1_test_source),
        c2_test_source  => get_test_source(c2_test_source),
        c3_test_source  => get_test_source(c3_test_source),
        c4_test_source  => get_test_source(c4_test_source),
        clk4_counter    => get_clk_counter(get_clk4_counter(clk4_counter), port_clk4),
        clk3_counter    => get_clk_counter(get_clk3_counter(clk3_counter), port_clk3),
        clk2_counter    => get_clk_counter(get_clk2_counter(clk2_counter), port_clk2),
        clk1_counter    => get_clk_counter(get_clk1_counter(clk1_counter), port_clk1),
        clk0_counter    => get_clk_counter(get_clk0_counter(clk0_counter), port_clk0),
        vco_multiply_by => vco_multiply_by,
        vco_divide_by   => vco_divide_by,
        vco_frequency_control => alpha_tolower(vco_frequency_control),
        vco_phase_shift_step  => vco_phase_shift_step,
        charge_pump_current => charge_pump_current,
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => loop_filter_c,
        charge_pump_current_bits  => charge_pump_current_bits,
        loop_filter_c_bits        => loop_filter_c_bits,
        loop_filter_r_bits        => loop_filter_r_bits,
        clk4_use_even_counter_mode => alpha_tolower(clk5_use_even_counter_mode),
        clk3_use_even_counter_mode => alpha_tolower(clk6_use_even_counter_mode),
        clk2_use_even_counter_mode => alpha_tolower(clk7_use_even_counter_mode),
        clk1_use_even_counter_mode => alpha_tolower(clk8_use_even_counter_mode),
        clk0_use_even_counter_mode => alpha_tolower(clk9_use_even_counter_mode),
        clk4_use_even_counter_value => alpha_tolower(clk4_use_even_counter_value),
        clk3_use_even_counter_value => alpha_tolower(clk3_use_even_counter_value),
        clk2_use_even_counter_value => alpha_tolower(clk2_use_even_counter_value),
        clk1_use_even_counter_value => alpha_tolower(clk1_use_even_counter_value),
        clk0_use_even_counter_value => alpha_tolower(clk0_use_even_counter_value)
    )
    port map (
        inclk       => inclk,
        fbin        => fbin_wire,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        scanclk     => scanclk,
        scandata    => scandata,
        scanclkena  => scanclkena_wire,
        configupdate => configupdate_wire,
        phasecounterselect => phasecounterselect_wire(2 downto 0),
        phaseupdown => phaseupdown_wire,
        phasestep   => phasestep_wire,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_wire(3),
        clk(4)      => clk_wire(4),
        clkbad      => clkbad_wire,
        activeclock => activeclock_wire,
        locked      => locked_tmp,
        scandataout => scandataout_wire,
        scandone    => scandone_wire,
        phasedone   => phasedone_wire,
        vcooverrange => vcooverrange_wire,
        vcounderrange => vcounderrange_wire,
        fbout       => fbout_wire
    );
end generate CYCLONEIII_ALTPLL;

-- Instantiate cycloneiiigx_pll
CYCLONEIIIGL_ALTPLL:
if (IS_STINGRAY) generate
    M6 : MF_cycloneiiigl_pll
    generic map(
        operation_mode          => alpha_tolower(operation_mode),
        pll_type                => alpha_tolower(pll_type),
        compensate_clock        => alpha_tolower(compensate_clock),
        inclk0_input_frequency  => inclk0_input_frequency,
        inclk1_input_frequency  => inclk1_input_frequency,
        self_reset_on_loss_lock => alpha_tolower(self_reset_on_loss_lock),
        switch_over_type        => alpha_tolower(switch_over_type),
        enable_switch_over_counter => alpha_tolower(enable_switch_over_counter),
        switch_over_counter     => switch_over_counter,
        bandwidth               => bandwidth,
        bandwidth_type          => alpha_tolower(bandwidth_type),
        lock_high               => lock_high,
        lock_low                => lock_low,
        lock_window_ui          => lock_window_ui,
        simulation_type         => alpha_tolower(simulation_type),
        family_name             => intended_device_family,
        
        -- internal clock specifications
        clk4_multiply_by    => clk4_multiply_by,
        clk3_multiply_by    => clk3_multiply_by,
        clk2_multiply_by    => clk2_multiply_by,
        clk1_multiply_by    => clk1_multiply_by,
        clk0_multiply_by    => clk0_multiply_by,
        clk4_divide_by      => clk4_divide_by,
        clk3_divide_by      => clk3_divide_by,
        clk2_divide_by      => clk2_divide_by,
        clk1_divide_by      => clk1_divide_by,
        clk0_divide_by      => clk0_divide_by,
        clk4_phase_shift    => clk4_phase_shift,
        clk3_phase_shift    => clk3_phase_shift,
        clk2_phase_shift    => clk2_phase_shift,
        clk1_phase_shift    => clk1_phase_shift,
        clk0_phase_shift    => clk0_phase_shift,
        clk4_duty_cycle     => clk4_duty_cycle,
        clk3_duty_cycle     => clk3_duty_cycle,
        clk2_duty_cycle     => clk2_duty_cycle,
        clk1_duty_cycle     => clk1_duty_cycle,
        clk0_duty_cycle     => clk0_duty_cycle,

        -- advanced user parameters
        vco_min         => get_vco_min_c3(vco_min),
        vco_max         => get_vco_max(vco_max),
        vco_center      => vco_center,
        dpa_multiply_by => dpa_multiply_by,
        dpa_divide_by   => dpa_divide_by,
        dpa_divider     => dpa_divider,
        pfd_min         => pfd_min,
        pfd_max         => pfd_max,
        m_initial       => m_initial,
        m               => m,
        n               => n,
        c0_high         => c0_high,
        c1_high         => c1_high,
        c2_high         => c2_high,
        c3_high         => c3_high,
        c4_high         => c4_high,
        c0_low          => c0_low,
        c1_low          => c1_low,
        c2_low          => c2_low,
        c3_low          => c3_low,
        c4_low          => c4_low,
        c0_initial      => c0_initial,
        c1_initial      => c1_initial,
        c2_initial      => c2_initial,
        c3_initial      => c3_initial,
        c4_initial      => c4_initial,
        c0_mode         => alpha_tolower(c0_mode),
        c1_mode         => alpha_tolower(c1_mode),
        c2_mode         => alpha_tolower(c2_mode),
        c3_mode         => alpha_tolower(c3_mode),
        c4_mode         => alpha_tolower(c4_mode),
        c0_ph           => c0_ph,
        c1_ph           => c1_ph,
        c2_ph           => c2_ph,
        c3_ph           => c3_ph,
        c4_ph           => c4_ph,
        m_ph            => m_ph,
        c1_use_casc_in  => c1_use_casc_in,
        c2_use_casc_in  => c2_use_casc_in,
        c3_use_casc_in  => c3_use_casc_in,
        c4_use_casc_in  => c4_use_casc_in,
        m_test_source   => get_test_source(m_test_source),
        c0_test_source  => get_test_source(c0_test_source),
        c1_test_source  => get_test_source(c1_test_source),
        c2_test_source  => get_test_source(c2_test_source),
        c3_test_source  => get_test_source(c3_test_source),
        c4_test_source  => get_test_source(c4_test_source),
        clk4_counter    => get_clk_counter(get_clk4_counter(clk4_counter), port_clk4),
        clk3_counter    => get_clk_counter(get_clk3_counter(clk3_counter), port_clk3),
        clk2_counter    => get_clk_counter(get_clk2_counter(clk2_counter), port_clk2),
        clk1_counter    => get_clk_counter(get_clk1_counter(clk1_counter), port_clk1),
        clk0_counter    => get_clk_counter(get_clk0_counter(clk0_counter), port_clk0),
        vco_multiply_by => vco_multiply_by,
        vco_divide_by   => vco_divide_by,
        vco_frequency_control => alpha_tolower(vco_frequency_control),
        vco_phase_shift_step  => vco_phase_shift_step,
        charge_pump_current => charge_pump_current,
        loop_filter_r       => loop_filter_r,
        loop_filter_c       => loop_filter_c,
        charge_pump_current_bits  => charge_pump_current_bits,
        loop_filter_c_bits        => loop_filter_c_bits,
        loop_filter_r_bits        => loop_filter_r_bits,
        clk4_use_even_counter_mode => alpha_tolower(clk5_use_even_counter_mode),
        clk3_use_even_counter_mode => alpha_tolower(clk6_use_even_counter_mode),
        clk2_use_even_counter_mode => alpha_tolower(clk7_use_even_counter_mode),
        clk1_use_even_counter_mode => alpha_tolower(clk8_use_even_counter_mode),
        clk0_use_even_counter_mode => alpha_tolower(clk9_use_even_counter_mode),
        clk4_use_even_counter_value => alpha_tolower(clk4_use_even_counter_value),
        clk3_use_even_counter_value => alpha_tolower(clk3_use_even_counter_value),
        clk2_use_even_counter_value => alpha_tolower(clk2_use_even_counter_value),
        clk1_use_even_counter_value => alpha_tolower(clk1_use_even_counter_value),
        clk0_use_even_counter_value => alpha_tolower(clk0_use_even_counter_value)
    )
    port map (
        inclk       => inclk,
        fbin        => fbin_wire,
        clkswitch   => clkswitch_wire,
        areset      => areset_wire,
        pfdena      => pfdena_wire,
        scanclk     => scanclk,
        scandata    => scandata,
        scanclkena  => scanclkena_wire,
        configupdate => configupdate_wire,
        phasecounterselect => phasecounterselect_wire(2 downto 0),
        phaseupdown => phaseupdown_wire,
        phasestep   => phasestep_wire,
        clk(0)      => clk_wire(0),
        clk(1)      => clk_wire(1),
        clk(2)      => clk_wire(2),
        clk(3)      => clk_wire(3),
        clk(4)      => clk_wire(4),
        clkbad      => clkbad_wire,
        activeclock => activeclock_wire,
        locked      => locked_tmp,
        scandataout => scandataout_wire,
        scandone    => scandone_wire,
        phasedone   => phasedone_wire,
        vcooverrange => vcooverrange_wire,
        vcounderrange => vcounderrange_wire,
        fbout       => fbout_wire,
        fref        => fref_wire,
        icdrclk     => icdrclk_wire
    );
end generate CYCLONEIIIGL_ALTPLL;

-- Instantiate pll_iobuf
STRATIXIIIPLL_IOBUF:
if ((IS_STRATIXIII) and (not IS_PIRANHA)
    and (alpha_tolower(operation_mode) = "zero_delay_buffer")
    and (using_fbmimicbidir_port = "ON")) generate
    iobuf1 : pll_iobuf
    port map (
        i       => fbout_wire,
        oe      => oe_wire,
        o       => iobuf_o,
        io      => fbmimicbidir
    );
    
    
end generate STRATIXIIIPLL_IOBUF;

process (locked_tmp, areset)
begin
    if (areset = '1') then
        pll_lock_sync <= '0';
    elsif (locked_tmp = '1' and locked_tmp'event) then
        pll_lock_sync <= '1';
    end if;
end process;

    
end behavior;
-- END ARCHITECTURE BEHAVIOR

---START_ENTITY_HEADER---------------------------------------------------------
--
-- Entity Name     :  altaccumulate
--
-- Description     :  Parameterized accumulator megafunction. The accumulator
-- performs an add function or a subtract function based on the add_sub
-- parameter. The input data can be signed or unsigned.
--
-- Limitation      : n/a
--
-- Results expected:  result - The results of add or subtract operation. Output
--                             port [width_out-1 .. 0] wide.
--                    cout   - The cout port has a physical interpretation as 
--                             the carry-out (borrow-in) of the MSB. The cout
--                             port is most meaningful for detecting overflow
--                             in unsigned operations. The cout port operates
--                             in the same manner for signed and unsigned
--                             operations.
--                    overflow - Indicates the accumulator is overflow.
--
---END_ENTITY_HEADER-----------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

-- BEGINNING OF ENTITY
entity altaccumulate is
    -- GENERIC DECLARATION
    generic (
        width_in           : natural := 4;      -- Required
        width_out          : natural := 8;      -- Required
        lpm_representation : string  := "UNSIGNED";
        extra_latency      : integer := 0;
        use_wys            : string  := "ON";
        lpm_hint           : string  := "UNUSED";
        lpm_type           : string  := "altaccumulate"
    );

    -- PORT DECLARATION
    port (
        -- INPUT PORT DECLARATION
        cin       : in std_logic := 'Z';
        data      : in std_logic_vector(width_in -1 downto 0);  -- Required port
        add_sub   : in std_logic := '1';
        clock     : in std_logic;   -- Required port
        sload     : in std_logic := '0';
        clken     : in std_logic := '1';
        sign_data : in std_logic := '0';
        aclr      : in std_logic := '0';

        -- OUTPUT PORT DECLARATION
        result    : out std_logic_vector(width_out -1 downto 0) := (others => '0'); -- Required port
        cout      : out std_logic := '0';
        overflow  : out std_logic := '0'
    );
end altaccumulate;
-- END OF ENTITY

-- BEGINNING OF ARCHITECTURE
architecture behaviour of altaccumulate is

-- TYPE DECLARATION
type pipeline is array (extra_latency-1 downto 0) of std_logic_vector (width_out+1 downto 0);

-- SIGNAL DECLARATION
signal temp_sum : std_logic_vector (width_out downto 0) := (others => '0');
signal cout_int : std_logic := '0';
signal overflow_int : std_logic := '0';
signal result_int : std_logic_vector (width_out+1 downto 0) := (others => '0');

signal result_pipe : pipeline := (others => (others => '0'));


begin
    MSG: process
    begin
        if( width_in <= 0 ) then
            ASSERT FALSE
            REPORT "Error! Value of width_in parameter must be greater than 0."
            SEVERITY ERROR;
        end if;

        if( width_out <= 0 ) then
            ASSERT FALSE
            REPORT "Error! Value of width_out parameter must be greater than 0."
            SEVERITY ERROR;
        end if;
        
        if( extra_latency > width_out ) then
            ASSERT FALSE
            REPORT "Info: Value of extra_latency parameter should be lower than width_out parameter for better performance/utilization."
            SEVERITY NOTE;
        end if;
        
        if( width_in > width_out ) then
            ASSERT FALSE
            REPORT "Error! Value of width_in parameter should be lower than or equal to width_out."
            SEVERITY ERROR;
        end if;
        wait;
    end process MSG;

    -- PROCESS DECLARATION
    ADDSUB : process (data, add_sub, sload, cin, sign_data,
                        result_int (width_out-1 downto 0))

    -- VARIABLE DECLARATIOM
    variable fb_int : std_logic_vector (width_out downto 0) := (others => '0');
    variable data_int : std_logic_vector (width_out-1 downto 0) := (others => '0');
    variable zeropad : std_logic_vector ((width_out - width_in)-1 downto 0) := (others => '0');
    variable temp_sum_int : std_logic_vector (width_out downto 0) := (others => '0');
    variable cout_temp, borrow : std_logic;
    variable result_full : std_logic_vector (width_out downto 0);
    variable temp_sum_zero : std_logic_vector (width_out downto 0) := (others => '0');
    variable cin_int : std_logic;
    begin

        if ((LPM_REPRESENTATION = "SIGNED") or (sign_data = '1')) then
            zeropad := (others => data (width_in-1));
        else
            zeropad := (others => '0');
        end if;

        if (sload = '1') then
            fb_int := (others => '0');
        else
            fb_int := ('0' & result_int (width_out-1 downto 0));
        end if;

        if ((data (0) = '1') or (data (0) = '0')) then
            data_int := (zeropad & data);
        end if;

        -- If cin is omitted (i.e. cin = 'z'), cin default is 0 for add operation
        -- and 1 for subtract operation.
        if ((cin /= '0') and (cin /= '1')) then
            cin_int := not add_sub;
        else
            cin_int := cin;
        end if;

        if (sload = '1') then
            temp_sum_int := unsigned(temp_sum_zero) + unsigned(data_int);
        else
            if (add_sub = '1') then
                temp_sum_int := unsigned(temp_sum_zero) + unsigned(fb_int) +
                                unsigned(data_int) + cin_int;
                cout_temp := temp_sum_int(width_out);
            else
                borrow := not cin_int;
                if ((borrow /= '1') and (borrow /= '0')) then
                    borrow := '0';
                end if;

                temp_sum_int := unsigned(temp_sum_zero) + unsigned (fb_int) -
                                unsigned (data_int) - borrow;
                result_full := unsigned(temp_sum_zero) + unsigned(data_int) +
                                borrow;

                if (fb_int >= result_full) then
                    cout_temp :='1';
                else
                    cout_temp :='0';
                end if;
            end if;
        end if;

        if (sload = '0') then
            if ((LPM_REPRESENTATION = "SIGNED") or (sign_data = '1')) then
                overflow_int <= ((not (data (width_in-1) xor result_int (width_out -1))) xor (not (add_sub))) and
                                (result_int (width_out -1) xor temp_sum_int (width_out -1));
            else
                overflow_int <= not (add_sub xor cout_temp);
            end if;
        else
            overflow_int <= '0';
            cout_temp := not add_sub;
        end if;

        cout_int <= cout_temp;
        temp_sum <= temp_sum_int;

    end process ADDSUB;

    ACC: process (clock, aclr, cout_int)

    -- VARIABLE DECLARATIOM
    variable head_pipe : integer;
    variable head : integer := 0;
    variable full_res: std_logic_vector (width_out+1 downto 0);
    begin
        head_pipe := head;

        if ((aclr /= '1') and (extra_latency = 0)) then
            cout <= cout_int;
        end if;    
        
        if (aclr = '1') then
            result <= (others => '0');
            result_int <= (others => '0');
            if (extra_latency > 0) then
                cout <= '0';
            else
                cout <= cout_int;
            end if;
            overflow <= '0';
            result_pipe <= (others => (others => '0'));
        
        elsif rising_edge(clock) then
            if (clken = '1') then
                if (extra_latency > 0) then
                    result_pipe (head_pipe) <= (result_int (width_out+1) &
                                                cout_int &
                                                result_int (width_out-1 downto 0));

                    head_pipe := (head_pipe + 1) mod (extra_latency);
                    if (head_pipe = head) then
                        full_res := (result_int (width_out+1) &
                                        cout_int &
                                        result_int (width_out-1 downto 0));
                    else
                        full_res := result_pipe (head_pipe);
                    end if;
                    cout <= full_res (width_out);
                    result <= full_res (width_out-1 downto 0);
                    overflow <= full_res (width_out+1);
                else
                    overflow <= overflow_int;
                    result <= temp_sum (width_out-1 downto 0);
                end if;
                result_int <= (overflow_int & cout_int &
                                temp_sum (width_out-1 downto 0));
            end if;
        end if;

        head := head_pipe;
    end process ACC;

end behaviour; -- End behaviour of altaccumulate
-- END OF ARCHITECTURE

-- --------------------------------------------------------------------------
-- Module Name      : altmult_accum
--
-- Description      : a*b + x (MAC)
--
-- Limitation       : Stratix DSP block
--
-- Results expected : signed & unsigned, maximum of 3 pipelines(latency) each.
--
-- --------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use work.ALTERA_DEVICE_FAMILIES.all;

entity altmult_accum is
    generic (

        -- ---------------------
        -- PARAMETER DECLARATION
        -- ---------------------
        width_a                        : natural := 1;
        width_b                        : natural := 1;
        width_result                   : natural := 2;
        width_upper_data               : natural := 1;
        input_source_a                 : string  := "DATAA";
        input_source_b                 : string  := "DATAB";
        input_reg_a                    : string  := "CLOCK0";
        input_aclr_a                   : string  := "ACLR3";
        input_reg_b                    : string  := "CLOCK0";
        input_aclr_b                   : string  := "ACLR3";
        port_addnsub                   : string  := "PORT_CONNECTIVITY";
        addnsub_reg                    : string  := "CLOCK0";
        addnsub_aclr                   : string  := "ACLR3";
        addnsub_pipeline_reg           : string  := "CLOCK0";
        addnsub_pipeline_aclr          : string  := "ACLR3";
        accum_direction                : string  := "ADD";
        accum_sload_reg                : string  := "CLOCK0";
        accum_sload_aclr               : string  := "ACLR3";
        accum_sload_pipeline_reg       : string  := "CLOCK0";
        accum_sload_pipeline_aclr      : string  := "ACLR3";
        representation_a               : string  := "UNSIGNED";
        port_signa                     : string  := "PORT_CONNECTIVITY";
        sign_reg_a                     : string  := "CLOCK0";
        sign_aclr_a                    : string  := "ACLR3";
        sign_pipeline_reg_a            : string  := "CLOCK0";
        sign_pipeline_aclr_a           : string  := "ACLR3";
        representation_b               : string  := "UNSIGNED";
        port_signb                     : string  := "PORT_CONNECTIVITY";
        sign_reg_b                     : string  := "CLOCK0";
        sign_aclr_b                    : string  := "ACLR3";
        sign_pipeline_reg_b            : string  := "CLOCK0";
        sign_pipeline_aclr_b           : string  := "ACLR3";
        multiplier_reg                 : string  := "CLOCK0";
        multiplier_aclr                : string  := "ACLR3";
        output_reg                     : string  := "CLOCK0";
        output_aclr                    : string  := "ACLR3";
        extra_multiplier_latency       : integer := 0;
        extra_accumulator_latency      : integer := 0;
        dedicated_multiplier_circuitry : string  := "AUTO";
        dsp_block_balancing            : string  := "AUTO";
        lpm_hint                       : string  := "UNUSED";
        lpm_type                       : string  := "altmult_accum";
        intended_device_family         : string  := "Stratix";
        multiplier_rounding            : string  := "NO";
        mult_round_aclr                : string  := "ACLR3";
        mult_round_reg                 : string  := "CLOCK0";
        multiplier_saturation          : string  := "NO";
        mult_saturation_aclr           : string  := "ACLR3";
        mult_saturation_reg            : string  := "CLOCK0";
        accumulator_rounding           : string  := "NO";
        accum_round_aclr               : string  := "ACLR3";
        accum_round_reg                : string  := "CLOCK0";
        accum_round_pipeline_aclr      : string  := "ACLR3";
        accum_round_pipeline_reg       : string  := "CLOCK0";
        accumulator_saturation         : string  := "NO";
        accum_saturation_aclr          : string  := "ACLR3";
        accum_saturation_reg           : string  := "CLOCK0";
        accum_saturation_pipeline_aclr : string  := "ACLR3";
        accum_saturation_pipeline_reg  : string  := "CLOCK0";
        accum_sload_upper_data_aclr    : string  := "ACLR3";
        accum_sload_upper_data_pipeline_aclr : string  := "ACLR3";
        accum_sload_upper_data_pipeline_reg  : string  := "CLOCK0";
        accum_sload_upper_data_reg     : string  := "CLOCK0";
        port_mult_is_saturated         : string  := "UNUSED";
        port_accum_is_saturated        : string  := "UNUSED"
    );

    port (

        -- ----------------
        -- PORT DECLARATION
        -- ----------------

        -- input data ports
        dataa       : in std_logic_vector(width_a -1 downto 0) := (others => '0');
        datab       : in std_logic_vector(width_b -1 downto 0) := (others => '0');
        scanina     : in std_logic_vector(width_a -1 downto 0) := (others => 'Z');
        scaninb     : in std_logic_vector(width_b -1 downto 0) := (others => 'Z');
        accum_sload_upper_data : in std_logic_vector(width_upper_data - 1 downto 0) := (others => '0');
        sourcea     : in std_logic := '0';
        sourceb     : in std_logic := '0';
        -- control signals
        addnsub   : in std_logic := 'Z';
        accum_sload : in std_logic := '0';
        signa       : in std_logic := 'Z';
        signb       : in std_logic := 'Z';
        -- clock ports
        clock0      : in std_logic := '1';
        clock1      : in std_logic := '1';
        clock2      : in std_logic := '1';
        clock3      : in std_logic := '1';
        -- clock enable ports
        ena0        : in std_logic := '1';
        ena1        : in std_logic := '1';
        ena2        : in std_logic := '1';
        ena3        : in std_logic := '1';
        -- clear ports
        aclr0       : in std_logic := '0';
        aclr1       : in std_logic := '0';
        aclr2       : in std_logic := '0';
        aclr3       : in std_logic := '0';
        -- round and saturation ports
        mult_round       : in std_logic := '0';
        mult_saturation  : in std_logic := '0';
        accum_round      : in std_logic := '0';
        accum_saturation : in std_logic := '0';
        -- output ports
        result      : out std_logic_vector(width_result -1 downto 0) := (others => '0');
        overflow    : out std_logic :='0';
        scanouta    : out std_logic_vector (width_a -1 downto 0) := (others => '0');
        scanoutb    : out std_logic_vector (width_b -1 downto 0) := (others => '0');
        mult_is_saturated  : out std_logic := '0';
        accum_is_saturated : out std_logic := '0'
    );
end altmult_accum;


architecture behaviour of altmult_accum is
    -- -------------------------------------
    -- INTERNAL SIGNALS AND TYPE DECLARATION
    -- -------------------------------------

    -- CONSTANT DECLARATION
    constant IS_STRATIXIII   : boolean := FEATURE_FAMILY_STRATIXIII(intended_device_family);
    constant IS_STRATIXII  : boolean := FEATURE_FAMILY_STRATIXII(intended_device_family);
    constant IS_CYCLONEII   : boolean := FEATURE_FAMILY_CYCLONEII(intended_device_family);
    
    function resolve_internal_width (ARG : integer;ARG2 : integer) return integer is
        variable changed_width:integer := 0;
    begin
        if (multiplier_saturation = "NO" and multiplier_rounding = "NO" and
            accumulator_saturation = "NO" and accumulator_rounding = "NO") then
            if (ARG2 = 0) then
                changed_width := width_a;
            else
                changed_width := width_b;
            end if;
        else
            changed_width := 18;
        end if;
        return changed_width;
    end resolve_internal_width;

    -- This constant int_width_a would be  used internally in this model
    -- to represent width_a
    constant int_width_a : natural := resolve_internal_width(width_a, 0);
    
    -- This constant int_width_b woudl be used internally in this model 
    -- to represent width_b        
    constant int_width_b : natural := resolve_internal_width(width_b, 1);

    function resolve_internal_extra_width return integer is
        variable changed_value :integer := 0;
    begin
        if (multiplier_saturation = "NO" and multiplier_rounding = "NO" and
            accumulator_saturation = "NO" and accumulator_rounding = "NO") then
            changed_value := 0;
        else
            changed_value := int_width_a + int_width_b - width_a - width_b;
        end if;
        return changed_value;
    end resolve_internal_extra_width;
 
    constant int_extra_width : integer := resolve_internal_extra_width;
    
    function resolve_internal_width_result return integer is
        variable changed_width_result:integer := 0;
    begin
        if (multiplier_saturation = "NO" and multiplier_rounding = "NO" and
            accumulator_saturation = "NO" and accumulator_rounding = "NO") then
            if ((int_width_a + int_width_b - 1) > width_result) then
                changed_width_result := int_width_a + int_width_b - 1;
            else
                changed_width_result := width_result;
            end if;
        else
            if ((int_width_a + int_width_b - 1) > 52) then
                changed_width_result := int_width_a + int_width_b - 1;
            else
                changed_width_result := 52;
            end if;
        end if;
        return changed_width_result;
    end resolve_internal_width_result;
    
    constant int_width_result : natural := resolve_internal_width_result;
    
    -- -------------------------------------
    -- INTERNAL TEMPLATE DECLARATION
    -- -------------------------------------
    type pipeline_accum is array (extra_accumulator_latency downto 0) of std_logic_vector (int_width_result downto 0);
    type pipeline_multi is array (extra_multiplier_latency downto 0) of std_logic_vector (int_width_a + int_width_b + 4 downto 0);
    type pipeline_sload is array (extra_multiplier_latency downto 0) of std_logic_vector (width_upper_data - 1 downto 0);

    signal mult_a             : std_logic_vector (width_a - 1 downto 0):= (others => '0');
    signal mult_b             : std_logic_vector (width_b - 1 downto 0):= (others => '0');
    signal mult_res           : std_logic_vector (int_width_a + int_width_b - 1 downto 0):= (others => '0');
    signal acc_sload_reg      : std_logic := '0';
    signal accum_sload_pipe   : std_logic := '0';
    signal sign_a_reg         : std_logic := '0';
    signal sign_a_pipe        : std_logic := '0';
    signal sign_a_latent      : std_logic := '0';
    signal sign_b_reg         : std_logic := '0';
    signal sign_b_pipe        : std_logic := '0';
    signal sign_b_latent      : std_logic := '0';
    signal addsub_reg         : std_logic := '0';
    signal addsub_pipe        : std_logic := '0';
    signal addsub_latent      : std_logic := '0';
    signal accum_sload_latent : std_logic := '0';

    signal mult_pipe   : pipeline_multi := (others => (others => '0'));
    signal sload_upper_data_pipe    : pipeline_sload := (others => (others => '0'));

    signal mult_out_latent : std_logic_vector (int_width_a + int_width_b - 1 downto 0):= (others => '0');
    signal result_int      : std_logic_vector (int_width_result - 1 downto 0):= (others => '0');
    signal temp_mult_zero  : std_logic_vector (int_width_a + int_width_b downto 0):= (others => '0');
    signal mult_full       : std_logic_vector (int_width_a + int_width_b + 4 downto 0):= (others => '0');

    signal mult_signed      : std_logic := '0';
    signal do_add           : std_logic := '0';
    signal temp_mult_signed : std_logic := '0';
    signal head_result      : natural   := 0;
    signal head_mult        : natural   := 0;

    signal lower_bits               : std_logic_vector (width_result + width_upper_data - 1 downto 0) := (others => '0');
    signal sload_upper_data_reg     : std_logic_vector (width_upper_data - 1 downto 0) := (others => '0');
    signal sload_upper_data_latent  : std_logic_vector (width_upper_data - 1 downto 0) := (others => '0');
    signal sload_upper_data_wire    : std_logic_vector (width_upper_data - 1 downto 0) := (others => '0');
    signal sload_upper_data_full    : std_logic_vector (width_upper_data - 1 downto 0) := (others => '0');

    signal mult_is_saturated_wire : std_logic := '0';
    signal mult_is_saturated_reg  : std_logic := '0';
    signal mult_is_saturated_out  : std_logic := '0';
    signal accum_is_saturated_out : std_logic := '0';

    signal mult_round_wire : std_logic := '0';
    signal mult_saturate_wire : std_logic := '0';
    signal mult_final_out : std_logic_vector (int_width_a + int_width_b - 1 downto 0) := (others => '0');

    signal accum_round_pipe_wire : std_logic := '0';
    signal accum_round_wire : std_logic := '0';
    signal accum_saturation_pipe_wire : std_logic := '0';
    signal accum_saturate_wire : std_logic := '0';
    
    begin

        scanouta           <= mult_a;
        scanoutb           <= mult_b;
        sign_a_latent      <= mult_full (int_width_a + int_width_b + 4) when extra_multiplier_latency >0 else sign_a_reg;
        sign_b_latent      <= mult_full (int_width_a + int_width_b + 3) when extra_multiplier_latency >0 else sign_b_reg;
        accum_sload_latent <= mult_full (int_width_a + int_width_b + 2) when extra_multiplier_latency >0 else acc_sload_reg;
        addsub_latent      <= mult_full (int_width_a + int_width_b + 1) when extra_multiplier_latency >0 else addsub_reg;
        mult_signed        <= mult_full (int_width_a + int_width_b + 0) when extra_multiplier_latency >0 else temp_mult_signed;
        mult_out_latent    <= mult_full (int_width_a + int_width_b - 1 downto 0) when extra_multiplier_latency >0 else mult_final_out;
        sload_upper_data_latent <= sload_upper_data_full when extra_multiplier_latency >0 else sload_upper_data_reg;

        mult_is_saturated  <= mult_is_saturated_out when (port_mult_is_saturated = "USED") else '0';
        accum_is_saturated <= accum_is_saturated_out when (port_accum_is_saturated = "USED") else '0';


        -- Parameter Checking
        process 
        begin
            if ((dedicated_multiplier_circuitry /= "AUTO") and 
                (dedicated_multiplier_circuitry /= "YES") and 
                (dedicated_multiplier_circuitry /= "NO")) then
                assert false
                report "Error: The DEDICATED_MULTIPLIER_CIRCUITRY parameter is set to an illegal value."
                severity error;
            end if;                

            if (width_a <= 0) then
                assert false
                report "Error: width_a must be greater than 0."
                severity error;
            end if;

            if (width_b <= 0) then
                assert false
                report "Error: width_b must be greater than 0."
                severity error;
            end if;

            if (width_result <= 0) then
                assert false
                report "Error: width_result must be greater than 0."
                severity error;
            end if;

            if ((not IS_STRATIXII) and
                (not IS_CYCLONEII) and
                (input_source_a /= "DATAA")) then
                assert false
                report "Error: The input source for port A are limited to input dataa."
                severity error;
            end if;

            if ((not IS_STRATIXII) and
                (not IS_CYCLONEII) and
                (input_source_b /= "DATAB")) then
                assert false
                report "Error: The input source for port B are limited to input datab."
                severity error;
            end if;

            if ((not FEATURE_FAMILY_BASE_STRATIXII(intended_device_family)) and (multiplier_rounding /= "NO")) then
                assert false
                report "Error: There is no rounding feature for " & intended_device_family & " device."
                severity error;
            end if;

            if ((not IS_STRATIXII) and (accumulator_rounding /= "NO")) then
                assert false
                report "Error: There is no rounding feature for "& intended_device_family &" device."
                severity error;
            end if;

            if ((not FEATURE_FAMILY_BASE_STRATIXII(intended_device_family)) and (multiplier_saturation /= "NO")) then
                assert false
                report "Error: There is no saturation feature for "& intended_device_family &" device."
                severity error;
            end if;

            if ((not IS_STRATIXII) and (accumulator_saturation /= "NO")) then
                assert false
                report "Error: There is no saturation feature for "& intended_device_family &" device."
                severity error;
            end if;
            
            if ((IS_STRATIXIII) and (port_addnsub /= "PORT_UNUSED")) then
                assert false
                report "Error: The addnsub port is not available for "& intended_device_family &" device."
                severity error;
            end if;
            
            if ((IS_STRATIXIII) and (accum_direction /= "ADD") and
                (accum_direction /= "SUB")) then
                assert false
                report "Error: Invalid value for ACCUM_DIRECTION parameter for "& intended_device_family &" device."
                severity error;
            end if;
            
            if ((IS_STRATIXIII) and (input_source_a = "VARIABLE")) then
                assert false
                report "Error: Invalid value for INPUT_SOURCE_A parameter for "& intended_device_family &" device."
                severity error;
            end if;
            
            wait;
            
        end process;

        G1:if (input_reg_a = "UNREGISTERED") generate
        process (dataa, scanina, sourcea)
        begin
            if (input_source_a = "DATAA") then
                mult_a <= dataa;
            elsif (input_source_a = "SCANA") then
                mult_a <= scanina;
            elsif (input_source_a = "VARIABLE") then
                if (sourcea = '1') then
                    mult_a <= dataa;
                else
                    mult_a <= scanina;
                end if;
            end if;
        end process;
        end generate G1;        
                
        G2:if (input_reg_b = "UNREGISTERED") generate
        process (datab, scaninb, sourceb)
        begin
            if (input_source_b = "DATAB") then
                mult_b <= datab;
            elsif (input_source_b = "SCANB") then
                mult_b <= scaninb;
            elsif (input_source_b = "VARIABLE") then
                if (sourceb = '1') then
                    mult_b <= datab;
                else
                    mult_b <= scaninb;
                end if;
            end if;
        end process;
        end generate G2;
                        
        G3: if (addnsub_reg = "UNREGISTERED") generate    
                addsub_reg <= addnsub; 
        end generate G3;
        
        G4: if (addnsub_pipeline_reg = "UNREGISTERED") generate 
                addsub_pipe <= addsub_latent;
        end generate G4;
        
        G5: if (accum_sload_reg = "UNREGISTERED") generate
                acc_sload_reg <= accum_sload;
        end generate G5;       
            
        G6: if (accum_sload_pipeline_reg = "UNREGISTERED") generate
                accum_sload_pipe <= accum_sload_latent;
        end generate G6;   
        
        G7: if (sign_reg_a = "UNREGISTERED") generate
                sign_a_reg <= signa;
        end generate G7;
            
        G8: if sign_reg_b= "UNREGISTERED" generate
                sign_b_reg <= signb;
        end generate G8;
            
        G9: if (sign_pipeline_reg_a = "UNREGISTERED") generate
                sign_a_pipe <= sign_a_latent;
        end generate G9;    
        
        G10: if (sign_pipeline_reg_b = "UNREGISTERED") generate
                sign_b_pipe <= sign_b_latent;
        end generate G10;
            
        G11: if (accum_round_reg = "UNREGISTERED") generate
        process (accum_round, accum_sload)
        begin
            if (IS_STRATIXIII) then
                accum_round_pipe_wire <= accum_sload;
            else
                accum_round_pipe_wire <= accum_round;
            end if;
        end process;
        end generate G11;
            
        G12: if (accum_round_pipeline_reg = "UNREGISTERED") generate
                accum_round_wire <= accum_round_pipe_wire;
        end generate G12;
            
        G12b: if (accum_saturation_reg = "UNREGISTERED") generate
                accum_saturation_pipe_wire <= accum_saturation;
        end generate G12b;
        
        G14: if (accum_saturation_pipeline_reg = "UNREGISTERED") generate
                accum_saturate_wire <= accum_saturation_pipe_wire;
        end generate G14;
            
        G15: if (mult_round_reg = "UNREGISTERED") generate
                mult_round_wire <= mult_round;
        end generate G15;
            
        G16: if (mult_saturation_reg = "UNREGISTERED") generate
                mult_saturate_wire <= mult_saturation;
        end generate G16;
            
        G17: if (accum_sload_upper_data_reg = "UNREGISTERED") generate
                sload_upper_data_reg <= accum_sload_upper_data;
        end generate G17;
            
        G18: if (accum_sload_upper_data_pipeline_reg = "UNREGISTERED") generate
                sload_upper_data_wire <= sload_upper_data_latent;
        end generate G18;
            
        G19: if (multiplier_reg = "UNREGISTERED") generate
                mult_res <= mult_out_latent;
                mult_is_saturated_reg <= mult_is_saturated_wire;
        end generate G19;
            
        -- ----------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set mult_a)
        -- The signal registered is dataa
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if input_reg_a is unregistered and
        --       dataa changes value
        -- ---------------------------------------------------------------------------
        
        IFG1: if (input_reg_a = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, dataa, scanina, sourcea)
        begin
            if (((input_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                mult_a <= (others => '0');
            elsif rising_edge(clock0) then
                if ((ena0 ='1')) then                
                    if (input_source_a = "DATAA") then
                        mult_a <= dataa;
                    elsif (input_source_a = "SCANA") then
                        mult_a <= scanina;
                    elsif (input_source_a = "VARIABLE") then
                        if (sourcea = '1') then
                            mult_a <= dataa;
                        else
                            mult_a <= scanina;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG1;

        IFG2: if (input_reg_a = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, dataa, scanina, sourcea)
        begin
            if (((input_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                mult_a <= (others => '0');
            elsif rising_edge(clock1) then
                if ((ena1 ='1')) then
                    if (input_source_a = "DATAA") then
                        mult_a <= dataa;
                    elsif (input_source_a = "SCANA") then
                        mult_a <= scanina;
                    elsif (input_source_a = "VARIABLE") then
                        if (sourcea = '1') then
                            mult_a <= dataa;
                        else
                            mult_a <= scanina;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG2;

        IFG3: if (input_reg_a = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, dataa, scanina, sourcea)
        begin
            if (((input_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                mult_a <= (others => '0');
            elsif rising_edge(clock2) then
                if ((ena2 ='1'))then
                    if (input_source_a = "DATAA") then
                        mult_a <= dataa;
                    elsif (input_source_a = "SCANA") then
                        mult_a <= scanina;
                    elsif (input_source_a = "VARIABLE") then
                        if (sourcea = '1') then
                            mult_a <= dataa;
                        else
                            mult_a <= scanina;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG3;

        IFG4: if (input_reg_a = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, dataa, scanina, sourcea)
        begin
            if (((input_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                mult_a <= (others => '0');
            elsif rising_edge(clock3) then
                if ((ena3 ='1')) then
                    if (input_source_a = "DATAA") then
                        mult_a <= dataa;
                    elsif (input_source_a = "SCANA") then
                        mult_a <= scanina;
                    elsif (input_source_a = "VARIABLE") then
                        if (sourcea = '1') then
                            mult_a <= dataa;
                        else
                            mult_a <= scanina;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG4;
        -- ----------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set mult_b)
        -- The signal registered is datab
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if input_reg_b is unregistered and
        --       datab changes value
        -- ---------------------------------------------------------------------------
        IFG5: if (input_reg_b = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, datab, scaninb, sourceb)
        begin
            if (((input_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                mult_b <= (others => '0');
            elsif rising_edge(clock0) then
                if ((ena0 ='1')) then
                    if (input_source_b = "DATAB") then
                        mult_b <= datab;
                    elsif (input_source_b = "SCANB") then
                        mult_b <= scaninb;
                    elsif (input_source_b = "VARIABLE") then
                        if (sourceb = '1') then
                            mult_b <= datab;
                        else
                            mult_b <= scaninb;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG5;

        IFG6: if (input_reg_b = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, datab, scaninb, sourceb)
        begin
            if (((input_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                mult_b <= (others => '0');
            elsif rising_edge(clock1) then
                if ((ena1 ='1')) then
                    if (input_source_b = "DATAB") then
                        mult_b <= datab;
                    elsif (input_source_b = "SCANB") then
                        mult_b <= scaninb;
                    elsif (input_source_b = "VARIABLE") then
                        if (sourceb = '1') then
                            mult_b <= datab;
                        else
                            mult_b <= scaninb;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG6;

        IFG7: if (input_reg_b = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, datab, scaninb, sourceb)
        begin
            if (((input_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                mult_b <= (others => '0');
            elsif rising_edge(clock2) then
                if ((ena2 ='1')) then
                    if (input_source_b = "DATAB") then
                        mult_b <= datab;
                    elsif (input_source_b = "SCANB") then
                        mult_b <= scaninb;
                    elsif (input_source_b = "VARIABLE") then
                        if (sourceb = '1') then
                            mult_b <= datab;
                        else
                            mult_b <= scaninb;
                        end if;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG7;

        IFG8: if (input_reg_b = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, datab, scaninb, sourceb)
        begin
            if (((input_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((input_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((input_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((input_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                mult_b <= (others => '0');
            elsif rising_edge(clock3) then
                if ((ena3 ='1')) then
                    if (input_source_b = "DATAB") then
                        mult_b <= datab;
                    elsif (input_source_b = "SCANB") then
                        mult_b <= scaninb;
                    elsif (input_source_b = "VARIABLE") then
                        if (sourceb = '1') then
                            mult_b <= datab;
                        else
                            mult_b <= scaninb;
                        end if;
                    end if;
                end if;        
            end if;
        end process;
        end generate IFG8;

        -- ------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set addsub_reg)
        -- The signal registered is addnsub
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if addnsub_reg is unregistered and
        --       addnsub changes value
        -- ------------------------------------------------------------------------------
        IFG9: if (addnsub_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, addnsub)
        begin
            if (((addnsub_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_reg <= '0';
            elsif rising_edge(clock0) then
                if ((ena0 ='1')) then
                addsub_reg <= addnsub;
                end if;
            end if;
        end process;
        end generate IFG9;
        
        IFG10: if (addnsub_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, addnsub)
        begin
            if (((addnsub_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_reg <= '0';
            elsif rising_edge(clock1) then
                if ((ena1 ='1')) then
                addsub_reg <= addnsub;
                end if;
            end if;
        end process;
        end generate IFG10;
        
        IFG11: if (addnsub_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, addnsub)
        begin
            if (((addnsub_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_reg <= '0';
            elsif rising_edge(clock2) then
                if ((ena2 ='1')) then
                addsub_reg <= addnsub;
                end if;
            end if;
        end process;
        end generate IFG11;
        
        IFG12: if (addnsub_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, addnsub)
        begin
            if (((addnsub_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_reg <= '0';
            elsif rising_edge(clock3) then
                if ((ena3 ='1')) then
                    addsub_reg <= addnsub;
                end if;
            end if;
        end process;
        end generate IFG12;


        -- ------------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set addsub_pipe)
        -- The signal registered is addnsub_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if addnsub_pipeline_reg is unregistered and
        --       addsub_latent changes value
        -- ------------------------------------------------------------------------------------
        
        IFG12b: if (addnsub_pipeline_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, addsub_latent)
        begin
            if (((addnsub_pipeline_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_pipe <= '0';
            elsif  rising_edge(clock0) then
                if ((ena0 ='1')) then
                addsub_pipe <= addsub_latent;
                end if;
            end if;
        end process;
        end generate IFG12b;
        
        IFG14: if (addnsub_pipeline_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, addsub_latent)
        begin
            if (((addnsub_pipeline_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_pipe <= '0';
            elsif rising_edge(clock1) then
                if ((ena1 ='1')) then
                addsub_pipe <= addsub_latent;
                end if;
            end if;
        end process;
        end generate IFG14;
        
        IFG15: if (addnsub_pipeline_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, addsub_latent)
        begin
            if (((addnsub_pipeline_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_pipe <= '0';
            elsif rising_edge(clock2) then
                if ((ena2 ='1')) then
                    addsub_pipe <= addsub_latent;
                end if;
            end if;
        end process;
        end generate IFG15;
        
        IFG16: if (addnsub_pipeline_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, addsub_latent)
        begin
            if (((addnsub_pipeline_aclr= "ACLR0") and (aclr0 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR1") and (aclr1 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR2") and (aclr2 = '1')) or
                ((addnsub_pipeline_aclr= "ACLR3") and (aclr3 = '1'))) then
                addsub_pipe <= '0';
            elsif rising_edge(clock3) then
                if ((ena3 ='1')) then
                addsub_pipe <= addsub_latent;
                end if;
            end if;
        end process;
        end generate IFG16;
      

        -- ---------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set acc_sload_reg)
        -- The signal registered is accum_sload
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_sload_reg is unregistered and
        --       accum_sload changes value
        -- ---------------------------------------------------------------------------------
        IFG17: if (accum_sload_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, accum_sload)
        begin
            if (((accum_sload_aclr= "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_aclr= "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_aclr= "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_aclr= "ACLR3") and (aclr3 = '1'))) then
                acc_sload_reg <= '0';
            elsif rising_edge(clock0) then
                if ((ena0 ='1')) then
                acc_sload_reg <= accum_sload;
                end if;
            end if;
        end process;
        end generate IFG17;
        
        IFG18: if (accum_sload_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, accum_sload)
        begin
            if (((accum_sload_aclr= "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_aclr= "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_aclr= "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_aclr= "ACLR3") and (aclr3 = '1'))) then
                acc_sload_reg <= '0';
            elsif rising_edge(clock1) then
                if ((ena1 ='1')) then
                acc_sload_reg <= accum_sload;
                end if;
            end if;
        end process;
        end generate IFG18;
        
        IFG19: if (accum_sload_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, accum_sload)
        begin
            if (((accum_sload_aclr= "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_aclr= "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_aclr= "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_aclr= "ACLR3") and (aclr3 = '1'))) then
                acc_sload_reg <= '0';
            elsif rising_edge(clock2) then
                if((ena2 ='1')) then
                acc_sload_reg <= accum_sload;
                end if;
            end if;
        end process;
        end generate IFG19;

        IFG20: if (accum_sload_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, accum_sload)
        begin
            if (((accum_sload_aclr= "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_aclr= "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_aclr= "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_aclr= "ACLR3") and (aclr3 = '1'))) then
                acc_sload_reg <= '0';
            elsif rising_edge(clock3) then
                if ((ena3 ='1')) then
                    acc_sload_reg <= accum_sload;
                end if;
            end if;
        end process;
        end generate IFG20;



        -- ------------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set accum_sload_pipe)
        -- The signal registered is accum_sload_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_sload_pipeline_reg
        -- is unregistered and accum_sload_latent changes value
        -- ------------------------------------------------------------------------------------
        IFG21: if (accum_sload_pipeline_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, accum_sload_latent)
        begin
            if (((accum_sload_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_sload_pipe <= '0';
            elsif rising_edge(clock0) then
                if ((ena0 = '1')) then
                accum_sload_pipe <= accum_sload_latent;
                end if;
            end if;
        end process;
        end generate IFG21;
        
        IFG22: if (accum_sload_pipeline_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, accum_sload_latent)
        begin
            if (((accum_sload_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_sload_pipe <= '0';
            elsif rising_edge(clock1) then
                if ((ena1 = '1')) then
                accum_sload_pipe <= accum_sload_latent;
                end if;
            end if;
        end process;
        end generate IFG22;

        IFG23: if (accum_sload_pipeline_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, accum_sload_latent)
        begin
            if (((accum_sload_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_sload_pipe <= '0';
            elsif rising_edge(clock2) then
                if ((ena2 = '1')) then
                accum_sload_pipe <= accum_sload_latent;
                end if;
            end if;
        end process;
        end generate IFG23;

        IFG24: if (accum_sload_pipeline_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, accum_sload_latent)
        begin
            if (((accum_sload_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or
                ((accum_sload_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_sload_pipe <= '0';
            elsif rising_edge(clock3) then
                if ((ena3 = '1')) then
                    accum_sload_pipe <= accum_sload_latent;
                end if;
            end if;
        end process;
        end generate IFG24;


        -- ------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set sign_a_reg)
        -- The signal registered is signa
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if sign_reg_a is unregistered and
        --       signa changes value
        -- ------------------------------------------------------------------------------
        
        IFG25: if (sign_reg_a = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, signa)
        begin
            if (((sign_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_reg <= '0';
            elsif (rising_edge(clock0)) then 
                if (ena0 ='1') then
                sign_a_reg <= signa;
            end if;
            end if;
        end process;
        end generate IFG25;
        
        IFG26: if (sign_reg_a = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, signa)
        begin
            if (((sign_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_reg <= '0';
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                sign_a_reg <= signa;
            end if;
        end process;
        end generate IFG26;
        
        IFG27: if (sign_reg_a = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, signa)
        begin
            if (((sign_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_reg <= '0';
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                    sign_a_reg <= signa;
                end if;
        end process;
        end generate IFG27;
        
        IFG28: if (sign_reg_a = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, signa)
        begin
            if (((sign_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_reg <= '0';
            elsif (rising_edge(clock3) and (ena3 ='1')) then
                sign_a_reg <= signa;
            end if;
        end process;
        end generate IFG28;
        
        


        -- ------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set sign_b_reg)
        -- The signal registered is signb
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if sign_reg_b is unregistered and
        --       signb changes value
        -- ------------------------------------------------------------------------------
        
        IFG29: if (sign_reg_b = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, signb)
        begin
            if (((sign_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_reg <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 ='1') then
                sign_b_reg <= signb;
                end if;
            end if;
        end process;
        end generate IFG29;

        IFG30: if (sign_reg_b = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, signb)
        begin
            if (((sign_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_reg <= '0';
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                sign_b_reg <= signb;
            end if;
        end process;
        end generate IFG30;

        IFG31: if (sign_reg_b = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, signb)
        begin
            if (((sign_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_reg <= '0';
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                    sign_b_reg <= signb;
            end if;
        end process;
        end generate IFG31;
        
        IFG32: if (sign_reg_b = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, signb)
        begin
            if (((sign_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_reg <= '0';
            elsif (rising_edge(clock3) and (ena3 ='1'))then
                sign_b_reg <= signb;
            end if;
        end process;
        end generate IFG32;


        -- -------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set sign_a_pipe)
        -- The signal registered is sign_a_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if sign_pipeline_reg_a
        -- is unregistered and sign_a_latent changes value
        -- -------------------------------------------------------------------------------
        
        IFG33: if (sign_pipeline_reg_a = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, sign_a_latent)
        begin
            if (((sign_pipeline_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_pipe <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 ='1') then
                sign_a_pipe <= sign_a_latent;
                end if;
            end if;
        end process;
        end generate IFG33;
        
        IFG34: if (sign_pipeline_reg_a = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, sign_a_latent)
        begin
            if (((sign_pipeline_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_pipe <= '0';
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                sign_a_pipe <= sign_a_latent;
            end if;
        end process;
        end generate IFG34;
        
        IFG35: if (sign_pipeline_reg_a = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, sign_a_latent)
        begin
            if (((sign_pipeline_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_pipe <= '0';
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                    sign_a_pipe <= sign_a_latent;
            end if;
        end process;
        end generate IFG35;
        
        IFG36: if (sign_pipeline_reg_a = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, sign_a_latent)
        begin
            if (((sign_pipeline_aclr_a= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_a= "ACLR3") and (aclr3 = '1'))) then
                sign_a_pipe <= '0';
            elsif (rising_edge(clock3) and (ena3 ='1')) then
                sign_a_pipe <= sign_a_latent;
            end if;
        end process;
        end generate IFG36;


        -- -------------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set sign_b_pipe)
        -- The signal registered is sign_b_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if sign_pipeline_reg_b
        -- is unregistered and sign_b_latent changes value
        -- -------------------------------------------------------------------------------
        
        IFG37: if (sign_pipeline_reg_b = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, sign_b_latent)
        begin
            if (((sign_pipeline_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_pipe <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 ='1') then
                sign_b_pipe <= sign_b_latent;
                end if;
            end if;
        end process;
        end generate IFG37;
        
        IFG38: if (sign_pipeline_reg_b = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, sign_b_latent)
        begin
            if (((sign_pipeline_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_pipe <= '0';
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                sign_b_pipe <= sign_b_latent;
            end if;
        end process;
        end generate IFG38;
        
        IFG39: if (sign_pipeline_reg_b = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, sign_b_latent)
        begin
            if (((sign_pipeline_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_pipe <= '0';
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                    sign_b_pipe <= sign_b_latent;
            end if;
        end process;
        end generate IFG39;
        
        IFG40: if (sign_pipeline_reg_b = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, sign_b_latent)
        begin
            if (((sign_pipeline_aclr_b= "ACLR0") and (aclr0 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR1") and (aclr1 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR2") and (aclr2 = '1')) or
                ((sign_pipeline_aclr_b= "ACLR3") and (aclr3 = '1'))) then
                sign_b_pipe <= '0';
            elsif (rising_edge(clock3) and (ena3 ='1')) then
                sign_b_pipe <= sign_b_latent;
            end if;
        end process;
        end generate IFG40;
                

        
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set accum_round_pipe_wire)
        -- The signal registered is accum_round
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_round_reg
        -- is unregistered and accum_round changes value
        -------------------------------------------------------------------------------------
        
        IFG41: if (accum_round_reg = "CLOCK0") generate
        process (clock0, accum_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_pipe_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                    if (IS_STRATIXIII) then
                        accum_round_pipe_wire <= accum_sload;
                    else
                        accum_round_pipe_wire <= accum_round;
                    end if;
                end if;
            end if;
        end process;
        end generate IFG41;

        IFG42: if (accum_round_reg = "CLOCK1") generate
        process (clock1, accum_round, aclr0, aclr1, aclr2, aclr3)
        begin
          
            if (((accum_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_pipe_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                if (IS_STRATIXIII) then
                    accum_round_pipe_wire <= accum_sload;
                else
                    accum_round_pipe_wire <= accum_round;
                end if;
            end if;
        end process;
        end generate IFG42;

        IFG43: if (accum_round_reg = "CLOCK2") generate
        process (clock2, accum_round, aclr0, aclr1, aclr2, aclr3)
        begin
          
            if (((accum_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_pipe_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                if (IS_STRATIXIII) then
                    accum_round_pipe_wire <= accum_sload;
                else
                    accum_round_pipe_wire <= accum_round;
                end if;
            end if;
        end process;
        end generate IFG43;

        IFG44: if (accum_round_reg = "CLOCK3") generate
        process (clock3, accum_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_pipe_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                if (IS_STRATIXIII) then
                    accum_round_pipe_wire <= accum_sload;
                else
                    accum_round_pipe_wire <= accum_round;
                end if;
            end if;
        end process;
        end generate IFG44;

        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set accum_round_wire)
        -- The signal registered is accum_round_pipe_wire
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_round_pipeline_reg
        -- is unregistered and accum_round_pipe_wire changes value
        -------------------------------------------------------------------------------------
        
        IFG45: if (accum_round_pipeline_reg = "CLOCK0") generate
        process (clock0, accum_round_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                accum_round_wire <= accum_round_pipe_wire;
                end if;
            end if;
        end process;
        end generate IFG45;
          
        IFG46: if (accum_round_pipeline_reg = "CLOCK1") generate
        process (clock1, accum_round_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                accum_round_wire <= accum_round_pipe_wire;
            end if;
        end process;
        end generate IFG46;
                       
        IFG47: if (accum_round_pipeline_reg = "CLOCK2") generate
        process (clock2, accum_round_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                accum_round_wire <= accum_round_pipe_wire;
            end if;
        end process;
        end generate IFG47;
        
        IFG48: if (accum_round_pipeline_reg = "CLOCK3") generate 
        process (clock3, accum_round_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_round_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_round_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_round_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                accum_round_wire <= accum_round_pipe_wire;
            end if;
        end process;
        end generate IFG48;
         
            
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set accum_saturation_pipe_wire)
        -- The signal registered is accum_saturation
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_saturation_reg
        -- is unregistered and accum_saturation changes value
        -- ---------------------------------------------------------------------------------
        
        IFG49: if (accum_saturation_reg = "CLOCK0") generate
        process (clock0, accum_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturation_pipe_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1')then
                accum_saturation_pipe_wire <= accum_saturation;
                end if;
            end if;
        end process;
        end generate IFG49;

        IFG50: if (accum_saturation_reg = "CLOCK1") generate
        process (clock1, accum_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturation_pipe_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                accum_saturation_pipe_wire <= accum_saturation;
            end if;
        end process;
        end generate IFG50;
        
        IFG51: if (accum_saturation_reg = "CLOCK2") generate
        process (clock2, accum_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturation_pipe_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                accum_saturation_pipe_wire <= accum_saturation;
            end if;
        end process;
        end generate IFG51;
         
        IFG52: if (accum_saturation_reg = "CLOCK3") generate
        process (clock3, accum_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturation_pipe_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                accum_saturation_pipe_wire <= accum_saturation;
            end if;
        end process;
        end generate IFG52;

        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set accum_saturate_wire)
        -- The signal registered is accum_saturation_pipe_wire
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_saturation_pipeline_reg
        -- is unregistered and accum_saturation_pipe_wire changes value
        -- ---------------------------------------------------------------------------------

        IFG53: if (accum_saturation_pipeline_reg = "CLOCK0") generate
        process (clock0, accum_saturation_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                    ((accum_saturation_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                    ((accum_saturation_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                    ((accum_saturation_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                    accum_saturate_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                    accum_saturate_wire <= accum_saturation_pipe_wire;
                end if;
            end if;
        end process;
        end generate IFG53;

        IFG54: if (accum_saturation_pipeline_reg = "CLOCK1") generate
        process (clock1, accum_saturation_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturate_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                accum_saturate_wire <= accum_saturation_pipe_wire;
            end if;
        end process;
        end generate IFG54;
         
        IFG55: if (accum_saturation_pipeline_reg = "CLOCK2") generate
        process (clock2, accum_saturation_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturate_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                accum_saturate_wire <= accum_saturation_pipe_wire;
            end if;
        end process;
        end generate IFG55;

        IFG56: if (accum_saturation_pipeline_reg = "CLOCK3") generate
        process (clock3, accum_saturation_pipe_wire, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_saturation_pipeline_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((accum_saturation_pipeline_aclr = "ACLR3") and (aclr3 = '1'))) then
                accum_saturate_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                accum_saturate_wire <= accum_saturation_pipe_wire;
            end if;
        end process;
        end generate IFG56;
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set mult_round_wire)
        -- The signal registered is mult_round
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if mult_round_reg
        -- is unregistered and mult_round changes value
        -- ---------------------------------------------------------------------------------
        
        IFG57: if (mult_round_reg = "CLOCK0") generate
        process (clock0, mult_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_round_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                mult_round_wire <= mult_round;
                end if;
            end if;
        end process;
        end generate IFG57;
         
        IFG58: if (mult_round_reg = "CLOCK1") generate
        process (clock1, mult_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_round_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                mult_round_wire <= mult_round;
            end if;
        end process;
        end generate IFG58;
        
        IFG59: if (mult_round_reg = "CLOCK2") generate
        process (clock2, mult_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_round_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                mult_round_wire <= mult_round;
            end if;
        end process;
        end generate IFG59;
         
        IFG60: if (mult_round_reg = "CLOCK3") generate
        process (clock3, mult_round, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_round_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_round_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_round_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_round_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_round_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                mult_round_wire <= mult_round;
            end if;
        end process;
        end generate IFG60;
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set mult_saturation_wire)
        -- The signal registered is mult_saturation
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if mult_saturation_reg
        -- is unregistered and mult_saturation changes value
        -- ---------------------------------------------------------------------------------
        IFG61: if (mult_saturation_reg = "CLOCK0") generate
        process (clock0, mult_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_saturate_wire <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                mult_saturate_wire <= mult_saturation;
                end if;
            end if;
        end process;
        end generate IFG61;
            
        IFG62: if (mult_saturation_reg = "CLOCK1") generate
        process (clock1, mult_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_saturate_wire <= '0';
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                mult_saturate_wire <= mult_saturation;
            end if;
        end process;
        end generate IFG62;
        
        IFG63: if (mult_saturation_reg = "CLOCK2") generate    
        process (clock2, mult_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_saturate_wire <= '0';
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                mult_saturate_wire <= mult_saturation;
            end if;
        end process;
        end generate IFG63;
            
        IFG64: if (mult_saturation_reg = "CLOCK3") generate    
        process (clock3, mult_saturation, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((mult_saturation_aclr = "ACLR0") and (aclr0 = '1')) or  
                ((mult_saturation_aclr = "ACLR1") and (aclr1 = '1')) or  
                ((mult_saturation_aclr = "ACLR2") and (aclr2 = '1')) or  
                ((mult_saturation_aclr = "ACLR3") and (aclr3 = '1'))) then
                mult_saturate_wire <= '0';
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                mult_saturate_wire <= mult_saturation;
            end if;
        end process;
        end generate IFG64;    
            
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set sload_upper_data_reg)
        -- The signal registered is accum_sload_upper_data
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_sload_upper_data_reg
        -- is unregistered and accum_sload_upper_data changes value
        -- ---------------------------------------------------------------------------------
        
        IFG65: if (accum_sload_upper_data_reg = "CLOCK0") generate
        process (clock0, accum_sload_upper_data, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_reg <= (others => '0');
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                sload_upper_data_reg <= accum_sload_upper_data;
                end if;
            end if;
        end process;
        end generate IFG65;
        
        IFG66: if (accum_sload_upper_data_reg = "CLOCK1") generate
        process (clock1, accum_sload_upper_data, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_reg <= (others => '0');
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                sload_upper_data_reg <= accum_sload_upper_data;
            end if;
        end process;
        end generate IFG66;
        
        IFG67: if (accum_sload_upper_data_reg = "CLOCK2") generate
        process (clock2, accum_sload_upper_data, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_reg <= (others => '0');
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                sload_upper_data_reg <= accum_sload_upper_data;
            end if;
        end process;
        end generate IFG67;
        
        IFG68: if (accum_sload_upper_data_reg = "CLOCK3") generate
        process (clock3, accum_sload_upper_data, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_reg <= (others => '0');
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                sload_upper_data_reg <= accum_sload_upper_data;
            end if;
        end process;
        end generate IFG68;
          
        -- ---------------------------------------------------------------------------------
        -- This statement contains 1 register and a combinatorial block (to set sload_upper_data_wire)
        -- The signal registered is sload_upper_data_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if accum_sload_upper_data_pipeline_reg
        -- is unregistered and sload_upper_data_latent changes value
        -- ---------------------------------------------------------------------------------
        IFG69: if (accum_sload_upper_data_pipeline_reg = "CLOCK0") generate
        process (clock0, sload_upper_data_latent, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_pipeline_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_wire <= (others => '0');
            elsif (rising_edge(clock0)) then
                if (ena0 = '1') then
                sload_upper_data_wire <= sload_upper_data_latent;
                end if;
            end if;
        end process;
        end generate IFG69;
            
        IFG70: if (accum_sload_upper_data_pipeline_reg = "CLOCK1") generate
        process (clock1, sload_upper_data_latent, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_pipeline_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_wire <= (others => '0');
            elsif (rising_edge(clock1) and (ena1 = '1')) then
                sload_upper_data_wire <= sload_upper_data_latent;
            end if;
        end process;
        end generate IFG70;
        
        IFG71: if (accum_sload_upper_data_pipeline_reg = "CLOCK2") generate    
        process (clock2, sload_upper_data_latent, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_pipeline_aclr  = "ACLR0") and (aclr0 = '1')) or  
                    ((accum_sload_upper_data_pipeline_aclr  = "ACLR1") and (aclr1 = '1')) or  
                    ((accum_sload_upper_data_pipeline_aclr  = "ACLR2") and (aclr2 = '1')) or  
                    ((accum_sload_upper_data_pipeline_aclr  = "ACLR3") and (aclr3 = '1'))) then
                    sload_upper_data_wire <= (others => '0');
            elsif (rising_edge(clock2) and (ena2 = '1')) then
                sload_upper_data_wire <= sload_upper_data_latent;
            end if;
        end process;
        end generate IFG71;
            
        IFG72: if (accum_sload_upper_data_pipeline_reg = "CLOCK3") generate    
        process (clock3, sload_upper_data_latent, aclr0, aclr1, aclr2, aclr3)
        begin
            if (((accum_sload_upper_data_pipeline_aclr  = "ACLR0") and (aclr0 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR1") and (aclr1 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR2") and (aclr2 = '1')) or  
                ((accum_sload_upper_data_pipeline_aclr  = "ACLR3") and (aclr3 = '1'))) then
                sload_upper_data_wire <= (others => '0');
            elsif (rising_edge(clock3) and (ena3 = '1')) then
                sload_upper_data_wire <= sload_upper_data_latent;
            end if;
        end process;
        end generate IFG72;    
          

        -- ----------------------------------------------------------------------------
        -- This block multiplies the two input numbers and sets the result to mult_final_out
        -- ----------------------------------------------------------------------------
        process (mult_a, mult_b, sign_a_reg, sign_b_reg, mult_round_wire, mult_saturate_wire, signa, signb, temp_mult_zero)
            variable temp_mult_int           : std_logic_vector (int_width_a + int_width_b downto 0);
            variable temp_mult : std_logic_vector (int_width_a + int_width_b -1 downto 0):= (others => '0');
            variable neg_a, neg_b, is_signed : std_logic;
            variable mult_round_out : std_logic_vector (int_width_a + int_width_b - 1 downto 0) := (others => '0');
            variable mult_saturate_overflow : std_logic := '0';
            variable mult_saturate_out : std_logic_vector (int_width_a + int_width_b - 1 downto 0) := (others => '0');
            variable mult_result : std_logic_vector (int_width_a + int_width_b - 1 downto 0) := (others => '0');

            variable int_mult_a : std_logic_vector (int_width_a - 1 downto 0);
            variable int_mult_b : std_logic_vector (int_width_b - 1 downto 0);
            variable mult_a_zero_bits_pad : std_logic_vector (int_width_a - width_a - 1 downto 0) := (others => '0');
            variable mult_b_zero_bits_pad : std_logic_vector (int_width_b - width_b - 1 downto 0) := (others => '0');
        begin
            is_signed := '0';

            if (port_signa = "PORT_CONNECTIVITY") then
                if (((representation_a = "SIGNED") and (signa = 'Z')) or (sign_a_reg = '1')) then
                    neg_a := mult_a (width_a-1);
                    is_signed :='1';
                end if;
            else
                if (((representation_a = "SIGNED") and (port_signa = "PORT_UNUSED")) or (sign_a_reg = '1')) then
                    neg_a := mult_a (width_a-1);
                    is_signed :='1';
                end if;            
            end if;

            if (port_signb = "PORT_CONNECTIVITY") then
                if (((representation_b = "SIGNED") and (signb = 'Z')) or (sign_b_reg = '1')) then
                    neg_b := mult_b (width_b-1);
                    is_signed :='1';
                end if;
            else
                if (((representation_b = "SIGNED") and (port_signb = "PORT_UNUSED")) or (sign_b_reg = '1')) then
                    neg_b := mult_b (width_b-1);
                    is_signed :='1';
                end if;            
            end if;
            
            if(int_width_a > width_a) then
                int_mult_a := mult_a & mult_a_zero_bits_pad;
            else
                int_mult_a := mult_a;
            end if;
            
            if(int_width_b > width_b) then
                int_mult_b := mult_b & mult_b_zero_bits_pad;
            else
                int_mult_b := mult_b;
            end if;

            if (port_signa = "PORT_CONNECTIVITY" and port_signb ="PORT_CONNECTIVITY") then
                if (((representation_a = "SIGNED") and (signa = 'Z')) or (sign_a_reg = '1')) then
                    if (((representation_b = "SIGNED") and( signb = 'Z')) or (sign_b_reg = '1')) then
                        temp_mult_int := signed (temp_mult_zero) + (signed (int_mult_a) * signed (int_mult_b));
                    else
                        temp_mult_int := signed (temp_mult_zero) + (signed (int_mult_a) * unsigned (int_mult_b));
                    end if;
                else
                    if (((representation_b = "SIGNED") and (signb = 'Z')) or (sign_b_reg = '1')) then
                        temp_mult_int := signed (temp_mult_zero) + (unsigned (int_mult_a) * signed (int_mult_b));
                    else
                        temp_mult_int := signed (temp_mult_zero) + (unsigned (int_mult_a) * unsigned (int_mult_b));
                    end if;
                end if;
            else
                if (((representation_a = "SIGNED") and (port_signa = "PORT_UNUSED")) or (sign_a_reg = '1')) then
                    if (((representation_b = "SIGNED") and(port_signb = "PORT_UNUSED")) or (sign_b_reg = '1')) then
                        temp_mult_int := signed (temp_mult_zero) + (signed (int_mult_a) * signed (int_mult_b));
                    else
                        temp_mult_int := signed (temp_mult_zero) + (signed (int_mult_a) * unsigned (int_mult_b));
                    end if;
                else
                    if (((representation_b = "SIGNED") and (port_signb = "PORT_UNUSED")) or (sign_b_reg = '1')) then
                        temp_mult_int := signed (temp_mult_zero) + (unsigned (int_mult_a) * signed (int_mult_b));
                    else
                        temp_mult_int := signed (temp_mult_zero) + (unsigned (int_mult_a) * unsigned (int_mult_b));
                    end if;
                end if;
            end if;

            temp_mult := temp_mult_int (int_width_a + int_width_b -1 downto 0);
            
            if (FEATURE_FAMILY_BASE_STRATIXII(intended_device_family)) then
            -- StratixII rounding support

                -- This is based on both input is in Q1.15 format with assumption
                -- width_a = 16 and width_b = 16

                if ((multiplier_rounding = "YES") or
                    ((multiplier_rounding = "VARIABLE") and (mult_round_wire = '1'))) then
                    mult_round_out := unsigned (temp_mult) + ( 2 ** (int_width_a + int_width_b - 18));
                else
                    mult_round_out := temp_mult;
                end if;

                -- StratixII saturation support

                if ((multiplier_saturation = "YES") or 
                    (( multiplier_saturation = "VARIABLE") and (mult_saturate_wire = '1'))) then
                    if((mult_round_out(int_width_a + int_width_b - 1) = '0') and (mult_round_out(int_width_a + int_width_b - 2) = '1')) then
                        mult_saturate_overflow := '1';
                    else
                        mult_saturate_overflow := '0';
                    end  if;
                    
                    if (mult_saturate_overflow = '0') then
                        mult_saturate_out := mult_round_out;
                    else
                        for i in (int_width_a + int_width_b - 1) downto (int_width_a + int_width_b - 2) loop
                            mult_saturate_out(i) := mult_round_out(int_width_a + int_width_b - 1);
                        end loop;

                        for i in (int_width_a + int_width_b - 3) downto 0 loop
                            mult_saturate_out(i) := not mult_round_out(int_width_a + int_width_b - 1);
                        end loop;
                        
                        for i in (int_width_a + int_width_b - 34) downto 0 loop
                            mult_saturate_out(i) := '0';
                        end loop;

                    end if;
                else
                    mult_saturate_out := mult_round_out;
                    mult_saturate_overflow := '0';
                end if;

                if ((multiplier_rounding = "YES") or
                    ((multiplier_rounding = "VARIABLE") and (mult_round_wire = '1'))) then

                    mult_result := mult_saturate_out;
                    
                    for i in (int_width_a + int_width_b - 18) downto 0 loop
                        mult_result(i) := '0';
                    end loop;
                else
                    mult_result := mult_saturate_out;
                end if;
                
                mult_is_saturated_wire <= mult_saturate_overflow;
            end if;
        
            if (not FEATURE_FAMILY_BASE_STRATIXII(intended_device_family)) then
                mult_final_out <= temp_mult;
            else
                mult_final_out <= mult_result;
            end if;

        end process;


        -- ----------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set mult_res)
        -- The signal registered is mult_out_latent
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if multiplier_reg
        -- is unregistered and mult_out_latent changes value
        -- ----------------------------------------------------------------------------
        IFG73: if (multiplier_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, mult_out_latent)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_res <= (others =>'0');
            elsif (rising_edge(clock0)) then
                if (ena0 ='1') then
                mult_res <= mult_out_latent;
                end if;
            end if;
        end process;
        end generate IFG73;

        IFG74: if (multiplier_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, mult_out_latent)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_res <= (others =>'0');
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                mult_res <= mult_out_latent;
            end if;
        end process;
        end generate IFG74;

        IFG75: if (multiplier_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, mult_out_latent)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_res <= (others =>'0');
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                mult_res <= mult_out_latent;
            end if;
        end process;
        end generate IFG75;
        
        IFG76: if (multiplier_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, mult_out_latent)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_res <= (others =>'0');
            elsif (rising_edge(clock3) and (ena3 ='1')) then
                mult_res <= mult_out_latent;
            end if;
        end process;
        end generate IFG76;

        -- ----------------------------------------------------------------------------
        -- This process contains 1 register and a combinatorial block (to set mult_is_saturated_reg)
        -- The signal registered is mult_is_saturated_wire
        --
        -- The register has an asynchronous clear and a clock enable signal
        -- NOTE: the combinatorial block is trigged if multiplier_reg
        -- is unregistered and mult_is_saturated_wire changes value
        -- ----------------------------------------------------------------------------
        IFG77: if (multiplier_reg = "CLOCK0") generate
        process (clock0, aclr0, aclr1, aclr2, aclr3, mult_is_saturated_wire)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_is_saturated_reg <= '0';
            elsif (rising_edge(clock0)) then
                if (ena0 ='1') then
                mult_is_saturated_reg <= mult_is_saturated_wire;
                end if;
            end if;
        end process; 
        end generate IFG77;
               
        IFG78: if (multiplier_reg = "CLOCK1") generate
        process (clock1, aclr0, aclr1, aclr2, aclr3, mult_is_saturated_wire)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_is_saturated_reg <= '0';
            elsif (rising_edge(clock1) and (ena1 ='1')) then
                mult_is_saturated_reg <= mult_is_saturated_wire;
            end if;
        end process;        
        end generate IFG78;
        
        IFG79: if (multiplier_reg = "CLOCK2") generate
        process (clock2, aclr0, aclr1, aclr2, aclr3, mult_is_saturated_wire)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_is_saturated_reg <= '0';
            elsif (rising_edge(clock2) and (ena2 ='1')) then
                mult_is_saturated_reg <= mult_is_saturated_wire;
            end if;
        end process;        
        end generate IFG79;

        IFG80: if (multiplier_reg = "CLOCK3") generate
        process (clock3, aclr0, aclr1, aclr2, aclr3, mult_is_saturated_wire)
        begin
            if (((multiplier_aclr= "ACLR0") and (aclr0 = '1')) or
                ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                ((multiplier_aclr= "ACLR3") and (aclr3 = '1'))) then
                mult_is_saturated_reg <= '0';
            elsif (rising_edge(clock3) and (ena3 ='1')) then
                mult_is_saturated_reg <= mult_is_saturated_wire;
            end if;
        end process;        
        end generate IFG80;
        
        IFG81: if (extra_multiplier_latency >0) generate
        process (clock0, clock1, clock2, clock3, aclr0, aclr1, aclr2, aclr3)
        -- ------------------------------------------------------------------------
        -- This process is only valid if extra_multiplier_latency is greater then 0
        -- ------------------------------------------------------------------------
            variable head_mult_int: integer := 0;

        begin
        -- ------------------------------------------------------------------------
        -- This process is only valid if extra_multiplier_latency is greater then 0
        -- ------------------------------------------------------------------------

            if ( (((multiplier_aclr= "ACLR0") or (multiplier_reg = "UNREGISTERED")) and (aclr0 = '1')) or
                    ((multiplier_reg /= "UNREGISTERED") and
                    ( ((multiplier_aclr= "ACLR1") and (aclr1 = '1')) or
                        ((multiplier_aclr= "ACLR2") and (aclr2 = '1')) or
                        ((multiplier_aclr= "ACLR3") and (aclr3 = '1')) )) ) then
                mult_pipe <= (others => (others => '0'));
                mult_full <= (others => '0');
                sload_upper_data_full <= (others => '0');
                sload_upper_data_pipe <= (others => (others => '0'));
                
                
            elsif ( (rising_edge(clock0) and ((multiplier_reg = "CLOCK0") or (multiplier_reg = "UNREGISTERED"))) or  
                    (rising_edge(clock1) and (multiplier_reg = "CLOCK1")) or
                    (rising_edge(clock2) and (multiplier_reg = "CLOCK2")) or 
                    (rising_edge(clock3) and (multiplier_reg = "CLOCK3"))  ) then
                
                if ((((multiplier_reg = "CLOCK0") or (multiplier_reg = "UNREGISTERED")) and (ena0 ='1')) or
                    ((multiplier_reg = "CLOCK1") and (ena1 ='1')) or
                    ((multiplier_reg = "CLOCK2") and (ena2 ='1')) or
                    ((multiplier_reg = "CLOCK3") and (ena3 ='1')) ) then    
                    
                if (extra_multiplier_latency >0) then
                    head_mult_int := head_mult;
                    mult_pipe (head_mult_int) <=  sign_a_reg & sign_b_reg & acc_sload_reg & addsub_reg  & '0' & mult_final_out;
                    sload_upper_data_pipe (head_mult_int) <= sload_upper_data_reg;
                    head_mult_int := (head_mult_int +1) mod (extra_multiplier_latency);

                    if (extra_multiplier_latency = 1) then
                        mult_full <= sign_a_reg & sign_b_reg & acc_sload_reg & addsub_reg  & '0' & mult_final_out;
                        sload_upper_data_full <= sload_upper_data_reg;
                    else
                        mult_full <= (mult_pipe(head_mult_int));
                        sload_upper_data_full <= (sload_upper_data_pipe(head_mult_int));
                    end if;

                    head_mult <= head_mult_int;
                end if;
            end if;
            end if;
        end process; 
        end generate IFG81;
        
        process (clock0, clock1, clock2, clock3, aclr0, aclr1, aclr2, aclr3)
        -- -------------------------------------------------------------
        -- This is the main process block that performs the accumulation
        -- -------------------------------------------------------------
            variable head_result_int : integer := 0;
            variable temp_sum : std_logic_vector (int_width_result downto 0) := (others => '0');
            variable result_full : std_logic_vector (int_width_result downto 0) := (others => '0');
            
            variable cout_int, overflow_int :std_logic;
            variable temp_sum_zero : std_logic_vector (int_width_result downto 0) := (others => '0');
            variable accum_int, addsub_int, signed_int : std_logic;
            variable result_temp : std_logic_vector (int_width_result -1 downto 0);
            variable sign_extend : std_logic_vector (int_width_result - int_width_a - int_width_b - 1 downto 0) := (others => '0');
            variable mult_res_temp : std_logic_vector (int_width_result -1 downto 0) := (others => '0');
            variable accum_final_out : std_logic_vector (int_width_result - 1 downto 0) := (others => '0');
            variable accum_round_out : std_logic_vector (int_width_result - 1 downto 0) := (others => '0');
            variable accum_saturate_overflow : std_logic := '0';
            variable accum_saturate_out : std_logic_vector (int_width_result - 1 downto 0) := (others => '0');
            variable accum_result_sign_bits : std_logic_vector (int_width_result - int_width_a - int_width_b + 2 - 1 downto 0) := (others => '0');
            variable accum_result_sign_bits_ones : std_logic_vector (int_width_result - int_width_a - int_width_b + 2 - 1 downto 0) := (others => '1');
            variable accum_result_sign_bits_zeros : std_logic_vector (int_width_result - int_width_a - int_width_b + 2 - 1 downto 0) := (others => '0');
            variable accum_result : std_logic_vector (int_width_result - 1 downto 0) := (others => '0');
            variable upper_data_sign_extend : std_logic := '0';
            variable upper_data_sign_bit : std_logic := '0';
            variable result_pipe : pipeline_accum := (others => (others => '0'));
            variable sat_for_ini : integer := int_width_a + int_width_b - 34;
            variable bits_to_round : integer := int_width_a + int_width_b - 18;
            variable accum_sat_for_limit : integer := int_width_a + int_width_b - 33;
    
        begin

        -- -------------------------------------------------------------
        -- This is the main process block that performs the accumulation
        -- -------------------------------------------------------------

            if (((output_aclr= "ACLR0") and (aclr0 = '1')) or
                ((output_aclr= "ACLR1") and (aclr1 = '1')) or
                ((output_aclr= "ACLR2") and (aclr2 = '1')) or
                ((output_aclr= "ACLR3") and (aclr3 = '1'))) then
                temp_sum     := (others => '0');
                result_pipe  := (others => (others => '0'));
                result       <= (others => '0');
                result_int   <= (others => '0');
                overflow_int := '0';
                overflow     <= '0';
                accum_is_saturated_out <= '0';
                mult_is_saturated_out <= '0';
                
            elsif ( (rising_edge(clock0) and (output_reg = "CLOCK0")) or  
                    (rising_edge(clock1) and (output_reg = "CLOCK1")) or
                    (rising_edge(clock2) and (output_reg = "CLOCK2")) or 
                    (rising_edge(clock3) and (output_reg = "CLOCK3"))  ) then
                
                if (((output_reg = "CLOCK0") and (ena0 ='1')) or
                    ((output_reg = "CLOCK1") and (ena1 ='1')) or
                    ((output_reg = "CLOCK2") and (ena2 ='1')) or
                    ((output_reg = "CLOCK3") and (ena3 ='1')) ) then         
                        
                if (accum_sload = 'Z') then
                    accum_int := '0';
                else
                    accum_int := accum_sload_pipe;
                end if;

                -- check if addition flag is to be set
                if (port_addnsub = "PORT_CONNECTIVITY") then
                    if (((addnsub = 'Z') and (accum_direction = "ADD")) or (addsub_pipe = '1')) then
                        addsub_int := '1';
                    else
                        addsub_int := '0';
                    end if;
                else
                    if (((port_addnsub = "PORT_UNUSED") and (accum_direction = "ADD")) or (addsub_pipe = '1')) then
                        addsub_int := '1';
                    else
                        addsub_int := '0';
                    end if;                
                end if;

                -- check if signed flag is to be set
                if (port_signa = "PORT_CONNECTIVITY" and port_signb = "PORT_CONNECTIVITY") then
                    if ((((representation_b = "SIGNED") and (signb = 'Z')) or (sign_b_pipe = '1')) or
                        (((representation_a = "SIGNED") and (signa = 'Z')) or (sign_a_pipe = '1'))) then
                        signed_int := '1';
                    else
                        signed_int := '0';
                    end if;
                else
                    if ((((representation_b = "SIGNED") and (port_signb = "PORT_UNUSED")) or (sign_b_pipe = '1')) or
                        (((representation_a = "SIGNED") and (port_signa = "PORT_UNUSED")) or (sign_a_pipe = '1'))) then
                        signed_int := '1';
                    else
                        signed_int := '0';
                    end if;                
                end if;

                sign_extend   := (others => (signed_int and mult_res (int_width_a + int_width_b -1)));
                if (int_width_result >= (int_width_a + int_width_b)) then
                mult_res_temp := sign_extend & mult_res;
                else
                        mult_res_temp := sign_extend & mult_res(int_width_result -1 downto 0);
                end if;

                if (int_width_result > width_result) then
                    upper_data_sign_extend := '1';
                else
                    upper_data_sign_extend := '0';
                end if;

                if (accum_int ='1') then
                    if ((not IS_STRATIXII) and
                        (not IS_CYCLONEII)) then
                        result_temp := (others => '0');
                    else
                        upper_data_sign_bit := (signed_int and sload_upper_data_wire(width_upper_data - 1));
                        result_temp := (others => '0');
                        
                        if(upper_data_sign_extend = '1') then
                            for i in (int_width_result - 1) downto (int_extra_width + width_result) loop
                                result_temp(i) := upper_data_sign_bit;
                            end loop;
                        end if;

                        if(width_upper_data > width_result) then
                            result_temp(int_extra_width + width_result - 1 downto int_extra_width) := sload_upper_data_wire(width_result - 1 downto 0);
                        else
                            result_temp(int_extra_width + width_result - 1 downto int_extra_width + width_result - width_upper_data) := sload_upper_data_wire;
                        end if;                        
                    end if;
                else
                    result_temp := result_int;
                end if;


                if (addsub_int = '1') then -- add the numbers if the add flag is turned on
                    temp_sum := unsigned(temp_sum_zero)+ unsigned (result_temp) + unsigned (mult_res_temp);
                    
                    cout_int := temp_sum (int_width_result);
                else -- subtract the numbers if the add flag is turned off
                    temp_sum := unsigned(temp_sum_zero)+ unsigned (result_temp) - unsigned (mult_res_temp);
                    

                    if (unsigned (result_temp) >= unsigned (mult_res_temp)) then
                        cout_int := '1';
                    else
                        cout_int := '0';
                    end if;
                end if;

                if (signed_int = '1' and (not (mult_res = temp_mult_zero))) then
                    overflow_int := (((not (mult_res (int_width_a + int_width_b-1) xor result_temp (int_width_result -1))) xor (not (addsub_int)))
                                    and (result_temp (int_width_result -1) xor temp_sum (int_width_result -1)));
                else
                    overflow_int := not (addsub_int xor cout_int);
                end if;


                if (IS_STRATIXII) then
                    -- StratixII rounding support
        
                    -- This is based on both input is in Q1.15 format with assumption
                    -- width_a = 16 and width_b = 16
                    -- result_width = widht_a + width_b
        
                    if ((accumulator_rounding = "YES") or
                        ((accumulator_rounding = "VARIABLE") and (accum_round_wire = '1'))) then
                        accum_round_out := temp_sum(int_width_result -1 downto 0);
                        accum_round_out := signed (accum_round_out) + ( 2 ** bits_to_round);
                    else
                        accum_round_out := temp_sum(int_width_result -1 downto 0);
                    end if;

                    -- StratixII saturation support

                    if ((accumulator_saturation = "YES") or 
                        ((accumulator_saturation = "VARIABLE") and (accum_saturate_wire = '1'))) then
                        accum_result_sign_bits := accum_round_out(int_width_result - 1 downto int_width_a + int_width_b - 2);
                        if ((accum_result_sign_bits = accum_result_sign_bits_ones) or
                            (accum_result_sign_bits = accum_result_sign_bits_zeros)) then
                            accum_saturate_overflow := '0';
                        else
                            accum_saturate_overflow := '1';
                        end if;

                        if (accum_saturate_overflow = '0') then
                            accum_saturate_out := accum_round_out;
                            accum_saturate_out(sat_for_ini) := '0';
                        else
                        
                            for i in (int_width_result - 1) downto (int_width_a + int_width_b - 2) loop
                                accum_saturate_out(i) := accum_round_out(int_width_result - 1);
                            end loop;

                            for i in (int_width_a + int_width_b - 3) downto (accum_sat_for_limit) loop
                                accum_saturate_out(i) := not accum_round_out(int_width_result - 1);
                            end loop;
                            
                            for i in (sat_for_ini) downto 0 loop
                                accum_saturate_out(i) := '0';
                            end loop;

                        end if;
                    else
                        accum_saturate_out := accum_round_out;
                        accum_saturate_overflow := '0';
                    end if;
                            
                    if ((accumulator_rounding = "YES") or
                        ((accumulator_rounding = "VARIABLE") and (accum_round_wire = '1'))) then
                        
                        accum_result := accum_saturate_out;
                        for i in (bits_to_round) downto 0 loop
                            accum_result(i) := '0';
                        end loop;
                    else
                        accum_result := accum_saturate_out;
                    end if;

                    accum_is_saturated_out <= accum_saturate_overflow;
                    mult_is_saturated_out <= mult_is_saturated_reg;                    

                end if;

                if (not IS_STRATIXII) then
                    accum_final_out := temp_sum(int_width_result -1 downto 0);
                else
                    accum_final_out := accum_result;
                end if;
        
                if (extra_accumulator_latency = 0) then
                    result   <= accum_final_out(width_result - 1 + int_extra_width downto int_extra_width);
                    overflow <= overflow_int;
                else
                    head_result_int               := head_result;
                    result_pipe (head_result_int) := (overflow_int & accum_final_out);
                    head_result_int               := (head_result_int +1) mod (extra_accumulator_latency + 1);
                    result_full                   := result_pipe(head_result_int);
                    result                        <= result_full (width_result - 1 + int_extra_width downto int_extra_width);
                    overflow                      <= result_full (int_width_result);
                    head_result                   <= head_result_int;
                end if;

                result_int <= accum_final_out;
                end if;
            end if;
        end process;

end behaviour;  -- end of ALT_MULT_ACCUM

----------------------------------------------------------------------------
-- Module Name      : altmult_add
--
-- Description      : a*b + c*d
--
-- Limitation       : Stratix DSP block
--
-- Results expected : signed & unsigned, maximum of 3 pipelines(latency) each.
--                    possible of zero pipeline.
--
----------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use work.ALTERA_DEVICE_FAMILIES.all;

entity     altmult_add is
    generic (

        -- ---------------------
        -- PARAMETER DECLARATION
        -- ---------------------
        width_a               : natural := 1;
        width_b               : natural := 1;
        width_result          : natural := 1;
        number_of_multipliers : natural := 1;
                
        -- A inputs
        input_register_a0 : string := "CLOCK0";
        input_aclr_a0     : string := "ACLR3";
        input_source_a0   : string := "DATAA";

        input_register_a1 : string := "CLOCK0";
        input_aclr_a1     : string := "ACLR3";
        input_source_a1   : string := "DATAA";

        input_register_a2 : string := "CLOCK0";
        input_aclr_a2     : string := "ACLR3";
        input_source_a2   : string := "DATAA";

        input_register_a3 : string := "CLOCK0";
        input_aclr_a3     : string := "ACLR3";
        input_source_a3   : string := "DATAA";
        
        port_signa                 : string := "PORT_CONNECTIVITY";
        representation_a           : string := "UNSIGNED";
        signed_register_a          : string := "CLOCK0";
        signed_aclr_a              : string := "ACLR3";
        signed_pipeline_register_a : string := "CLOCK0";
        signed_pipeline_aclr_a     : string := "ACLR3";
        
        scanouta_register : string := "UNREGISTERED";
        scanouta_aclr     : string := "NONE";


        -- B inputs
        input_register_b0 : string := "CLOCK0";
        input_aclr_b0     : string := "ACLR3";
        input_source_b0   : string := "DATAB";

        input_register_b1 : string := "CLOCK0";
        input_aclr_b1     : string := "ACLR3";
        input_source_b1   : string := "DATAB";

        input_register_b2 : string := "CLOCK0";
        input_aclr_b2     : string := "ACLR3";
        input_source_b2   : string := "DATAB";

        input_register_b3 : string := "CLOCK0";
        input_aclr_b3     : string := "ACLR3";
        input_source_b3   : string := "DATAB";

        port_signb                 : string := "PORT_CONNECTIVITY";
        representation_b           : string := "UNSIGNED";
        signed_register_b          : string := "CLOCK0";
        signed_aclr_b              : string := "ACLR3";
        signed_pipeline_register_b : string := "CLOCK0";
        signed_pipeline_aclr_b     : string := "ACLR3";

        -- Multiplier parameter
        multiplier_register0 : string := "CLOCK0";
        multiplier_aclr0     : string := "ACLR3";
        multiplier_register1 : string := "CLOCK0";
        multiplier_aclr1     : string := "ACLR3";
        multiplier_register2 : string := "CLOCK0";
        multiplier_aclr2     : string := "ACLR3";
        multiplier_register3 : string := "CLOCK0";
        multiplier_aclr3     : string := "ACLR3";

        port_addnsub1                         : string := "PORT_CONNECTIVITY";
        addnsub_multiplier_register1          : string := "CLOCK0";
        addnsub_multiplier_aclr1              : string := "ACLR3";
        addnsub_multiplier_pipeline_register1 : string := "CLOCK0";
        addnsub_multiplier_pipeline_aclr1     : string := "ACLR3";
                
        port_addnsub3                         : string := "PORT_CONNECTIVITY";
        addnsub_multiplier_register3          : string := "CLOCK0";
        addnsub_multiplier_aclr3              : string := "ACLR3";
        addnsub_multiplier_pipeline_register3 : string := "CLOCK0";
        addnsub_multiplier_pipeline_aclr3     : string := "ACLR3";
            
        multiplier1_direction : string := "ADD";
        multiplier3_direction : string := "ADD";            

        -- output parameters
        output_register : string := "CLOCK0";
        output_aclr     : string := "ACLR3";

        -- StratixII parameters
        multiplier01_rounding    : string := "NO";
        multiplier01_saturation : string := "NO";
        mult01_round_aclr           : string := "ACLR3";
        mult01_round_register       : string := "CLOCK0";
        mult01_saturation_register  : string := "CLOCK0";
        mult01_saturation_aclr      : string := "ACLR3";
        multiplier23_rounding    : string := "NO";
        multiplier23_saturation : string := "NO";
        mult23_round_aclr           : string := "ACLR3";
        mult23_round_register       : string := "CLOCK0";
        mult23_saturation_register  : string := "CLOCK0";
        mult23_saturation_aclr      : string := "ACLR3";
        adder1_rounding         : string := "NO";
        adder3_rounding         : string := "NO";
        addnsub1_round_aclr              : string := "ACLR3";
        addnsub1_round_pipeline_aclr     : string := "ACLR3";
        addnsub1_round_register          : string := "CLOCK0";
        addnsub1_round_pipeline_register : string := "CLOCK0";
        addnsub3_round_aclr              : string := "ACLR3";
        addnsub3_round_pipeline_aclr     : string := "ACLR3";
        addnsub3_round_register          : string := "CLOCK0";
        addnsub3_round_pipeline_register : string := "CLOCK0";
        port_mult0_is_saturated : string := "UNUSED";
        port_mult1_is_saturated : string := "UNUSED";
        port_mult2_is_saturated : string := "UNUSED";
        port_mult3_is_saturated : string := "UNUSED";
        
        -- Stratix III parameters
        -- Rounding parameters
        output_rounding : string := "NO";
        output_round_type : string := "NEAREST_INTEGER";
        width_msb : integer := 17;
        output_round_register : string := "UNREGISTERED";
        output_round_aclr : string := "NONE";
        output_round_pipeline_register : string := "UNREGISTERED";
        output_round_pipeline_aclr : string := "NONE";
    
        chainout_rounding : string := "NO";
        chainout_round_register : string := "UNREGISTERED";
        chainout_round_aclr : string := "NONE";
        chainout_round_pipeline_register : string := "UNREGISTERED";
        chainout_round_pipeline_aclr : string := "NONE";
        chainout_round_output_register : string := "UNREGISTERED";
        chainout_round_output_aclr : string := "NONE";
    
        -- saturation parameters
        port_output_is_overflow : string := "PORT_UNUSED";
        port_chainout_sat_is_overflow : string := "PORT_UNUSED";
        output_saturation : string := "NO";
        output_saturate_type : string := "ASYMMETRIC";
        width_saturate_sign : integer := 1;
        output_saturate_register : string := "UNREGISTERED";
        output_saturate_aclr : string := "NONE";
        output_saturate_pipeline_register : string := "UNREGISTERED";
        output_saturate_pipeline_aclr : string := "NONE";
    
        chainout_saturation : string := "NO";
        chainout_saturate_register : string := "UNREGISTERED";
        chainout_saturate_aclr : string := "NONE";
        chainout_saturate_pipeline_register : string := "UNREGISTERED";
        chainout_saturate_pipeline_aclr : string := "NONE";
        chainout_saturate_output_register : string := "UNREGISTERED";
        chainout_saturate_output_aclr : string := "NONE";
    
        -- chainout parameters
        chainout_adder : string := "NO";
        chainout_register : string := "UNREGISTERED";
        chainout_aclr : string := "ACLR3";
        width_chainin : integer := 1;
        zero_chainout_output_register : string := "UNREGISTERED";
        zero_chainout_output_aclr : string := "NONE";

        -- rotate & shift parameters
        shift_mode : string := "NO";
        rotate_aclr : string := "NONE";
        rotate_register : string := "UNREGISTERED";
        rotate_pipeline_register : string := "UNREGISTERED";
        rotate_pipeline_aclr : string := "NONE";
        rotate_output_register : string := "UNREGISTERED";
        rotate_output_aclr : string := "NONE";
        shift_right_register : string := "UNREGISTERED";
        shift_right_aclr : string := "NONE";
        shift_right_pipeline_register : string := "UNREGISTERED";
        shift_right_pipeline_aclr : string := "NONE";
        shift_right_output_register : string := "UNREGISTERED";
        shift_right_output_aclr : string := "NONE";
    
        -- loopback parameters
        zero_loopback_register : string := "UNREGISTERED";
        zero_loopback_aclr : string := "NONE";
        zero_loopback_pipeline_register : string := "UNREGISTERED";
        zero_loopback_pipeline_aclr : string := "NONE";
        zero_loopback_output_register : string := "UNREGISTERED";
        zero_loopback_output_aclr : string := "NONE";

        -- accumulator parameters
        accum_sload_register : string := "UNREGISTERED";
        accum_sload_aclr : string := "NONE";
        accum_sload_pipeline_register : string := "UNREGISTERED";
        accum_sload_pipeline_aclr : string := "NONE";
        accum_direction : string := "ADD";
        accumulator : string := "NO";


        -- General setting parameters
        extra_latency                  : integer := 0;
        dedicated_multiplier_circuitry : string  := "AUTO";
        dsp_block_balancing            : string  := "AUTO";
        lpm_hint                       : string  := "UNUSED";
        lpm_type                       : string  := "altmult_add";
        intended_device_family         : string  := "Stratix"
    );
                        
    port (

        -- ----------------
        -- PORT DECLARATION
        -- ----------------

        -- data input ports
        dataa : in std_logic_vector(number_of_multipliers * width_a -1 downto 0);
        datab : in std_logic_vector(number_of_multipliers * width_b -1 downto 0);

        scanina : in std_logic_vector(width_a -1 downto 0) := (others => '0');
        scaninb : in std_logic_vector(width_b -1 downto 0) := (others => '0');

        sourcea : in std_logic_vector((number_of_multipliers -1) downto 0) := (others => '0');
        sourceb : in std_logic_vector((number_of_multipliers -1) downto 0) := (others => '0');

        -- clock ports
        clock3 : in std_logic := '1';
        clock2 : in std_logic := '1';
        clock1 : in std_logic := '1';
        clock0 : in std_logic := '1';

        -- clear ports
        aclr3 : in std_logic := '0';
        aclr2 : in std_logic := '0';
        aclr1 : in std_logic := '0';
        aclr0 : in std_logic := '0';

        -- clock enable signals
        ena3 : in std_logic := '1';
        ena2 : in std_logic := '1';
        ena1 : in std_logic := '1';
        ena0 : in std_logic := '1';

        -- control signals
        signa    : in std_logic := 'Z';
        signb    : in std_logic := 'Z';
        addnsub1 : in std_logic := 'Z';
        addnsub3 : in std_logic := 'Z';

        -- StratixII only input ports
        mult01_round        : in std_logic := '0';
        mult23_round        : in std_logic := '0';
        mult01_saturation   : in std_logic := '0';
        mult23_saturation   : in std_logic := '0';
        addnsub1_round      : in std_logic := '0';
        addnsub3_round      : in std_logic := '0';
        
        -- Stratix III only input ports
        output_round : in std_logic := '0';
        chainout_round : in std_logic := '0';
        output_saturate : in std_logic := '0';
        chainout_saturate : in std_logic := '0';
        chainin : in std_logic_vector (width_chainin - 1 downto 0) := (others => '0');
        zero_chainout : in std_logic := '0';
        rotate : in std_logic := '0';
        shift_right : in std_logic := '0';
        zero_loopback : in std_logic := '0';
        accum_sload : in std_logic := '0';


        -- output ports
        result   : out std_logic_vector(width_result -1 downto 0) := (others => '0');
        scanouta : out std_logic_vector (width_a -1 downto 0) := (others => '0');
        scanoutb : out std_logic_vector (width_b -1 downto 0) := (others => '0');

        -- StratixII only output ports
        mult0_is_saturated : out std_logic := '0';
        mult1_is_saturated : out std_logic := '0';
        mult2_is_saturated : out std_logic := '0';
        mult3_is_saturated : out std_logic := '0';
        
        -- Stratix III only output ports
        overflow : out std_logic := '0';
        chainout_sat_overflow : out std_logic := '0'

    );

end altmult_add;

architecture behaviour of altmult_add is

    -- ---------------------------
    -- SIGNAL AND TYPE DECLARATION
    -- ---------------------------
    
    function resolve_internal_width (ARG : integer;ARG2 : integer) return integer is
        variable changed_width:integer := 0;
    begin
        if (multiplier01_saturation = "NO" and multiplier23_saturation = "NO" and multiplier01_rounding = "NO" and multiplier23_rounding = "NO"
            and output_saturation = "NO" and output_rounding = "NO" and chainout_adder = "NO" and input_source_b0 /= "LOOPBACK" ) then
            if (ARG2 = 0) then
                changed_width := width_a;
            else
                changed_width := width_b;
            end if;
        else
            if (ARG < 18) then
                changed_width := 18;
            else 
                if (ARG2 = 0) then
                    changed_width := width_a;
                else
                    changed_width := width_b;
                end if;
            end if;
         
        end if;
        return changed_width;
    end resolve_internal_width;
    -- This constant int_width_a would be  used internally in this model
    -- to represent width_a
    constant int_width_a : natural := resolve_internal_width(width_a, 0);
    -- This constant int_width_b woudl be used internally in this model 
    -- to represent width_b        
    constant int_width_b : natural := resolve_internal_width(width_b, 1);
      
    function resolve_internal_mult_diff return integer is
        variable changed_value :integer := 0;
    begin
        if (multiplier01_saturation = "NO" and multiplier23_saturation = "NO" and multiplier01_rounding = "NO" and multiplier23_rounding = "NO"
            and output_rounding = "NO" and output_saturation = "NO" and chainout_adder = "NO") then
            changed_value := 0;            
        else
            if (chainout_adder = "YES") then
                if (width_result > width_a + width_b + 8) then
                    changed_value := 0;
                else
                    changed_value := int_width_a - width_a + int_width_b - width_b;
                end if;
            else
                changed_value := int_width_a - width_a + int_width_b - width_b;
            end if;
        end if;
        return changed_value;
    end resolve_internal_mult_diff;
    
    constant int_mult_diff_bit : integer := resolve_internal_mult_diff;
 
    function resolve_internal_width_result return integer is
        variable changed_width_result:integer := 0;
    begin
        if (multiplier01_saturation = "NO" and multiplier23_saturation = "NO" and multiplier01_rounding = "NO" and multiplier23_rounding = "NO"
            and output_rounding = "NO" and output_saturation = "NO" and chainout_rounding = "NO" and chainout_saturation = "NO" and chainout_adder = "NO" and shift_mode = "NO") then
            changed_width_result := width_result;            
        else
            if (shift_mode /= "NO") then
                changed_width_result := 64;
            elsif (chainout_adder = "YES") then
                changed_width_result := 44;
            elsif (width_result > (int_width_a + int_width_b)) then
                changed_width_result := width_result + (width_result - int_width_a - int_width_b);
            else
                changed_width_result := int_width_a + int_width_b;
            end if;
        end if;
        return changed_width_result;
    end resolve_internal_width_result;
    
    constant int_width_result : natural := resolve_internal_width_result;
 
    function resolve_result_width return integer is
        variable width_value :integer := 0;
    begin
        width_value := 44;
        return width_value;
    end resolve_result_width;
    
    constant result_width : integer := resolve_result_width;
    
    function resolve_saturation_position return integer is
        variable saturation_value :integer := 0;
    begin
        if (output_saturation /= "NO" and chainout_saturation = "NO") then
            if (((width_a + width_b )> width_result) and (width_result >= width_saturate_sign)) then
                saturation_value :=  (int_width_a + int_width_b - width_saturate_sign - (width_a + width_b - width_result));            
            elsif (((width_a + width_b) = width_result) and (width_result >= width_saturate_sign)) then
                saturation_value:= (int_width_a + int_width_b - width_saturate_sign);
            elsif (width_result >= width_saturate_sign) then 
                saturation_value := (int_width_a + int_width_b - width_saturate_sign +  (width_result - width_saturate_sign) + (width_saturate_sign - width_a - width_b));
            end if;
        elsif (chainout_saturation /= "NO") then
            if ((width_result >= int_width_result) and (width_result > width_saturate_sign)) then
                saturation_value :=  width_result - width_saturate_sign;           
            elsif (width_result > width_saturate_sign) then 
                saturation_value := width_result + int_mult_diff_bit - width_saturate_sign;
        end if;
        else
            saturation_value:=  2;
        end if;
        return saturation_value;
    end resolve_saturation_position;
    
    constant saturation_position : natural := resolve_saturation_position;                             
                                
    function resolve_chainout_saturation_position return integer is
        variable saturation_value :integer := 0;
    begin
        if (chainout_saturation /= "NO") then
            if ((width_result >= int_width_result) and (width_result > width_saturate_sign)) then
                saturation_value :=  width_result - width_saturate_sign;           
            elsif (width_result > width_saturate_sign) then 
                saturation_value := width_result + int_mult_diff_bit - width_saturate_sign;
            end if;
        else
            saturation_value := 2;
        end if;

        if (saturation_value  < 0) then
            saturation_value:= 2;
        elsif (saturation_value > int_width_result) then
            saturation_value:= (int_width_a + int_width_b - width_saturate_sign);
        end if;
        return saturation_value;
    end resolve_chainout_saturation_position;
    
    constant chainout_saturation_position : natural := resolve_chainout_saturation_position;            
    
    function resolve_round_position return integer is
        variable round_value :integer := 2;
    begin
        if (output_rounding /= "NO" or output_saturate_type = "SYMMETRIC") then
            if (input_source_b0 = "LOOPBACK") then
                round_value := 18;
            elsif (((width_a + width_b )> width_result) and (width_msb < width_result)) then
                round_value :=  (int_width_a + int_width_b - width_msb - (width_a + width_b - width_result));            
            elsif (((width_a + width_b) = width_result) and (width_msb < width_result)) then
                round_value:= (int_width_a + int_width_b - width_msb);
            elsif  (width_msb < width_result) then
                round_value := (int_width_a + int_width_b - width_msb + (width_result - width_a - width_b));
            end if;
        else
            round_value := 2;
        end if;

        if (output_rounding /= "NO" or output_saturate_type = "SYMMETRIC") then
            if (round_value < 0) then
                round_value := 2;
            elsif (round_value > int_width_result) then 
                round_value := int_width_result - width_msb;
            end if;
        end if;
        return round_value;
    end resolve_round_position;
    
    constant round_position : natural := resolve_round_position;    

    function resolve_chainout_round_position return integer is
        variable round_value :integer := 2;
    begin
        if (chainout_rounding /= "NO" or output_saturate_type = "SYMMETRIC") then
            if ((width_result >= int_width_result) and (width_msb < width_result)) then
                round_value :=  width_result - width_msb; 
            elsif  (width_msb < width_result) then
                round_value :=  width_result + int_mult_diff_bit - width_msb;
            end if;
        else
            round_value := 2;
        end if;

        if (chainout_rounding /= "NO" or output_saturate_type = "SYMMETRIC") then
            if (round_value < 0) then
                round_value := 2;
            elsif (round_value > int_width_result) then
                round_value := int_width_result - width_msb;
            end if;
        end if;
        return round_value;
    end resolve_chainout_round_position;

    constant chainout_round_position : natural := resolve_chainout_round_position;
    
    function resolve_chainout_input_a return integer is
        variable input_a_value :integer := 0;
    begin
        if (chainout_adder = "YES") then
            if (width_a < 18) then
                input_a_value := 18 - width_a;
            else
                input_a_value := 1;
            end if;
        end if;
        return input_a_value;
    end resolve_chainout_input_a;

    constant chainout_input_a : natural := resolve_chainout_input_a;     
    
    function resolve_chainout_input_b return integer is
        variable input_b_value :integer := 0;
    begin
        if (chainout_adder = "YES") then
            if (width_b < 18) then
                input_b_value := 18 - width_b;
            else
                input_b_value := 1;
            end if;
        end if;
        return input_b_value;
    end resolve_chainout_input_b;
    
    constant chainout_input_b : natural := resolve_chainout_input_b;     
    
    function resolve_accum_width return integer is
        variable accum_value :integer := 0;
    begin
        if((int_width_a + int_width_b) < 44) then
            accum_value := 44;
        else
            accum_value := int_width_a + int_width_b;
        end if;
        return accum_value;
    end resolve_accum_width;

    constant accum_width : natural := resolve_accum_width;  
    
    function resolve_loopback_width return integer is
        variable loopback_value :integer := 0;
    begin
        loopback_value := 17;
        return loopback_value;
    end resolve_loopback_width;

    constant loopback_width : na